/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.util;

import java.util.Arrays;

public class BulkArrayList<T>
implements Cloneable {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private Object[] data;
    private int size;
    private int increment;

    public BulkArrayList(int capacity) {
        this.data = new Object[capacity];
        this.increment = capacity;
    }

    public BulkArrayList(T[] data, int increment) {
        this(Math.max(increment, data.length));
        this.increment = increment;
        System.arraycopy(data, 0, this.data, 0, data.length);
    }

    private void ensureCapacity(int c) {
        if (this.data.length <= c) {
            Object[] newData = new Object[Math.max(this.data.length + this.increment, c + 1)];
            System.arraycopy(this.data, 0, newData, 0, this.size);
            this.data = newData;
        }
    }

    public void add(T value) {
        this.ensureCapacity(this.size);
        this.data[this.size] = value;
        ++this.size;
    }

    public void remove(int index) {
        if (index < 0 || index >= this.size) {
            throw new IllegalArgumentException();
        }
        int tailSize = this.size - index - 1;
        if (tailSize > 0) {
            System.arraycopy(this.data, index + 1, this.data, index, tailSize);
        }
        --this.size;
        this.data[this.size] = 0;
    }

    public void set(int index, T value) {
        this.ensureCapacity(index);
        this.data[index] = value;
        if (index >= this.size) {
            this.size = index + 1;
        }
    }

    public void removeRange(int index, int count) {
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (count < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (index + count > this.size) {
            throw new IndexOutOfBoundsException();
        }
        System.arraycopy(this.data, index + count, this.data, index, count);
        this.size -= count;
        Arrays.fill(this.data, this.size, this.size + count, null);
    }

    public T get(int index) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException("Illegal Index: " + index + " Max:" + this.size);
        }
        return (T)this.data[index];
    }

    public void clear() {
        this.size = 0;
        Arrays.fill(this.data, null);
    }

    public int size() {
        return this.size;
    }

    public <T> T[] toArray(T[] retval) {
        if (retval.length < this.size) {
            return Arrays.copyOf(this.data, this.size, retval.getClass());
        }
        System.arraycopy(this.data, 0, retval, 0, this.size);
        Arrays.fill(retval, this.size, retval.length, null);
        return retval;
    }

    public BulkArrayList<T> clone() throws CloneNotSupportedException {
        BulkArrayList intList = (BulkArrayList)super.clone();
        intList.data = (Object[])this.data.clone();
        return intList;
    }
}

