/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.util;

import java.io.ObjectStreamException;
import java.io.Serializable;
import org.pentaho.reporting.engine.classic.core.util.ObjectStreamResolveException;

public class StagingMode
implements Serializable {
    public static final StagingMode MEMORY = new StagingMode("memory");
    public static final StagingMode THRU = new StagingMode("thru");
    public static final StagingMode TMPFILE = new StagingMode("tmpfile");
    private String type;

    private StagingMode(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StagingMode that = (StagingMode)o;
        return !(this.type != null ? !this.type.equals(that.type) : that.type != null);
    }

    public int hashCode() {
        return this.type != null ? this.type.hashCode() : 0;
    }

    public String toString() {
        return this.type;
    }

    protected Object readResolve() throws ObjectStreamException {
        if (this.type.equals(StagingMode.MEMORY.type)) {
            return MEMORY;
        }
        if (this.type.equals(StagingMode.THRU.type)) {
            return THRU;
        }
        if (this.type.equals(StagingMode.TMPFILE.type)) {
            return TMPFILE;
        }
        throw new ObjectStreamResolveException();
    }

    public static StagingMode valueOf(String s) {
        if (s == null) {
            throw new NullPointerException();
        }
        if (s.equals(StagingMode.MEMORY.type)) {
            return MEMORY;
        }
        if (s.equals(StagingMode.THRU.type)) {
            return THRU;
        }
        if (s.equals(StagingMode.TMPFILE.type)) {
            return TMPFILE;
        }
        throw new IllegalArgumentException();
    }
}

