/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.impl;

import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import org.firebirdsql.encodings.Encoding;
import org.firebirdsql.encodings.EncodingFactory;
import org.firebirdsql.gds.BlobParameterBuffer;
import org.firebirdsql.gds.DatabaseParameterBuffer;
import org.firebirdsql.gds.GDS;
import org.firebirdsql.gds.GDSException;
import org.firebirdsql.gds.IscBlobHandle;
import org.firebirdsql.gds.IscDbHandle;
import org.firebirdsql.gds.IscStmtHandle;
import org.firebirdsql.gds.IscTrHandle;
import org.firebirdsql.gds.TransactionParameterBuffer;
import org.firebirdsql.gds.XSQLDA;
import org.firebirdsql.gds.impl.AbstractIscDbHandle;
import org.firebirdsql.gds.impl.AbstractIscStmtHandle;
import org.firebirdsql.gds.impl.AbstractIscTrHandle;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;

public class GDSHelper {
    public static final int DEFAULT_BLOB_BUFFER_SIZE = 16384;
    private static final Logger log = LoggerFactory.getLogger(GDSHelper.class, false);
    private GDS gds;
    private AbstractIscDbHandle currentDbHandle;
    private AbstractIscTrHandle currentTr;
    protected DatabaseParameterBuffer dpb;
    private boolean registerResultSets;
    private GDSHelperErrorListener listener;
    public static final byte[] BLOB_LENGTH_REQUEST = new byte[]{6};

    public GDSHelper(GDS gds, DatabaseParameterBuffer dpb, AbstractIscDbHandle dbHandle, GDSHelperErrorListener listener) {
        this.gds = gds;
        this.dpb = dpb;
        this.currentDbHandle = dbHandle;
        this.registerResultSets = !this.getDatabaseParameterBuffer().hasArgument(137);
        this.listener = listener;
    }

    private void notifyListeners(GDSException ex) {
        if (this.listener != null) {
            this.listener.errorOccured(ex);
        }
    }

    public AbstractIscTrHandle getCurrentTrHandle() {
        return this.currentTr;
    }

    public synchronized void setCurrentTrHandle(AbstractIscTrHandle currentTr) {
        this.currentTr = currentTr;
        this.notify();
    }

    public IscDbHandle getCurrentDbHandle() {
        return this.currentDbHandle;
    }

    public DatabaseParameterBuffer getDatabaseParameterBuffer() {
        return this.dpb;
    }

    public AbstractIscStmtHandle allocateStatement() throws GDSException {
        try {
            AbstractIscStmtHandle stmt = (AbstractIscStmtHandle)this.gds.createIscStmtHandle();
            this.gds.iscDsqlAllocateStatement(this.getCurrentDbHandle(), stmt);
            return stmt;
        }
        catch (GDSException ex) {
            this.notifyListeners(ex);
            throw ex;
        }
    }

    public boolean inTransaction() {
        return this.currentTr != null;
    }

    public int getTransactionId(IscTrHandle trHandle) throws GDSException {
        try {
            byte[] trInfo = this.gds.iscTransactionInformation(trHandle, new byte[]{4}, 32);
            if (trInfo.length < 3 || trInfo[0] != 4) {
                throw new GDSException("Unexpected response buffer");
            }
            int length = this.gds.iscVaxInteger(trInfo, 1, 2);
            return this.gds.iscVaxInteger(trInfo, 3, length);
        }
        catch (GDSException ex) {
            this.notifyListeners(ex);
            throw ex;
        }
    }

    public void prepareStatement(AbstractIscStmtHandle stmt, String sql, boolean describeBind) throws GDSException, SQLException {
        try {
            if (log != null) {
                log.trace("preparing sql: " + sql);
            }
            String localEncoding = this.dpb.getArgumentAsString(135);
            String mappingPath = this.dpb.getArgumentAsString(136);
            Encoding encoding = EncodingFactory.getEncoding(localEncoding, mappingPath);
            int dialect = 3;
            if (this.dpb.hasArgument(63)) {
                dialect = this.dpb.getArgumentAsInt(63);
            }
            XSQLDA out = this.gds.iscDsqlPrepare((IscTrHandle)this.currentTr, (IscStmtHandle)stmt, encoding.encodeToCharset(sql), dialect);
            if (out.sqld != out.sqln) {
                throw new GDSException("Not all columns returned");
            }
            if (describeBind) {
                this.gds.iscDsqlDescribeBind(stmt, 1);
            }
            stmt.statement = sql;
        }
        catch (GDSException ex) {
            this.notifyListeners(ex);
            throw ex;
        }
    }

    public void executeStatement(AbstractIscStmtHandle stmt, boolean sendOutSqlda) throws GDSException {
        try {
            if (log != null && log.isDebugEnabled()) {
                log.debug("Executing " + stmt.statement);
            }
            this.gds.iscDsqlExecute2(this.currentTr, stmt, 1, stmt.getInSqlda(), sendOutSqlda ? stmt.getOutSqlda() : null);
        }
        catch (GDSException ex) {
            this.notifyListeners(ex);
            throw ex;
        }
    }

    public void executeImmediate(String statement) throws GDSException {
        try {
            this.gds.iscDsqlExecImmed2(this.getIscDBHandle(), (IscTrHandle)this.currentTr, statement, 3, null, null);
        }
        catch (GDSException ex) {
            this.notifyListeners(ex);
            throw ex;
        }
    }

    public void fetch(AbstractIscStmtHandle stmt, int fetchSize) throws GDSException {
        try {
            this.gds.iscDsqlFetch(stmt, 1, stmt.getOutSqlda(), fetchSize);
            if (this.registerResultSets) {
                this.currentTr.registerStatementWithTransaction(stmt);
            }
        }
        catch (GDSException ex) {
            this.notifyListeners(ex);
            throw ex;
        }
    }

    public void setCursorName(AbstractIscStmtHandle stmt, String cursorName) throws GDSException {
        try {
            this.gds.iscDsqlSetCursorName(stmt, cursorName, 0);
        }
        catch (GDSException ex) {
            this.notifyListeners(ex);
            throw ex;
        }
    }

    public void closeStatement(AbstractIscStmtHandle stmt, boolean deallocate) throws GDSException {
        try {
            if (!deallocate && !stmt.hasOpenResultSet()) {
                return;
            }
            try {
                this.gds.iscDsqlFreeStatement(stmt, deallocate ? 2 : 1);
            }
            catch (GDSException ex) {
                if (deallocate) {
                    throw ex;
                }
                boolean recloseClosedCursorError = false;
                GDSException tempEx = ex;
                do {
                    if (tempEx.getIntParam() != 0x14000101) continue;
                    recloseClosedCursorError = true;
                    break;
                } while ((tempEx = tempEx.getNext()) != null);
                if (!recloseClosedCursorError) {
                    throw ex;
                }
            }
        }
        catch (GDSException ex) {
            this.notifyListeners(ex);
            throw ex;
        }
    }

    public void getSqlCounts(AbstractIscStmtHandle stmt) throws GDSException {
        try {
            this.gds.getSqlCounts(stmt);
        }
        catch (GDSException ex) {
            this.notifyListeners(ex);
            throw ex;
        }
    }

    public void populateStatementInfo(AbstractIscStmtHandle fixedStmt) throws GDSException {
        byte[] REQUEST = new byte[]{22, 21, 1};
        try {
            byte[] buffer;
            int bufferSize = 1024;
            while ((buffer = this.gds.iscDsqlSqlInfo(fixedStmt, REQUEST, bufferSize))[0] == 2) {
                bufferSize *= 2;
            }
            if (buffer[0] == 1) {
                throw new GDSException(335544364);
            }
            String executionPlan = null;
            int statementType = -1;
            int dataLength = -1;
            block8: for (int i = 0; i < buffer.length; ++i) {
                switch (buffer[i]) {
                    case 22: {
                        dataLength = this.gds.iscVaxInteger(buffer, ++i, 2);
                        executionPlan = new String(buffer, (i += 2) + 1, dataLength);
                        i += dataLength - 1;
                        continue block8;
                    }
                    case 21: {
                        dataLength = this.gds.iscVaxInteger(buffer, ++i, 2);
                        statementType = this.gds.iscVaxInteger(buffer, i += 2, dataLength);
                        i += dataLength;
                    }
                    case 0: 
                    case 1: {
                        continue block8;
                    }
                    default: {
                        throw new GDSException(335544364);
                    }
                }
            }
            fixedStmt.setExecutionPlan(executionPlan);
            fixedStmt.setStatementType(statementType);
        }
        catch (GDSException ex) {
            this.notifyListeners(ex);
            throw ex;
        }
    }

    public IscBlobHandle openBlob(long blob_id, boolean segmented) throws GDSException {
        try {
            IscBlobHandle blob = this.gds.createIscBlobHandle();
            blob.setBlobId(blob_id);
            BlobParameterBuffer blobParameterBuffer = this.gds.createBlobParameterBuffer();
            blobParameterBuffer.addArgument(3, segmented ? 0 : 1);
            this.gds.iscOpenBlob2(this.currentDbHandle, this.currentTr, blob, blobParameterBuffer);
            return blob;
        }
        catch (GDSException ex) {
            this.notifyListeners(ex);
            throw ex;
        }
    }

    public IscBlobHandle createBlob(boolean segmented) throws GDSException {
        try {
            IscBlobHandle blob = this.gds.createIscBlobHandle();
            BlobParameterBuffer blobParameterBuffer = this.gds.createBlobParameterBuffer();
            blobParameterBuffer.addArgument(3, segmented ? 0 : 1);
            this.gds.iscCreateBlob2(this.currentDbHandle, this.currentTr, blob, blobParameterBuffer);
            return blob;
        }
        catch (GDSException ex) {
            this.notifyListeners(ex);
            throw ex;
        }
    }

    public byte[] getBlobSegment(IscBlobHandle blob, int len) throws GDSException {
        try {
            return this.gds.iscGetSegment(blob, len);
        }
        catch (GDSException ex) {
            this.notifyListeners(ex);
            throw ex;
        }
    }

    public void closeBlob(IscBlobHandle blob) throws GDSException {
        try {
            this.gds.iscCloseBlob(blob);
        }
        catch (GDSException ex) {
            this.notifyListeners(ex);
            throw ex;
        }
    }

    public void seekBlob(IscBlobHandle blob, int position, int mode) throws GDSException {
        try {
            this.gds.iscSeekBlob(blob, position, mode);
        }
        catch (GDSException ex) {
            this.notifyListeners(ex);
            throw ex;
        }
    }

    public void putBlobSegment(IscBlobHandle blob, byte[] buf) throws GDSException {
        try {
            this.gds.iscPutSegment(blob, buf);
        }
        catch (GDSException ex) {
            this.notifyListeners(ex);
            throw ex;
        }
    }

    public byte[] getBlobInfo(IscBlobHandle blob, byte[] requestItems, int bufferLength) throws GDSException {
        try {
            return this.gds.iscBlobInfo(blob, requestItems, bufferLength);
        }
        catch (GDSException ex) {
            this.notifyListeners(ex);
            throw ex;
        }
    }

    public int getBlobLength(IscBlobHandle blob) throws GDSException {
        try {
            byte[] info = this.gds.iscBlobInfo(blob, BLOB_LENGTH_REQUEST, 20);
            if (info[0] != 6) {
                throw new GDSException(335544364);
            }
            int dataLength = this.gds.iscVaxInteger(info, 1, 2);
            return this.gds.iscVaxInteger(info, 3, dataLength);
        }
        catch (GDSException ex) {
            this.notifyListeners(ex);
            throw ex;
        }
    }

    public AbstractIscTrHandle startTransaction(TransactionParameterBuffer tpb) throws GDSException {
        try {
            AbstractIscTrHandle trHandle = (AbstractIscTrHandle)this.gds.createIscTrHandle();
            this.gds.iscStartTransaction(trHandle, this.currentDbHandle, tpb);
            this.setCurrentTrHandle(trHandle);
            return trHandle;
        }
        catch (GDSException ex) {
            this.notifyListeners(ex);
            throw ex;
        }
    }

    public void prepareTransaction(AbstractIscTrHandle trHandle, byte[] message) throws GDSException {
        try {
            this.gds.iscPrepareTransaction2(trHandle, message);
        }
        catch (GDSException ex) {
            this.notifyListeners(ex);
            throw ex;
        }
    }

    public void commitTransaction(AbstractIscTrHandle trHandle) throws GDSException {
        try {
            this.gds.iscCommitTransaction(trHandle);
        }
        catch (GDSException ex) {
            this.notifyListeners(ex);
            throw ex;
        }
    }

    public void rollbackTransaction(AbstractIscTrHandle trHandle) throws GDSException {
        try {
            this.gds.iscRollbackTransaction(trHandle);
        }
        catch (GDSException ex) {
            this.notifyListeners(ex);
            throw ex;
        }
    }

    public void detachDatabase() throws GDSException {
        try {
            this.gds.iscDetachDatabase(this.currentDbHandle);
        }
        catch (GDSException ex) {
            this.notifyListeners(ex);
            throw ex;
        }
    }

    public int iscVaxInteger(byte[] buffer, int pos, int length) {
        return this.gds.iscVaxInteger(buffer, pos, length);
    }

    public String getDatabaseProductName() {
        return this.currentDbHandle.getDatabaseProductName();
    }

    public String getDatabaseProductVersion() {
        return this.currentDbHandle.getDatabaseProductVersion();
    }

    public int getDatabaseProductMajorVersion() {
        return this.currentDbHandle.getDatabaseProductMajorVersion();
    }

    public int getDatabaseProductMinorVersion() {
        return this.currentDbHandle.getDatabaseProductMinorVersion();
    }

    public String getUserName() {
        return this.dpb.getArgumentAsString(28);
    }

    public int getBlobBufferLength() {
        if (this.dpb.hasArgument(130)) {
            return this.dpb.getArgumentAsInt(130);
        }
        return 16384;
    }

    public String getIscEncoding() {
        try {
            String result = this.dpb.getArgumentAsString(48);
            if (result == null) {
                result = "NONE";
            }
            return result;
        }
        catch (NullPointerException ex) {
            return "NONE";
        }
    }

    public String getJavaEncoding() {
        return this.dpb.getArgumentAsString(135);
    }

    public String getMappingPath() {
        return this.dpb.getArgumentAsString(136);
    }

    public List getWarnings() {
        if (this.currentDbHandle == null) {
            return Collections.EMPTY_LIST;
        }
        return this.currentDbHandle.getWarnings();
    }

    public void clearWarnings() {
        if (this.currentDbHandle != null) {
            this.currentDbHandle.clearWarnings();
        }
    }

    public IscDbHandle getIscDBHandle() {
        return this.currentDbHandle;
    }

    public GDS getInternalAPIHandler() {
        return this.gds;
    }

    public static interface GDSHelperErrorListener {
        public void errorOccured(GDSException var1);
    }
}

