/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.manager;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.manager.ConnManager;
import com.cloudera.sqoop.manager.ManagerFactory;
import com.cloudera.sqoop.metastore.JobData;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sqoop.manager.Db2Manager;
import org.apache.sqoop.manager.DirectMySQLManager;
import org.apache.sqoop.manager.DirectPostgresqlManager;
import org.apache.sqoop.manager.HsqldbManager;
import org.apache.sqoop.manager.MySQLManager;
import org.apache.sqoop.manager.OracleManager;
import org.apache.sqoop.manager.PostgresqlManager;
import org.apache.sqoop.manager.SQLServerManager;

public class DefaultManagerFactory
extends ManagerFactory {
    public static final Log LOG = LogFactory.getLog((String)DefaultManagerFactory.class.getName());

    @Override
    public ConnManager accept(JobData data) {
        SqoopOptions options = data.getSqoopOptions();
        String scheme = this.extractScheme(options);
        if (null == scheme) {
            LOG.warn((Object)"Null scheme associated with connect string.");
            return null;
        }
        LOG.debug((Object)("Trying with scheme: " + scheme));
        if (scheme.equals("jdbc:mysql:")) {
            if (options.isDirect()) {
                return new DirectMySQLManager(options);
            }
            return new MySQLManager(options);
        }
        if (scheme.equals("jdbc:postgresql:")) {
            if (options.isDirect()) {
                return new DirectPostgresqlManager(options);
            }
            return new PostgresqlManager(options);
        }
        if (scheme.startsWith("jdbc:hsqldb:")) {
            return new HsqldbManager(options);
        }
        if (scheme.startsWith("jdbc:oracle:")) {
            return new OracleManager(options);
        }
        if (scheme.startsWith("jdbc:sqlserver:")) {
            return new SQLServerManager(options);
        }
        if (scheme.startsWith("jdbc:db2:")) {
            return new Db2Manager(options);
        }
        return null;
    }

    protected String extractScheme(SqoopOptions options) {
        String connectStr = options.getConnectString();
        int schemeStopIdx = connectStr.indexOf("//");
        if (-1 == schemeStopIdx && -1 == (schemeStopIdx = connectStr.lastIndexOf(58))) {
            LOG.warn((Object)"Could not determine scheme component of connect string");
            schemeStopIdx = connectStr.length();
        }
        return connectStr.substring(0, schemeStopIdx);
    }
}

