/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.util;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.manager.ImportJobContext;
import java.io.IOException;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class AppendUtils {
    public static final Log LOG = LogFactory.getLog((String)AppendUtils.class.getName());
    private static final SimpleDateFormat DATE_FORM = new SimpleDateFormat("ddHHmmssSSS");
    private static final String TEMP_IMPORT_ROOT = System.getProperty("sqoop.test.import.rootDir", "_sqoop");
    private static final int PARTITION_DIGITS = 5;
    private static final String FILEPART_SEPARATOR = "-";
    private static final String FILEEXT_SEPARATOR = ".";
    private ImportJobContext context = null;

    public AppendUtils(ImportJobContext context) {
        this.context = context;
    }

    public void append() throws IOException {
        SqoopOptions options = this.context.getOptions();
        FileSystem fs = FileSystem.get((Configuration)options.getConf());
        Path tempDir = this.context.getDestination();
        Path userDestDir = null;
        userDestDir = options.getTargetDir() != null ? new Path(options.getTargetDir()) : (options.getWarehouseDir() != null ? new Path(options.getWarehouseDir(), this.context.getTableName()) : new Path(this.context.getTableName()));
        int nextPartition = 0;
        if (!fs.exists(tempDir)) {
            LOG.warn((Object)("Cannot append files to target dir; no such directory: " + tempDir));
            return;
        }
        if (!fs.exists(userDestDir)) {
            LOG.info((Object)("Creating missing output directory - " + userDestDir.getName()));
            fs.mkdirs(userDestDir);
            nextPartition = 0;
        } else {
            LOG.info((Object)("Appending to directory " + userDestDir.getName()));
            nextPartition = this.getNextPartition(fs, userDestDir);
        }
        this.moveFiles(fs, tempDir, userDestDir, nextPartition);
        LOG.debug((Object)("Deleting temporary folder " + tempDir.getName()));
        fs.delete(tempDir, true);
    }

    private int getNextPartition(FileSystem fs, Path targetDir) throws IOException {
        int nextPartition = 0;
        FileStatus[] existingFiles = fs.listStatus(targetDir);
        if (existingFiles != null && existingFiles.length > 0) {
            Pattern patt = Pattern.compile("part.*-([0-9][0-9][0-9][0-9][0-9]).*");
            for (FileStatus fileStat : existingFiles) {
                int thisPart;
                String filename;
                Matcher mat;
                if (fileStat.isDir() || !(mat = patt.matcher(filename = fileStat.getPath().getName())).matches() || (thisPart = Integer.parseInt(mat.group(1))) < nextPartition) continue;
                nextPartition = thisPart;
                ++nextPartition;
            }
        }
        if (nextPartition > 0) {
            LOG.info((Object)("Using found partition " + nextPartition));
        }
        return nextPartition;
    }

    private void moveFiles(FileSystem fs, Path sourceDir, Path targetDir, int partitionStart) throws IOException {
        NumberFormat numpart = NumberFormat.getInstance();
        numpart.setMinimumIntegerDigits(5);
        numpart.setGroupingUsed(false);
        Pattern patt = Pattern.compile("part.*-([0-9][0-9][0-9][0-9][0-9]).*");
        FileStatus[] tempFiles = fs.listStatus(sourceDir);
        if (null == tempFiles) {
            throw new IOException("Could not list files from " + sourceDir);
        }
        for (FileStatus fileStat : tempFiles) {
            if (!fileStat.isDir()) {
                String filename = fileStat.getPath().getName();
                Matcher mat = patt.matcher(filename);
                if (!mat.matches()) continue;
                String name = this.getFilename(filename);
                String fileToMove = name.concat(numpart.format(partitionStart++));
                String extension = this.getFileExtension(filename);
                if (extension != null) {
                    fileToMove = fileToMove.concat(extension);
                }
                LOG.debug((Object)("Filename: " + filename + " repartitioned to: " + fileToMove));
                fs.rename(fileStat.getPath(), new Path(targetDir, fileToMove));
                continue;
            }
            String dirName = fileStat.getPath().getName();
            Path path = new Path(targetDir, dirName);
            int dirNumber = 0;
            while (fs.exists(path)) {
                path = new Path(targetDir, dirName.concat(FILEPART_SEPARATOR).concat(numpart.format(dirNumber++)));
            }
            LOG.debug((Object)("Directory: " + dirName + " renamed to: " + path.getName()));
            fs.rename(fileStat.getPath(), path);
        }
    }

    private String getFilename(String filename) {
        String result = null;
        int pos = filename.lastIndexOf(FILEPART_SEPARATOR);
        result = pos != -1 ? filename.substring(0, pos + 1) : ((pos = filename.lastIndexOf(FILEEXT_SEPARATOR)) != -1 ? filename.substring(0, pos) : filename);
        return result;
    }

    private String getFileExtension(String filename) {
        int pos = filename.lastIndexOf(FILEEXT_SEPARATOR);
        if (pos != -1) {
            return filename.substring(pos, filename.length());
        }
        return null;
    }

    public static Path getTempAppendDir(String tableName) {
        String timeId = DATE_FORM.format(new Date(System.currentTimeMillis()));
        String tempDir = TEMP_IMPORT_ROOT + "/" + timeId + tableName;
        return new Path(tempDir);
    }
}

