/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.ui.xul.jface.tags;

import java.beans.Expression;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.components.XulMenuList;
import org.pentaho.ui.xul.components.XulMenuitem;
import org.pentaho.ui.xul.containers.XulMenupopup;
import org.pentaho.ui.xul.dom.Element;
import org.pentaho.ui.xul.jface.tags.JfaceMenuitem;
import org.pentaho.ui.xul.jface.tags.JfaceMenupopup;
import org.pentaho.ui.xul.swt.AbstractSwtXulContainer;

public class JfaceMenuList<T>
extends AbstractSwtXulContainer
implements XulMenuList<T> {
    private Combo combobox;
    private XulDomContainer xulDomContainer;
    private static final Log logger = LogFactory.getLog(JfaceMenuList.class);
    private String binding;
    private Object previousSelectedItem = null;
    private String previousValue;
    private JfaceMenupopup popup;
    private JfaceMenuitem selectedItem = null;
    private List elements = null;
    private boolean editable = false;
    private String command;
    private XulComponent parent;

    public JfaceMenuList(Element self, XulComponent parent, XulDomContainer domContainer, String tagName) {
        super("menulist");
        this.xulDomContainer = domContainer;
        this.parent = parent;
        this.setEditable("true".equals(self.getAttributeValue("editable")));
        this.setupCombobox();
    }

    private void setupCombobox() {
        int style = 4;
        if (!this.editable) {
            style |= 8;
        }
        this.combobox = new Combo((Composite)this.parent.getManagedObject(), style);
        this.setManagedObject(this.combobox);
        this.combobox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JfaceMenuList.this.fireSelectedEvents();
            }
        });
        this.combobox.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                JfaceMenuList.this.fireModifiedEvents();
            }
        });
    }

    @Override
    public void addChild(Element ele) {
        int index;
        super.addChild(ele);
        if (!(ele instanceof XulMenupopup)) {
            return;
        }
        this.popup = (JfaceMenupopup)ele;
        int selectedIndex = index = -1;
        for (XulComponent child : this.popup.getChildNodes()) {
            ++index;
            if (!(child instanceof JfaceMenuitem) || !((JfaceMenuitem)child).isSelected()) continue;
            this.combobox.select(index);
            selectedIndex = index;
        }
        this.setSelectedIndex(selectedIndex);
    }

    @Override
    public void layout() {
        int i = 0;
        int index = -1;
        this.combobox.removeAll();
        for (XulComponent item : this.popup.getChildNodes()) {
            JfaceMenuitem mItem = (JfaceMenuitem)item;
            if (mItem.isVisible()) {
                this.combobox.add(mItem.getLabel());
            }
            if (mItem.isSelected()) {
                this.combobox.select(i);
                index = i;
            }
            ++i;
        }
        if (index == -1) {
            if (this.getEditable()) {
                this.setValue(this.previousValue);
            } else {
                this.setSelectedIndex(0);
            }
        }
        this.combobox.update();
    }

    @Deprecated
    public void replaceAllItems(Collection<T> tees) {
        this.setElements(tees);
    }

    public void setOncommand(String command) {
        this.command = command;
    }

    public Collection<T> getElements() {
        Object elements = null;
        elements = this.elements == null ? (this.popup == null ? null : this.popup.getChildNodes()) : this.elements;
        return elements;
    }

    public String getBinding() {
        return this.binding;
    }

    public void setBinding(String binding) {
        this.binding = binding;
    }

    private String extractLabel(T t) {
        String attribute = this.getBinding();
        if (StringUtils.isEmpty((String)attribute)) {
            return t.toString();
        }
        String getter = "get" + String.valueOf(attribute.charAt(0)).toUpperCase() + attribute.substring(1);
        try {
            return new Expression(t, getter, null).getValue().toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setElements(Collection<T> tees) {
        List menuItems = this.popup.getChildNodes();
        this.elements = (List)tees;
        int index = 0;
        int itemCount = menuItems.size();
        for (T t : tees) {
            XulMenuitem menuitem;
            if (index < itemCount) {
                menuitem = (XulMenuitem)menuItems.get(index);
                menuitem.setVisible(true);
            } else {
                menuitem = this.popup.createNewMenuitemAtPos(index);
            }
            ++index;
            menuitem.setLabel(this.extractLabel(t));
        }
        while (index < itemCount) {
            ((XulComponent)menuItems.get(index)).setVisible(false);
            ++index;
        }
        this.layout();
        this.setValue(this.previousValue);
    }

    public String getSelectedItem() {
        int idx = this.combobox.getSelectionIndex();
        return idx > -1 && idx < this.combobox.getItemCount() ? this.combobox.getItem(idx) : null;
    }

    public void setSelectedItem(T t) {
        List elements = (List)this.getElements();
        int index = t == null ? -1 : (elements == null ? this.combobox.indexOf(t.toString()) : elements.indexOf(t));
        this.setSelectedIndex(index);
    }

    public int getSelectedIndex() {
        Collection<T> elements = this.getElements();
        int selectedIndex = elements == null || elements.size() == 0 ? -1 : this.combobox.getSelectionIndex();
        return selectedIndex;
    }

    public void setSelectedIndex(int idx) {
        if (idx == -1) {
            this.combobox.clearSelection();
        } else {
            this.combobox.select(idx);
        }
        this.fireSelectedEvents();
    }

    @Override
    public void removeChild(Element ele) {
        String selected = this.getSelectedItem();
        super.removeChild(ele);
        if (selected == null) {
            return;
        }
        Collection<T> elist = this.getElements();
        for (T t : elist) {
            if (!selected.equals(t.toString())) continue;
            this.setSelectedItem(t);
        }
    }

    private void fireSelectedEvents() {
        int idx = this.getSelectedIndex();
        Collection<T> elements = this.getElements();
        if (idx >= 0) {
            Object newSelectedItem = elements == null ? null : elements.toArray()[idx];
            this.changeSupport.firePropertyChange("selectedItem", this.previousSelectedItem, newSelectedItem);
            this.previousSelectedItem = newSelectedItem;
        }
        this.changeSupport.firePropertyChange("selectedIndex", null, (Object)this.combobox.getSelectionIndex());
        if (this.command != null && this.getDocument() != null) {
            this.invoke(this.command, new Object[0]);
        }
    }

    private void fireModifiedEvents() {
        String newValue = this.getValue();
        this.changeSupport.firePropertyChange("value", this.previousValue, newValue);
        this.previousValue = newValue;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public boolean getEditable() {
        return this.editable;
    }

    public String getValue() {
        return this.combobox.getText();
    }

    public void setValue(String value) {
        if (value == null) {
            value = "";
        }
        this.combobox.setText(value);
    }

    @Override
    public void setDisabled(boolean disabled) {
        super.setDisabled(disabled);
        this.combobox.setEnabled(!disabled);
    }
}

