/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.ui.xul.swt.tags;

import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.VisibilityWindowListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.components.XulBrowser;
import org.pentaho.ui.xul.dom.Element;
import org.pentaho.ui.xul.swt.SwtElement;

public class SwtBrowser
extends SwtElement
implements XulBrowser {
    private static final String EMPTY_URL = "about:blank";
    private Browser browser;
    private Composite mainPanel;
    private boolean showToolbar = true;
    private Text location;
    private ToolBar toolbar;
    private String src = "about:blank";
    private String home;
    private Composite toolbarPanel;

    public SwtBrowser(Element self, XulComponent parent, XulDomContainer container, String tagName) {
        super(tagName);
        Composite parentComposite = (Composite)parent.getManagedObject();
        this.mainPanel = new Composite(parentComposite, 2048);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.mainPanel.setLayout((Layout)layout);
        this.setManagedObject(this.mainPanel);
    }

    public void execute(String data) {
        this.browser.execute(data);
    }

    public String getData() {
        return "" + this.browser.getData();
    }

    public String getSrc() {
        return this.browser.getUrl();
    }

    public void setSrc(String src) {
        if (StringUtils.isEmpty((String)src)) {
            src = EMPTY_URL;
        }
        if (this.browser != null) {
            this.browser.setUrl(src);
            this.location.setText(src);
        }
        this.src = src;
        if (this.home == null) {
            this.home = src;
        }
    }

    public void back() {
        this.browser.back();
    }

    public void forward() {
        this.browser.forward();
    }

    public void home() {
        this.browser.setUrl(this.home);
    }

    public void reload() {
        this.browser.refresh();
    }

    public void stop() {
        this.browser.stop();
    }

    @Override
    public void layout() {
        this.toolbarPanel = new Composite(this.mainPanel, 2048);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        this.toolbarPanel.setLayoutData((Object)data);
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.toolbarPanel.setLayout((Layout)layout);
        this.toolbar = new ToolBar(this.toolbarPanel, 0x800100);
        ToolItem item = new ToolItem(this.toolbar, 8);
        item.setText("<");
        item.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent se) {
            }

            public void widgetSelected(SelectionEvent se) {
                SwtBrowser.this.back();
            }
        });
        data = new GridData();
        data.horizontalSpan = 1;
        data.grabExcessHorizontalSpace = false;
        this.toolbar.setLayoutData((Object)data);
        item = new ToolItem(this.toolbar, 8);
        item.setText(">");
        item.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent se) {
            }

            public void widgetSelected(SelectionEvent se) {
                SwtBrowser.this.forward();
            }
        });
        item = new ToolItem(this.toolbar, 8);
        item.setText("R");
        item.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent se) {
            }

            public void widgetSelected(SelectionEvent se) {
                SwtBrowser.this.reload();
            }
        });
        this.location = new Text(this.toolbarPanel, 2048);
        this.location.setText(this.src);
        this.location.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent arg0) {
                if (arg0.character == '\r') {
                    SwtBrowser.this.setSrc(SwtBrowser.this.location.getText());
                }
            }
        });
        data = new GridData();
        data.horizontalSpan = 2;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.location.setLayoutData((Object)data);
        this.browser = this.createBrowser(this.mainPanel);
        this.hookupBrowserListeners(this.browser, false);
        this.browser.addCloseWindowListener(new CloseWindowListener(){

            public void close(WindowEvent event) {
                Browser browser = (Browser)event.widget;
                Shell shell = browser.getShell();
                shell.close();
            }
        });
        this.browser.setUrl(this.src);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        this.browser.setLayoutData((Object)data);
        this.browser.addLocationListener(new LocationListener(){

            public void changed(LocationEvent arg0) {
                SwtBrowser.this.src = arg0.location;
                SwtBrowser.this.location.setText(arg0.location);
            }

            public void changing(LocationEvent arg0) {
            }
        });
        this.setShowtoolbar(this.getShowtoolbar());
        this.mainPanel.layout(true);
    }

    private void hookupBrowserListeners(final Browser browser, boolean visibilityListeners) {
        browser.addOpenWindowListener(new OpenWindowListener(){

            public void open(WindowEvent event) {
                Shell shell = new Shell(browser.getShell());
                shell.setText("");
                shell.setLayout((Layout)new FillLayout());
                Browser newBrowser = new Browser((Composite)shell, 0);
                SwtBrowser.this.hookupBrowserListeners(newBrowser, true);
                event.browser = newBrowser;
            }
        });
        if (!visibilityListeners) {
            return;
        }
        browser.addVisibilityWindowListener(new VisibilityWindowListener(){

            public void hide(WindowEvent event) {
                Browser b = (Browser)event.widget;
                Shell shell = b.getShell();
                shell.setVisible(false);
            }

            public void show(WindowEvent event) {
                Browser b = (Browser)event.widget;
                Shell shell = b.getShell();
                if (event.location != null) {
                    shell.setLocation(event.location);
                }
                if (event.size != null) {
                    Point size = event.size;
                    shell.setSize(shell.computeSize(size.x, size.y));
                }
                if (!"webkit".equals(b.getBrowserType()) || event.addressBar) {
                    shell.open();
                }
            }
        });
    }

    protected Browser createBrowser(Composite parent) {
        Browser browser = new Browser(parent, SwtBrowser.isCentOS() ? 32768 : 0);
        browser.setUrl(EMPTY_URL);
        return browser;
    }

    public boolean getShowtoolbar() {
        return this.showToolbar;
    }

    public void setShowtoolbar(boolean flag) {
        this.showToolbar = flag;
        if (this.toolbarPanel != null) {
            this.toolbarPanel.setVisible(flag);
            ((GridData)this.toolbarPanel.getLayoutData()).exclude = !this.showToolbar;
            this.mainPanel.layout(true);
        }
    }

    public Browser getBrowser() {
        return this.browser;
    }

    private static boolean isCentOS() {
        String os = System.getProperty("os.name").toLowerCase();
        String osVersion = System.getProperty("os.version").toLowerCase();
        return os.indexOf("nux") >= 0 && osVersion.contains("centos");
    }
}

