/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.ui.xul.swt.tags;

import java.util.List;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.containers.XulMenu;
import org.pentaho.ui.xul.containers.XulRoot;
import org.pentaho.ui.xul.dom.Element;
import org.pentaho.ui.xul.swt.AbstractSwtXulContainer;
import org.pentaho.ui.xul.swt.tags.SwtMenupopup;
import org.pentaho.ui.xul.util.Orient;

public class SwtMenu
extends AbstractSwtXulContainer
implements XulMenu {
    private Menu menu;
    private String accel = null;
    private MenuItem header;
    private Menu dropdown;
    private Shell shell;
    private XulComponent parent;
    private XulDomContainer domContainer;

    public SwtMenu(Element self, XulComponent parent, XulDomContainer domContainer, String tagName) {
        super("menu");
        this.domContainer = domContainer;
        if (domContainer.getOuterContext() != null) {
            this.shell = (Shell)domContainer.getOuterContext();
        }
        this.orient = Orient.VERTICAL;
        if (this.shell == null) {
            XulComponent p;
            for (p = parent; p != null && !(p instanceof XulRoot); p = p.getParent()) {
            }
            if (p != null && p instanceof XulRoot) {
                this.shell = (Shell)p.getManagedObject();
            }
        }
        this.header = new MenuItem((Menu)parent.getManagedObject(), 64);
        this.setManagedObject(this.header);
        this.parent = parent;
    }

    public XulComponent getParent() {
        return this.parent;
    }

    private void addMenuChildren(Menu menuParent, List<XulComponent> children) {
        for (Element element : children) {
            for (XulComponent compInner : ((SwtMenupopup)element).getChildNodes()) {
                if (!(compInner instanceof XulMenu)) continue;
                MenuItem item = new MenuItem(menuParent, 64);
                Menu flyout = new Menu((Decorations)this.shell, 4);
                item.setMenu(flyout);
                this.addMenuChildren(flyout, compInner.getChildNodes());
            }
        }
    }

    @Override
    public void layout() {
        this.initialized = true;
    }

    public String getAcceltext() {
        return this.accel;
    }

    public String getAccesskey() {
        return String.valueOf(this.header.getAccelerator());
    }

    @Override
    public boolean isDisabled() {
        return !this.header.isEnabled();
    }

    public String getLabel() {
        return this.header.getText();
    }

    public void setAcceltext(String accel) {
        this.accel = accel;
    }

    public void setAccesskey(String accessKey) {
        if (this.header != null) {
            String remainder;
            int mask = 0;
            if (accessKey.indexOf("ctrl") > -1) {
                mask += 262144;
            }
            if (accessKey.indexOf("shift") > -1) {
                mask += 131072;
            }
            if (accessKey.indexOf("alt") > -1) {
                mask += 65536;
            }
            if ((remainder = accessKey.replaceAll("ctrl", "").replaceAll("shift", "").replaceAll("alt", "").replaceAll("-", "").trim()).length() == 1) {
                mask += remainder.charAt(0);
            }
            this.header.setAccelerator(mask);
        }
    }

    @Override
    public void setDisabled(boolean disabled) {
        if (this.header != null) {
            this.header.setEnabled(!disabled);
        }
    }

    public void setLabel(String label) {
        if (this.header != null) {
            this.header.setText(label);
        }
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.header.setEnabled(visible);
    }
}

