/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.base.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.pentaho.reporting.libraries.base.util.EmptyIterator;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class HashNMap<K, V>
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -670924844536074826L;
    private HashMap<K, List<V>> table = new HashMap();
    private static final Object[] EMPTY_ARRAY = new Object[0];

    protected List<V> createList() {
        return new ArrayList();
    }

    public boolean put(K key, V val) {
        List<V> v = this.table.get(key);
        if (v == null) {
            List<V> newList = this.createList();
            newList.add(val);
            this.table.put(key, newList);
            return true;
        }
        v.clear();
        return v.add(val);
    }

    public boolean add(K key, V val) {
        List<V> v = this.table.get(key);
        if (v == null) {
            this.put(key, val);
            return true;
        }
        return v.add(val);
    }

    public V getFirst(K key) {
        return this.get(key, 0);
    }

    public V get(K key, int n) {
        List<V> v = this.table.get(key);
        if (v == null) {
            return null;
        }
        return v.get(n);
    }

    public Iterator<V> getAll(K key) {
        List<V> v = this.table.get(key);
        if (v == null) {
            return EmptyIterator.emptyIterator();
        }
        return v.iterator();
    }

    public Iterator<K> keys() {
        return this.table.keySet().iterator();
    }

    public Set<K> keySet() {
        return this.table.keySet();
    }

    public boolean remove(K key, V value) {
        List<V> v = this.table.get(key);
        if (v == null) {
            return false;
        }
        if (!v.remove(value)) {
            return false;
        }
        if (v.isEmpty()) {
            this.table.remove(key);
        }
        return true;
    }

    public void removeAll(K key) {
        this.table.remove(key);
    }

    public void clear() {
        this.table.clear();
    }

    public boolean containsKey(K key) {
        return this.table.containsKey(key);
    }

    public boolean containsValue(V value) {
        Iterator<List<V>> e = this.table.values().iterator();
        boolean found = false;
        while (e.hasNext() && !found) {
            List<V> v = e.next();
            found = v.contains(value);
        }
        return found;
    }

    public boolean containsValue(K key, V value) {
        List<V> v = this.table.get(key);
        if (v == null) {
            return false;
        }
        return v.contains(value);
    }

    public Object clone() throws CloneNotSupportedException {
        HashNMap map = (HashNMap)super.clone();
        map.table = (HashMap)this.table.clone();
        for (Map.Entry<K, List<Object>> entry : map.table.entrySet()) {
            List<V> list = entry.getValue();
            if (list == null) continue;
            entry.setValue((List<Object>)ObjectUtilities.clone(list));
        }
        return map;
    }

    public V[] toArray(K key, V[] data) {
        if (key == null) {
            throw new NullPointerException("Key must not be null.");
        }
        List<V> list = this.table.get(key);
        if (list != null) {
            return list.toArray(data);
        }
        if (data.length > 0) {
            data[0] = null;
        }
        return data;
    }

    public Object[] toArray(K key) {
        if (key == null) {
            throw new NullPointerException("Key must not be null.");
        }
        List<V> list = this.table.get(key);
        if (list != null) {
            return list.toArray();
        }
        return EMPTY_ARRAY;
    }

    public int getValueCount(K key) {
        if (key == null) {
            throw new NullPointerException("Key must not be null.");
        }
        List<V> list = this.table.get(key);
        if (list != null) {
            return list.size();
        }
        return 0;
    }

    public boolean isEmpty() {
        return this.table.isEmpty();
    }
}

