/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.base.versioning;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.base.versioning.ProjectInformation;

public class VersionHelper {
    private static final Log logger = LogFactory.getLog(VersionHelper.class);
    private static final ManifestCache manifestCache = new ManifestCache();
    private String version;
    private String title;
    private String productId;
    private String releaseMilestone;
    private String releaseMinor;
    private String releaseMajor;
    private String releaseCandidateToken;
    private String releaseNumber;
    private String releaseBuildNumber;
    private ProjectInformation projectInformation;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VersionHelper(ProjectInformation projectInformation) {
        Manifest manifest;
        block14: {
            if (projectInformation == null) {
                throw new NullPointerException();
            }
            this.projectInformation = projectInformation;
            manifest = manifestCache.get(projectInformation.getInternalName());
            if (manifest == null) {
                ClassLoader loader = projectInformation.getClass().getClassLoader();
                try {
                    Enumeration<URL> resources = loader.getResources("META-INF/MANIFEST.MF");
                    while (resources.hasMoreElements()) {
                        Attributes attr;
                        String maybeTitle;
                        URL url = resources.nextElement();
                        String urlAsText = url.toURI().toString();
                        Manifest maybeManifest = manifestCache.getByURL(urlAsText);
                        if (maybeManifest == null) {
                            InputStream inputStream = url.openStream();
                            try {
                                maybeManifest = new Manifest(new BufferedInputStream(inputStream));
                            }
                            finally {
                                inputStream.close();
                            }
                        }
                        if ((maybeTitle = this.getValue(attr = this.getAttributes(maybeManifest, projectInformation.getInternalName()), "Implementation-ProductID", null)) != null) {
                            manifestCache.set(maybeTitle, urlAsText, maybeManifest);
                            if (!maybeTitle.equals(projectInformation.getInternalName())) continue;
                            manifest = maybeManifest;
                            break;
                        }
                        manifestCache.set(maybeTitle, urlAsText, maybeManifest);
                    }
                }
                catch (Exception e) {
                    if (!logger.isDebugEnabled()) break block14;
                    logger.debug((Object)("Failed to read manifest for retrieving library version information for " + projectInformation.getProductId()), (Throwable)e);
                }
            }
        }
        if (manifest != null) {
            this.init(manifest);
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Failed to create version information for " + projectInformation.getInternalName()));
            }
            this.version = "TRUNK.development";
            this.title = projectInformation.getInternalName();
            this.productId = projectInformation.getInternalName();
            this.releaseMajor = "0";
            this.releaseMinor = "0";
            this.releaseMilestone = "0";
            this.releaseCandidateToken = "snapshot";
            this.releaseBuildNumber = "0";
            this.releaseNumber = this.createReleaseVersion();
        }
    }

    private boolean init(Manifest props) {
        try {
            Attributes attr = this.getAttributes(props, this.projectInformation.getInternalName());
            String maybeTitle = this.getValue(attr, "Implementation-ProductID", null);
            if (!ObjectUtilities.equal(this.projectInformation.getInternalName(), maybeTitle)) {
                return false;
            }
            this.title = this.getValue(attr, "Implementation-Title", maybeTitle);
            this.version = this.getValue(attr, "Implementation-Version", "");
            if (this.version.length() == 0) {
                this.version = "TRUNK.development";
            }
            this.releaseMajor = "0";
            this.releaseMinor = "0";
            this.releaseMilestone = "0";
            this.releaseCandidateToken = "snapshot";
            this.releaseBuildNumber = "0";
            if (!this.version.startsWith("TRUNK")) {
                String implIndicator;
                String versionNumber;
                int dashPos = this.version.indexOf(45);
                if (dashPos != -1) {
                    versionNumber = this.version.substring(0, dashPos);
                    implIndicator = this.version.substring(dashPos + 1);
                } else {
                    versionNumber = this.version;
                    implIndicator = "";
                }
                if (!StringUtils.isEmpty(versionNumber)) {
                    StringTokenizer tokImpl;
                    StringTokenizer tokNum = new StringTokenizer(versionNumber, ".");
                    if (tokNum.hasMoreTokens()) {
                        this.releaseMajor = tokNum.nextToken();
                    }
                    if (tokNum.hasMoreTokens()) {
                        this.releaseMinor = tokNum.nextToken();
                    }
                    if (tokNum.hasMoreTokens()) {
                        this.releaseMilestone = tokNum.nextToken();
                    }
                    if ((tokImpl = new StringTokenizer(implIndicator, ".")).hasMoreTokens()) {
                        this.releaseCandidateToken = tokImpl.nextToken();
                    }
                    if (tokImpl.hasMoreTokens()) {
                        this.releaseBuildNumber = tokImpl.nextToken();
                    }
                }
            }
            this.releaseNumber = this.createReleaseVersion();
            this.productId = maybeTitle;
            if (this.productId.length() == 0) {
                this.productId = this.createProductId();
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private Attributes getAttributes(Manifest props, String name) {
        Attributes attributes = props.getAttributes(name);
        if (attributes == null) {
            return props.getMainAttributes();
        }
        return attributes;
    }

    private String getValue(Attributes attrs, String name, String defaultValue) {
        String value = attrs.getValue(name);
        if (value == null) {
            return defaultValue;
        }
        return value.trim();
    }

    private String createProductId() {
        if (this.version.trim().length() == 0) {
            return this.title;
        }
        return this.title + '-' + this.version;
    }

    private String createReleaseVersion() {
        StringBuilder buffer = new StringBuilder(50);
        buffer.append(this.releaseMajor);
        buffer.append('.');
        buffer.append(this.releaseMinor);
        buffer.append('.');
        buffer.append(this.releaseMilestone);
        if (this.releaseCandidateToken.length() > 0) {
            buffer.append('-');
            buffer.append(this.releaseCandidateToken);
        }
        if (this.releaseBuildNumber.length() > 0) {
            buffer.append(" (Build ");
            buffer.append(this.releaseBuildNumber);
            buffer.append(')');
        }
        return buffer.toString();
    }

    public String getVersion() {
        return this.version;
    }

    public String getTitle() {
        return this.title;
    }

    public String getProductId() {
        return this.productId;
    }

    public String getReleaseMilestone() {
        return this.releaseMilestone;
    }

    public String getReleaseMinor() {
        return this.releaseMinor;
    }

    public String getReleaseMajor() {
        return this.releaseMajor;
    }

    public String getReleaseCandidateToken() {
        return this.releaseCandidateToken;
    }

    public String getReleaseNumber() {
        return this.releaseNumber;
    }

    public String getReleaseBuildNumber() {
        return this.releaseBuildNumber;
    }

    private static class ManifestCache {
        private Map<String, Manifest> manifests = new HashMap<String, Manifest>();
        private Map<String, Manifest> manifestsByURL = new HashMap<String, Manifest>();

        public synchronized Manifest get(String title) {
            return this.manifests.get(title);
        }

        public synchronized void set(String title, String url, Manifest manifest) {
            if (title != null) {
                this.manifests.put(title, manifest);
            }
            this.manifestsByURL.put(url, manifest);
        }

        public synchronized Manifest getByURL(String url) {
            return this.manifestsByURL.get(url);
        }
    }
}

