/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.mongodbinput;

import com.mongodb.AggregationOutput;
import com.mongodb.DBObject;
import com.mongodb.ServerAddress;
import com.mongodb.util.JSON;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.mongodbinput.MongoDbInputData;
import org.pentaho.di.trans.steps.mongodbinput.MongoDbInputMeta;
import org.pentaho.mongo.AuthContext;
import org.pentaho.mongo.MongoUtils;

public class MongoDbInput
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = MongoDbInputMeta.class;
    private MongoDbInputMeta meta;
    private MongoDbInputData data;
    private boolean m_serverDetermined;
    private Object[] m_currentInputRowDrivingQuery = null;

    public MongoDbInput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        AuthContext context = MongoUtils.createAuthContext(this.meta, (VariableSpace)this);
        try {
            return context.doAs(new PrivilegedExceptionAction<Boolean>(){

                @Override
                public Boolean run() throws KettleException {
                    boolean hasNext;
                    if (MongoDbInput.this.meta.getExecuteForEachIncomingRow() && MongoDbInput.this.m_currentInputRowDrivingQuery == null) {
                        MongoDbInput.access$102(MongoDbInput.this, MongoDbInput.this.getRow());
                        if (MongoDbInput.this.m_currentInputRowDrivingQuery == null) {
                            MongoDbInput.this.setOutputDone();
                            return false;
                        }
                        if (!MongoDbInput.this.first) {
                            MongoDbInput.this.initQuery();
                        }
                    }
                    if (MongoDbInput.this.first) {
                        ((MongoDbInput)MongoDbInput.this).data.outputRowMeta = new RowMeta();
                        MongoDbInput.this.meta.getFields(((MongoDbInput)MongoDbInput.this).data.outputRowMeta, MongoDbInput.this.getStepname(), null, null, (VariableSpace)MongoDbInput.this);
                        MongoDbInput.this.initQuery();
                        MongoDbInput.this.first = false;
                        MongoDbInput.this.data.init();
                    }
                    boolean bl = (MongoDbInput.this.meta.getQueryIsPipeline() ? ((MongoDbInput)MongoDbInput.this).data.m_pipelineResult.hasNext() : ((MongoDbInput)MongoDbInput.this).data.cursor.hasNext()) && !MongoDbInput.this.isStopped() ? true : (hasNext = false);
                    if (hasNext) {
                        ServerAddress s;
                        DBObject nextDoc = null;
                        Object[] row = null;
                        nextDoc = MongoDbInput.this.meta.getQueryIsPipeline() ? ((MongoDbInput)MongoDbInput.this).data.m_pipelineResult.next() : ((MongoDbInput)MongoDbInput.this).data.cursor.next();
                        if (!MongoDbInput.this.meta.getQueryIsPipeline() && !MongoDbInput.this.m_serverDetermined && (s = ((MongoDbInput)MongoDbInput.this).data.cursor.getServerAddress()) != null) {
                            MongoDbInput.this.m_serverDetermined = true;
                            MongoDbInput.this.logBasic(BaseMessages.getString((Class)PKG, (String)"MongoDbInput.Message.QueryPulledDataFrom", (String[])new String[]{s.toString()}));
                        }
                        if (MongoDbInput.this.meta.getOutputJson() || MongoDbInput.this.meta.getMongoFields() == null || MongoDbInput.this.meta.getMongoFields().size() == 0) {
                            String json = nextDoc.toString();
                            row = RowDataUtil.allocateRowData((int)((MongoDbInput)MongoDbInput.this).data.outputRowMeta.size());
                            int index = 0;
                            row[index++] = json;
                            MongoDbInput.this.putRow(((MongoDbInput)MongoDbInput.this).data.outputRowMeta, row);
                        } else {
                            Object[][] outputRows = MongoDbInput.this.data.mongoDocumentToKettle(nextDoc, (VariableSpace)MongoDbInput.this);
                            for (int i = 0; i < outputRows.length; ++i) {
                                MongoDbInput.this.putRow(((MongoDbInput)MongoDbInput.this).data.outputRowMeta, outputRows[i]);
                            }
                        }
                    } else {
                        if (!MongoDbInput.this.meta.getExecuteForEachIncomingRow()) {
                            MongoDbInput.this.setOutputDone();
                            return false;
                        }
                        MongoDbInput.access$102(MongoDbInput.this, null);
                    }
                    return true;
                }
            });
        }
        catch (PrivilegedActionException e) {
            Exception cause = e.getException();
            if (cause instanceof KettleException) {
                throw (KettleException)cause;
            }
            throw new KettleException("Unexpected error", (Throwable)e.getException());
        }
    }

    protected void initQuery() throws KettleException {
        if (this.data.cursor != null) {
            this.data.cursor.close();
        }
        if (this.log.isDetailed()) {
            this.m_serverDetermined = false;
        }
        String query = this.environmentSubstitute(this.meta.getJsonQuery());
        String fields = this.environmentSubstitute(this.meta.getFieldsName());
        if (Const.isEmpty((String)query) && Const.isEmpty((String)fields)) {
            if (this.meta.getQueryIsPipeline()) {
                throw new KettleException(BaseMessages.getString(MongoDbInputMeta.PKG, (String)"MongoDbInput.ErrorMessage.EmptyAggregationPipeline", (String[])new String[0]));
            }
            this.data.cursor = this.data.collection.find();
        } else if (this.meta.getQueryIsPipeline()) {
            if (Const.isEmpty((String)query)) {
                throw new KettleException(BaseMessages.getString(MongoDbInputMeta.PKG, (String)"MongoDbInput.ErrorMessage.EmptyAggregationPipeline", (String[])new String[0]));
            }
            if (this.meta.getExecuteForEachIncomingRow() && this.m_currentInputRowDrivingQuery != null) {
                query = this.fieldSubstitute(query, this.getInputRowMeta(), this.m_currentInputRowDrivingQuery);
            }
            this.logDetailed(BaseMessages.getString(PKG, (String)"MongoDbInput.Message.QueryPulledDataFrom", (String[])new String[]{query}));
            List<DBObject> pipeline = MongoDbInputData.jsonPipelineToDBObjectList(query);
            DBObject firstP = pipeline.get(0);
            DBObject[] remainder = null;
            if (pipeline.size() > 1) {
                remainder = new DBObject[pipeline.size() - 1];
                for (int i = 1; i < pipeline.size(); ++i) {
                    remainder[i - 1] = pipeline.get(i);
                }
            } else {
                remainder = new DBObject[]{};
            }
            AggregationOutput result = this.data.collection.aggregate(firstP, remainder);
            this.data.m_pipelineResult = result.results().iterator();
            if (this.first) {
                this.logBasic(BaseMessages.getString(PKG, (String)"MongoDbInput.Message.AggregationPulledDataFrom", (String[])new String[]{result.getServerUsed().toString()}));
            } else {
                this.logDetailed(BaseMessages.getString(PKG, (String)"MongoDbInput.Message.AggregationPulledDataFrom", (String[])new String[]{result.getServerUsed().toString()}));
            }
        } else {
            if (this.meta.getExecuteForEachIncomingRow() && this.m_currentInputRowDrivingQuery != null) {
                query = this.fieldSubstitute(query, this.getInputRowMeta(), this.m_currentInputRowDrivingQuery);
                fields = this.fieldSubstitute(fields, this.getInputRowMeta(), this.m_currentInputRowDrivingQuery);
            }
            this.logDetailed(BaseMessages.getString(PKG, (String)"MongoDbInput.Message.ExecutingQuery", (String[])new String[]{query}));
            DBObject dbObject = (DBObject)JSON.parse((String)(Const.isEmpty((String)query) ? "{}" : query));
            DBObject dbObject2 = (DBObject)JSON.parse((String)fields);
            this.data.cursor = this.data.collection.find(dbObject, dbObject2);
        }
    }

    public boolean init(StepMetaInterface stepMetaInterface, StepDataInterface stepDataInterface) {
        if (super.init(stepMetaInterface, stepDataInterface)) {
            this.meta = (MongoDbInputMeta)stepMetaInterface;
            this.data = (MongoDbInputData)stepDataInterface;
            String hostname = this.environmentSubstitute(this.meta.getHostnames());
            int port = Const.toInt((String)this.environmentSubstitute(this.meta.getPort()), (int)27017);
            String db = this.environmentSubstitute(this.meta.getDbName());
            String collection = this.environmentSubstitute(this.meta.getCollection());
            try {
                if (Const.isEmpty((String)db)) {
                    throw new Exception(BaseMessages.getString(PKG, (String)"MongoInput.ErrorMessage.NoDBSpecified", (String[])new String[0]));
                }
                if (Const.isEmpty((String)collection)) {
                    throw new Exception(BaseMessages.getString(PKG, (String)"MongoInput.ErrorMessage.NoCollectionSpecified", (String[])new String[0]));
                }
                if (!Const.isEmpty((String)this.meta.getAuthenticationUser())) {
                    String authInfo = this.meta.getUseKerberosAuthentication() ? BaseMessages.getString(PKG, (String)"MongoDbInput.Message.KerberosAuthentication", (String[])new String[]{this.environmentSubstitute(this.meta.getAuthenticationUser())}) : BaseMessages.getString(PKG, (String)"MongoDbInput.Message.NormalAuthentication", (String[])new String[]{this.environmentSubstitute(this.meta.getAuthenticationUser())});
                    this.logBasic(authInfo);
                }
                this.data.mongo = MongoDbInputData.initConnection(this.meta, (VariableSpace)this, this.log);
                this.data.db = this.data.mongo.getDB(db);
                this.data.collection = this.data.db.getCollection(collection);
                if (!((MongoDbInputMeta)stepMetaInterface).getOutputJson()) {
                    ((MongoDbInputData)stepDataInterface).setMongoFields(((MongoDbInputMeta)stepMetaInterface).getMongoFields());
                }
                return true;
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"MongoDbInput.ErrorConnectingToMongoDb.Exception", (String[])new String[]{hostname, "" + port, db, collection}), e);
                return false;
            }
        }
        return false;
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        if (this.data.cursor != null) {
            this.data.cursor.close();
        }
        if (this.data.mongo != null) {
            this.data.mongo.close();
        }
        super.dispose(smi, sdi);
    }

    static /* synthetic */ Object[] access$102(MongoDbInput x0, Object[] x1) {
        x0.m_currentInputRowDrivingQuery = x1;
        return x1;
    }
}

