/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.mongodbinput;

import com.mongodb.AggregationOutput;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.util.JSON;
import java.math.BigDecimal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bson.types.BSONTimestamp;
import org.bson.types.Binary;
import org.bson.types.Code;
import org.bson.types.MaxKey;
import org.bson.types.MinKey;
import org.bson.types.ObjectId;
import org.bson.types.Symbol;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.step.BaseStepData;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.steps.mongodbinput.MongoDbInputMeta;
import org.pentaho.mongo.AuthContext;
import org.pentaho.mongo.MongoUtils;

public class MongoDbInputData
extends BaseStepData
implements StepDataInterface {
    public static final int MONGO_DEFAULT_PORT = 27017;
    public RowMetaInterface outputRowMeta;
    public MongoClient mongo;
    public DB db;
    public DBCollection collection;
    public MongoClient m_mongoClient;
    public DBCursor cursor;
    Iterator<DBObject> m_pipelineResult;
    private List<MongoField> m_userFields;
    private MongoArrayExpansion m_expansionHandler;

    protected static MongoArrayExpansion checkFieldPaths(List<MongoField> normalFields, RowMetaInterface outputRowMeta) throws KettleException {
        String expansion = null;
        ArrayList<MongoField> normalList = new ArrayList<MongoField>();
        ArrayList<MongoField> expansionList = new ArrayList<MongoField>();
        for (MongoField f : normalFields) {
            String path = f.m_fieldPath;
            if (path != null && path.lastIndexOf("[*]") >= 0) {
                if (path.indexOf("[*]") != path.lastIndexOf("[*]")) {
                    throw new KettleException(BaseMessages.getString(MongoDbInputMeta.PKG, (String)"MongoInput.ErrorMessage.PathContainsMultipleExpansions", (String[])new String[]{path}));
                }
                String pathPart = path.substring(0, path.lastIndexOf("[*]") + 3);
                if (expansion == null) {
                    expansion = pathPart;
                } else if (!expansion.equals(pathPart)) {
                    throw new KettleException(BaseMessages.getString(MongoDbInputMeta.PKG, (String)"MongoDbInput.ErrorMessage.MutipleDifferentExpansions", (String[])new String[0]));
                }
                expansionList.add(f);
                continue;
            }
            normalList.add(f);
        }
        normalFields.clear();
        for (MongoField f : normalList) {
            normalFields.add(f);
        }
        if (expansionList.size() > 0) {
            ArrayList<MongoField> subFields = new ArrayList<MongoField>();
            for (MongoField ef : expansionList) {
                MongoField subField = new MongoField();
                subField.m_fieldName = ef.m_fieldName;
                String path = ef.m_fieldPath;
                if (path.charAt(path.length() - 2) == '*') {
                    path = "dummy";
                } else {
                    path = path.substring(path.lastIndexOf("[*]") + 3, path.length());
                    path = "$" + path;
                }
                subField.m_fieldPath = path;
                subField.m_indexedVals = ef.m_indexedVals;
                subField.m_kettleType = ef.m_kettleType;
                subFields.add(subField);
            }
            MongoArrayExpansion exp = new MongoArrayExpansion(subFields);
            exp.m_expansionPath = expansion;
            exp.m_outputRowMeta = outputRowMeta;
            return exp;
        }
        return null;
    }

    public void init() throws KettleException {
        if (this.m_userFields != null) {
            this.m_expansionHandler = MongoDbInputData.checkFieldPaths(this.m_userFields, this.outputRowMeta);
            for (MongoField f : this.m_userFields) {
                int outputIndex = this.outputRowMeta.indexOfValue(f.m_fieldName);
                f.init(outputIndex);
            }
            if (this.m_expansionHandler != null) {
                this.m_expansionHandler.init();
            }
        }
    }

    public Object[][] mongoDocumentToKettle(DBObject mongoObj, VariableSpace space) throws KettleException {
        Object[][] result = null;
        if (this.m_expansionHandler != null) {
            this.m_expansionHandler.reset(space);
            result = mongoObj instanceof BasicDBObject ? this.m_expansionHandler.convertToKettleValue((BasicDBObject)mongoObj, space) : this.m_expansionHandler.convertToKettleValue((BasicDBList)mongoObj, space);
        } else {
            result = new Object[1][];
        }
        Object[] normalData = RowDataUtil.allocateRowData((int)this.outputRowMeta.size());
        for (MongoField f : this.m_userFields) {
            Object value = null;
            f.reset(space);
            if (mongoObj instanceof BasicDBObject) {
                value = f.convertToKettleValue((BasicDBObject)mongoObj);
            } else if (mongoObj instanceof BasicDBList) {
                value = f.convertToKettleValue((BasicDBList)mongoObj);
            }
            normalData[f.m_outputIndex] = value;
        }
        if (this.m_expansionHandler == null) {
            result[0] = normalData;
        } else {
            for (int i = 0; i < result.length; ++i) {
                Object[] row = result[i];
                for (MongoField f : this.m_userFields) {
                    row[f.m_outputIndex] = normalData[f.m_outputIndex];
                }
            }
        }
        return result;
    }

    public static MongoClient initConnection(MongoDbInputMeta meta, VariableSpace vars, LogChannelInterface log) throws KettleException {
        return MongoUtils.initConnection(meta, vars, MongoUtils.createCredentials(meta, vars), log);
    }

    public static String cleansePath(String path) {
        String cleanKey;
        String key;
        int index = path.indexOf("${");
        int endIndex = 0;
        String tempStr = path;
        while (index >= 0 && (endIndex += tempStr.indexOf("}")) > 0 && endIndex > (index += 2) + 1 && endIndex + 1 < (path = path.replace(key = path.substring(index, endIndex), cleanKey = key.replace('.', '_'))).length()) {
            tempStr = path.substring(endIndex + 1, path.length());
            index = tempStr.indexOf("${");
            if (index <= 0) continue;
            index += endIndex;
        }
        return path;
    }

    public void setMongoFields(List<MongoField> fields) {
        this.m_userFields = new ArrayList<MongoField>();
        for (MongoField f : fields) {
            this.m_userFields.add(f.copy());
        }
    }

    protected static int mongoToKettleType(Object fieldValue) {
        if (fieldValue == null) {
            return 2;
        }
        if (fieldValue instanceof Symbol || fieldValue instanceof String || fieldValue instanceof Code || fieldValue instanceof ObjectId || fieldValue instanceof MinKey || fieldValue instanceof MaxKey) {
            return 2;
        }
        if (fieldValue instanceof Date) {
            return 3;
        }
        if (fieldValue instanceof Number) {
            try {
                Integer.parseInt(fieldValue.toString());
                return 5;
            }
            catch (NumberFormatException e) {
                return 1;
            }
        }
        if (fieldValue instanceof Binary) {
            return 8;
        }
        if (fieldValue instanceof BSONTimestamp) {
            return 5;
        }
        return 2;
    }

    protected static void setMinArrayIndexes(MongoField m) {
        if (m.m_fieldName.indexOf(91) < 0) {
            return;
        }
        String temp = m.m_fieldPath;
        String tempComp = m.m_fieldName;
        StringBuffer updated = new StringBuffer();
        while (temp.indexOf(91) >= 0) {
            String firstPart = temp.substring(0, temp.indexOf(91));
            String innerPart = temp.substring(temp.indexOf(91) + 1, temp.indexOf(93));
            if (!innerPart.equals("-")) {
                updated.append(temp);
                temp = "";
                break;
            }
            updated.append(firstPart);
            String innerComp = tempComp.substring(tempComp.indexOf(91) + 1, tempComp.indexOf(93));
            if (temp.indexOf(93) < temp.length() - 1) {
                temp = temp.substring(temp.indexOf(93) + 1, temp.length());
                tempComp = tempComp.substring(tempComp.indexOf(93) + 1, tempComp.length());
            } else {
                temp = "";
            }
            String[] compParts = innerComp.split(":");
            String replace = "[" + compParts[0] + "]";
            updated.append(replace);
        }
        if (temp.length() > 0) {
            updated.append(temp);
        }
        m.m_fieldPath = updated.toString();
    }

    protected static void updateMaxArrayIndexes(MongoField m, String update) {
        if (m.m_fieldName.indexOf(91) < 0) {
            return;
        }
        if (m.m_fieldName.split("\\[").length != update.split("\\[").length) {
            throw new IllegalArgumentException("Field path and update path do not seem to contain the same number of array parts!");
        }
        String temp = m.m_fieldName;
        String tempComp = update;
        StringBuffer updated = new StringBuffer();
        while (temp.indexOf(91) >= 0) {
            String firstPart = temp.substring(0, temp.indexOf(91));
            String innerPart = temp.substring(temp.indexOf(91) + 1, temp.indexOf(93));
            if (innerPart.indexOf(58) < 0) {
                updated.append(temp);
                temp = "";
                break;
            }
            updated.append(firstPart);
            String innerComp = tempComp.substring(tempComp.indexOf(91) + 1, tempComp.indexOf(93));
            if (temp.indexOf(93) < temp.length() - 1) {
                temp = temp.substring(temp.indexOf(93) + 1, temp.length());
                tempComp = tempComp.substring(tempComp.indexOf(93) + 1, tempComp.length());
            } else {
                temp = "";
            }
            String[] origParts = innerPart.split(":");
            String[] compParts = innerComp.split(":");
            int origMax = Integer.parseInt(origParts[1]);
            int compMax = Integer.parseInt(compParts[1]);
            if (compMax > origMax) {
                String newRange = "[" + origParts[0] + ":" + compMax + "]";
                updated.append(newRange);
                continue;
            }
            String oldRange = "[" + innerPart + "]";
            updated.append(oldRange);
        }
        if (temp.length() > 0) {
            updated.append(temp);
        }
        m.m_fieldName = updated.toString();
    }

    protected static void docToFields(DBObject doc, Map<String, MongoField> lookup) {
        String root = "$";
        String name = "$";
        if (doc instanceof BasicDBObject) {
            MongoDbInputData.processRecord((BasicDBObject)doc, root, name, lookup);
        } else if (doc instanceof BasicDBList) {
            MongoDbInputData.processList((BasicDBList)doc, root, name, lookup);
        }
    }

    protected static void processRecord(BasicDBObject rec, String path, String name, Map<String, MongoField> lookup) {
        for (String key : rec.keySet()) {
            Object fieldValue = rec.get(key);
            if (fieldValue instanceof BasicDBObject) {
                MongoDbInputData.processRecord((BasicDBObject)fieldValue, path + "." + key, name + "." + key, lookup);
                continue;
            }
            if (fieldValue instanceof BasicDBList) {
                MongoDbInputData.processList((BasicDBList)fieldValue, path + "." + key, name + "." + key, lookup);
                continue;
            }
            String finalPath = path + "." + key;
            String finalName = name + "." + key;
            if (!lookup.containsKey(finalPath)) {
                MongoField newField = new MongoField();
                int kettleType = MongoDbInputData.mongoToKettleType(fieldValue);
                newField.m_mongoType = fieldValue;
                newField.m_fieldName = finalName;
                newField.m_fieldPath = finalPath;
                newField.m_kettleType = ValueMeta.getTypeDesc((int)kettleType);
                newField.m_percentageOfSample = 1;
                lookup.put(finalPath, newField);
                continue;
            }
            MongoField m = lookup.get(finalPath);
            if (!m.m_mongoType.getClass().isAssignableFrom(fieldValue.getClass())) {
                m.m_disparateTypes = true;
            }
            m.m_percentageOfSample++;
            MongoDbInputData.updateMaxArrayIndexes(m, finalName);
        }
    }

    protected static void processList(BasicDBList list, String path, String name, Map<String, MongoField> lookup) {
        if (list.size() == 0) {
            return;
        }
        String nonPrimitivePath = path + "[-]";
        String primitivePath = path;
        for (int i = 0; i < list.size(); ++i) {
            Object element = list.get(i);
            if (element instanceof BasicDBObject) {
                MongoDbInputData.processRecord((BasicDBObject)element, nonPrimitivePath, name + "[" + i + ":" + i + "]", lookup);
                continue;
            }
            if (element instanceof BasicDBList) {
                MongoDbInputData.processList((BasicDBList)element, nonPrimitivePath, name + "[" + i + ":" + i + "]", lookup);
                continue;
            }
            String finalPath = primitivePath + "[" + i + "]";
            String finalName = name + "[" + i + "]";
            if (!lookup.containsKey(finalPath)) {
                MongoField newField = new MongoField();
                int kettleType = MongoDbInputData.mongoToKettleType(element);
                newField.m_mongoType = element;
                newField.m_fieldName = finalPath;
                newField.m_fieldPath = finalName;
                newField.m_kettleType = ValueMeta.getTypeDesc((int)kettleType);
                newField.m_percentageOfSample = 1;
                lookup.put(finalPath, newField);
                continue;
            }
            MongoField m = lookup.get(finalPath);
            if (!m.m_mongoType.getClass().isAssignableFrom(element.getClass())) {
                m.m_disparateTypes = true;
            }
            m.m_percentageOfSample++;
            MongoDbInputData.updateMaxArrayIndexes(m, finalName);
        }
    }

    protected static void postProcessPaths(Map<String, MongoField> fieldLookup, List<MongoField> discoveredFields, int numDocsProcessed) {
        for (String key : fieldLookup.keySet()) {
            MongoField m = fieldLookup.get(key);
            m.m_occurenceFraction = "" + m.m_percentageOfSample + "/" + numDocsProcessed;
            MongoDbInputData.setMinArrayIndexes(m);
            if (m.m_fieldName.contains("[") && m.m_fieldName.contains(":")) {
                m.m_arrayIndexInfo = m.m_fieldName;
            }
            if (m.m_fieldName.indexOf(46) >= 0) {
                m.m_fieldName = m.m_fieldName.substring(m.m_fieldName.lastIndexOf(46) + 1, m.m_fieldName.length());
            }
            if (m.m_disparateTypes) {
                m.m_kettleType = ValueMeta.getTypeDesc((int)2);
            }
            discoveredFields.add(m);
        }
        HashMap<String, Integer> tempM = new HashMap<String, Integer>();
        for (MongoField m : discoveredFields) {
            if (tempM.get(m.m_fieldName) != null) {
                Integer toUse = (Integer)tempM.get(m.m_fieldName);
                String key = m.m_fieldName;
                m.m_fieldName = key + "_" + toUse;
                toUse = new Integer(toUse + 1);
                tempM.put(key, toUse);
                continue;
            }
            tempM.put(m.m_fieldName, 1);
        }
    }

    private static Iterator<DBObject> setUpPipelineSample(String query, int numDocsToSample, DBCollection collection) throws KettleException {
        query = query + ", {$limit : " + numDocsToSample + "}";
        List<DBObject> samplePipe = MongoDbInputData.jsonPipelineToDBObjectList(query);
        DBObject first = samplePipe.get(0);
        DBObject[] remainder = new DBObject[samplePipe.size() - 1];
        for (int i = 1; i < samplePipe.size(); ++i) {
            remainder[i - 1] = samplePipe.get(i);
        }
        AggregationOutput result = collection.aggregate(first, remainder);
        return result.results().iterator();
    }

    public static boolean discoverFields(final MongoDbInputMeta meta, final VariableSpace vars, final int docsToSample) throws KettleException {
        try {
            AuthContext context = MongoUtils.createAuthContext(meta, vars);
            return context.doAs(new PrivilegedExceptionAction<Boolean>(){

                @Override
                public Boolean run() throws KettleException {
                    int numDocsToSample = docsToSample;
                    if (numDocsToSample < 1) {
                        numDocsToSample = 100;
                    }
                    DBCursor cursor = null;
                    MongoClient mongo = null;
                    String db = vars.environmentSubstitute(meta.getDbName());
                    String collection = vars.environmentSubstitute(meta.getCollection());
                    ArrayList<MongoField> discoveredFields = new ArrayList<MongoField>();
                    HashMap<String, MongoField> fieldLookup = new HashMap<String, MongoField>();
                    try {
                        mongo = MongoDbInputData.initConnection(meta, vars, null);
                        if (Const.isEmpty((String)db)) {
                            throw new KettleException(BaseMessages.getString(MongoDbInputMeta.PKG, (String)"MongoInput.ErrorMessage.NoDBSpecified", (String[])new String[0]));
                        }
                        DB database = mongo.getDB(db);
                        String realUser = vars.environmentSubstitute(meta.getAuthenticationUser());
                        String realPass = Encr.decryptPasswordOptionallyEncrypted((String)vars.environmentSubstitute(meta.getAuthenticationPassword()));
                        if (!(meta.getUseKerberosAuthentication() || Const.isEmpty((String)realUser) && Const.isEmpty((String)realPass) || database.authenticate(realUser, realPass.toCharArray()))) {
                            throw new KettleException(BaseMessages.getString(MongoDbInputMeta.PKG, (String)"MongoDbInput.ErrorAuthenticating.Exception", (String[])new String[0]));
                        }
                        if (Const.isEmpty((String)collection)) {
                            throw new KettleException(BaseMessages.getString(MongoDbInputMeta.PKG, (String)"MongoInput.ErrorMessage.NoCollectionSpecified", (String[])new String[0]));
                        }
                        DBCollection dbcollection = database.getCollection(collection);
                        String query = vars.environmentSubstitute(meta.getJsonQuery());
                        String fields = vars.environmentSubstitute(meta.getFieldsName());
                        cursor = null;
                        Iterator pipeSample = null;
                        if (meta.getQueryIsPipeline()) {
                            pipeSample = MongoDbInputData.setUpPipelineSample(query, numDocsToSample, dbcollection);
                        } else if (Const.isEmpty((String)query) && Const.isEmpty((String)fields)) {
                            cursor = dbcollection.find().limit(numDocsToSample);
                        } else {
                            DBObject dbObject = (DBObject)JSON.parse((String)(Const.isEmpty((String)query) ? "{}" : query));
                            DBObject dbObject2 = (DBObject)JSON.parse((String)fields);
                            cursor = dbcollection.find(dbObject, dbObject2).limit(numDocsToSample);
                        }
                        int actualCount = 0;
                        while (cursor != null ? cursor.hasNext() : pipeSample.hasNext()) {
                            ++actualCount;
                            DBObject nextDoc = cursor != null ? cursor.next() : (DBObject)pipeSample.next();
                            MongoDbInputData.docToFields(nextDoc, fieldLookup);
                        }
                        MongoDbInputData.postProcessPaths(fieldLookup, discoveredFields, actualCount);
                        if (discoveredFields.size() > 0) {
                            meta.setMongoFields(discoveredFields);
                            Boolean bl = true;
                            return bl;
                        }
                    }
                    catch (Exception e) {
                        throw new KettleException((Throwable)e);
                    }
                    finally {
                        if (cursor != null) {
                            cursor.close();
                        }
                        if (mongo != null) {
                            mongo.close();
                        }
                    }
                    return false;
                }
            });
        }
        catch (PrivilegedActionException ex) {
            if (ex.getException() instanceof KettleException) {
                throw (KettleException)ex.getException();
            }
            throw new KettleException("Unable to discover fields from MongoDB", (Throwable)ex);
        }
    }

    protected static List<DBObject> jsonPipelineToDBObjectList(String jsonPipeline) throws KettleException {
        ArrayList<DBObject> pipeline = new ArrayList<DBObject>();
        StringBuilder b = new StringBuilder(jsonPipeline.trim());
        int bracketCount = -1;
        ArrayList<String> parts = new ArrayList<String>();
        for (int i = 0; i < b.length(); ++i) {
            if (b.charAt(i) == '{') {
                if (bracketCount == -1) {
                    b.delete(0, i);
                    bracketCount = 0;
                    i = 0;
                }
                ++bracketCount;
            }
            if (b.charAt(i) == '}') {
                --bracketCount;
            }
            if (bracketCount != 0) continue;
            String part = b.substring(0, i + 1);
            parts.add(part);
            bracketCount = -1;
            if (i == b.length() - 1) break;
            b.delete(0, i + 1);
            i = 0;
        }
        for (String p : parts) {
            if (Const.isEmpty((String)p)) continue;
            DBObject o = (DBObject)JSON.parse((String)p);
            pipeline.add(o);
        }
        if (pipeline.size() == 0) {
            throw new KettleException(BaseMessages.getString(MongoDbInputMeta.PKG, (String)"MongoDbInput.ErrorMessage.UnableToParsePipelineOperators", (String[])new String[0]));
        }
        return pipeline;
    }

    public static String indexedValsList(List<String> indexedVals) {
        StringBuffer temp = new StringBuffer();
        for (int i = 0; i < indexedVals.size(); ++i) {
            temp.append(indexedVals.get(i));
            if (i >= indexedVals.size() - 1) continue;
            temp.append(",");
        }
        return temp.toString();
    }

    public static List<String> indexedValsList(String indexedVals) {
        String[] parts = indexedVals.split(",");
        ArrayList<String> list = new ArrayList<String>();
        for (String s : parts) {
            list.add(s.trim());
        }
        return list;
    }

    protected static class MongoArrayExpansion {
        public String m_expansionPath;
        protected List<MongoField> m_subFields;
        private List<String> m_pathParts;
        private List<String> m_tempParts;
        protected RowMetaInterface m_outputRowMeta;

        public MongoArrayExpansion(List<MongoField> subFields) {
            this.m_subFields = subFields;
        }

        public void init() throws KettleException {
            if (Const.isEmpty((String)this.m_expansionPath)) {
                throw new KettleException(BaseMessages.getString(MongoDbInputMeta.PKG, (String)"MongoDbInput.ErrorMessage.NoPathSet", (String[])new String[0]));
            }
            if (this.m_pathParts != null) {
                return;
            }
            String expansionPath = MongoDbInputData.cleansePath(this.m_expansionPath);
            String[] temp = expansionPath.split("\\.");
            this.m_pathParts = new ArrayList<String>();
            for (String part : temp) {
                this.m_pathParts.add(part);
            }
            if (this.m_pathParts.get(0).equals("$")) {
                this.m_pathParts.remove(0);
            } else if (this.m_pathParts.get(0).startsWith("$[")) {
                String r = this.m_pathParts.get(0).substring(1, this.m_pathParts.get(0).length());
                this.m_pathParts.set(0, r);
            }
            this.m_tempParts = new ArrayList<String>();
            if (this.m_subFields != null) {
                for (MongoField f : this.m_subFields) {
                    int outputIndex = this.m_outputRowMeta.indexOfValue(f.m_fieldName);
                    f.init(outputIndex);
                }
            }
        }

        public void reset(VariableSpace space) {
            this.m_tempParts.clear();
            for (String part : this.m_pathParts) {
                this.m_tempParts.add(space.environmentSubstitute(part));
            }
            for (MongoField f : this.m_subFields) {
                f.reset(space);
            }
        }

        protected Object[][] nullResult() {
            Object[][] result = new Object[1][this.m_outputRowMeta.size() + RowDataUtil.OVER_ALLOCATE_SIZE];
            return result;
        }

        public Object[][] convertToKettleValue(BasicDBObject mongoObject, VariableSpace space) throws KettleException {
            Object fieldValue;
            if (mongoObject == null) {
                return this.nullResult();
            }
            if (this.m_tempParts.size() == 0) {
                throw new KettleException(BaseMessages.getString(MongoDbInputMeta.PKG, (String)"MongoDbInput.ErrorMessage.MalformedPathRecord", (String[])new String[0]));
            }
            String part = this.m_tempParts.remove(0);
            if (part.charAt(0) == '[') {
                return this.nullResult();
            }
            if (part.indexOf(91) > 0) {
                String arrayPart = part.substring(part.indexOf(91));
                part = part.substring(0, part.indexOf(91));
                this.m_tempParts.add(0, arrayPart);
            }
            if ((fieldValue = mongoObject.get(part)) == null) {
                return this.nullResult();
            }
            if (fieldValue instanceof BasicDBObject) {
                return this.convertToKettleValue((BasicDBObject)fieldValue, space);
            }
            if (fieldValue instanceof BasicDBList) {
                return this.convertToKettleValue((BasicDBList)fieldValue, space);
            }
            return this.nullResult();
        }

        public Object[][] convertToKettleValue(BasicDBList mongoList, VariableSpace space) throws KettleException {
            if (mongoList == null) {
                return this.nullResult();
            }
            if (this.m_tempParts.size() == 0) {
                throw new KettleException(BaseMessages.getString(MongoDbInputMeta.PKG, (String)"MongoDbInput.ErrorMessage.MalformedPathArray", (String[])new String[0]));
            }
            String part = this.m_tempParts.remove(0);
            if (part.charAt(0) != '[') {
                return this.nullResult();
            }
            String index = part.substring(1, part.indexOf(93));
            if (part.indexOf(93) < part.length() - 1) {
                part = part.substring(part.indexOf(93) + 1, part.length());
                this.m_tempParts.add(0, part);
            }
            if (index.equals("*")) {
                Object[][] result = new Object[mongoList.size()][this.m_outputRowMeta.size() + RowDataUtil.OVER_ALLOCATE_SIZE];
                for (int i = 0; i < mongoList.size(); ++i) {
                    Object element = mongoList.get(i);
                    for (int j = 0; j < this.m_subFields.size(); ++j) {
                        MongoField sf = this.m_subFields.get(j);
                        sf.reset(space);
                        result[i][sf.m_outputIndex] = element instanceof BasicDBObject ? sf.convertToKettleValue((BasicDBObject)element) : (element instanceof BasicDBList ? sf.convertToKettleValue((BasicDBList)element) : sf.getKettleValue(element));
                    }
                }
                return result;
            }
            int arrayI = 0;
            try {
                arrayI = Integer.parseInt(index.trim());
            }
            catch (NumberFormatException e) {
                throw new KettleException(BaseMessages.getString(MongoDbInputMeta.PKG, (String)"MongoDbInput.ErrorMessage.UnableToParseArrayIndex", (String[])new String[]{index}));
            }
            if (arrayI >= mongoList.size() || arrayI < 0) {
                return this.nullResult();
            }
            Object element = mongoList.get(arrayI);
            if (element == null) {
                return this.nullResult();
            }
            if (element instanceof BasicDBObject) {
                return this.convertToKettleValue((BasicDBObject)element, space);
            }
            if (element instanceof BasicDBList) {
                return this.convertToKettleValue((BasicDBList)element, space);
            }
            return this.nullResult();
        }
    }

    public static class MongoField
    implements Comparable<MongoField> {
        public String m_fieldName = "";
        public String m_fieldPath = "";
        public String m_kettleType = "";
        public List<String> m_indexedVals;
        public transient String m_arrayIndexInfo;
        private transient int m_percentageOfSample = -1;
        public transient String m_occurenceFraction = "";
        private transient Object m_mongoType;
        public transient boolean m_disparateTypes;
        protected int m_outputIndex;
        private ValueMeta m_tempValueMeta;
        private List<String> m_pathParts;
        private List<String> m_tempParts;

        public MongoField copy() {
            MongoField newF = new MongoField();
            newF.m_fieldName = this.m_fieldName;
            newF.m_fieldPath = this.m_fieldPath;
            newF.m_kettleType = this.m_kettleType;
            newF.m_indexedVals = this.m_indexedVals;
            return newF;
        }

        public void init(int outputIndex) throws KettleException {
            if (Const.isEmpty((String)this.m_fieldPath)) {
                throw new KettleException(BaseMessages.getString(MongoDbInputMeta.PKG, (String)"MongoDbOutput.Messages.MongoField.Error.NoPathSet", (String[])new String[0]));
            }
            if (this.m_pathParts != null) {
                return;
            }
            String fieldPath = MongoDbInputData.cleansePath(this.m_fieldPath);
            String[] temp = fieldPath.split("\\.");
            this.m_pathParts = new ArrayList<String>();
            for (String part : temp) {
                this.m_pathParts.add(part);
            }
            if (this.m_pathParts.get(0).equals("$")) {
                this.m_pathParts.remove(0);
            } else if (this.m_pathParts.get(0).startsWith("$[")) {
                String r = this.m_pathParts.get(0).substring(1, this.m_pathParts.get(0).length());
                this.m_pathParts.set(0, r);
            }
            this.m_tempParts = new ArrayList<String>();
            this.m_tempValueMeta = new ValueMeta();
            this.m_tempValueMeta.setType(ValueMeta.getType((String)this.m_kettleType));
            this.m_outputIndex = outputIndex;
        }

        public void reset(VariableSpace space) {
            this.m_tempParts.clear();
            for (String part : this.m_pathParts) {
                this.m_tempParts.add(space.environmentSubstitute(part));
            }
        }

        protected Object getKettleValue(Object fieldValue) throws KettleException {
            switch (this.m_tempValueMeta.getType()) {
                case 6: {
                    fieldValue = fieldValue instanceof Number ? BigDecimal.valueOf(((Number)fieldValue).doubleValue()) : (fieldValue instanceof Date ? new BigDecimal(((Date)fieldValue).getTime()) : new BigDecimal(fieldValue.toString()));
                    return this.m_tempValueMeta.getBigNumber(fieldValue);
                }
                case 8: {
                    fieldValue = fieldValue instanceof Binary ? (Object)((Binary)fieldValue).getData() : (Object)fieldValue.toString().getBytes();
                    return this.m_tempValueMeta.getBinary(fieldValue);
                }
                case 4: {
                    fieldValue = fieldValue instanceof Number ? new Boolean(((Number)fieldValue).intValue() != 0) : (fieldValue instanceof Date ? new Boolean(((Date)fieldValue).getTime() != 0L) : new Boolean(fieldValue.toString().equalsIgnoreCase("Y") || fieldValue.toString().equalsIgnoreCase("T") || fieldValue.toString().equalsIgnoreCase("1")));
                    return this.m_tempValueMeta.getBoolean(fieldValue);
                }
                case 3: {
                    if (fieldValue instanceof Number) {
                        fieldValue = new Date(((Number)fieldValue).longValue());
                    } else if (!(fieldValue instanceof Date)) {
                        throw new KettleException(BaseMessages.getString(MongoDbInputMeta.PKG, (String)"MongoDbInput.ErrorMessage.DateConversion", (String[])new String[]{fieldValue.toString()}));
                    }
                    return this.m_tempValueMeta.getDate(fieldValue);
                }
                case 5: {
                    if (fieldValue instanceof Number) {
                        fieldValue = new Long(((Number)fieldValue).intValue());
                    } else if (fieldValue instanceof Binary) {
                        byte[] b = ((Binary)fieldValue).getData();
                        String s = new String(b);
                        fieldValue = new Integer(s);
                    } else {
                        fieldValue = new Integer(fieldValue.toString());
                    }
                    return this.m_tempValueMeta.getInteger(fieldValue);
                }
                case 1: {
                    if (fieldValue instanceof Number) {
                        fieldValue = new Double(((Number)fieldValue).doubleValue());
                    } else if (fieldValue instanceof Binary) {
                        byte[] b = ((Binary)fieldValue).getData();
                        String s = new String(b);
                        fieldValue = new Double(s);
                    } else {
                        fieldValue = new Double(fieldValue.toString());
                    }
                    return this.m_tempValueMeta.getNumber(fieldValue);
                }
                case 2: {
                    return this.m_tempValueMeta.getString(fieldValue);
                }
            }
            return null;
        }

        public Object convertToKettleValue(BasicDBObject mongoObject) throws KettleException {
            Object fieldValue;
            if (mongoObject == null) {
                return null;
            }
            if (this.m_tempParts.size() == 0) {
                throw new KettleException(BaseMessages.getString(MongoDbInputMeta.PKG, (String)"MongoDbInput.ErrorMessage.MalformedPathRecord", (String[])new String[0]));
            }
            String part = this.m_tempParts.remove(0);
            if (part.charAt(0) == '[') {
                return null;
            }
            if (part.indexOf(91) > 0) {
                String arrayPart = part.substring(part.indexOf(91));
                part = part.substring(0, part.indexOf(91));
                this.m_tempParts.add(0, arrayPart);
            }
            if ((fieldValue = mongoObject.get(part)) == null) {
                return null;
            }
            if (this.m_tempParts.size() == 0) {
                return this.getKettleValue(fieldValue);
            }
            if (fieldValue instanceof BasicDBObject) {
                return this.convertToKettleValue((BasicDBObject)fieldValue);
            }
            if (fieldValue instanceof BasicDBList) {
                return this.convertToKettleValue((BasicDBList)fieldValue);
            }
            return null;
        }

        public Object convertToKettleValue(BasicDBList mongoList) throws KettleException {
            if (mongoList == null) {
                return null;
            }
            if (this.m_tempParts.size() == 0) {
                throw new KettleException(BaseMessages.getString(MongoDbInputMeta.PKG, (String)"MongoDbInput.ErrorMessage.MalformedPathArray", (String[])new String[0]));
            }
            String part = this.m_tempParts.remove(0);
            if (part.charAt(0) != '[') {
                return null;
            }
            String index = part.substring(1, part.indexOf(93));
            int arrayI = 0;
            try {
                arrayI = Integer.parseInt(index.trim());
            }
            catch (NumberFormatException e) {
                throw new KettleException(BaseMessages.getString(MongoDbInputMeta.PKG, (String)"MongoDbInput.ErrorMessage.UnableToParseArrayIndex", (String[])new String[]{index}));
            }
            if (part.indexOf(93) < part.length() - 1) {
                part = part.substring(part.indexOf(93) + 1, part.length());
                this.m_tempParts.add(0, part);
            }
            if (arrayI >= mongoList.size() || arrayI < 0) {
                return null;
            }
            Object element = mongoList.get(arrayI);
            if (element == null) {
                return null;
            }
            if (this.m_tempParts.size() == 0) {
                return this.getKettleValue(element);
            }
            if (element instanceof BasicDBObject) {
                return this.convertToKettleValue((BasicDBObject)element);
            }
            if (element instanceof BasicDBList) {
                return this.convertToKettleValue((BasicDBList)element);
            }
            return null;
        }

        @Override
        public int compareTo(MongoField comp) {
            return this.m_fieldName.compareTo(comp.m_fieldName);
        }
    }
}

