/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.mongodbinput;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.annotations.Step;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.mongodbinput.MongoDbInput;
import org.pentaho.di.trans.steps.mongodbinput.MongoDbInputData;
import org.pentaho.mongo.NamedReadPreference;
import org.w3c.dom.Node;

@Step(id="MongoDbInput", image="mongodb-input.png", name="MongoDB Input", description="Reads from a Mongo DB collection", categoryDescription="Big Data")
public class MongoDbInputMeta
extends BaseStepMeta
implements StepMetaInterface {
    protected static Class<?> PKG = MongoDbInputMeta.class;
    private String hostname;
    private String port;
    private String dbName;
    private String collection;
    private String jsonFieldName;
    private String fields;
    private String authenticationUser;
    private String authenticationPassword;
    private boolean m_kerberos;
    private String jsonQuery;
    private boolean m_aggPipeline = false;
    private boolean m_outputJson = true;
    private String m_connectTimeout = "";
    private String m_socketTimeout = "";
    private String m_readPreference = NamedReadPreference.PRIMARY.getName();
    private boolean m_useAllReplicaSetMembers;
    private List<MongoDbInputData.MongoField> m_fields;
    private List<String> m_readPrefTagSets;
    private boolean m_executeForEachIncomingRow = false;

    public void setMongoFields(List<MongoDbInputData.MongoField> fields) {
        this.m_fields = fields;
    }

    public List<MongoDbInputData.MongoField> getMongoFields() {
        return this.m_fields;
    }

    public void setReadPrefTagSets(List<String> tagSets) {
        this.m_readPrefTagSets = tagSets;
    }

    public List<String> getReadPrefTagSets() {
        return this.m_readPrefTagSets;
    }

    public void setUseAllReplicaSetMembers(boolean u) {
        this.m_useAllReplicaSetMembers = u;
    }

    public boolean getUseAllReplicaSetMembers() {
        return this.m_useAllReplicaSetMembers;
    }

    public void setExecuteForEachIncomingRow(boolean e) {
        this.m_executeForEachIncomingRow = e;
    }

    public boolean getExecuteForEachIncomingRow() {
        return this.m_executeForEachIncomingRow;
    }

    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        this.readData(stepnode);
    }

    public Object clone() {
        MongoDbInputMeta retval = (MongoDbInputMeta)((Object)super.clone());
        return retval;
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            String tags;
            Node mongo_fields;
            String executeForEachR;
            String queryIsPipe;
            this.hostname = XMLHandler.getTagValue((Node)stepnode, (String)"hostname");
            this.port = XMLHandler.getTagValue((Node)stepnode, (String)"port");
            this.dbName = XMLHandler.getTagValue((Node)stepnode, (String)"db_name");
            this.fields = XMLHandler.getTagValue((Node)stepnode, (String)"fields_name");
            this.collection = XMLHandler.getTagValue((Node)stepnode, (String)"collection");
            this.jsonFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"json_field_name");
            this.jsonQuery = XMLHandler.getTagValue((Node)stepnode, (String)"json_query");
            this.authenticationUser = XMLHandler.getTagValue((Node)stepnode, (String)"auth_user");
            this.authenticationPassword = Encr.decryptPasswordOptionallyEncrypted((String)XMLHandler.getTagValue((Node)stepnode, (String)"auth_password"));
            this.m_kerberos = false;
            String useKerberos = XMLHandler.getTagValue((Node)stepnode, (String)"auth_kerberos");
            if (!Const.isEmpty((String)useKerberos)) {
                this.m_kerberos = useKerberos.equalsIgnoreCase("Y");
            }
            this.m_connectTimeout = XMLHandler.getTagValue((Node)stepnode, (String)"connect_timeout");
            this.m_socketTimeout = XMLHandler.getTagValue((Node)stepnode, (String)"socket_timeout");
            this.m_readPreference = XMLHandler.getTagValue((Node)stepnode, (String)"read_preference");
            this.m_outputJson = true;
            String outputJson = XMLHandler.getTagValue((Node)stepnode, (String)"output_json");
            if (!Const.isEmpty((String)outputJson)) {
                this.m_outputJson = outputJson.equalsIgnoreCase("Y");
            }
            this.m_useAllReplicaSetMembers = false;
            String useAll = XMLHandler.getTagValue((Node)stepnode, (String)"use_all_replica_members");
            if (!Const.isEmpty((String)useAll)) {
                this.m_useAllReplicaSetMembers = useAll.equalsIgnoreCase("Y");
            }
            if (!Const.isEmpty((String)(queryIsPipe = XMLHandler.getTagValue((Node)stepnode, (String)"query_is_pipeline")))) {
                this.m_aggPipeline = queryIsPipe.equalsIgnoreCase("Y");
            }
            if (!Const.isEmpty((String)(executeForEachR = XMLHandler.getTagValue((Node)stepnode, (String)"execute_for_each_row")))) {
                this.m_executeForEachIncomingRow = executeForEachR.equalsIgnoreCase("Y");
            }
            if ((mongo_fields = XMLHandler.getSubNode((Node)stepnode, (String)"mongo_fields")) != null && XMLHandler.countNodes((Node)mongo_fields, (String)"mongo_field") > 0) {
                int nrfields = XMLHandler.countNodes((Node)mongo_fields, (String)"mongo_field");
                this.m_fields = new ArrayList<MongoDbInputData.MongoField>();
                for (int i = 0; i < nrfields; ++i) {
                    Node fieldNode = XMLHandler.getSubNodeByNr((Node)mongo_fields, (String)"mongo_field", (int)i);
                    MongoDbInputData.MongoField newField = new MongoDbInputData.MongoField();
                    newField.m_fieldName = XMLHandler.getTagValue((Node)fieldNode, (String)"field_name");
                    newField.m_fieldPath = XMLHandler.getTagValue((Node)fieldNode, (String)"field_path");
                    newField.m_kettleType = XMLHandler.getTagValue((Node)fieldNode, (String)"field_type");
                    String indexedVals = XMLHandler.getTagValue((Node)fieldNode, (String)"indexed_vals");
                    if (indexedVals != null && indexedVals.length() > 0) {
                        newField.m_indexedVals = MongoDbInputData.indexedValsList(indexedVals);
                    }
                    this.m_fields.add(newField);
                }
            }
            if (!Const.isEmpty((String)(tags = XMLHandler.getTagValue((Node)stepnode, (String)"tag_sets")))) {
                String[] parts;
                this.m_readPrefTagSets = new ArrayList<String>();
                for (String p : parts = tags.split("#@#")) {
                    this.m_readPrefTagSets.add(p.trim());
                }
            }
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"MongoDbInputMeta.Exception.UnableToLoadStepInfo", (String[])new String[0]), (Throwable)e);
        }
    }

    public void setDefault() {
        this.hostname = "localhost";
        this.port = "27017";
        this.dbName = "db";
        this.collection = "collection";
        this.jsonFieldName = "json";
    }

    public void getFields(RowMetaInterface rowMeta, String origin, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) throws KettleStepException {
        if (this.m_outputJson || this.m_fields == null || this.m_fields.size() == 0) {
            ValueMeta jsonValueMeta = new ValueMeta(this.jsonFieldName, 2);
            jsonValueMeta.setOrigin(origin);
            rowMeta.addValueMeta((ValueMetaInterface)jsonValueMeta);
        } else {
            for (MongoDbInputData.MongoField f : this.m_fields) {
                ValueMeta vm = new ValueMeta();
                vm.setName(f.m_fieldName);
                vm.setOrigin(origin);
                vm.setType(ValueMeta.getType((String)f.m_kettleType));
                if (f.m_indexedVals != null) {
                    vm.setIndex(f.m_indexedVals.toArray());
                }
                rowMeta.addValueMeta((ValueMetaInterface)vm);
            }
        }
    }

    protected String tagSetsToString() {
        if (this.m_readPrefTagSets != null && this.m_readPrefTagSets.size() > 0) {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < this.m_readPrefTagSets.size(); ++i) {
                String s = this.m_readPrefTagSets.get(i);
                if (!(s = s.trim()).startsWith("{")) {
                    s = "{" + s;
                }
                if (!s.endsWith("}")) {
                    s = s + "}";
                }
                builder.append(s);
                if (i == this.m_readPrefTagSets.size() - 1) continue;
                builder.append(s).append("#@#");
            }
            return builder.toString();
        }
        return null;
    }

    public String getXML() {
        String tags;
        StringBuffer retval = new StringBuffer(300);
        retval.append("    ").append(XMLHandler.addTagValue((String)"hostname", (String)this.hostname));
        retval.append("    ").append(XMLHandler.addTagValue((String)"port", (String)this.port));
        retval.append("    ").append(XMLHandler.addTagValue((String)"use_all_replica_members", (boolean)this.m_useAllReplicaSetMembers));
        retval.append("    ").append(XMLHandler.addTagValue((String)"db_name", (String)this.dbName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"fields_name", (String)this.fields));
        retval.append("    ").append(XMLHandler.addTagValue((String)"collection", (String)this.collection));
        retval.append("    ").append(XMLHandler.addTagValue((String)"json_field_name", (String)this.jsonFieldName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"json_query", (String)this.jsonQuery));
        retval.append("    ").append(XMLHandler.addTagValue((String)"auth_user", (String)this.authenticationUser));
        retval.append("    ").append(XMLHandler.addTagValue((String)"auth_password", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.authenticationPassword)));
        retval.append("    ").append(XMLHandler.addTagValue((String)"auth_kerberos", (boolean)this.m_kerberos));
        retval.append("    ").append(XMLHandler.addTagValue((String)"connect_timeout", (String)this.m_connectTimeout));
        retval.append("    ").append(XMLHandler.addTagValue((String)"socket_timeout", (String)this.m_socketTimeout));
        retval.append("    ").append(XMLHandler.addTagValue((String)"read_preference", (String)this.m_readPreference));
        retval.append("    ").append(XMLHandler.addTagValue((String)"output_json", (boolean)this.m_outputJson));
        retval.append("    ").append(XMLHandler.addTagValue((String)"query_is_pipeline", (boolean)this.m_aggPipeline));
        retval.append("    ").append(XMLHandler.addTagValue((String)"execute_for_each_row", (boolean)this.m_executeForEachIncomingRow));
        if (this.m_fields != null && this.m_fields.size() > 0) {
            retval.append("\n    ").append(XMLHandler.openTag((String)"mongo_fields"));
            for (MongoDbInputData.MongoField f : this.m_fields) {
                retval.append("\n      ").append(XMLHandler.openTag((String)"mongo_field"));
                retval.append("\n        ").append(XMLHandler.addTagValue((String)"field_name", (String)f.m_fieldName));
                retval.append("\n        ").append(XMLHandler.addTagValue((String)"field_path", (String)f.m_fieldPath));
                retval.append("\n        ").append(XMLHandler.addTagValue((String)"field_type", (String)f.m_kettleType));
                if (f.m_indexedVals != null && f.m_indexedVals.size() > 0) {
                    retval.append("\n        ").append(XMLHandler.addTagValue((String)"indexed_vals", (String)MongoDbInputData.indexedValsList(f.m_indexedVals)));
                }
                retval.append("\n      ").append(XMLHandler.closeTag((String)"mongo_field"));
            }
            retval.append("\n    ").append(XMLHandler.closeTag((String)"mongo_fields"));
        }
        if (!Const.isEmpty((String)(tags = this.tagSetsToString()))) {
            retval.append("    ").append(XMLHandler.addTagValue((String)"tag_sets", (String)tags));
        }
        return retval.toString();
    }

    public void readRep(Repository rep, ObjectId id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        try {
            String tags;
            this.hostname = rep.getStepAttributeString(id_step, "hostname");
            this.port = rep.getStepAttributeString(id_step, "port");
            this.m_useAllReplicaSetMembers = rep.getStepAttributeBoolean(id_step, 0, "use_all_replica_members");
            this.dbName = rep.getStepAttributeString(id_step, "db_name");
            this.fields = rep.getStepAttributeString(id_step, "fields_name");
            this.collection = rep.getStepAttributeString(id_step, "collection");
            this.jsonFieldName = rep.getStepAttributeString(id_step, "json_field_name");
            this.jsonQuery = rep.getStepAttributeString(id_step, "json_query");
            this.authenticationUser = rep.getStepAttributeString(id_step, "auth_user");
            this.authenticationPassword = Encr.decryptPasswordOptionallyEncrypted((String)rep.getStepAttributeString(id_step, "auth_password"));
            this.m_kerberos = rep.getStepAttributeBoolean(id_step, "auth_kerberos");
            this.m_connectTimeout = rep.getStepAttributeString(id_step, "connect_timeout");
            this.m_socketTimeout = rep.getStepAttributeString(id_step, "socket_timeout");
            this.m_readPreference = rep.getStepAttributeString(id_step, "read_preference");
            this.m_outputJson = rep.getStepAttributeBoolean(id_step, 0, "output_json");
            this.m_aggPipeline = rep.getStepAttributeBoolean(id_step, "query_is_pipeline");
            this.m_executeForEachIncomingRow = rep.getStepAttributeBoolean(id_step, "execute_for_each_row");
            int nrfields = rep.countNrStepAttributes(id_step, "field_name");
            if (nrfields > 0) {
                this.m_fields = new ArrayList<MongoDbInputData.MongoField>();
                for (int i = 0; i < nrfields; ++i) {
                    MongoDbInputData.MongoField newField = new MongoDbInputData.MongoField();
                    newField.m_fieldName = rep.getStepAttributeString(id_step, i, "field_name");
                    newField.m_fieldPath = rep.getStepAttributeString(id_step, i, "field_path");
                    newField.m_kettleType = rep.getStepAttributeString(id_step, i, "field_type");
                    String indexedVals = rep.getStepAttributeString(id_step, i, "indexed_vals");
                    if (indexedVals != null && indexedVals.length() > 0) {
                        newField.m_indexedVals = MongoDbInputData.indexedValsList(indexedVals);
                    }
                    this.m_fields.add(newField);
                }
            }
            if (!Const.isEmpty((String)(tags = rep.getStepAttributeString(id_step, "tag_sets")))) {
                String[] parts;
                this.m_readPrefTagSets = new ArrayList<String>();
                for (String p : parts = tags.split("?@?")) {
                    this.m_readPrefTagSets.add(p.trim());
                }
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"MongoDbInputMeta.Exception.UnexpectedErrorWhileReadingStepInfo", (String[])new String[0]), (Throwable)e);
        }
    }

    public void saveRep(Repository rep, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            String tags;
            rep.saveStepAttribute(id_transformation, id_step, "hostname", this.hostname);
            rep.saveStepAttribute(id_transformation, id_step, "port", this.port);
            rep.saveStepAttribute(id_transformation, id_step, "use_all_replica_members", this.m_useAllReplicaSetMembers);
            rep.saveStepAttribute(id_transformation, id_step, "db_name", this.dbName);
            rep.saveStepAttribute(id_transformation, id_step, "fields_name", this.fields);
            rep.saveStepAttribute(id_transformation, id_step, "collection", this.collection);
            rep.saveStepAttribute(id_transformation, id_step, "json_field_name", this.jsonFieldName);
            rep.saveStepAttribute(id_transformation, id_step, "json_query", this.jsonQuery);
            rep.saveStepAttribute(id_transformation, id_step, "auth_user", this.authenticationUser);
            rep.saveStepAttribute(id_transformation, id_step, "auth_password", Encr.encryptPasswordIfNotUsingVariables((String)this.authenticationPassword));
            rep.saveStepAttribute(id_transformation, id_step, "auth_kerberos", this.m_kerberos);
            rep.saveStepAttribute(id_transformation, id_step, "connect_timeout", this.m_connectTimeout);
            rep.saveStepAttribute(id_transformation, id_step, "socket_timeout", this.m_socketTimeout);
            rep.saveStepAttribute(id_transformation, id_step, "read_preference", this.m_readPreference);
            rep.saveStepAttribute(id_transformation, id_step, 0, "output_json", this.m_outputJson);
            rep.saveStepAttribute(id_transformation, id_step, 0, "query_is_pipeline", this.m_aggPipeline);
            rep.saveStepAttribute(id_transformation, id_step, 0, "execute_for_each_row", this.m_executeForEachIncomingRow);
            if (this.m_fields != null && this.m_fields.size() > 0) {
                for (int i = 0; i < this.m_fields.size(); ++i) {
                    MongoDbInputData.MongoField f = this.m_fields.get(i);
                    rep.saveStepAttribute(id_transformation, id_step, i, "field_name", f.m_fieldName);
                    rep.saveStepAttribute(id_transformation, id_step, i, "field_path", f.m_fieldPath);
                    rep.saveStepAttribute(id_transformation, id_step, i, "field_type", f.m_kettleType);
                    if (f.m_indexedVals == null || f.m_indexedVals.size() <= 0) continue;
                    String indexedVals = MongoDbInputData.indexedValsList(f.m_indexedVals);
                    rep.saveStepAttribute(id_transformation, id_step, i, "indexed_vals", indexedVals);
                }
            }
            if (!Const.isEmpty((String)(tags = this.tagSetsToString()))) {
                rep.saveStepAttribute(id_transformation, id_step, "tag_sets", tags);
            }
        }
        catch (KettleException e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"MongoDbInputMeta.Exception.UnableToSaveStepInfo", (String[])new String[0]) + id_step, (Throwable)e);
        }
    }

    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new MongoDbInput(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    public StepDataInterface getStepData() {
        return new MongoDbInputData();
    }

    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
    }

    public String getHostnames() {
        return this.hostname;
    }

    public void setHostnames(String hostname) {
        this.hostname = hostname;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public String getFieldsName() {
        return this.fields;
    }

    public void setFieldsName(String fields) {
        this.fields = fields;
    }

    public String getCollection() {
        return this.collection;
    }

    public void setCollection(String collection) {
        this.collection = collection;
    }

    public String getJsonFieldName() {
        return this.jsonFieldName;
    }

    public void setJsonFieldName(String jsonFieldName) {
        this.jsonFieldName = jsonFieldName;
    }

    public String getAuthenticationUser() {
        return this.authenticationUser;
    }

    public void setAuthenticationUser(String authenticationUser) {
        this.authenticationUser = authenticationUser;
    }

    public String getAuthenticationPassword() {
        return this.authenticationPassword;
    }

    public void setAuthenticationPassword(String authenticationPassword) {
        this.authenticationPassword = authenticationPassword;
    }

    public void setUseKerberosAuthentication(boolean k) {
        this.m_kerberos = k;
    }

    public boolean getUseKerberosAuthentication() {
        return this.m_kerberos;
    }

    public String getJsonQuery() {
        return this.jsonQuery;
    }

    public void setJsonQuery(String jsonQuery) {
        this.jsonQuery = jsonQuery;
    }

    public void setOutputJson(boolean outputJson) {
        this.m_outputJson = outputJson;
    }

    public boolean getOutputJson() {
        return this.m_outputJson;
    }

    public void setQueryIsPipeline(boolean q) {
        this.m_aggPipeline = q;
    }

    public boolean getQueryIsPipeline() {
        return this.m_aggPipeline;
    }

    public void setConnectTimeout(String to) {
        this.m_connectTimeout = to;
    }

    public String getConnectTimeout() {
        return this.m_connectTimeout;
    }

    public void setSocketTimeout(String so) {
        this.m_socketTimeout = so;
    }

    public String getSocketTimeout() {
        return this.m_socketTimeout;
    }

    public void setReadPreference(String preference) {
        this.m_readPreference = preference;
    }

    public String getReadPreference() {
        return this.m_readPreference;
    }
}

