/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.mongodboutput;

import com.mongodb.CommandResult;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import com.mongodb.ServerAddress;
import com.mongodb.WriteResult;
import java.net.UnknownHostException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.mongodboutput.MongoDbOutputData;
import org.pentaho.di.trans.steps.mongodboutput.MongoDbOutputMeta;
import org.pentaho.mongo.AuthContext;
import org.pentaho.mongo.MongoUtils;

public class MongoDbOutput
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = MongoDbOutputMeta.class;
    protected MongoDbOutputMeta m_meta;
    protected MongoDbOutputData m_data;
    protected MongoDbOutputData.MongoTopLevel m_mongoTopLevelStructure = MongoDbOutputData.MongoTopLevel.INCONSISTENT;
    protected int m_batchInsertSize = 100;
    protected List<DBObject> m_batch;
    protected int m_writeRetries = 5;
    protected int m_writeRetryDelay = 10;

    public MongoDbOutput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        AuthContext context = MongoUtils.createAuthContext(this.m_meta, (VariableSpace)this);
        try {
            return context.doAs(new PrivilegedExceptionAction<Boolean>(){

                @Override
                public Boolean run() throws KettleException {
                    Object[] row = MongoDbOutput.this.getRow();
                    if (row == null) {
                        List<MongoDbOutputMeta.MongoIndex> indexes;
                        if (MongoDbOutput.this.m_batch != null && MongoDbOutput.this.m_batch.size() > 0) {
                            MongoDbOutput.this.doBatch();
                        }
                        if ((indexes = MongoDbOutput.this.m_meta.getMongoIndexes()) != null && indexes.size() > 0) {
                            MongoDbOutput.this.logBasic(BaseMessages.getString((Class)PKG, (String)"MongoDbOutput.Messages.ApplyingIndexOpps", (String[])new String[0]));
                            MongoDbOutput.this.m_data.applyIndexes(indexes, MongoDbOutput.this.log, MongoDbOutput.this.m_meta.getTruncate());
                        }
                        MongoDbOutput.this.disconnect();
                        MongoDbOutput.this.setOutputDone();
                        return false;
                    }
                    if (MongoDbOutput.this.first) {
                        MongoDbOutput.this.first = false;
                        MongoDbOutput.this.m_batchInsertSize = 100;
                        String batchInsert = MongoDbOutput.this.environmentSubstitute(MongoDbOutput.this.m_meta.getBatchInsertSize());
                        if (!Const.isEmpty((String)batchInsert)) {
                            MongoDbOutput.this.m_batchInsertSize = Integer.parseInt(batchInsert);
                        }
                        MongoDbOutput.this.m_batch = new ArrayList<DBObject>(MongoDbOutput.this.m_batchInsertSize);
                        MongoDbOutput.this.m_data.setOutputRowMeta(MongoDbOutput.this.getInputRowMeta());
                        MongoDbOutput.this.m_mongoTopLevelStructure = MongoDbOutputData.checkTopLevelConsistency(MongoDbOutput.this.m_meta.m_mongoFields, (VariableSpace)MongoDbOutput.this);
                        MongoDbOutput.this.m_data.m_hasTopLevelJSONDocInsert = MongoDbOutputData.scanForInsertTopLevelJSONDoc(MongoDbOutput.this.m_meta.m_mongoFields);
                        if (MongoDbOutput.this.m_mongoTopLevelStructure == MongoDbOutputData.MongoTopLevel.INCONSISTENT) {
                            throw new KettleException(BaseMessages.getString((Class)PKG, (String)"MongoDbOutput.Messages.Error.InconsistentMongoTopLevel", (String[])new String[0]));
                        }
                        RowMetaInterface rmi = MongoDbOutput.this.getInputRowMeta();
                        List<MongoDbOutputMeta.MongoField> mongoFields = MongoDbOutput.this.m_meta.getMongoFields();
                        ArrayList<String> notToBeInserted = new ArrayList<String>();
                        for (int i = 0; i < rmi.size(); ++i) {
                            ValueMetaInterface vm = rmi.getValueMeta(i);
                            boolean ok = false;
                            for (MongoDbOutputMeta.MongoField field : mongoFields) {
                                String mongoMatch = MongoDbOutput.this.environmentSubstitute(field.m_incomingFieldName);
                                if (!vm.getName().equals(mongoMatch)) continue;
                                ok = true;
                                break;
                            }
                            if (ok) continue;
                            notToBeInserted.add(vm.getName());
                        }
                        if (notToBeInserted.size() == rmi.size()) {
                            throw new KettleException(BaseMessages.getString((Class)PKG, (String)"MongoDbOutput.Messages.Error.NotInsertingAnyFields", (String[])new String[0]));
                        }
                        if (notToBeInserted.size() > 0) {
                            StringBuffer b = new StringBuffer();
                            for (String s : notToBeInserted) {
                                b.append(s).append(" ");
                            }
                            MongoDbOutput.this.logBasic(BaseMessages.getString((Class)PKG, (String)"MongoDbOutput.Messages.FieldsNotToBeInserted", (String[])new String[0]), new Object[]{b.toString()});
                        }
                        MongoDbOutput.this.m_data.setMongoFields(MongoDbOutput.this.m_meta.getMongoFields());
                        MongoDbOutput.this.m_data.init((VariableSpace)MongoDbOutput.this);
                        if (MongoDbOutput.this.m_meta.getTruncate()) {
                            try {
                                MongoDbOutput.this.logBasic(BaseMessages.getString((Class)PKG, (String)"MongoDbOutput.Messages.TruncatingCollection", (String[])new String[0]));
                                MongoDbOutput.this.m_data.getCollection().drop();
                                String collection = MongoDbOutput.this.environmentSubstitute(MongoDbOutput.this.m_meta.getCollection());
                                MongoDbOutput.this.m_data.createCollection(collection);
                                MongoDbOutput.this.m_data.setCollection(MongoDbOutput.this.m_data.getDB().getCollection(collection));
                            }
                            catch (Exception m) {
                                MongoDbOutput.this.disconnect();
                                throw new KettleException(m.getMessage(), (Throwable)m);
                            }
                        }
                    }
                    if (!MongoDbOutput.this.isStopped()) {
                        if (MongoDbOutput.this.m_meta.getUpsert()) {
                            MongoDbOutputData cfr_ignored_0 = MongoDbOutput.this.m_data;
                            DBObject updateQuery = MongoDbOutputData.getQueryObject(MongoDbOutput.this.m_data.m_userFields, MongoDbOutput.this.getInputRowMeta(), row, (VariableSpace)MongoDbOutput.this, MongoDbOutput.this.m_mongoTopLevelStructure);
                            if (MongoDbOutput.this.log.isDebug()) {
                                MongoDbOutput.this.logDebug(BaseMessages.getString((Class)PKG, (String)"MongoDbOutput.Messages.Debug.QueryForUpsert", (Object[])new Object[]{updateQuery}));
                            }
                            if (updateQuery != null) {
                                DBObject insertUpdate = null;
                                if (!MongoDbOutput.this.m_meta.getModifierUpdate()) {
                                    insertUpdate = MongoDbOutputData.kettleRowToMongo(MongoDbOutput.this.m_data.m_userFields, MongoDbOutput.this.getInputRowMeta(), row, (VariableSpace)MongoDbOutput.this, MongoDbOutput.this.m_mongoTopLevelStructure, MongoDbOutput.this.m_data.m_hasTopLevelJSONDocInsert);
                                    if (MongoDbOutput.this.log.isDebug()) {
                                        MongoDbOutput.this.logDebug(BaseMessages.getString((Class)PKG, (String)"MongoDbOutput.Messages.Debug.InsertUpsertObject", (Object[])new Object[]{insertUpdate}));
                                    }
                                } else {
                                    insertUpdate = MongoDbOutput.this.m_data.getModifierUpdateObject(MongoDbOutput.this.m_data.m_userFields, MongoDbOutput.this.getInputRowMeta(), row, (VariableSpace)MongoDbOutput.this, MongoDbOutput.this.m_mongoTopLevelStructure);
                                    if (MongoDbOutput.this.log.isDebug()) {
                                        MongoDbOutput.this.logDebug(BaseMessages.getString((Class)PKG, (String)"MongoDbOutput.Messages.Debug.ModifierUpdateObject", (Object[])new Object[]{insertUpdate}));
                                    }
                                }
                                if (insertUpdate != null) {
                                    MongoDbOutput.this.commitUpsert(updateQuery, insertUpdate);
                                }
                            }
                        } else {
                            DBObject mongoInsert = MongoDbOutputData.kettleRowToMongo(MongoDbOutput.this.m_data.m_userFields, MongoDbOutput.this.getInputRowMeta(), row, (VariableSpace)MongoDbOutput.this, MongoDbOutput.this.m_mongoTopLevelStructure, MongoDbOutput.this.m_data.m_hasTopLevelJSONDocInsert);
                            if (mongoInsert != null) {
                                MongoDbOutput.this.m_batch.add(mongoInsert);
                            }
                            if (MongoDbOutput.this.m_batch.size() == MongoDbOutput.this.m_batchInsertSize) {
                                MongoDbOutput.this.logDetailed(BaseMessages.getString((Class)PKG, (String)"MongoDbOutput.Messages.CommitingABatch", (String[])new String[0]));
                                MongoDbOutput.this.doBatch();
                            }
                        }
                    }
                    return true;
                }
            });
        }
        catch (PrivilegedActionException e) {
            Exception cause = e.getException();
            if (cause instanceof KettleException) {
                throw (KettleException)((Object)cause);
            }
            throw new KettleException("Unexpected error", (Throwable)e.getException());
        }
    }

    protected void commitUpsert(DBObject updateQuery, DBObject insertUpdate) throws KettleException {
        int retrys = 0;
        MongoException lastEx = null;
        while (retrys <= this.m_writeRetries && !this.isStopped()) {
            CommandResult cmd;
            block7: {
                WriteResult result = null;
                cmd = null;
                try {
                    result = this.m_data.getCollection().update(updateQuery, insertUpdate, true, this.m_meta.getMulti());
                    cmd = result.getLastError();
                    if (cmd != null && !cmd.ok()) {
                        String message = cmd.getErrorMessage();
                        this.logError(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.Error.MongoReported", (String[])new String[]{message}));
                        cmd.throwOnError();
                    }
                }
                catch (MongoException me) {
                    lastEx = me;
                    if (++retrys > this.m_writeRetries) break block7;
                    this.logError(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.Error.ErrorWritingToMongo", (String[])new String[]{me.toString()}));
                    this.logBasic(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.Message.Retry", (Object[])new Object[]{this.m_writeRetryDelay}));
                    try {
                        Thread.sleep(this.m_writeRetryDelay * 1000);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
            }
            if (cmd == null || !cmd.ok()) continue;
            break;
        }
        if ((retrys > this.m_writeRetries || this.isStopped()) && lastEx != null) {
            throw new KettleException(lastEx);
        }
    }

    protected void doBatch() throws KettleException {
        int retrys = 0;
        MongoException lastEx = null;
        while (retrys <= this.m_writeRetries && !this.isStopped()) {
            ServerAddress s;
            CommandResult cmd;
            block8: {
                WriteResult result = null;
                cmd = null;
                try {
                    result = this.m_data.getCollection().insert(this.m_batch);
                    cmd = result.getLastError();
                    if (cmd != null && !cmd.ok()) {
                        String message = cmd.getErrorMessage();
                        this.logError(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.Error.MongoReported", (String[])new String[]{message}));
                        cmd.throwOnError();
                    }
                }
                catch (MongoException me) {
                    lastEx = me;
                    if (++retrys > this.m_writeRetries) break block8;
                    this.logError(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.Error.ErrorWritingToMongo", (String[])new String[]{me.toString()}));
                    this.logBasic(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.Message.Retry", (Object[])new Object[]{this.m_writeRetryDelay}));
                    try {
                        Thread.sleep(this.m_writeRetryDelay * 1000);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
            }
            if (cmd != null && (s = cmd.getServerUsed()) != null) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.WroteBatchToServer", (String[])new String[]{s.toString()}));
            }
            if (cmd == null || !cmd.ok()) continue;
            break;
        }
        if ((retrys > this.m_writeRetries || this.isStopped()) && lastEx != null) {
            throw new KettleException(lastEx);
        }
        this.m_batch.clear();
    }

    public boolean init(StepMetaInterface stepMetaInterface, StepDataInterface stepDataInterface) {
        if (super.init(stepMetaInterface, stepDataInterface)) {
            this.m_meta = (MongoDbOutputMeta)stepMetaInterface;
            this.m_data = (MongoDbOutputData)stepDataInterface;
            if (!Const.isEmpty((String)this.m_meta.getWriteRetries())) {
                try {
                    this.m_writeRetries = Integer.parseInt(this.m_meta.getWriteRetries());
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
            }
            if (!Const.isEmpty((String)this.m_meta.getWriteRetryDelay())) {
                try {
                    this.m_writeRetryDelay = Integer.parseInt(this.m_meta.getWriteRetryDelay());
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
            }
            String hostname = this.environmentSubstitute(this.m_meta.getHostnames());
            int port = Const.toInt((String)this.environmentSubstitute(this.m_meta.getPort()), (int)27017);
            String db = this.environmentSubstitute(this.m_meta.getDBName());
            String collection = this.environmentSubstitute(this.m_meta.getCollection());
            try {
                if (Const.isEmpty((String)db)) {
                    throw new Exception(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.Error.NoDBSpecified", (String[])new String[0]));
                }
                if (Const.isEmpty((String)collection)) {
                    throw new Exception(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.Error.NoCollectionSpecified", (String[])new String[0]));
                }
                if (!Const.isEmpty((String)this.m_meta.getUsername())) {
                    String authInfo = this.m_meta.getUseKerberosAuthentication() ? BaseMessages.getString(PKG, (String)"MongoDbOutput.Message.KerberosAuthentication", (String[])new String[]{this.environmentSubstitute(this.m_meta.getUsername())}) : BaseMessages.getString(PKG, (String)"MongoDbOutput.Message.NormalAuthentication", (String[])new String[]{this.environmentSubstitute(this.m_meta.getUsername())});
                    this.logBasic(authInfo);
                }
                this.m_data.setConnection(MongoDbOutputData.connect(this.m_meta, (VariableSpace)this, this.log));
                this.m_data.setDB(this.m_data.getConnection().getDB(db));
                if (Const.isEmpty((String)collection)) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.Error.NoCollectionSpecified", (String[])new String[0]));
                }
                this.m_data.createCollection(collection);
                this.m_data.setCollection(this.m_data.getDB().getCollection(collection));
                return true;
            }
            catch (UnknownHostException ex) {
                this.logError(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.Error.UnknownHost", (String[])new String[]{hostname}), ex);
                return false;
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.Error.ProblemConnecting", (String[])new String[]{hostname, "" + port}), e);
                return false;
            }
        }
        return false;
    }

    protected void disconnect() {
        if (this.m_data != null) {
            MongoDbOutputData.disconnect(this.m_data.getConnection());
        }
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        if (this.m_data != null) {
            MongoDbOutputData.disconnect(this.m_data.getConnection());
        }
        super.dispose(smi, sdi);
    }
}

