/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.mongodboutput;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.annotations.Step;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.mongodboutput.MongoDbOutput;
import org.pentaho.di.trans.steps.mongodboutput.MongoDbOutputData;
import org.pentaho.mongo.NamedReadPreference;
import org.w3c.dom.Node;

@Step(id="MongoDbOutput", image="MongoDB.png", name="MongoDB Output", description="Writes to a Mongo DB collection", categoryDescription="Big Data")
public class MongoDbOutputMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = MongoDbOutputMeta.class;
    protected String m_hostnames = "localhost";
    protected String m_port = "27017";
    protected String m_dbName;
    protected String m_collection;
    protected boolean m_truncate;
    protected String m_username;
    protected String m_password;
    private boolean m_kerberos;
    protected boolean m_upsert;
    protected boolean m_multi;
    protected boolean m_modifierUpdate;
    protected String m_batchInsertSize = "100";
    protected List<MongoField> m_mongoFields;
    protected List<MongoIndex> m_mongoIndexes;
    protected String m_connectTimeout = "";
    protected String m_socketTimeout = "";
    protected String m_readPreference = NamedReadPreference.PRIMARY.getName();
    protected String m_writeConcern = "";
    protected String m_wTimeout = "";
    protected boolean m_journal;
    private boolean m_useAllReplicaSetMembers;
    public static final int RETRIES = 5;
    public static final int RETRY_DELAY = 10;
    private String m_writeRetries = "5";
    private String m_writeRetryDelay = "10";

    public void setDefault() {
        this.m_hostnames = "localhost";
        this.m_port = "27017";
        this.m_collection = "";
        this.m_dbName = "";
        this.m_upsert = false;
        this.m_modifierUpdate = false;
        this.m_truncate = false;
        this.m_batchInsertSize = "100";
    }

    public void setMongoFields(List<MongoField> mongoFields) {
        this.m_mongoFields = mongoFields;
    }

    public List<MongoField> getMongoFields() {
        return this.m_mongoFields;
    }

    public void setMongoIndexes(List<MongoIndex> mongoIndexes) {
        this.m_mongoIndexes = mongoIndexes;
    }

    public List<MongoIndex> getMongoIndexes() {
        return this.m_mongoIndexes;
    }

    public void setHostnames(String hosts) {
        this.m_hostnames = hosts;
    }

    public String getHostnames() {
        return this.m_hostnames;
    }

    public void setPort(String port) {
        this.m_port = port;
    }

    public String getPort() {
        return this.m_port;
    }

    public void setUseAllReplicaSetMembers(boolean u) {
        this.m_useAllReplicaSetMembers = u;
    }

    public boolean getUseAllReplicaSetMembers() {
        return this.m_useAllReplicaSetMembers;
    }

    public void setWriteRetries(String r) {
        this.m_writeRetries = r;
    }

    public String getWriteRetries() {
        return this.m_writeRetries;
    }

    public void setWriteRetryDelay(String d) {
        this.m_writeRetryDelay = d;
    }

    public String getWriteRetryDelay() {
        return this.m_writeRetryDelay;
    }

    public void setDBName(String db) {
        this.m_dbName = db;
    }

    public String getDBName() {
        return this.m_dbName;
    }

    public void setCollection(String collection) {
        this.m_collection = collection;
    }

    public String getCollection() {
        return this.m_collection;
    }

    public void setUsername(String username) {
        this.m_username = username;
    }

    public String getUsername() {
        return this.m_username;
    }

    public void setPassword(String password) {
        this.m_password = password;
    }

    public String getPassword() {
        return this.m_password;
    }

    public void setUseKerberosAuthentication(boolean k) {
        this.m_kerberos = k;
    }

    public boolean getUseKerberosAuthentication() {
        return this.m_kerberos;
    }

    public void setUpsert(boolean upsert) {
        this.m_upsert = upsert;
    }

    public boolean getUpsert() {
        return this.m_upsert;
    }

    public void setMulti(boolean multi) {
        this.m_multi = multi;
    }

    public boolean getMulti() {
        return this.m_multi;
    }

    public void setModifierUpdate(boolean u) {
        this.m_modifierUpdate = u;
    }

    public boolean getModifierUpdate() {
        return this.m_modifierUpdate;
    }

    public void setTruncate(boolean truncate) {
        this.m_truncate = truncate;
    }

    public boolean getTruncate() {
        return this.m_truncate;
    }

    public String getBatchInsertSize() {
        return this.m_batchInsertSize;
    }

    public void setBatchInsertSize(String size) {
        this.m_batchInsertSize = size;
    }

    public void setConnectTimeout(String to) {
        this.m_connectTimeout = to;
    }

    public String getConnectTimeout() {
        return this.m_connectTimeout;
    }

    public void setSocketTimeout(String so) {
        this.m_socketTimeout = so;
    }

    public String getSocketTimeout() {
        return this.m_socketTimeout;
    }

    public void setReadPreference(String preference) {
        this.m_readPreference = preference;
    }

    public String getReadPreference() {
        return this.m_readPreference;
    }

    public void setWriteConcern(String concern) {
        this.m_writeConcern = concern;
    }

    public String getWriteConcern() {
        return this.m_writeConcern;
    }

    public void setWTimeout(String w) {
        this.m_wTimeout = w;
    }

    public String getWTimeout() {
        return this.m_wTimeout;
    }

    public void setJournal(boolean j) {
        this.m_journal = j;
    }

    public boolean getJournal() {
        return this.m_journal;
    }

    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        CheckResult cr;
        if (prev == null || prev.size() == 0) {
            cr = new CheckResult(3, BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.Error.NotReceivingFieldsFromPreviousSteps", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.ReceivingFields", (Object[])new Object[]{prev.size()}), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.ReceivingInfo", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.Error.NoInputReceivedFromOtherSteps", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        return new MongoDbOutput(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public StepDataInterface getStepData() {
        return new MongoDbOutputData();
    }

    public String getXML() {
        StringBuffer retval = new StringBuffer();
        if (!Const.isEmpty((String)this.m_hostnames)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"mongo_host", (String)this.m_hostnames));
        }
        if (!Const.isEmpty((String)this.m_port)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"mongo_port", (String)this.m_port));
        }
        retval.append("    ").append(XMLHandler.addTagValue((String)"use_all_replica_members", (boolean)this.m_useAllReplicaSetMembers));
        if (!Const.isEmpty((String)this.m_username)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"mongo_user", (String)this.m_username));
        }
        if (!Const.isEmpty((String)this.m_password)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"mongo_password", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.m_password)));
        }
        retval.append("    ").append(XMLHandler.addTagValue((String)"auth_kerberos", (boolean)this.m_kerberos));
        if (!Const.isEmpty((String)this.m_dbName)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"mongo_db", (String)this.m_dbName));
        }
        if (!Const.isEmpty((String)this.m_collection)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"mongo_collection", (String)this.m_collection));
        }
        if (!Const.isEmpty((String)this.m_batchInsertSize)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"batch_insert_size", (String)this.m_batchInsertSize));
        }
        retval.append("    ").append(XMLHandler.addTagValue((String)"connect_timeout", (String)this.m_connectTimeout));
        retval.append("    ").append(XMLHandler.addTagValue((String)"socket_timeout", (String)this.m_socketTimeout));
        retval.append("    ").append(XMLHandler.addTagValue((String)"read_preference", (String)this.m_readPreference));
        retval.append("    ").append(XMLHandler.addTagValue((String)"write_concern", (String)this.m_writeConcern));
        retval.append("    ").append(XMLHandler.addTagValue((String)"w_timeout", (String)this.m_wTimeout));
        retval.append("    ").append(XMLHandler.addTagValue((String)"journaled_writes", (boolean)this.m_journal));
        retval.append("\n    ").append(XMLHandler.addTagValue((String)"truncate", (boolean)this.m_truncate));
        retval.append("\n    ").append(XMLHandler.addTagValue((String)"upsert", (boolean)this.m_upsert));
        retval.append("\n    ").append(XMLHandler.addTagValue((String)"multi", (boolean)this.m_multi));
        retval.append("\n    ").append(XMLHandler.addTagValue((String)"modifier_update", (boolean)this.m_modifierUpdate));
        retval.append("    ").append(XMLHandler.addTagValue((String)"write_retries", (String)this.m_writeRetries));
        retval.append("    ").append(XMLHandler.addTagValue((String)"write_retry_delay", (String)this.m_writeRetryDelay));
        if (this.m_mongoFields != null && this.m_mongoFields.size() > 0) {
            retval.append("\n    ").append(XMLHandler.openTag((String)"mongo_fields"));
            for (MongoField field : this.m_mongoFields) {
                retval.append("\n      ").append(XMLHandler.openTag((String)"mongo_field"));
                retval.append("\n         ").append(XMLHandler.addTagValue((String)"incoming_field_name", (String)field.m_incomingFieldName));
                retval.append("\n         ").append(XMLHandler.addTagValue((String)"mongo_doc_path", (String)field.m_mongoDocPath));
                retval.append("\n         ").append(XMLHandler.addTagValue((String)"use_incoming_field_name_as_mongo_field_name", (boolean)field.m_useIncomingFieldNameAsMongoFieldName));
                retval.append("\n         ").append(XMLHandler.addTagValue((String)"update_match_field", (boolean)field.m_updateMatchField));
                retval.append("\n         ").append(XMLHandler.addTagValue((String)"modifier_update_operation", (String)field.m_modifierUpdateOperation));
                retval.append("\n         ").append(XMLHandler.addTagValue((String)"modifier_policy", (String)field.m_modifierOperationApplyPolicy));
                retval.append("\n         ").append(XMLHandler.addTagValue((String)"json_field", (boolean)field.m_JSON));
                retval.append("\n      ").append(XMLHandler.closeTag((String)"mongo_field"));
            }
            retval.append("\n    ").append(XMLHandler.closeTag((String)"mongo_fields"));
        }
        if (this.m_mongoIndexes != null && this.m_mongoIndexes.size() > 0) {
            retval.append("\n    ").append(XMLHandler.openTag((String)"mongo_indexes"));
            for (MongoIndex index : this.m_mongoIndexes) {
                retval.append("\n      ").append(XMLHandler.openTag((String)"mongo_index"));
                retval.append("\n         ").append(XMLHandler.addTagValue((String)"path_to_fields", (String)index.m_pathToFields));
                retval.append("\n         ").append(XMLHandler.addTagValue((String)"drop", (boolean)index.m_drop));
                retval.append("\n         ").append(XMLHandler.addTagValue((String)"unique", (boolean)index.m_unique));
                retval.append("\n         ").append(XMLHandler.addTagValue((String)"sparse", (boolean)index.m_sparse));
                retval.append("\n      ").append(XMLHandler.closeTag((String)"mongo_index"));
            }
            retval.append("\n    ").append(XMLHandler.closeTag((String)"mongo_indexes"));
        }
        return retval.toString();
    }

    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        Node fieldNode;
        int i;
        int nrfields;
        Node fields;
        String writeRetryDelay;
        String writeRetries;
        this.m_hostnames = XMLHandler.getTagValue((Node)stepnode, (String)"mongo_host");
        this.m_port = XMLHandler.getTagValue((Node)stepnode, (String)"mongo_port");
        this.m_username = XMLHandler.getTagValue((Node)stepnode, (String)"mongo_user");
        this.m_password = XMLHandler.getTagValue((Node)stepnode, (String)"mongo_password");
        if (!Const.isEmpty((String)this.m_password)) {
            this.m_password = Encr.decryptPasswordOptionallyEncrypted((String)this.m_password);
        }
        this.m_kerberos = false;
        String useKerberos = XMLHandler.getTagValue((Node)stepnode, (String)"auth_kerberos");
        if (!Const.isEmpty((String)useKerberos)) {
            this.m_kerberos = useKerberos.equalsIgnoreCase("Y");
        }
        this.m_dbName = XMLHandler.getTagValue((Node)stepnode, (String)"mongo_db");
        this.m_collection = XMLHandler.getTagValue((Node)stepnode, (String)"mongo_collection");
        this.m_batchInsertSize = XMLHandler.getTagValue((Node)stepnode, (String)"batch_insert_size");
        this.m_connectTimeout = XMLHandler.getTagValue((Node)stepnode, (String)"connect_timeout");
        this.m_socketTimeout = XMLHandler.getTagValue((Node)stepnode, (String)"socket_timeout");
        this.m_readPreference = XMLHandler.getTagValue((Node)stepnode, (String)"read_preference");
        this.m_writeConcern = XMLHandler.getTagValue((Node)stepnode, (String)"write_concern");
        this.m_wTimeout = XMLHandler.getTagValue((Node)stepnode, (String)"w_timeout");
        String journaled = XMLHandler.getTagValue((Node)stepnode, (String)"journaled_writes");
        if (!Const.isEmpty((String)journaled)) {
            this.m_journal = journaled.equalsIgnoreCase("Y");
        }
        this.m_truncate = XMLHandler.getTagValue((Node)stepnode, (String)"truncate").equalsIgnoreCase("Y");
        this.m_upsert = XMLHandler.getTagValue((Node)stepnode, (String)"upsert").equalsIgnoreCase("Y");
        this.m_multi = XMLHandler.getTagValue((Node)stepnode, (String)"multi").equalsIgnoreCase("Y");
        this.m_modifierUpdate = XMLHandler.getTagValue((Node)stepnode, (String)"modifier_update").equalsIgnoreCase("Y");
        this.m_useAllReplicaSetMembers = false;
        String useAll = XMLHandler.getTagValue((Node)stepnode, (String)"use_all_replica_members");
        if (!Const.isEmpty((String)useAll)) {
            this.m_useAllReplicaSetMembers = useAll.equalsIgnoreCase("Y");
        }
        if (!Const.isEmpty((String)(writeRetries = XMLHandler.getTagValue((Node)stepnode, (String)"write_retries")))) {
            this.m_writeRetries = writeRetries;
        }
        if (!Const.isEmpty((String)(writeRetryDelay = XMLHandler.getTagValue((Node)stepnode, (String)"write_retry_delay")))) {
            this.m_writeRetryDelay = writeRetryDelay;
        }
        if ((fields = XMLHandler.getSubNode((Node)stepnode, (String)"mongo_fields")) != null && XMLHandler.countNodes((Node)fields, (String)"mongo_field") > 0) {
            nrfields = XMLHandler.countNodes((Node)fields, (String)"mongo_field");
            this.m_mongoFields = new ArrayList<MongoField>();
            for (i = 0; i < nrfields; ++i) {
                String jsonField;
                fieldNode = XMLHandler.getSubNodeByNr((Node)fields, (String)"mongo_field", (int)i);
                MongoField newField = new MongoField();
                newField.m_incomingFieldName = XMLHandler.getTagValue((Node)fieldNode, (String)"incoming_field_name");
                newField.m_mongoDocPath = XMLHandler.getTagValue((Node)fieldNode, (String)"mongo_doc_path");
                newField.m_useIncomingFieldNameAsMongoFieldName = XMLHandler.getTagValue((Node)fieldNode, (String)"use_incoming_field_name_as_mongo_field_name").equalsIgnoreCase("Y");
                newField.m_updateMatchField = XMLHandler.getTagValue((Node)fieldNode, (String)"update_match_field").equalsIgnoreCase("Y");
                newField.m_modifierUpdateOperation = XMLHandler.getTagValue((Node)fieldNode, (String)"modifier_update_operation");
                String policy = XMLHandler.getTagValue((Node)fieldNode, (String)"modifier_policy");
                if (!Const.isEmpty((String)policy)) {
                    newField.m_modifierOperationApplyPolicy = policy;
                }
                if (!Const.isEmpty((String)(jsonField = XMLHandler.getTagValue((Node)fieldNode, (String)"json_field")))) {
                    newField.m_JSON = jsonField.equalsIgnoreCase("Y");
                }
                this.m_mongoFields.add(newField);
            }
        }
        if ((fields = XMLHandler.getSubNode((Node)stepnode, (String)"mongo_indexes")) != null && XMLHandler.countNodes((Node)fields, (String)"mongo_index") > 0) {
            nrfields = XMLHandler.countNodes((Node)fields, (String)"mongo_index");
            this.m_mongoIndexes = new ArrayList<MongoIndex>();
            for (i = 0; i < nrfields; ++i) {
                fieldNode = XMLHandler.getSubNodeByNr((Node)fields, (String)"mongo_index", (int)i);
                MongoIndex newIndex = new MongoIndex();
                newIndex.m_pathToFields = XMLHandler.getTagValue((Node)fieldNode, (String)"path_to_fields");
                newIndex.m_drop = XMLHandler.getTagValue((Node)fieldNode, (String)"drop").equalsIgnoreCase("Y");
                newIndex.m_unique = XMLHandler.getTagValue((Node)fieldNode, (String)"unique").equalsIgnoreCase("Y");
                newIndex.m_sparse = XMLHandler.getTagValue((Node)fieldNode, (String)"sparse").equalsIgnoreCase("Y");
                this.m_mongoIndexes.add(newIndex);
            }
        }
    }

    public void readRep(Repository rep, ObjectId id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        int i;
        String writeRetryDelay;
        this.m_hostnames = rep.getStepAttributeString(id_step, 0, "mongo_host");
        this.m_port = rep.getStepAttributeString(id_step, 0, "mongo_port");
        this.m_useAllReplicaSetMembers = rep.getStepAttributeBoolean(id_step, 0, "use_all_replica_members");
        this.m_username = rep.getStepAttributeString(id_step, 0, "mongo_user");
        this.m_password = rep.getStepAttributeString(id_step, 0, "mongo_password");
        if (!Const.isEmpty((String)this.m_password)) {
            this.m_password = Encr.decryptPasswordOptionallyEncrypted((String)this.m_password);
        }
        this.m_kerberos = rep.getStepAttributeBoolean(id_step, "auth_kerberos");
        this.m_dbName = rep.getStepAttributeString(id_step, 0, "mongo_db");
        this.m_collection = rep.getStepAttributeString(id_step, 0, "mongo_collection");
        this.m_batchInsertSize = rep.getStepAttributeString(id_step, 0, "batch_insert_size");
        this.m_connectTimeout = rep.getStepAttributeString(id_step, "connect_timeout");
        this.m_socketTimeout = rep.getStepAttributeString(id_step, "socket_timeout");
        this.m_readPreference = rep.getStepAttributeString(id_step, "read_preference");
        this.m_writeConcern = rep.getStepAttributeString(id_step, "write_concern");
        this.m_wTimeout = rep.getStepAttributeString(id_step, "w_timeout");
        this.m_journal = rep.getStepAttributeBoolean(id_step, 0, "journaled_writes");
        this.m_truncate = rep.getStepAttributeBoolean(id_step, 0, "truncate");
        this.m_upsert = rep.getStepAttributeBoolean(id_step, 0, "upsert");
        this.m_multi = rep.getStepAttributeBoolean(id_step, 0, "multi");
        this.m_modifierUpdate = rep.getStepAttributeBoolean(id_step, 0, "modifier_update");
        int nrfields = rep.countNrStepAttributes(id_step, "incoming_field_name");
        String writeRetries = rep.getStepAttributeString(id_step, "write_retries");
        if (!Const.isEmpty((String)writeRetries)) {
            this.m_writeRetries = writeRetries;
        }
        if (!Const.isEmpty((String)(writeRetryDelay = rep.getStepAttributeString(id_step, "write_retry_delay")))) {
            this.m_writeRetryDelay = writeRetryDelay;
        }
        if (nrfields > 0) {
            this.m_mongoFields = new ArrayList<MongoField>();
            for (i = 0; i < nrfields; ++i) {
                MongoField newField = new MongoField();
                newField.m_incomingFieldName = rep.getStepAttributeString(id_step, i, "incoming_field_name");
                newField.m_mongoDocPath = rep.getStepAttributeString(id_step, i, "mongo_doc_path");
                newField.m_useIncomingFieldNameAsMongoFieldName = rep.getStepAttributeBoolean(id_step, i, "use_incoming_field_name_as_mongo_field_name");
                newField.m_updateMatchField = rep.getStepAttributeBoolean(id_step, i, "update_match_field");
                newField.m_modifierUpdateOperation = rep.getStepAttributeString(id_step, i, "modifier_update_operation");
                String policy = rep.getStepAttributeString(id_step, i, "modifier_policy");
                if (!Const.isEmpty((String)policy)) {
                    newField.m_modifierOperationApplyPolicy = policy;
                }
                newField.m_JSON = rep.getStepAttributeBoolean(id_step, i, "json_field");
                this.m_mongoFields.add(newField);
            }
        }
        if ((nrfields = rep.countNrStepAttributes(id_step, "path_to_fields")) > 0) {
            this.m_mongoIndexes = new ArrayList<MongoIndex>();
            for (i = 0; i < nrfields; ++i) {
                MongoIndex newIndex = new MongoIndex();
                newIndex.m_pathToFields = rep.getStepAttributeString(id_step, i, "path_to_fields");
                newIndex.m_drop = rep.getStepAttributeBoolean(id_step, i, "drop");
                newIndex.m_unique = rep.getStepAttributeBoolean(id_step, i, "unique");
                newIndex.m_sparse = rep.getStepAttributeBoolean(id_step, i, "sparse");
                this.m_mongoIndexes.add(newIndex);
            }
        }
    }

    public void saveRep(Repository rep, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        int i;
        if (!Const.isEmpty((String)this.m_hostnames)) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "mongo_host", this.m_hostnames);
        }
        if (!Const.isEmpty((String)this.m_port)) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "mongo_port", this.m_port);
        }
        rep.saveStepAttribute(id_transformation, id_step, "use_all_replica_members", this.m_useAllReplicaSetMembers);
        if (!Const.isEmpty((String)this.m_username)) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "mongo_user", this.m_username);
        }
        if (!Const.isEmpty((String)this.m_password)) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "mongo_password", Encr.encryptPasswordIfNotUsingVariables((String)this.m_password));
        }
        rep.saveStepAttribute(id_transformation, id_step, "auth_kerberos", this.m_kerberos);
        if (!Const.isEmpty((String)this.m_dbName)) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "mongo_db", this.m_dbName);
        }
        if (!Const.isEmpty((String)this.m_collection)) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "mongo_collection", this.m_collection);
        }
        if (!Const.isEmpty((String)this.m_batchInsertSize)) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "batch_insert_size", this.m_batchInsertSize);
        }
        rep.saveStepAttribute(id_transformation, id_step, "connect_timeout", this.m_connectTimeout);
        rep.saveStepAttribute(id_transformation, id_step, "socket_timeout", this.m_socketTimeout);
        rep.saveStepAttribute(id_transformation, id_step, "read_preference", this.m_readPreference);
        rep.saveStepAttribute(id_transformation, id_step, "write_concern", this.m_writeConcern);
        rep.saveStepAttribute(id_transformation, id_step, "w_timeout", this.m_wTimeout);
        rep.saveStepAttribute(id_transformation, id_step, "journaled_writes", this.m_journal);
        rep.saveStepAttribute(id_transformation, id_step, 0, "truncate", this.m_truncate);
        rep.saveStepAttribute(id_transformation, id_step, 0, "upsert", this.m_upsert);
        rep.saveStepAttribute(id_transformation, id_step, 0, "multi", this.m_multi);
        rep.saveStepAttribute(id_transformation, id_step, 0, "modifier_update", this.m_modifierUpdate);
        rep.saveStepAttribute(id_transformation, id_step, 0, "write_retries", this.m_writeRetries);
        rep.saveStepAttribute(id_transformation, id_step, 0, "write_retry_delay", this.m_writeRetryDelay);
        if (this.m_mongoFields != null && this.m_mongoFields.size() > 0) {
            for (i = 0; i < this.m_mongoFields.size(); ++i) {
                MongoField field = this.m_mongoFields.get(i);
                rep.saveStepAttribute(id_transformation, id_step, i, "incoming_field_name", field.m_incomingFieldName);
                rep.saveStepAttribute(id_transformation, id_step, i, "mongo_doc_path", field.m_mongoDocPath);
                rep.saveStepAttribute(id_transformation, id_step, i, "use_incoming_field_name_as_mongo_field_name", field.m_useIncomingFieldNameAsMongoFieldName);
                rep.saveStepAttribute(id_transformation, id_step, i, "update_match_field", field.m_updateMatchField);
                rep.saveStepAttribute(id_transformation, id_step, i, "modifier_update_operation", field.m_modifierUpdateOperation);
                rep.saveStepAttribute(id_transformation, id_step, i, "modifier_policy", field.m_modifierOperationApplyPolicy);
                rep.saveStepAttribute(id_transformation, id_step, i, "json_field", field.m_JSON);
            }
        }
        if (this.m_mongoIndexes != null && this.m_mongoIndexes.size() > 0) {
            for (i = 0; i < this.m_mongoIndexes.size(); ++i) {
                MongoIndex mongoIndex = this.m_mongoIndexes.get(i);
                rep.saveStepAttribute(id_transformation, id_step, i, "path_to_fields", mongoIndex.m_pathToFields);
                rep.saveStepAttribute(id_transformation, id_step, i, "drop", mongoIndex.m_drop);
                rep.saveStepAttribute(id_transformation, id_step, i, "unique", mongoIndex.m_unique);
                rep.saveStepAttribute(id_transformation, id_step, i, "sparse", mongoIndex.m_sparse);
            }
        }
    }

    public String getDialogClassName() {
        return "org.pentaho.di.trans.steps.mongodboutput.MongoDbOutputDialog";
    }

    public static class MongoIndex {
        public String m_pathToFields = "";
        public boolean m_drop;
        public boolean m_unique;
        public boolean m_sparse;

        public String toString() {
            StringBuffer buff = new StringBuffer();
            buff.append(this.m_pathToFields + " (unique = " + new Boolean(this.m_unique).toString() + " sparse = " + new Boolean(this.m_sparse).toString() + ")");
            return buff.toString();
        }
    }

    public static class MongoField {
        public String m_incomingFieldName = "";
        public String m_mongoDocPath = "";
        protected List<String> m_pathList;
        protected List<String> m_tempPathList;
        public boolean m_useIncomingFieldNameAsMongoFieldName;
        public boolean m_updateMatchField;
        public String m_modifierUpdateOperation = "N/A";
        public String m_modifierOperationApplyPolicy = "Insert&Update";
        public boolean m_JSON = false;

        public MongoField copy() {
            MongoField newF = new MongoField();
            newF.m_incomingFieldName = this.m_incomingFieldName;
            newF.m_mongoDocPath = this.m_mongoDocPath;
            newF.m_useIncomingFieldNameAsMongoFieldName = this.m_useIncomingFieldNameAsMongoFieldName;
            newF.m_updateMatchField = this.m_updateMatchField;
            newF.m_modifierUpdateOperation = this.m_modifierUpdateOperation;
            newF.m_modifierOperationApplyPolicy = this.m_modifierOperationApplyPolicy;
            newF.m_JSON = this.m_JSON;
            return newF;
        }

        public void init(VariableSpace vars) {
            String path = vars.environmentSubstitute(this.m_mongoDocPath);
            this.m_pathList = new ArrayList<String>();
            if (!Const.isEmpty((String)path)) {
                String[] parts;
                for (String p : parts = path.split("\\.")) {
                    this.m_pathList.add(p);
                }
            }
            this.m_tempPathList = new ArrayList<String>(this.m_pathList);
        }

        public void reset() {
            if (this.m_tempPathList != null && this.m_tempPathList.size() > 0) {
                this.m_tempPathList.clear();
            }
            if (this.m_tempPathList != null) {
                this.m_tempPathList.addAll(this.m_pathList);
            }
        }
    }
}

