/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.mongo;

import com.sun.security.auth.module.Krb5LoginModule;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public class KerberosUtil {
    private static final String KERBEROS_APP_NAME = "pentaho";
    private static final Map<String, String> LOGIN_CONFIG_KERBEROS = new HashMap<String, String>();
    private static final AppConfigurationEntry CONFIG_ENTRY_PENTAHO_KERBEROS;
    private static final AppConfigurationEntry[] CONFIG_ENTRIES;

    public LoginContext loginAs(String principal) throws LoginException {
        Subject subject = new Subject();
        LoginContext lc = new LoginContext(KERBEROS_APP_NAME, subject, null, new StaticConfiguration());
        lc.login();
        return lc;
    }

    static {
        LOGIN_CONFIG_KERBEROS.put("doNotPrompt", Boolean.TRUE.toString());
        LOGIN_CONFIG_KERBEROS.put("useTicketCache", Boolean.TRUE.toString());
        LOGIN_CONFIG_KERBEROS.put("renewTGT", Boolean.TRUE.toString());
        String ticketCache = System.getenv("KRB5CCNAME");
        if (ticketCache != null) {
            LOGIN_CONFIG_KERBEROS.put("ticketCache", ticketCache);
        }
        CONFIG_ENTRY_PENTAHO_KERBEROS = new AppConfigurationEntry(Krb5LoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, LOGIN_CONFIG_KERBEROS);
        CONFIG_ENTRIES = new AppConfigurationEntry[]{CONFIG_ENTRY_PENTAHO_KERBEROS};
    }

    private static class StaticConfiguration
    extends Configuration {
        private StaticConfiguration() {
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String ignored) {
            return CONFIG_ENTRIES;
        }
    }
}

