/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.mongo;

import com.mongodb.BasicDBList;
import com.mongodb.CommandResult;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.TaggableReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.util.JSON;
import java.net.UnknownHostException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.steps.mongodbinput.MongoDbInputData;
import org.pentaho.di.trans.steps.mongodbinput.MongoDbInputMeta;
import org.pentaho.di.trans.steps.mongodboutput.MongoDbOutputMeta;
import org.pentaho.mongo.AuthContext;
import org.pentaho.mongo.KerberosUtil;
import org.pentaho.mongo.NamedReadPreference;

public class MongoUtils {
    private static Class<?> PKG = MongoUtils.class;
    public static final int MONGO_DEFAULT_PORT = 27017;
    public static final String LOCAL_DB = "local";
    public static final String REPL_SET_COLLECTION = "system.replset";
    public static final String REPL_SET_SETTINGS = "settings";
    public static final String REPL_SET_LAST_ERROR_MODES = "getLastErrorModes";
    public static final String REPL_SET_MEMBERS = "members";
    private static final KerberosUtil KERBEROS_UTIL = new KerberosUtil();

    public static MongoCredential createCredentials(String username, String password, String dbName, boolean kerberos) {
        MongoCredential cred = null;
        if (kerberos) {
            if (!Const.isEmpty((String)username)) {
                cred = MongoCredential.createGSSAPICredential((String)username);
            }
        } else if (!Const.isEmpty((String)username) || !Const.isEmpty((String)password)) {
            cred = MongoCredential.createMongoCRCredential((String)username, (String)dbName, (char[])password.toCharArray());
        }
        return cred;
    }

    public static MongoCredential createCredentials(MongoDbOutputMeta meta, VariableSpace vars) {
        String realUser = vars.environmentSubstitute(meta.getUsername());
        String realPass = Encr.decryptPasswordOptionallyEncrypted((String)vars.environmentSubstitute(meta.getPassword()));
        return MongoUtils.createCredentials(realUser, realPass, meta.getDBName(), meta.getUseKerberosAuthentication());
    }

    public static MongoCredential createCredentials(MongoDbInputMeta meta, VariableSpace vars) {
        String realUser = vars.environmentSubstitute(meta.getAuthenticationUser());
        String realPass = Encr.decryptPasswordOptionallyEncrypted((String)vars.environmentSubstitute(meta.getAuthenticationPassword()));
        return MongoUtils.createCredentials(realUser, realPass, meta.getDbName(), meta.getUseKerberosAuthentication());
    }

    public static void configureConnectionOptions(MongoClientOptions.Builder optsBuilder, String connTimeout, String socketTimeout, String readPreference, String writeConcern, String wTimeout, boolean journaled, List<String> tagSet, VariableSpace vars, LogChannelInterface log) throws KettleException {
        WriteConcern concern;
        block32: {
            if (!Const.isEmpty((String)connTimeout)) {
                String connS = vars.environmentSubstitute(connTimeout);
                try {
                    int cTimeout = Integer.parseInt(connS);
                    if (cTimeout > 0) {
                        optsBuilder.connectTimeout(cTimeout);
                    }
                }
                catch (NumberFormatException n) {
                    throw new KettleException((Throwable)n);
                }
            }
            if (!Const.isEmpty((String)socketTimeout)) {
                String sockS = vars.environmentSubstitute(socketTimeout);
                try {
                    int sockTimeout = Integer.parseInt(sockS);
                    if (sockTimeout > 0) {
                        optsBuilder.socketTimeout(sockTimeout);
                    }
                }
                catch (NumberFormatException n) {
                    throw new KettleException((Throwable)n);
                }
            }
            if (log != null) {
                String rpLogSetting = NamedReadPreference.PRIMARY.getName();
                if (!Const.isEmpty((String)readPreference)) {
                    rpLogSetting = readPreference;
                }
                log.logBasic(BaseMessages.getString(PKG, (String)"MongoUtils.Message.UsingReadPreference", (String[])new String[]{rpLogSetting}));
            }
            DBObject firstTagSet = null;
            DBObject[] remainingTagSets = new DBObject[]{};
            if (tagSet != null && tagSet.size() > 0) {
                if (tagSet.size() > 1) {
                    remainingTagSets = new DBObject[tagSet.size() - 1];
                }
                firstTagSet = (DBObject)JSON.parse((String)tagSet.get(0).trim());
                for (int i = 1; i < tagSet.size(); ++i) {
                    remainingTagSets[i - 1] = (DBObject)JSON.parse((String)tagSet.get(i).trim());
                }
                if (log != null && !Const.isEmpty((String)readPreference) && !readPreference.equalsIgnoreCase(NamedReadPreference.PRIMARY.getName())) {
                    StringBuilder builder = new StringBuilder();
                    for (String s : tagSet) {
                        builder.append(s).append(" ");
                    }
                    log.logBasic(BaseMessages.getString(PKG, (String)"MongoUtils.Message.UsingReadPreferenceTagSets", (String[])new String[]{builder.toString()}));
                }
            } else if (log != null) {
                log.logBasic(BaseMessages.getString(PKG, (String)"MongoUtils.Message.NoReadPreferenceTagSetsDefined", (String[])new String[0]));
            }
            if (!Const.isEmpty((String)readPreference)) {
                String rp = vars.environmentSubstitute(readPreference);
                NamedReadPreference preference = NamedReadPreference.byName(rp);
                if (firstTagSet != null && preference.getPreference() instanceof TaggableReadPreference) {
                    optsBuilder.readPreference(preference.getTaggableReadPreference(firstTagSet, remainingTagSets));
                } else {
                    optsBuilder.readPreference(preference.getPreference());
                }
            }
            writeConcern = vars.environmentSubstitute(writeConcern);
            wTimeout = vars.environmentSubstitute(wTimeout);
            concern = null;
            if (Const.isEmpty((String)writeConcern) && Const.isEmpty((String)wTimeout) && !journaled) {
                concern = new WriteConcern();
                concern.setWObject((Object)new Integer(1));
                if (log != null) {
                    log.logBasic(BaseMessages.getString(PKG, (String)"MongoUtils.Message.ConfiguringWithDefaultWriteConcern", (String[])new String[0]));
                }
            } else {
                int wt = 0;
                if (!Const.isEmpty((String)wTimeout)) {
                    try {
                        wt = Integer.parseInt(wTimeout);
                    }
                    catch (NumberFormatException n) {
                        throw new KettleException((Throwable)n);
                    }
                }
                if (!Const.isEmpty((String)writeConcern)) {
                    try {
                        int wc = Integer.parseInt(writeConcern);
                        concern = new WriteConcern(wc, wt, false, journaled);
                        if (log != null) {
                            String lwc = "w = " + writeConcern + ", wTimeout = " + wt + ", journaled = " + new Boolean(journaled).toString();
                            log.logBasic(BaseMessages.getString(PKG, (String)"MongoUtils.Message.ConfiguringWithWriteConcern", (String[])new String[]{lwc}));
                        }
                        break block32;
                    }
                    catch (NumberFormatException n) {
                        concern = new WriteConcern(writeConcern, wt, false, journaled);
                        if (log != null) {
                            String lwc = "w = " + writeConcern + ", wTimeout = " + wt + ", journaled = " + new Boolean(journaled).toString();
                            log.logBasic(BaseMessages.getString(PKG, (String)"MongoUtils.Message.ConfiguringWithWriteConcern", (String[])new String[]{lwc}));
                        }
                        break block32;
                    }
                }
                concern = new WriteConcern(1, wt, false, journaled);
                if (log != null) {
                    String lwc = "w = 1, wTimeout = " + wt + ", journaled = " + new Boolean(journaled).toString();
                    log.logBasic(BaseMessages.getString(PKG, (String)"MongoUtils.Message.ConfiguringWithWriteConcern", (String[])new String[]{lwc}));
                }
            }
        }
        optsBuilder.writeConcern(concern);
    }

    public static MongoClient initConnection(String hostsPorts, String singlePort, MongoCredential cred, boolean useAllReplicaSetMembers, String connTimeout, String socketTimeout, String readPreference, String writeConcern, String wTimeout, boolean journaled, List<String> tagSet, VariableSpace vars, LogChannelInterface log) throws KettleException {
        String[] parts;
        hostsPorts = vars.environmentSubstitute(hostsPorts);
        singlePort = vars.environmentSubstitute(singlePort);
        int singlePortI = -1;
        try {
            singlePortI = Integer.parseInt(singlePort);
        }
        catch (NumberFormatException n) {
            // empty catch block
        }
        if (Const.isEmpty((String)hostsPorts)) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"MongoUtils.Message.Error.EmptyHostsString", (String[])new String[0]));
        }
        ArrayList<ServerAddress> repSet = new ArrayList<ServerAddress>();
        for (String part : parts = hostsPorts.trim().split(",")) {
            int port = singlePortI != -1 ? singlePortI : 27017;
            String[] hp = part.split(":");
            if (hp.length > 2) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"MongoUtils.Message.Error.MalformedHost", (String[])new String[]{part}));
            }
            String host = hp[0];
            if (hp.length == 2) {
                try {
                    port = Integer.parseInt(hp[1].trim());
                }
                catch (NumberFormatException n) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"MongoUtils.Message.Error.UnableToParsePortNumber", (String[])new String[]{hp[1]}));
                }
            }
            try {
                ServerAddress s = new ServerAddress(host, port);
                repSet.add(s);
            }
            catch (UnknownHostException u) {
                throw new KettleException((Throwable)u);
            }
        }
        MongoClientOptions.Builder mongoOptsBuilder = new MongoClientOptions.Builder();
        MongoUtils.configureConnectionOptions(mongoOptsBuilder, connTimeout, socketTimeout, readPreference, writeConcern, wTimeout, journaled, tagSet, vars, log);
        MongoClientOptions opts = mongoOptsBuilder.build();
        try {
            if (cred == null) {
                return repSet.size() > 1 || useAllReplicaSetMembers && repSet.size() >= 1 ? new MongoClient(repSet, opts) : (repSet.size() == 1 ? new MongoClient((ServerAddress)repSet.get(0), opts) : new MongoClient(new ServerAddress("localhost"), opts));
            }
            ArrayList<MongoCredential> credList = new ArrayList<MongoCredential>();
            credList.add(cred);
            return repSet.size() > 1 || useAllReplicaSetMembers && repSet.size() >= 1 ? new MongoClient(repSet, credList, opts) : (repSet.size() == 1 ? new MongoClient((ServerAddress)repSet.get(0), credList, opts) : new MongoClient(new ServerAddress("localhost"), credList, opts));
        }
        catch (UnknownHostException u) {
            throw new KettleException((Throwable)u);
        }
    }

    public static MongoClient initConnection(MongoDbOutputMeta meta, VariableSpace vars, MongoCredential cred, LogChannelInterface log) throws KettleException {
        String hostsPorts = meta.getHostnames();
        String singlePort = meta.getPort();
        String username = meta.getUsername();
        String password = meta.getPassword();
        String connTimeout = meta.getConnectTimeout();
        String sockTimeout = meta.getSocketTimeout();
        String readPreference = meta.getReadPreference();
        String writeConcern = meta.getWriteConcern();
        String wTimeout = meta.getWTimeout();
        boolean journaled = meta.getJournal();
        List<String> tagSet = null;
        boolean useAllReplicaSetMembers = meta.getUseAllReplicaSetMembers();
        return MongoUtils.initConnection(hostsPorts, singlePort, cred, useAllReplicaSetMembers, connTimeout, sockTimeout, readPreference, writeConcern, wTimeout, journaled, tagSet, vars, log);
    }

    public static MongoClient initConnection(MongoDbInputMeta meta, VariableSpace vars, MongoCredential cred, LogChannelInterface log) throws KettleException {
        String hostsPorts = meta.getHostnames();
        String singlePort = meta.getPort();
        String username = meta.getAuthenticationUser();
        String password = meta.getAuthenticationPassword();
        String connTimeout = meta.getConnectTimeout();
        String sockTimeout = meta.getSocketTimeout();
        String readPreference = meta.getReadPreference();
        String writeConcern = null;
        String wTimeout = null;
        boolean journaled = false;
        List<String> tagSet = meta.getReadPrefTagSets();
        boolean useAllReplicaSetMembers = meta.getUseAllReplicaSetMembers();
        return MongoUtils.initConnection(hostsPorts, singlePort, cred, useAllReplicaSetMembers, connTimeout, sockTimeout, readPreference, writeConcern, wTimeout, journaled, tagSet, vars, log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getLastErrorModes(String hostsPorts, String singlePort, MongoCredential cred, VariableSpace vars, LogChannelInterface log) throws KettleException {
        ArrayList<String> customLastErrorModes = new ArrayList<String>();
        MongoClient mongo = null;
        try {
            DBCollection replset;
            DB local;
            if (cred != null && cred.getMechanism().equals("MONGODB-CR")) {
                cred = MongoCredential.createMongoCRCredential((String)cred.getUserName(), (String)LOCAL_DB, (char[])cred.getPassword());
            }
            if ((local = (mongo = MongoUtils.initConnection(hostsPorts, singlePort, cred, false, null, null, null, null, null, false, null, vars, log)).getDB(LOCAL_DB)) != null && (replset = local.getCollection(REPL_SET_COLLECTION)) != null) {
                DBObject config = replset.findOne();
                MongoUtils.extractLastErrorModes(config, customLastErrorModes);
            }
        }
        finally {
            if (mongo != null) {
                mongo.close();
            }
        }
        return customLastErrorModes;
    }

    protected static void extractLastErrorModes(DBObject config, List<String> customLastErrorModes) {
        Object getLastErrModes;
        Object settings;
        if (config != null && (settings = config.get(REPL_SET_SETTINGS)) != null && (getLastErrModes = ((DBObject)settings).get(REPL_SET_LAST_ERROR_MODES)) != null) {
            for (String m : ((DBObject)getLastErrModes).keySet()) {
                customLastErrorModes.add(m);
            }
        }
    }

    public static List<String> getLastErrorModes(MongoDbOutputMeta meta, VariableSpace vars, MongoCredential cred, LogChannelInterface log) throws KettleException {
        return MongoUtils.getLastErrorModes(meta.getHostnames(), meta.getPort(), cred, vars, log);
    }

    protected static String quote(String string) {
        if (string.indexOf(34) >= 0 && string.indexOf(34) >= 0) {
            string = string.replace("\"", "\\\"");
        }
        string = "\"" + string + "\"";
        return string;
    }

    public static List<String> getAllTags(MongoDbInputMeta meta, VariableSpace vars, MongoCredential cred, LogChannelInterface log) throws KettleException {
        return MongoUtils.getAllTags(meta.getHostnames(), meta.getPort(), cred, vars, log);
    }

    public static List<String> getAllTags(String hostsPorts, String singlePort, MongoCredential cred, VariableSpace vars, LogChannelInterface log) throws KettleException {
        ArrayList<String> allTags = new ArrayList<String>();
        BasicDBList members = MongoUtils.getRepSetMemberRecords(hostsPorts, singlePort, cred, vars, log);
        MongoUtils.setupAllTags(members, allTags);
        return allTags;
    }

    protected static void setupAllTags(BasicDBList members, List<String> allTags) {
        HashSet<String> tempTags = new HashSet<String>();
        if (members != null && members.size() > 0) {
            for (int i = 0; i < members.size(); ++i) {
                DBObject tags;
                Object m = members.get(i);
                if (m == null || (tags = (DBObject)((DBObject)m).get("tags")) == null) continue;
                for (String tagName : tags.keySet()) {
                    String tagVal = tags.get(tagName).toString();
                    String combined = MongoUtils.quote(tagName) + " : " + MongoUtils.quote(tagVal);
                    tempTags.add(combined);
                }
            }
        }
        for (String s : tempTags) {
            allTags.add(s);
        }
    }

    public static List<DBObject> getReplicaSetMembersThatSatisfyTagSets(List<DBObject> tagSets, MongoDbInputMeta meta, VariableSpace vars, MongoCredential cred, LogChannelInterface log) throws KettleException {
        return MongoUtils.getReplicaSetMembersThatSatisfyTagSets(tagSets, meta.getHostnames(), meta.getPort(), cred, vars, log);
    }

    public static List<DBObject> getReplicaSetMembersThatSatisfyTagSets(List<DBObject> tagSets, String hostsPorts, String singlePort, MongoCredential cred, VariableSpace vars, LogChannelInterface log) throws KettleException {
        ArrayList<DBObject> satisfy = new ArrayList<DBObject>();
        BasicDBList members = MongoUtils.getRepSetMemberRecords(hostsPorts, singlePort, cred, vars, log);
        MongoUtils.checkForReplicaSetMembersThatSatisfyTagSets(tagSets, satisfy, members);
        return satisfy;
    }

    protected static void checkForReplicaSetMembersThatSatisfyTagSets(List<DBObject> tagSets, List<DBObject> satisfy, BasicDBList members) {
        if (members != null && members.size() > 0) {
            for (int i = 0; i < members.size(); ++i) {
                DBObject tags;
                Object m = members.get(i);
                if (m == null || (tags = (DBObject)((DBObject)m).get("tags")) == null) continue;
                for (int j = 0; j < tagSets.size(); ++j) {
                    boolean match = true;
                    DBObject toMatch = tagSets.get(j);
                    for (String tagName : toMatch.keySet()) {
                        String tagValue = toMatch.get(tagName).toString();
                        Object matchVal = tags.get(tagName);
                        if (matchVal == null) {
                            match = false;
                            break;
                        }
                        if (matchVal.toString().equals(tagValue)) continue;
                        match = false;
                        break;
                    }
                    if (!match || satisfy.contains(m)) continue;
                    satisfy.add((DBObject)m);
                }
            }
        }
    }

    protected static BasicDBList getRepSetMemberRecords(String hostsPorts, String singlePort, MongoCredential cred, VariableSpace vars, LogChannelInterface log) throws KettleException {
        MongoClient mongo = null;
        BasicDBList setMembers = null;
        try {
            DB local;
            if (cred != null && cred.getMechanism().equals("MONGODB-CR")) {
                cred = MongoCredential.createMongoCRCredential((String)cred.getUserName(), (String)LOCAL_DB, (char[])cred.getPassword());
            }
            if ((local = (mongo = MongoUtils.initConnection(hostsPorts, singlePort, cred, false, null, null, null, null, null, false, null, vars, log)).getDB(LOCAL_DB)) != null) {
                DBCollection replset = local.getCollection(REPL_SET_COLLECTION);
                if (replset != null) {
                    DBObject config = replset.findOne();
                    if (config != null) {
                        Object members = config.get(REPL_SET_MEMBERS);
                        if (members instanceof BasicDBList) {
                            if (((BasicDBList)members).size() == 0) {
                                if (log != null) {
                                    log.logBasic(BaseMessages.getString(PKG, (String)"MongoUtils.Message.Warning.NoReplicaSetMembersDefined", (String[])new String[0]));
                                }
                            } else {
                                setMembers = (BasicDBList)members;
                            }
                        } else if (log != null) {
                            log.logBasic(BaseMessages.getString(PKG, (String)"MongoUtils.Message.Warning.NoReplicaSetMembersDefined", (String[])new String[0]));
                        }
                    } else if (log != null) {
                        log.logBasic(BaseMessages.getString(PKG, (String)"MongoUtils.Message.Warning.NoReplicaSetMembersDefined", (String[])new String[0]));
                    }
                } else if (log != null) {
                    log.logBasic(BaseMessages.getString(PKG, (String)"MongoUtils.Message.Warning.ReplicaSetCollectionUnavailable", (String[])new String[0]));
                }
            } else if (log != null) {
                log.logBasic(BaseMessages.getString(PKG, (String)"MongoUtils.Message.Warning.LocalDBNotAvailable", (String[])new String[0]));
            }
        }
        catch (Exception ex) {
            throw new KettleException((Throwable)ex);
        }
        finally {
            if (mongo != null) {
                mongo.close();
            }
        }
        return setMembers;
    }

    public static List<ServerAddress> getReplicaSetMembers(String hostsPorts, String singlePort, MongoCredential cred, VariableSpace vars, LogChannelInterface log) throws KettleException {
        ArrayList<ServerAddress> replSetMembers = new ArrayList<ServerAddress>();
        if (log != null) {
            log.logBasic(BaseMessages.getString(PKG, (String)"MongoUtils.Message.QueryingForReplicaSetMembers", (String[])new String[]{hostsPorts}));
        }
        BasicDBList members = MongoUtils.getRepSetMemberRecords(hostsPorts, singlePort, cred, vars, log);
        try {
            if (members != null && members.size() > 0) {
                for (int i = 0; i < members.size(); ++i) {
                    ServerAddress address;
                    String hostPort;
                    Object m = members.get(i);
                    if (m == null || Const.isEmpty((String)(hostPort = ((DBObject)m).get("host").toString()))) continue;
                    String[] parts = hostPort.split(":");
                    if (parts.length == 2) {
                        address = new ServerAddress(parts[0].trim(), Integer.parseInt(parts[1].trim()));
                        replSetMembers.add(address);
                        continue;
                    }
                    address = new ServerAddress(parts[0].trim());
                    replSetMembers.add(address);
                }
            }
        }
        catch (Exception ex) {
            throw new KettleException((Throwable)ex);
        }
        return replSetMembers;
    }

    public static AuthContext createAuthContext(MongoDbInputMeta meta, VariableSpace varSpace) throws KettleException {
        return MongoUtils.createAuthContext(meta.getUseKerberosAuthentication(), varSpace.environmentSubstitute(meta.getAuthenticationUser()));
    }

    public static AuthContext createAuthContext(MongoDbOutputMeta meta, VariableSpace varSpace) throws KettleException {
        return MongoUtils.createAuthContext(meta.getUseKerberosAuthentication(), varSpace.environmentSubstitute(meta.getUsername()));
    }

    private static AuthContext createAuthContext(boolean useKerberosAuth, String principal) throws KettleException {
        LoginContext context = null;
        if (useKerberosAuth) {
            try {
                context = KERBEROS_UTIL.loginAs(principal);
            }
            catch (LoginException ex) {
                throw new KettleException("Unable to authenticate as '" + principal + "'", (Throwable)ex);
            }
        }
        return new AuthContext(context);
    }

    public static List<String> getDatabaseNames(final MongoDbInputMeta meta, final VariableSpace varSpace) throws KettleException {
        try {
            AuthContext context = MongoUtils.createAuthContext(meta, varSpace);
            return context.doAs(new PrivilegedExceptionAction<List<String>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public List<String> run() throws Exception {
                    MongoClient conn = null;
                    try {
                        conn = MongoDbInputData.initConnection(meta, varSpace, null);
                        List list = conn.getDatabaseNames();
                        return list;
                    }
                    finally {
                        if (conn != null) {
                            conn.close();
                        }
                    }
                }
            });
        }
        catch (PrivilegedActionException ex) {
            if (ex.getCause() instanceof KettleException) {
                throw (KettleException)ex.getCause();
            }
            throw new KettleException("Unable to retrieve database names from MongoDB", ex.getCause());
        }
    }

    public static Set<String> getCollectionsNames(final MongoDbInputMeta meta, final TransMeta varSpace, final String dB, final String username, final String realPass) throws KettleException {
        try {
            AuthContext context = MongoUtils.createAuthContext(meta, (VariableSpace)varSpace);
            return context.doAs(new PrivilegedExceptionAction<Set<String>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Set<String> run() throws Exception {
                    MongoClient conn = null;
                    try {
                        CommandResult comResult;
                        conn = MongoDbInputData.initConnection(meta, (VariableSpace)varSpace, null);
                        DB theDB = conn.getDB(dB);
                        if (!(Const.isEmpty((String)username) && Const.isEmpty((String)realPass) || (comResult = theDB.authenticateCommand(username, realPass.toCharArray())).ok())) {
                            throw new Exception(BaseMessages.getString((Class)PKG, (String)"MongoDbInput.ErrorAuthenticating.Exception", (String[])new String[]{comResult.getErrorMessage()}));
                        }
                        Set set = theDB.getCollectionNames();
                        return set;
                    }
                    finally {
                        if (conn != null) {
                            conn.close();
                        }
                    }
                }
            });
        }
        catch (PrivilegedActionException ex) {
            if (ex.getCause() instanceof KettleException) {
                throw (KettleException)ex.getCause();
            }
            throw new KettleException("Unable to retrieve collection names for database " + dB + " from MongoDB", ex.getCause());
        }
    }

    public static void main(String[] args) {
        try {
            String hostPort = args[0];
            String defaultPort = args[1];
            Variables vars = new Variables();
            List<String> repSetTags = MongoUtils.getAllTags(hostPort, defaultPort, null, (VariableSpace)vars, null);
            System.out.println("Number of tags: " + repSetTags.size());
            for (String tag : repSetTags) {
                System.out.println(tag);
            }
            List<ServerAddress> repSetMembers = MongoUtils.getReplicaSetMembers(hostPort, defaultPort, null, (VariableSpace)vars, null);
            System.out.println("Number of replica set members: " + repSetMembers.size());
            for (ServerAddress s : repSetMembers) {
                System.out.println(s.toString());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

