/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.database.dialect;

import org.pentaho.database.DatabaseDialectException;
import org.pentaho.database.dialect.Hive2DatabaseDialect;
import org.pentaho.database.model.DatabaseAccessType;
import org.pentaho.database.model.DatabaseType;
import org.pentaho.database.model.IDatabaseConnection;
import org.pentaho.database.model.IDatabaseType;

public class ImpalaDatabaseDialect
extends Hive2DatabaseDialect {
    private static final long serialVersionUID = -6685869374136347923L;
    private static final int DEFAULT_PORT = 21050;
    private static final IDatabaseType DBTYPE = new DatabaseType("Impala", "IMPALA", DatabaseAccessType.getList(DatabaseAccessType.NATIVE, DatabaseAccessType.JNDI), 21050, "http://www.cloudera.com/content/support/en/documentation/cloudera-impala/cloudera-impala-documentation-v1-latest.html");

    @Override
    public IDatabaseType getDatabaseType() {
        return DBTYPE;
    }

    @Override
    public String getNativeDriver() {
        return "org.apache.hive.jdbc.ImpalaDriver";
    }

    @Override
    public String getURL(IDatabaseConnection connection) throws DatabaseDialectException {
        StringBuffer urlBuffer = new StringBuffer(this.getNativeJdbcPre());
        urlBuffer.append(connection.getHostname());
        urlBuffer.append(":");
        urlBuffer.append(connection.getDatabasePort());
        urlBuffer.append("/");
        urlBuffer.append(connection.getDatabaseName());
        urlBuffer.append(";auth=noSasl");
        return urlBuffer.toString();
    }

    @Override
    public String getNativeJdbcPre() {
        return "jdbc:hive2://";
    }

    @Override
    public String[] getUsedLibraries() {
        return new String[]{"pentaho-hadoop-hive-jdbc-shim-1.4-SNAPSHOT.jar"};
    }

    @Override
    public int getDefaultDatabasePort() {
        return 21050;
    }
}

