/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli;

import java.sql.Date;
import java.sql.Timestamp;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hive.service.cli.Type;
import org.apache.hive.service.cli.thrift.TBoolValue;
import org.apache.hive.service.cli.thrift.TByteValue;
import org.apache.hive.service.cli.thrift.TColumnValue;
import org.apache.hive.service.cli.thrift.TDoubleValue;
import org.apache.hive.service.cli.thrift.TI16Value;
import org.apache.hive.service.cli.thrift.TI32Value;
import org.apache.hive.service.cli.thrift.TI64Value;
import org.apache.hive.service.cli.thrift.TStringValue;

public class ColumnValue {
    public static final TColumnValue NULL = new TColumnValue();
    private final TColumnValue tColumnValue;

    public ColumnValue(TColumnValue tColumnValue) {
        this.tColumnValue = new TColumnValue(tColumnValue);
    }

    private static boolean isNull(Object value) {
        return value == null;
    }

    public static ColumnValue booleanValue(Boolean value) {
        TBoolValue tBoolValue = new TBoolValue();
        if (value != null) {
            tBoolValue.setValue(value);
        }
        return new ColumnValue(TColumnValue.boolVal(tBoolValue));
    }

    public static ColumnValue byteValue(Byte value) {
        TByteValue tByteValue = new TByteValue();
        if (value != null) {
            tByteValue.setValue(value);
        }
        return new ColumnValue(TColumnValue.byteVal(tByteValue));
    }

    public static ColumnValue shortValue(Short value) {
        TI16Value tI16Value = new TI16Value();
        if (value != null) {
            tI16Value.setValue(value);
        }
        return new ColumnValue(TColumnValue.i16Val(tI16Value));
    }

    public static ColumnValue intValue(Integer value) {
        TI32Value tI32Value = new TI32Value();
        if (value != null) {
            tI32Value.setValue(value);
        }
        return new ColumnValue(TColumnValue.i32Val(tI32Value));
    }

    public static ColumnValue longValue(Long value) {
        TI64Value tI64Value = new TI64Value();
        if (value != null) {
            tI64Value.setValue(value);
        }
        return new ColumnValue(TColumnValue.i64Val(tI64Value));
    }

    public static ColumnValue floatValue(Float value) {
        TDoubleValue tDoubleValue = new TDoubleValue();
        if (value != null) {
            tDoubleValue.setValue(value.floatValue());
        }
        return new ColumnValue(TColumnValue.doubleVal(tDoubleValue));
    }

    public static ColumnValue doubleValue(Double value) {
        TDoubleValue tDoubleValue = new TDoubleValue();
        if (value != null) {
            tDoubleValue.setValue(value);
        }
        return new ColumnValue(TColumnValue.doubleVal(tDoubleValue));
    }

    public static ColumnValue stringValue(String value) {
        TStringValue tStringValue = new TStringValue();
        if (value != null) {
            tStringValue.setValue(value);
        }
        return new ColumnValue(TColumnValue.stringVal(tStringValue));
    }

    public static ColumnValue stringValue(HiveChar value) {
        TStringValue tStringValue = new TStringValue();
        if (value != null) {
            tStringValue.setValue(value.toString());
        }
        return new ColumnValue(TColumnValue.stringVal(tStringValue));
    }

    public static ColumnValue stringValue(HiveVarchar value) {
        TStringValue tStringValue = new TStringValue();
        if (value != null) {
            tStringValue.setValue(value.toString());
        }
        return new ColumnValue(TColumnValue.stringVal(tStringValue));
    }

    public static ColumnValue dateValue(Date value) {
        TStringValue tStringValue = new TStringValue();
        if (value != null) {
            tStringValue.setValue(value.toString());
        }
        return new ColumnValue(TColumnValue.stringVal(tStringValue));
    }

    public static ColumnValue timestampValue(Timestamp value) {
        TStringValue tStringValue = new TStringValue();
        if (value != null) {
            tStringValue.setValue(value.toString());
        }
        return new ColumnValue(TColumnValue.stringVal(tStringValue));
    }

    public static ColumnValue stringValue(HiveDecimal value) {
        TStringValue tStrValue = new TStringValue();
        if (value != null) {
            tStrValue.setValue(value.toString());
        }
        return new ColumnValue(TColumnValue.stringVal(tStrValue));
    }

    public static ColumnValue newColumnValue(Type type, Object value) {
        switch (type) {
            case BOOLEAN_TYPE: {
                return ColumnValue.booleanValue((Boolean)value);
            }
            case TINYINT_TYPE: {
                return ColumnValue.byteValue((Byte)value);
            }
            case SMALLINT_TYPE: {
                return ColumnValue.shortValue((Short)value);
            }
            case INT_TYPE: {
                return ColumnValue.intValue((Integer)value);
            }
            case BIGINT_TYPE: {
                return ColumnValue.longValue((Long)value);
            }
            case FLOAT_TYPE: {
                return ColumnValue.floatValue((Float)value);
            }
            case DOUBLE_TYPE: {
                return ColumnValue.doubleValue((Double)value);
            }
            case STRING_TYPE: {
                return ColumnValue.stringValue((String)value);
            }
            case CHAR_TYPE: {
                return ColumnValue.stringValue((HiveChar)value);
            }
            case VARCHAR_TYPE: {
                return ColumnValue.stringValue((HiveVarchar)value);
            }
            case DATE_TYPE: {
                return ColumnValue.dateValue((Date)value);
            }
            case TIMESTAMP_TYPE: {
                return ColumnValue.timestampValue((Timestamp)value);
            }
            case DECIMAL_TYPE: {
                return ColumnValue.stringValue((HiveDecimal)value);
            }
            case BINARY_TYPE: 
            case ARRAY_TYPE: 
            case MAP_TYPE: 
            case STRUCT_TYPE: 
            case UNION_TYPE: 
            case USER_DEFINED_TYPE: {
                return ColumnValue.stringValue((String)value);
            }
        }
        return null;
    }

    public TColumnValue toTColumnValue() {
        return new TColumnValue(this.tColumnValue);
    }

    static {
        NULL.setStringVal(new TStringValue());
    }
}

