/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.protobuf.Service;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.CoprocessorHConnection;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.coprocessor.CoprocessorHost;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.io.MultipleIOException;

public class HTableWrapper
implements HTableInterface {
    private TableName tableName;
    private HTable table;
    private ClusterConnection connection;
    private final List<HTableInterface> openTables;

    public static HTableInterface createWrapper(List<HTableInterface> openTables, TableName tableName, CoprocessorHost.Environment env, ExecutorService pool) throws IOException {
        return new HTableWrapper(openTables, tableName, CoprocessorHConnection.getConnectionForEnvironment(env), pool);
    }

    private HTableWrapper(List<HTableInterface> openTables, TableName tableName, ClusterConnection connection, ExecutorService pool) throws IOException {
        this.tableName = tableName;
        this.table = new HTable(tableName, connection, pool);
        this.connection = connection;
        this.openTables = openTables;
        this.openTables.add(this);
    }

    public void internalClose() throws IOException {
        ArrayList<IOException> exceptions = new ArrayList<IOException>(2);
        try {
            this.table.close();
        }
        catch (IOException e) {
            exceptions.add(e);
        }
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (IOException e) {
            exceptions.add(e);
        }
        if (!exceptions.isEmpty()) {
            throw MultipleIOException.createIOException(exceptions);
        }
    }

    public Configuration getConfiguration() {
        return this.table.getConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            this.internalClose();
        }
        finally {
            this.openTables.remove(this);
        }
    }

    public Result getRowOrBefore(byte[] row, byte[] family) throws IOException {
        return this.table.getRowOrBefore(row, family);
    }

    public Result get(Get get) throws IOException {
        return this.table.get(get);
    }

    public boolean exists(Get get) throws IOException {
        return this.table.exists(get);
    }

    public Boolean[] exists(List<Get> gets) throws IOException {
        return this.table.exists(gets);
    }

    public void put(Put put) throws IOException {
        this.table.put(put);
    }

    public void put(List<Put> puts) throws IOException {
        this.table.put(puts);
    }

    public void delete(Delete delete) throws IOException {
        this.table.delete(delete);
    }

    public void delete(List<Delete> deletes) throws IOException {
        this.table.delete(deletes);
    }

    public boolean checkAndPut(byte[] row, byte[] family, byte[] qualifier, byte[] value, Put put) throws IOException {
        return this.table.checkAndPut(row, family, qualifier, value, put);
    }

    public boolean checkAndDelete(byte[] row, byte[] family, byte[] qualifier, byte[] value, Delete delete) throws IOException {
        return this.table.checkAndDelete(row, family, qualifier, value, delete);
    }

    public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount) throws IOException {
        return this.table.incrementColumnValue(row, family, qualifier, amount);
    }

    public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount, Durability durability) throws IOException {
        return this.table.incrementColumnValue(row, family, qualifier, amount, durability);
    }

    public Result append(Append append) throws IOException {
        return this.table.append(append);
    }

    public Result increment(Increment increment) throws IOException {
        return this.table.increment(increment);
    }

    public void flushCommits() throws IOException {
        this.table.flushCommits();
    }

    public boolean isAutoFlush() {
        return this.table.isAutoFlush();
    }

    public ResultScanner getScanner(Scan scan) throws IOException {
        return this.table.getScanner(scan);
    }

    public ResultScanner getScanner(byte[] family) throws IOException {
        return this.table.getScanner(family);
    }

    public ResultScanner getScanner(byte[] family, byte[] qualifier) throws IOException {
        return this.table.getScanner(family, qualifier);
    }

    public HTableDescriptor getTableDescriptor() throws IOException {
        return this.table.getTableDescriptor();
    }

    public byte[] getTableName() {
        return this.tableName.getName();
    }

    public TableName getName() {
        return this.table.getName();
    }

    public void batch(List<? extends Row> actions, Object[] results) throws IOException, InterruptedException {
        this.table.batch(actions, results);
    }

    public Object[] batch(List<? extends Row> actions) throws IOException, InterruptedException {
        return this.table.batch(actions);
    }

    public <R> void batchCallback(List<? extends Row> actions, Object[] results, Batch.Callback<R> callback) throws IOException, InterruptedException {
        this.table.batchCallback(actions, results, callback);
    }

    public <R> Object[] batchCallback(List<? extends Row> actions, Batch.Callback<R> callback) throws IOException, InterruptedException {
        return this.table.batchCallback(actions, callback);
    }

    public Result[] get(List<Get> gets) throws IOException {
        return this.table.get(gets);
    }

    public CoprocessorRpcChannel coprocessorService(byte[] row) {
        return this.table.coprocessorService(row);
    }

    public <T extends Service, R> Map<byte[], R> coprocessorService(Class<T> service, byte[] startKey, byte[] endKey, Batch.Call<T, R> callable) throws ServiceException, Throwable {
        return this.table.coprocessorService(service, startKey, endKey, callable);
    }

    public <T extends Service, R> void coprocessorService(Class<T> service, byte[] startKey, byte[] endKey, Batch.Call<T, R> callable, Batch.Callback<R> callback) throws ServiceException, Throwable {
        this.table.coprocessorService(service, startKey, endKey, callable, callback);
    }

    public void mutateRow(RowMutations rm) throws IOException {
        this.table.mutateRow(rm);
    }

    public void setAutoFlush(boolean autoFlush) {
        this.table.setAutoFlush(autoFlush, autoFlush);
    }

    public void setAutoFlush(boolean autoFlush, boolean clearBufferOnFail) {
        this.table.setAutoFlush(autoFlush, clearBufferOnFail);
    }

    public void setAutoFlushTo(boolean autoFlush) {
        this.table.setAutoFlushTo(autoFlush);
    }

    public long getWriteBufferSize() {
        return this.table.getWriteBufferSize();
    }

    public void setWriteBufferSize(long writeBufferSize) throws IOException {
        this.table.setWriteBufferSize(writeBufferSize);
    }

    public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount, boolean writeToWAL) throws IOException {
        return this.table.incrementColumnValue(row, family, qualifier, amount, writeToWAL);
    }
}

