/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.snapshot;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.errorhandling.ForeignExceptionListener;
import org.apache.hadoop.hbase.errorhandling.TimeoutExceptionInjector;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.wal.HLogUtil;
import org.apache.hadoop.hbase.snapshot.CorruptedSnapshotException;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.util.FSUtils;

public class TakeSnapshotUtils {
    private static final Log LOG = LogFactory.getLog(TakeSnapshotUtils.class);

    private TakeSnapshotUtils() {
    }

    public static Path getRegionSnapshotDirectory(HBaseProtos.SnapshotDescription desc, Path rootDir, String regionName) {
        Path snapshotDir = SnapshotDescriptionUtils.getWorkingSnapshotDir(desc, rootDir);
        return HRegion.getRegionDir(snapshotDir, regionName);
    }

    public static List<Path> getFamilySnapshotDirectories(HBaseProtos.SnapshotDescription snapshot, Path snapshotRegionDir, FileStatus[] families) {
        if (families == null || families.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Path> familyDirs = new ArrayList<Path>(families.length);
        for (FileStatus family : families) {
            familyDirs.add(new Path(snapshotRegionDir, family.getPath().getName()));
        }
        return familyDirs;
    }

    public static TimeoutExceptionInjector getMasterTimerAndBindToMonitor(HBaseProtos.SnapshotDescription snapshot, Configuration conf, ForeignExceptionListener monitor) {
        long maxTime = SnapshotDescriptionUtils.getMaxMasterTimeout(conf, snapshot.getType(), 60000L);
        return new TimeoutExceptionInjector(monitor, maxTime);
    }

    public static void verifyAllLogsGotReferenced(FileSystem fs, Path logsDir, Set<String> serverNames, HBaseProtos.SnapshotDescription snapshot, Path snapshotLogDir) throws IOException {
        TakeSnapshotUtils.assertTrue(snapshot, "Logs directory doesn't exist in snapshot", fs.exists(logsDir));
        Multimap<String, String> snapshotLogs = TakeSnapshotUtils.getMapOfServersAndLogs(fs, snapshotLogDir, serverNames);
        Multimap<String, String> realLogs = TakeSnapshotUtils.getMapOfServersAndLogs(fs, logsDir, serverNames);
        if (realLogs != null) {
            TakeSnapshotUtils.assertNotNull(snapshot, "No server logs added to snapshot", snapshotLogs);
        } else {
            TakeSnapshotUtils.assertNull(snapshot, "Snapshotted server logs that don't exist", snapshotLogs);
        }
        Set serverEntries = realLogs.asMap().entrySet();
        Set snapshotEntries = snapshotLogs.asMap().entrySet();
        TakeSnapshotUtils.assertEquals(snapshot, "Not the same number of snapshot and original server logs directories", serverEntries.size(), snapshotEntries.size());
        for (Map.Entry serverLogs : serverEntries) {
            if (!serverNames.contains(serverLogs.getKey())) continue;
            Collection snapshotServerLogs = snapshotLogs.get(serverLogs.getKey());
            TakeSnapshotUtils.assertNotNull(snapshot, "Snapshots missing logs for server:" + (String)serverLogs.getKey(), snapshotServerLogs);
            TakeSnapshotUtils.assertEquals(snapshot, "Didn't reference all the log files for server:" + (String)serverLogs.getKey(), ((Collection)serverLogs.getValue()).size(), snapshotServerLogs.size());
            for (String log : (Collection)serverLogs.getValue()) {
                TakeSnapshotUtils.assertTrue(snapshot, "Snapshot logs didn't include " + log, snapshotServerLogs.contains(log));
            }
        }
    }

    public static void verifyRecoveredEdits(FileSystem fs, Path rootDir, HRegionInfo regionInfo, HBaseProtos.SnapshotDescription snapshot) throws IOException {
        Path regionDir = HRegion.getRegionDir(rootDir, regionInfo);
        Path editsDir = HLogUtil.getRegionDirRecoveredEditsDir(regionDir);
        Path snapshotRegionDir = TakeSnapshotUtils.getRegionSnapshotDirectory(snapshot, rootDir, regionInfo.getEncodedName());
        Path snapshotEditsDir = HLogUtil.getRegionDirRecoveredEditsDir(snapshotRegionDir);
        FileStatus[] edits = FSUtils.listStatus(fs, editsDir);
        FileStatus[] snapshotEdits = FSUtils.listStatus(fs, snapshotEditsDir);
        if (edits == null) {
            TakeSnapshotUtils.assertNull(snapshot, "Snapshot has edits but table doesn't", snapshotEdits);
            return;
        }
        TakeSnapshotUtils.assertNotNull(snapshot, "Table has edits, but snapshot doesn't", snapshotEdits);
        TakeSnapshotUtils.assertEquals(snapshot, "Not same number of edits in snapshot as table", edits.length, snapshotEdits.length);
        for (FileStatus edit : edits) {
            for (FileStatus sEdit : snapshotEdits) {
                if (!sEdit.getPath().equals((Object)edit.getPath())) continue;
                TakeSnapshotUtils.assertEquals(snapshot, "Snapshot file" + sEdit.getPath() + " length not equal to the original: " + edit.getPath(), edit.getLen(), sEdit.getLen());
                break;
            }
            TakeSnapshotUtils.assertTrue(snapshot, "No edit in snapshot with name:" + edit.getPath(), false);
        }
    }

    private static void assertNull(HBaseProtos.SnapshotDescription snapshot, String msg, Object isNull) throws CorruptedSnapshotException {
        if (isNull != null) {
            throw new CorruptedSnapshotException(msg + ", Expected " + isNull + " to be null.", snapshot);
        }
    }

    private static void assertNotNull(HBaseProtos.SnapshotDescription snapshot, String msg, Object notNull) throws CorruptedSnapshotException {
        if (notNull == null) {
            throw new CorruptedSnapshotException(msg + ", Expected object to not be null, but was null.", snapshot);
        }
    }

    private static void assertTrue(HBaseProtos.SnapshotDescription snapshot, String msg, boolean isTrue) throws CorruptedSnapshotException {
        if (!isTrue) {
            throw new CorruptedSnapshotException(msg + ", Expected true, but was false", snapshot);
        }
    }

    private static void assertEquals(HBaseProtos.SnapshotDescription snapshot, String msg, int expected, int gotten) throws CorruptedSnapshotException {
        if (expected != gotten) {
            throw new CorruptedSnapshotException(msg + ". Expected:" + expected + ", got:" + gotten, snapshot);
        }
    }

    private static void assertEquals(HBaseProtos.SnapshotDescription snapshot, String msg, long expected, long gotten) throws CorruptedSnapshotException {
        if (expected != gotten) {
            throw new CorruptedSnapshotException(msg + ". Expected:" + expected + ", got:" + gotten, snapshot);
        }
    }

    private static Multimap<String, String> getMapOfServersAndLogs(FileSystem fs, Path logdir, Collection<String> toInclude) throws IOException {
        MatchesDirectoryNames filter = toInclude == null || toInclude.size() == 0 ? null : new MatchesDirectoryNames(toInclude);
        FileStatus[] serverLogDirs = FSUtils.listStatus(fs, logdir, filter);
        if (serverLogDirs == null) {
            return null;
        }
        HashMultimap map = HashMultimap.create();
        for (FileStatus server : serverLogDirs) {
            FileStatus[] serverLogs = FSUtils.listStatus(fs, server.getPath(), null);
            if (serverLogs == null) continue;
            for (FileStatus log : serverLogs) {
                map.put((Object)server.getPath().getName(), (Object)log.getPath().getName());
            }
        }
        return map;
    }

    public static Path getSnapshotHLogsDir(Path snapshotDir, String serverName) {
        return new Path(snapshotDir, HLogUtil.getHLogDirectoryName(serverName));
    }

    private static class MatchesDirectoryNames
    implements PathFilter {
        Collection<String> paths;

        public MatchesDirectoryNames(Collection<String> dirNames) {
            this.paths = dirNames;
        }

        public boolean accept(Path path) {
            return this.paths.contains(path.getName());
        }
    }
}

