/*
 * Decompiled with CFR 0.152.
 */
package parquet.column.impl;

import java.io.IOException;
import parquet.Log;
import parquet.bytes.BytesInput;
import parquet.bytes.BytesUtils;
import parquet.column.ColumnDescriptor;
import parquet.column.ColumnWriter;
import parquet.column.page.DictionaryPage;
import parquet.column.page.PageWriter;
import parquet.column.values.ValuesWriter;
import parquet.column.values.boundedint.DevNullValuesWriter;
import parquet.column.values.dictionary.DictionaryValuesWriter;
import parquet.column.values.plain.BooleanPlainValuesWriter;
import parquet.column.values.plain.FixedLenByteArrayPlainValuesWriter;
import parquet.column.values.plain.PlainValuesWriter;
import parquet.column.values.rle.RunLengthBitPackingHybridValuesWriter;
import parquet.io.ParquetEncodingException;
import parquet.io.api.Binary;

final class ColumnWriterImpl
implements ColumnWriter {
    private static final Log LOG = Log.getLog(ColumnWriterImpl.class);
    private static final boolean DEBUG = Log.DEBUG;
    private static final int INITIAL_COUNT_FOR_SIZE_CHECK = 100;
    private final ColumnDescriptor path;
    private final PageWriter pageWriter;
    private final long pageSizeThreshold;
    private ValuesWriter repetitionLevelColumn;
    private ValuesWriter definitionLevelColumn;
    private ValuesWriter dataColumn;
    private int valueCount;
    private int valueCountForNextSizeCheck;

    public ColumnWriterImpl(ColumnDescriptor path, PageWriter pageWriter, int pageSizeThreshold, int initialSizePerCol, int dictionaryPageSizeThreshold, boolean enableDictionary) {
        this.path = path;
        this.pageWriter = pageWriter;
        this.pageSizeThreshold = pageSizeThreshold;
        this.valueCountForNextSizeCheck = 100;
        this.repetitionLevelColumn = this.getColumnDescriptorValuesWriter(path.getMaxRepetitionLevel());
        this.definitionLevelColumn = this.getColumnDescriptorValuesWriter(path.getMaxDefinitionLevel());
        if (enableDictionary) {
            switch (path.getType()) {
                case BOOLEAN: {
                    this.dataColumn = new BooleanPlainValuesWriter();
                    break;
                }
                case BINARY: {
                    this.dataColumn = new DictionaryValuesWriter.PlainBinaryDictionaryValuesWriter(dictionaryPageSizeThreshold, initialSizePerCol);
                    break;
                }
                case INT64: {
                    this.dataColumn = new DictionaryValuesWriter.PlainLongDictionaryValuesWriter(dictionaryPageSizeThreshold, initialSizePerCol);
                    break;
                }
                case DOUBLE: {
                    this.dataColumn = new DictionaryValuesWriter.PlainDoubleDictionaryValuesWriter(dictionaryPageSizeThreshold, initialSizePerCol);
                    break;
                }
                case INT32: {
                    this.dataColumn = new DictionaryValuesWriter.PlainIntegerDictionaryValuesWriter(dictionaryPageSizeThreshold, initialSizePerCol);
                    break;
                }
                case FLOAT: {
                    this.dataColumn = new DictionaryValuesWriter.PlainFloatDictionaryValuesWriter(dictionaryPageSizeThreshold, initialSizePerCol);
                    break;
                }
                case INT96: {
                    this.dataColumn = new DictionaryValuesWriter.PlainFixedLenArrayDictionaryValuesWriter(dictionaryPageSizeThreshold, initialSizePerCol, 12);
                    break;
                }
                case FIXED_LEN_BYTE_ARRAY: {
                    this.dataColumn = new DictionaryValuesWriter.PlainFixedLenArrayDictionaryValuesWriter(dictionaryPageSizeThreshold, initialSizePerCol, path.getTypeLength());
                    break;
                }
                default: {
                    this.dataColumn = new PlainValuesWriter(initialSizePerCol);
                    break;
                }
            }
        } else {
            switch (path.getType()) {
                case BOOLEAN: {
                    this.dataColumn = new BooleanPlainValuesWriter();
                    break;
                }
                case FIXED_LEN_BYTE_ARRAY: {
                    this.dataColumn = new FixedLenByteArrayPlainValuesWriter(path.getTypeLength(), initialSizePerCol);
                    break;
                }
                case INT96: {
                    this.dataColumn = new FixedLenByteArrayPlainValuesWriter(12, initialSizePerCol);
                    break;
                }
                default: {
                    this.dataColumn = new PlainValuesWriter(initialSizePerCol);
                }
            }
        }
    }

    private ValuesWriter getColumnDescriptorValuesWriter(int maxLevel) {
        if (maxLevel == 0) {
            return new DevNullValuesWriter();
        }
        return new RunLengthBitPackingHybridValuesWriter(BytesUtils.getWidthFromMaxInt(maxLevel), 65536);
    }

    private void log(Object value, int r, int d) {
        LOG.debug(this.path + " " + value + " r:" + r + " d:" + d);
    }

    private void accountForValueWritten() {
        ++this.valueCount;
        if (this.valueCount > this.valueCountForNextSizeCheck) {
            long memSize = this.repetitionLevelColumn.getBufferedSize() + this.definitionLevelColumn.getBufferedSize() + this.dataColumn.getBufferedSize();
            if (memSize > this.pageSizeThreshold) {
                this.valueCountForNextSizeCheck = this.valueCount / 2;
                this.writePage();
            } else {
                this.valueCountForNextSizeCheck = (int)((float)this.valueCount + (float)this.valueCount * (float)this.pageSizeThreshold / (float)memSize) / 2 + 1;
            }
        }
    }

    private void writePage() {
        if (DEBUG) {
            LOG.debug("write page");
        }
        try {
            this.pageWriter.writePage(BytesInput.concat(this.repetitionLevelColumn.getBytes(), this.definitionLevelColumn.getBytes(), this.dataColumn.getBytes()), this.valueCount, this.repetitionLevelColumn.getEncoding(), this.definitionLevelColumn.getEncoding(), this.dataColumn.getEncoding());
        }
        catch (IOException e) {
            throw new ParquetEncodingException("could not write page for " + this.path, e);
        }
        this.repetitionLevelColumn.reset();
        this.definitionLevelColumn.reset();
        this.dataColumn.reset();
        this.valueCount = 0;
    }

    @Override
    public void writeNull(int repetitionLevel, int definitionLevel) {
        if (DEBUG) {
            this.log(null, repetitionLevel, definitionLevel);
        }
        this.repetitionLevelColumn.writeInteger(repetitionLevel);
        this.definitionLevelColumn.writeInteger(definitionLevel);
        this.accountForValueWritten();
    }

    @Override
    public void write(double value, int repetitionLevel, int definitionLevel) {
        if (DEBUG) {
            this.log(value, repetitionLevel, definitionLevel);
        }
        this.repetitionLevelColumn.writeInteger(repetitionLevel);
        this.definitionLevelColumn.writeInteger(definitionLevel);
        this.dataColumn.writeDouble(value);
        this.accountForValueWritten();
    }

    @Override
    public void write(float value, int repetitionLevel, int definitionLevel) {
        if (DEBUG) {
            this.log(Float.valueOf(value), repetitionLevel, definitionLevel);
        }
        this.repetitionLevelColumn.writeInteger(repetitionLevel);
        this.definitionLevelColumn.writeInteger(definitionLevel);
        this.dataColumn.writeFloat(value);
        this.accountForValueWritten();
    }

    @Override
    public void write(Binary value, int repetitionLevel, int definitionLevel) {
        if (DEBUG) {
            this.log(value, repetitionLevel, definitionLevel);
        }
        this.repetitionLevelColumn.writeInteger(repetitionLevel);
        this.definitionLevelColumn.writeInteger(definitionLevel);
        this.dataColumn.writeBytes(value);
        this.accountForValueWritten();
    }

    @Override
    public void write(boolean value, int repetitionLevel, int definitionLevel) {
        if (DEBUG) {
            this.log(value, repetitionLevel, definitionLevel);
        }
        this.repetitionLevelColumn.writeInteger(repetitionLevel);
        this.definitionLevelColumn.writeInteger(definitionLevel);
        this.dataColumn.writeBoolean(value);
        this.accountForValueWritten();
    }

    @Override
    public void write(int value, int repetitionLevel, int definitionLevel) {
        if (DEBUG) {
            this.log(value, repetitionLevel, definitionLevel);
        }
        this.repetitionLevelColumn.writeInteger(repetitionLevel);
        this.definitionLevelColumn.writeInteger(definitionLevel);
        this.dataColumn.writeInteger(value);
        this.accountForValueWritten();
    }

    @Override
    public void write(long value, int repetitionLevel, int definitionLevel) {
        if (DEBUG) {
            this.log(value, repetitionLevel, definitionLevel);
        }
        this.repetitionLevelColumn.writeInteger(repetitionLevel);
        this.definitionLevelColumn.writeInteger(definitionLevel);
        this.dataColumn.writeLong(value);
        this.accountForValueWritten();
    }

    @Override
    public void flush() {
        DictionaryPage dictionaryPage;
        if (this.valueCount > 0) {
            this.writePage();
        }
        if ((dictionaryPage = this.dataColumn.createDictionaryPage()) != null) {
            if (DEBUG) {
                LOG.debug("write dictionary");
            }
            try {
                this.pageWriter.writeDictionaryPage(dictionaryPage);
            }
            catch (IOException e) {
                throw new ParquetEncodingException("could not write dictionary page for " + this.path, e);
            }
            this.dataColumn.resetDictionary();
        }
    }

    @Override
    public long getBufferedSizeInMemory() {
        return this.repetitionLevelColumn.getBufferedSize() + this.definitionLevelColumn.getBufferedSize() + this.dataColumn.getBufferedSize() + this.pageWriter.getMemSize();
    }

    public long allocatedSize() {
        return this.repetitionLevelColumn.getAllocatedSize() + this.definitionLevelColumn.getAllocatedSize() + this.dataColumn.getAllocatedSize() + this.pageWriter.allocatedSize();
    }

    public String memUsageString(String indent) {
        StringBuilder b = new StringBuilder(indent).append(this.path).append(" {\n");
        b.append(this.repetitionLevelColumn.memUsageString(indent + "  r:")).append("\n");
        b.append(this.definitionLevelColumn.memUsageString(indent + "  d:")).append("\n");
        b.append(this.dataColumn.memUsageString(indent + "  data:")).append("\n");
        b.append(this.pageWriter.memUsageString(indent + "  pages:")).append("\n");
        b.append(indent).append(String.format("  total: %,d/%,d", this.getBufferedSizeInMemory(), this.allocatedSize())).append("\n");
        b.append(indent).append("}\n");
        return b.toString();
    }
}

