/*
 * Decompiled with CFR 0.152.
 */
package parquet.column.page;

import parquet.Log;
import parquet.bytes.BytesInput;
import parquet.column.Encoding;

public class Page {
    private static final boolean DEBUG = Log.DEBUG;
    private static final Log LOG = Log.getLog(Page.class);
    private static int nextId = 0;
    private final BytesInput bytes;
    private final int valueCount;
    private final int uncompressedSize;
    private final Encoding rlEncoding;
    private final Encoding dlEncoding;
    private final Encoding valuesEncoding;
    private final int id;

    public Page(BytesInput bytes, int valueCount, int uncompressedSize, Encoding rlEncoding, Encoding dlEncoding, Encoding valuesEncoding) {
        this.bytes = bytes;
        this.valueCount = valueCount;
        this.uncompressedSize = uncompressedSize;
        this.rlEncoding = rlEncoding;
        this.dlEncoding = dlEncoding;
        this.valuesEncoding = valuesEncoding;
        this.id = nextId++;
        if (DEBUG) {
            LOG.debug("new Page #" + this.id + " : " + bytes.size() + " bytes and " + valueCount + " records");
        }
    }

    public BytesInput getBytes() {
        return this.bytes;
    }

    public int getValueCount() {
        return this.valueCount;
    }

    public int getUncompressedSize() {
        return this.uncompressedSize;
    }

    public Encoding getDlEncoding() {
        return this.dlEncoding;
    }

    public Encoding getRlEncoding() {
        return this.rlEncoding;
    }

    public Encoding getValueEncoding() {
        return this.valuesEncoding;
    }

    public String toString() {
        return "Page [id: " + this.id + ", bytes.size=" + this.bytes.size() + ", valueCount=" + this.valueCount + ", uncompressedSize=" + this.uncompressedSize + "]";
    }
}

