/*
 * Decompiled with CFR 0.152.
 */
package parquet.column.values.plain;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import parquet.Log;
import parquet.bytes.LittleEndianDataInputStream;
import parquet.column.values.ValuesReader;
import parquet.io.ParquetDecodingException;

public abstract class PlainValuesReader
extends ValuesReader {
    private static final Log LOG = Log.getLog(PlainValuesReader.class);
    protected LittleEndianDataInputStream in;

    @Override
    public int initFromPage(long valueCount, byte[] in, int offset) throws IOException {
        if (Log.DEBUG) {
            LOG.debug("init from page at offset " + offset + " for length " + (in.length - offset));
        }
        this.in = new LittleEndianDataInputStream(new ByteArrayInputStream(in, offset, in.length - offset));
        return in.length;
    }

    public static class LongPlainValuesReader
    extends PlainValuesReader {
        @Override
        public void skip() {
            try {
                this.in.skipBytes(8);
            }
            catch (IOException e) {
                throw new ParquetDecodingException("could not skip long", e);
            }
        }

        @Override
        public long readLong() {
            try {
                return this.in.readLong();
            }
            catch (IOException e) {
                throw new ParquetDecodingException("could not read long", e);
            }
        }
    }

    public static class IntegerPlainValuesReader
    extends PlainValuesReader {
        @Override
        public void skip() {
            try {
                this.in.skipBytes(4);
            }
            catch (IOException e) {
                throw new ParquetDecodingException("could not skip int", e);
            }
        }

        @Override
        public int readInteger() {
            try {
                return this.in.readInt();
            }
            catch (IOException e) {
                throw new ParquetDecodingException("could not read int", e);
            }
        }
    }

    public static class FloatPlainValuesReader
    extends PlainValuesReader {
        @Override
        public void skip() {
            try {
                this.in.skipBytes(4);
            }
            catch (IOException e) {
                throw new ParquetDecodingException("could not skip float", e);
            }
        }

        @Override
        public float readFloat() {
            try {
                return this.in.readFloat();
            }
            catch (IOException e) {
                throw new ParquetDecodingException("could not read float", e);
            }
        }
    }

    public static class DoublePlainValuesReader
    extends PlainValuesReader {
        @Override
        public void skip() {
            try {
                this.in.skipBytes(8);
            }
            catch (IOException e) {
                throw new ParquetDecodingException("could not skip double", e);
            }
        }

        @Override
        public double readDouble() {
            try {
                return this.in.readDouble();
            }
            catch (IOException e) {
                throw new ParquetDecodingException("could not read double", e);
            }
        }
    }
}

