/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.FaultInjection;
import org.apache.oozie.XException;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.PreconditionException;
import org.apache.oozie.lock.LockToken;
import org.apache.oozie.service.CallableQueueService;
import org.apache.oozie.service.EventHandlerService;
import org.apache.oozie.service.InstrumentationService;
import org.apache.oozie.service.MemoryLocksService;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.Instrumentation;
import org.apache.oozie.util.XCallable;
import org.apache.oozie.util.XLog;

public abstract class XCommand<T>
implements XCallable<T> {
    public static final String DEFAULT_LOCK_TIMEOUT = "oozie.command.default.lock.timeout";
    public static final String INSTRUMENTATION_GROUP = "commands";
    public static final Long DEFAULT_REQUEUE_DELAY = 10L;
    public XLog LOG = XLog.getLog(this.getClass());
    private String key;
    private String name;
    private int priority;
    private String type;
    private long createdTime;
    private LockToken lock;
    private AtomicBoolean used = new AtomicBoolean(false);
    private boolean inInterrupt = false;
    private boolean isSynchronous = false;
    private Map<Long, List<XCommand<?>>> commandQueue;
    protected boolean dryrun = false;
    protected Instrumentation instrumentation;
    protected XLog.Info logInfo;
    protected static EventHandlerService eventService;

    public XCommand(String name, String type, int priority) {
        this.name = name;
        this.type = type;
        this.priority = priority;
        this.key = name + "_" + UUID.randomUUID();
        this.createdTime = System.currentTimeMillis();
        this.logInfo = new XLog.Info();
        this.instrumentation = Services.get().get(InstrumentationService.class).get();
        eventService = Services.get().get(EventHandlerService.class);
    }

    public XCommand(String name, String type, int priority, boolean dryrun) {
        this(name, type, priority);
        this.dryrun = dryrun;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public long getCreatedTime() {
        return this.createdTime;
    }

    protected void queue(XCommand<?> command) {
        this.queue(command, 0L);
    }

    protected void queue(XCommand<?> command, long msDelay) {
        List<XCommand<?>> list;
        if (this.commandQueue == null) {
            this.commandQueue = new HashMap();
        }
        if ((list = this.commandQueue.get(msDelay)) == null) {
            list = new ArrayList();
            this.commandQueue.put(msDelay, list);
        }
        list.add(command);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void acquireLock() throws InterruptedException, CommandException {
        if (this.getEntityKey() == null) {
            return;
        }
        this.lock = Services.get().get(MemoryLocksService.class).getWriteLock(this.getEntityKey(), this.getLockTimeOut());
        if (this.lock == null) {
            Instrumentation instrumentation = Services.get().get(InstrumentationService.class).get();
            instrumentation.incr(INSTRUMENTATION_GROUP, this.getName() + ".lockTimeOut", 1L);
            if (!this.isReQueueRequired()) throw new CommandException(ErrorCode.E0606, this.toString(), this.getLockTimeOut());
            this.queue(this, this.getRequeueDelay());
            this.LOG.debug("Could not get lock [{0}], timed out [{1}]ms, and requeue itself [{2}]", this.toString(), this.getLockTimeOut(), this.getName());
            return;
        } else {
            this.LOG.debug("Acquired lock for [{0}] in [{1}]", this.getEntityKey(), this.getName());
        }
    }

    private void releaseLock() {
        if (this.lock != null) {
            this.lock.release();
            this.LOG.debug("Released lock for [{0}] in [{1}]", this.getEntityKey(), this.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public final T call() throws CommandException {
        if (CallableQueueService.INTERRUPT_TYPES.contains(this.getType()) && this.used.get()) {
            this.LOG.debug("Command [{0}] key [{1}]  already used for [{2}]", new Object[]{this.getName(), this.getEntityKey(), this.toString()});
            return null;
        }
        this.commandQueue = null;
        instrumentation = Services.get().get(InstrumentationService.class).get();
        instrumentation.incr("commands", this.getName() + ".executions", 1L);
        callCron = new Instrumentation.Cron();
        try {
            block24: {
                block22: {
                    block23: {
                        callCron.start();
                        if (!this.isSynchronous) {
                            this.eagerLoadState();
                            this.LOG = XLog.resetPrefix(this.LOG);
                            this.eagerVerifyPrecondition();
                        }
                        ret = null;
                        if (!this.isSynchronous && this.isLockRequired() && !this.inInterruptMode()) {
                            acquireLockCron = new Instrumentation.Cron();
                            acquireLockCron.start();
                            this.acquireLock();
                            acquireLockCron.stop();
                            instrumentation.addCron("commands", this.getName() + ".acquireLock", acquireLockCron);
                        }
                        if (this.lock != null) {
                            this.executeInterrupts();
                        }
                        if (!this.isSynchronous && this.isLockRequired() && this.lock == null && !this.inInterruptMode()) ** GOTO lbl45
                        if (!CallableQueueService.INTERRUPT_TYPES.contains(this.getType()) || this.used.compareAndSet(false, true)) break block22;
                        this.LOG.debug("Command [{0}] key [{1}]  already executed for [{2}]", new Object[]{this.getName(), this.getEntityKey(), this.toString()});
                        acquireLockCron = null;
                        if (this.isSynchronous || !this.isLockRequired() || this.inInterruptMode()) break block23;
                        this.releaseLock();
                    }
                    return (T)acquireLockCron;
                }
                try {
                    this.LOG.trace("Load state for [{0}]", new Object[]{this.getEntityKey()});
                    this.loadState();
                    this.LOG = XLog.resetPrefix(this.LOG);
                    this.LOG.trace("Precondition check for command [{0}] key [{1}]", new Object[]{this.getName(), this.getEntityKey()});
                    this.verifyPrecondition();
                    this.LOG.debug("Execute command [{0}] key [{1}]", new Object[]{this.getName(), this.getEntityKey()});
                    executeCron = new Instrumentation.Cron();
                    executeCron.start();
                    ret = this.execute();
                    executeCron.stop();
                    instrumentation.addCron("commands", this.getName() + ".execute", executeCron);
lbl45:
                    // 2 sources

                    if (this.commandQueue != null) {
                        callableQueueService = Services.get().get(CallableQueueService.class);
                        for (Map.Entry<Long, List<XCommand<?>>> entry : this.commandQueue.entrySet()) {
                            this.LOG.debug("Queuing [{0}] commands with delay [{1}]ms", new Object[]{entry.getValue().size(), entry.getKey()});
                            if (callableQueueService.queueSerial(entry.getValue(), entry.getKey())) continue;
                            this.LOG.warn("Could not queue [{0}] commands with delay [{1}]ms, queue full", new Object[]{entry.getValue().size(), entry.getKey()});
                        }
                    }
                    var4_8 = ret;
                    if (this.isSynchronous || !this.isLockRequired() || this.inInterruptMode()) break block24;
                    this.releaseLock();
                }
                catch (Throwable var7_11) {
                    try {
                        if (!this.isSynchronous && this.isLockRequired() && !this.inInterruptMode()) {
                            this.releaseLock();
                        }
                        throw var7_11;
                    }
                    catch (PreconditionException pex) {
                        this.LOG.warn(pex.getMessage().toString() + ", Error Code: " + pex.getErrorCode().toString());
                        instrumentation.incr("commands", this.getName() + ".preconditionfailed", 1L);
                        var4_8 = null;
                        return var4_8;
                    }
                    catch (XException ex) {
                        this.LOG.error((Object)"XException, ", ex);
                        instrumentation.incr("commands", this.getName() + ".xexceptions", 1L);
                        if (ex instanceof CommandException) {
                            throw (CommandException)ex;
                        }
                        throw new CommandException(ex);
                    }
                    catch (Exception ex) {
                        this.LOG.error((Object)"Exception, ", ex);
                        instrumentation.incr("commands", this.getName() + ".exceptions", 1L);
                        throw new CommandException(ErrorCode.E0607, new Object[]{this.getName(), ex.getMessage(), ex});
                    }
                    catch (Error er) {
                        this.LOG.error((Object)"Error, ", er);
                        throw er;
                    }
                }
            }
            return var4_8;
        }
        finally {
            FaultInjection.deactivate("org.apache.oozie.command.SkipCommitFaultInjection");
            callCron.stop();
            instrumentation.addCron("commands", this.getName() + ".call", callCron);
        }
    }

    public final T call(String callerEntityKey) throws CommandException {
        if (!callerEntityKey.equals(this.getEntityKey())) {
            throw new CommandException(ErrorCode.E0607, "Entity Keys mismatch during synchronous call", "caller=" + callerEntityKey + ", callee=" + this.getEntityKey());
        }
        this.isSynchronous = true;
        this.LOG.trace("Executing synchronously command [{0}] on job [{1}]", this.getName(), this.getKey());
        return this.call();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeInterrupts() {
        CallableQueueService callableQueueService = Services.get().get(CallableQueueService.class);
        Set<XCallable<?>> callables = callableQueueService.checkInterrupts(this.getEntityKey());
        if (callables != null) {
            for (XCallable<?> callable : callables) {
                this.LOG.trace("executing interrupt callable [{0}]", callable.getName());
                try {
                    callable.setInterruptMode(true);
                    callable.call();
                    this.LOG.trace("executed interrupt callable [{0}]", callable.getName());
                }
                catch (Exception ex) {
                    this.LOG.warn("exception interrupt callable [{0}], {1}", callable.getName(), ex.getMessage(), ex);
                }
                finally {
                    callable.setInterruptMode(false);
                }
            }
        }
    }

    protected long getLockTimeOut() {
        return Services.get().getConf().getLong(DEFAULT_LOCK_TIMEOUT, 5000L);
    }

    protected abstract boolean isLockRequired();

    @Override
    public abstract String getEntityKey();

    protected boolean isReQueueRequired() {
        return true;
    }

    protected void eagerLoadState() throws CommandException {
    }

    protected void eagerVerifyPrecondition() throws CommandException, PreconditionException {
    }

    protected abstract void loadState() throws CommandException;

    protected abstract void verifyPrecondition() throws CommandException, PreconditionException;

    protected abstract T execute() throws CommandException;

    protected Instrumentation getInstrumentation() {
        return this.instrumentation;
    }

    public void resetUsed() {
        this.used.set(false);
    }

    protected Long getRequeueDelay() {
        return DEFAULT_REQUEUE_DELAY;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public void setInterruptMode(boolean mode) {
        this.inInterrupt = mode;
    }

    @Override
    public boolean inInterruptMode() {
        return this.inInterrupt;
    }

    public XLog getLog() {
        return this.LOG;
    }

    public String toString() {
        return this.getKey();
    }
}

