/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.bundle;

import java.util.Date;
import java.util.List;
import org.apache.oozie.BundleActionBean;
import org.apache.oozie.BundleJobBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.client.Job;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.PreconditionException;
import org.apache.oozie.command.SuspendTransitionXCommand;
import org.apache.oozie.command.coord.CoordSuspendXCommand;
import org.apache.oozie.executor.jpa.BatchQueryExecutor;
import org.apache.oozie.executor.jpa.BundleActionQueryExecutor;
import org.apache.oozie.executor.jpa.BundleJobQueryExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.util.InstrumentUtils;
import org.apache.oozie.util.LogUtils;
import org.apache.oozie.util.ParamChecker;

public class BundleJobSuspendXCommand
extends SuspendTransitionXCommand {
    private final String jobId;
    private List<BundleActionBean> bundleActions;
    private BundleJobBean bundleJob;

    public BundleJobSuspendXCommand(String id) {
        super("bundle_suspend", "bundle_suspend", 1);
        this.jobId = ParamChecker.notEmpty(id, "id");
    }

    @Override
    public Job getJob() {
        return this.bundleJob;
    }

    @Override
    public void notifyParent() throws CommandException {
    }

    @Override
    public void setJob(Job job) {
    }

    @Override
    public void performWrites() throws CommandException {
        try {
            BatchQueryExecutor.getInstance().executeBatchInsertUpdateDelete(null, this.updateList, null);
        }
        catch (JPAExecutorException e) {
            throw new CommandException(e);
        }
    }

    @Override
    public String getEntityKey() {
        return this.jobId;
    }

    @Override
    protected boolean isLockRequired() {
        return true;
    }

    @Override
    protected void loadState() throws CommandException {
        try {
            this.bundleJob = BundleJobQueryExecutor.getInstance().get(BundleJobQueryExecutor.BundleJobQuery.GET_BUNDLE_JOB, this.jobId);
        }
        catch (Exception Ex) {
            throw new CommandException(ErrorCode.E0604, this.jobId);
        }
        try {
            this.bundleActions = BundleActionQueryExecutor.getInstance().getList(BundleActionQueryExecutor.BundleActionQuery.GET_BUNDLE_ACTIONS_FOR_BUNDLE, this.bundleJob.getId());
        }
        catch (Exception Ex) {
            throw new CommandException(ErrorCode.E1311, this.jobId);
        }
        LogUtils.setLogInfo(this.bundleJob, this.logInfo);
    }

    @Override
    protected void verifyPrecondition() throws CommandException, PreconditionException {
        if (this.bundleJob.getStatus() == Job.Status.SUCCEEDED || this.bundleJob.getStatus() == Job.Status.FAILED || this.bundleJob.getStatus() == Job.Status.KILLED || this.bundleJob.getStatus() == Job.Status.DONEWITHERROR) {
            this.LOG.info("BundleJobSuspendXCommand is not going to execute because job either succeeded, failed, killed, or donewitherror; id = " + this.jobId + ", status = " + this.bundleJob.getStatus());
            throw new PreconditionException(ErrorCode.E1312, this.jobId, this.bundleJob.getStatus().toString());
        }
    }

    @Override
    public void updateJob() {
        InstrumentUtils.incrJobCounter("bundle_suspend", 1, null);
        this.bundleJob.setSuspendedTime(new Date());
        this.bundleJob.setLastModifiedTime(new Date());
        this.LOG.debug("Suspend bundle job id = " + this.jobId + ", status = " + this.bundleJob.getStatus() + ", pending = " + this.bundleJob.isPending());
        this.updateList.add(new BatchQueryExecutor.UpdateEntry<BundleJobQueryExecutor.BundleJobQuery>(BundleJobQueryExecutor.BundleJobQuery.UPDATE_BUNDLE_JOB_STATUS_PENDING_SUSP_MOD_TIME, this.bundleJob));
    }

    @Override
    public void suspendChildren() throws CommandException {
        for (BundleActionBean action : this.bundleActions) {
            if (action.getStatus() != Job.Status.RUNNING && action.getStatus() != Job.Status.RUNNINGWITHERROR && action.getStatus() != Job.Status.PREP && action.getStatus() != Job.Status.PAUSED && action.getStatus() != Job.Status.PAUSEDWITHERROR) continue;
            if (action.getCoordId() != null) {
                this.queue(new CoordSuspendXCommand(action.getCoordId()));
                this.updateBundleAction(action);
                this.LOG.debug("Suspend bundle action = [{0}], new status = [{1}], pending = [{2}] and queue CoordSuspendXCommand for [{3}]", action.getBundleActionId(), action.getStatus(), action.getPending(), action.getCoordId());
                continue;
            }
            this.updateBundleAction(action);
            this.LOG.debug("Suspend bundle action = [{0}], new status = [{1}], pending = [{2}] and coord id is null", action.getBundleActionId(), action.getStatus(), action.getPending());
        }
        this.LOG.debug("Suspended bundle actions for the bundle=[{0}]", this.jobId);
    }

    private void updateBundleAction(BundleActionBean action) {
        if (action.getStatus() == Job.Status.PREP) {
            action.setStatus(Job.Status.PREPSUSPENDED);
        } else if (action.getStatus() == Job.Status.RUNNING) {
            action.setStatus(Job.Status.SUSPENDED);
        } else if (action.getStatus() == Job.Status.RUNNINGWITHERROR) {
            action.setStatus(Job.Status.SUSPENDEDWITHERROR);
        } else if (action.getStatus() == Job.Status.PAUSED) {
            action.setStatus(Job.Status.SUSPENDED);
        } else if (action.getStatus() == Job.Status.PAUSEDWITHERROR) {
            action.setStatus(Job.Status.SUSPENDEDWITHERROR);
        }
        action.incrementAndGetPending();
        action.setLastModifiedTime(new Date());
        this.updateList.add(new BatchQueryExecutor.UpdateEntry<BundleActionQueryExecutor.BundleActionQuery>(BundleActionQueryExecutor.BundleActionQuery.UPDATE_BUNDLE_ACTION_STATUS_PENDING_MODTIME, action));
    }
}

