/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.coord;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.XException;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.Job;
import org.apache.oozie.client.rest.JsonBean;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.PreconditionException;
import org.apache.oozie.command.bundle.BundleStatusUpdateXCommand;
import org.apache.oozie.command.coord.CoordinatorXCommand;
import org.apache.oozie.coord.TimeUnit;
import org.apache.oozie.executor.jpa.BatchQueryExecutor;
import org.apache.oozie.executor.jpa.CoordActionGetJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobGetActionByActionNumberJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobGetJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobQueryExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.executor.jpa.sla.SLARegistrationGetJPAExecutor;
import org.apache.oozie.executor.jpa.sla.SLASummaryGetJPAExecutor;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.sla.SLARegistrationBean;
import org.apache.oozie.sla.SLASummaryBean;
import org.apache.oozie.sla.service.SLAService;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.JobUtils;
import org.apache.oozie.util.LogUtils;
import org.apache.oozie.util.ParamChecker;
import org.apache.oozie.util.StatusUtils;

public class CoordChangeXCommand
extends CoordinatorXCommand<Void> {
    private final String jobId;
    private Date newEndTime = null;
    private Integer newConcurrency = null;
    private Date newPauseTime = null;
    private Date oldPauseTime = null;
    private boolean resetPauseTime = false;
    private CoordinatorJobBean coordJob;
    private JPAService jpaService = null;
    private Job.Status prevStatus;
    private List<BatchQueryExecutor.UpdateEntry> updateList = new ArrayList<BatchQueryExecutor.UpdateEntry>();
    private List<JsonBean> deleteList = new ArrayList<JsonBean>();
    private static final Set<String> ALLOWED_CHANGE_OPTIONS = new HashSet<String>();

    public CoordChangeXCommand(String id, String changeValue) throws CommandException {
        super("coord_change", "coord_change", 0);
        this.jobId = ParamChecker.notEmpty(id, "id");
        ParamChecker.notEmpty(changeValue, "value");
        this.validateChangeValue(changeValue);
    }

    private void validateChangeValue(String changeValue) throws CommandException {
        String value;
        Map<String, String> map = JobUtils.parseChangeValue(changeValue);
        if (map.size() > ALLOWED_CHANGE_OPTIONS.size()) {
            throw new CommandException(ErrorCode.E1015, changeValue, "must change endtime|concurrency|pausetime");
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = entry.getKey();
            String value2 = entry.getValue();
            if (!ALLOWED_CHANGE_OPTIONS.contains(key)) {
                throw new CommandException(ErrorCode.E1015, changeValue, "must change endtime|concurrency|pausetime");
            }
            if (key.equals("pausetime") || !value2.equalsIgnoreCase("")) continue;
            throw new CommandException(ErrorCode.E1015, changeValue, "value on " + key + " can not be empty");
        }
        if (map.containsKey("endtime")) {
            value = map.get("endtime");
            try {
                this.newEndTime = DateUtils.parseDateOozieTZ(value);
            }
            catch (Exception ex) {
                throw new CommandException(ErrorCode.E1015, value, "must be a valid date");
            }
        }
        if (map.containsKey("concurrency")) {
            value = map.get("concurrency");
            try {
                this.newConcurrency = Integer.parseInt(value);
            }
            catch (NumberFormatException ex) {
                throw new CommandException(ErrorCode.E1015, value, "must be a valid integer");
            }
        }
        if (map.containsKey("pausetime")) {
            value = map.get("pausetime");
            if (value.equals("")) {
                this.resetPauseTime = true;
            } else {
                try {
                    this.newPauseTime = DateUtils.parseDateOozieTZ(value);
                }
                catch (Exception ex) {
                    throw new CommandException(ErrorCode.E1015, value, "must be a valid date");
                }
            }
        }
    }

    private Date getLastActionTime() {
        if (this.coordJob.getLastActionTime() == null) {
            return null;
        }
        Calendar d = Calendar.getInstance(DateUtils.getTimeZone(this.coordJob.getTimeZone()));
        d.setTime(this.coordJob.getLastActionTime());
        TimeUnit timeUnit = TimeUnit.valueOf(this.coordJob.getTimeUnitStr());
        d.add(timeUnit.getCalendarUnit(), -Integer.valueOf(this.coordJob.getFrequency()).intValue());
        return d.getTime();
    }

    private void checkEndTime(CoordinatorJobBean coordJob, Date newEndTime) throws CommandException {
        Date startTime = coordJob.getStartTime();
        if (newEndTime.before(startTime)) {
            throw new CommandException(ErrorCode.E1015, newEndTime, "cannot be before coordinator job's start time [" + startTime + "]");
        }
        Date lastActionTime = this.getLastActionTime();
        if (lastActionTime != null && !newEndTime.after(lastActionTime)) {
            throw new CommandException(ErrorCode.E1015, newEndTime, "must be after coordinator job's last action time [" + lastActionTime + "]");
        }
    }

    private void checkPauseTime(CoordinatorJobBean coordJob, Date newPauseTime) throws CommandException {
        Date d = new Date();
        if (newPauseTime.before(d)) {
            throw new CommandException(ErrorCode.E1015, newPauseTime, "must be a non-past time");
        }
    }

    private void processLookaheadActions(CoordinatorJobBean coordJob, Date newPauseTime) throws CommandException {
        Date lastActionTime = coordJob.getLastActionTime();
        if (lastActionTime != null) {
            Calendar d = Calendar.getInstance(DateUtils.getTimeZone(coordJob.getTimeZone()));
            d.setTime(this.getLastActionTime());
            TimeUnit timeUnit = TimeUnit.valueOf(coordJob.getTimeUnitStr());
            int lastActionNumber = coordJob.getLastActionNumber();
            boolean hasChanged = false;
            while (!newPauseTime.after(d.getTime())) {
                this.deleteAction(lastActionNumber);
                d.add(timeUnit.getCalendarUnit(), -Integer.valueOf(coordJob.getFrequency()).intValue());
                --lastActionNumber;
                hasChanged = true;
            }
            if (hasChanged) {
                coordJob.setLastActionNumber(lastActionNumber);
                d.add(timeUnit.getCalendarUnit(), Integer.valueOf(coordJob.getFrequency()));
                Date d1 = d.getTime();
                coordJob.setLastActionTime(d1);
                coordJob.setNextMaterializedTime(d1);
                coordJob.resetDoneMaterialization();
            }
        }
    }

    private void deleteAction(int actionNum) throws CommandException {
        try {
            SLASummaryBean slaSummaryBean;
            SLARegistrationBean slaReg;
            String actionId = this.jpaService.execute(new CoordJobGetActionByActionNumberJPAExecutor(this.jobId, actionNum));
            CoordinatorActionBean bean = this.jpaService.execute(new CoordActionGetJPAExecutor(actionId));
            if (SLAService.isEnabled()) {
                Services.get().get(SLAService.class).removeRegistration(actionId);
            }
            if ((slaReg = this.jpaService.execute(new SLARegistrationGetJPAExecutor(actionId))) != null) {
                this.LOG.debug("Deleting registration bean corresponding to action " + slaReg.getId());
                this.deleteList.add(slaReg);
            }
            if ((slaSummaryBean = this.jpaService.execute(new SLASummaryGetJPAExecutor(actionId))) != null) {
                this.LOG.debug("Deleting summary bean corresponding to action " + slaSummaryBean.getId());
                this.deleteList.add(slaSummaryBean);
            }
            if (bean.getStatus() != CoordinatorAction.Status.WAITING && bean.getStatus() != CoordinatorAction.Status.READY) {
                throw new CommandException(ErrorCode.E1022, bean.getId());
            }
            this.deleteList.add(bean);
        }
        catch (JPAExecutorException e) {
            throw new CommandException(e);
        }
    }

    private void check(CoordinatorJobBean coordJob, Date newEndTime, Integer newConcurrency, Date newPauseTime) throws CommandException {
        if (coordJob.getStatus() == Job.Status.KILLED) {
            throw new CommandException(ErrorCode.E1016, new Object[0]);
        }
        if (newEndTime != null) {
            this.checkEndTime(coordJob, newEndTime);
        }
        if (newPauseTime != null) {
            this.checkPauseTime(coordJob, newPauseTime);
        }
    }

    @Override
    protected Void execute() throws CommandException {
        this.LOG.info("STARTED CoordChangeXCommand for jobId=" + this.jobId);
        try {
            if (this.newEndTime != null) {
                boolean dontChange;
                boolean bl = dontChange = this.coordJob.getEndTime().before(this.newEndTime) && this.coordJob.getNextMaterializedTime() != null && this.coordJob.getNextMaterializedTime().after(this.newEndTime);
                if (!dontChange) {
                    this.coordJob.setEndTime(this.newEndTime);
                    if (this.coordJob.getStatus() == Job.Status.SUCCEEDED) {
                        this.coordJob.setStatus(Job.Status.RUNNING);
                    }
                    if (this.coordJob.getStatus() == Job.Status.DONEWITHERROR || this.coordJob.getStatus() == Job.Status.FAILED) {
                        this.coordJob.setStatus(StatusUtils.getStatusIfBackwardSupportTrue(Job.Status.RUNNINGWITHERROR));
                    }
                    this.coordJob.setPending();
                    this.coordJob.resetDoneMaterialization();
                }
            }
            if (this.newConcurrency != null) {
                this.coordJob.setConcurrency(this.newConcurrency);
            }
            if (this.newPauseTime != null || this.resetPauseTime) {
                this.coordJob.setPauseTime(this.newPauseTime);
                if (this.oldPauseTime != null && this.newPauseTime != null) {
                    if (this.oldPauseTime.before(this.newPauseTime)) {
                        if (this.coordJob.getStatus() == Job.Status.PAUSED) {
                            this.coordJob.setStatus(Job.Status.RUNNING);
                        } else if (this.coordJob.getStatus() == Job.Status.PAUSEDWITHERROR) {
                            this.coordJob.setStatus(Job.Status.RUNNINGWITHERROR);
                        }
                    }
                } else if (this.oldPauseTime != null && this.newPauseTime == null) {
                    if (this.coordJob.getStatus() == Job.Status.PAUSED) {
                        this.coordJob.setStatus(Job.Status.RUNNING);
                    } else if (this.coordJob.getStatus() == Job.Status.PAUSEDWITHERROR) {
                        this.coordJob.setStatus(Job.Status.RUNNINGWITHERROR);
                    }
                }
                if (!this.resetPauseTime) {
                    this.processLookaheadActions(this.coordJob, this.newPauseTime);
                }
            }
            if (this.coordJob.getNextMaterializedTime() != null && this.coordJob.getEndTime().compareTo(this.coordJob.getNextMaterializedTime()) <= 0) {
                this.LOG.info("[" + this.coordJob.getId() + "]: all actions have been materialized, job status = " + this.coordJob.getStatus() + ", set pending to true");
                this.coordJob.setDoneMaterialization();
            }
            this.coordJob.setLastModifiedTime(new Date());
            this.updateList.add(new BatchQueryExecutor.UpdateEntry<CoordJobQueryExecutor.CoordJobQuery>(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB_CHANGE, this.coordJob));
            BatchQueryExecutor.getInstance().executeBatchInsertUpdateDelete(null, this.updateList, this.deleteList);
            Void dontChange = null;
            return dontChange;
        }
        catch (XException ex) {
            throw new CommandException(ex);
        }
        finally {
            this.LOG.info("ENDED CoordChangeXCommand for jobId=" + this.jobId);
            if (this.coordJob.getBundleId() != null) {
                BundleStatusUpdateXCommand bundleStatusUpdate = new BundleStatusUpdateXCommand(this.coordJob, this.prevStatus);
                bundleStatusUpdate.call();
            }
        }
    }

    @Override
    public String getEntityKey() {
        return this.jobId;
    }

    @Override
    protected void loadState() throws CommandException {
        this.jpaService = Services.get().get(JPAService.class);
        if (this.jpaService == null) {
            throw new CommandException(ErrorCode.E0610, new Object[0]);
        }
        try {
            this.coordJob = this.jpaService.execute(new CoordJobGetJPAExecutor(this.jobId));
            this.oldPauseTime = this.coordJob.getPauseTime();
            this.prevStatus = this.coordJob.getStatus();
        }
        catch (JPAExecutorException e) {
            throw new CommandException(e);
        }
        LogUtils.setLogInfo(this.coordJob, this.logInfo);
    }

    @Override
    protected void verifyPrecondition() throws CommandException, PreconditionException {
        this.check(this.coordJob, this.newEndTime, this.newConcurrency, this.newPauseTime);
    }

    @Override
    protected boolean isLockRequired() {
        return true;
    }

    static {
        ALLOWED_CHANGE_OPTIONS.add("endtime");
        ALLOWED_CHANGE_OPTIONS.add("concurrency");
        ALLOWED_CHANGE_OPTIONS.add("pausetime");
    }
}

