/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.executor.jpa.QueryExecutor;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.sla.SLARegistrationBean;

public class SLARegistrationQueryExecutor
extends QueryExecutor<SLARegistrationBean, SLARegQuery> {
    private static SLARegistrationQueryExecutor instance = new SLARegistrationQueryExecutor();
    private static JPAService jpaService;

    private SLARegistrationQueryExecutor() {
        Services services = Services.get();
        if (services != null) {
            jpaService = Services.get().get(JPAService.class);
        }
    }

    public static QueryExecutor<SLARegistrationBean, SLARegQuery> getInstance() {
        if (instance == null) {
            instance = new SLARegistrationQueryExecutor();
        }
        return instance;
    }

    @Override
    public Query getUpdateQuery(SLARegQuery namedQuery, SLARegistrationBean bean, EntityManager em) throws JPAExecutorException {
        Query query = em.createNamedQuery(namedQuery.name());
        switch (namedQuery) {
            case UPDATE_SLA_REG_ALL: {
                query.setParameter("jobId", (Object)bean.getId());
                query.setParameter("nominalTime", (Object)bean.getNominalTimestamp());
                query.setParameter("expectedStartTime", (Object)bean.getExpectedStartTimestamp());
                query.setParameter("expectedEndTime", (Object)bean.getExpectedEndTimestamp());
                query.setParameter("expectedDuration", (Object)bean.getExpectedDuration());
                query.setParameter("slaConfig", (Object)bean.getSlaConfig());
                query.setParameter("notificationMsg", (Object)bean.getNotificationMsg());
                query.setParameter("upstreamApps", (Object)bean.getUpstreamApps());
                query.setParameter("appType", (Object)bean.getAppType().toString());
                query.setParameter("appName", (Object)bean.getAppName());
                query.setParameter("user", (Object)bean.getUser());
                query.setParameter("parentId", (Object)bean.getParentId());
                query.setParameter("jobData", (Object)bean.getJobData());
                break;
            }
            default: {
                throw new JPAExecutorException(ErrorCode.E0603, "QueryExecutor cannot set parameters for " + namedQuery.name());
            }
        }
        return query;
    }

    @Override
    public Query getSelectQuery(SLARegQuery namedQuery, EntityManager em, Object ... parameters) throws JPAExecutorException {
        return null;
    }

    @Override
    public int executeUpdate(SLARegQuery namedQuery, SLARegistrationBean jobBean) throws JPAExecutorException {
        EntityManager em = jpaService.getEntityManager();
        Query query = this.getUpdateQuery(namedQuery, jobBean, em);
        int ret = jpaService.executeUpdate(namedQuery.name(), query, em);
        return ret;
    }

    @Override
    public SLARegistrationBean get(SLARegQuery namedQuery, Object ... parameters) throws JPAExecutorException {
        EntityManager em = jpaService.getEntityManager();
        Query query = this.getSelectQuery(namedQuery, em, parameters);
        SLARegistrationBean bean = (SLARegistrationBean)jpaService.executeGet(namedQuery.name(), query, em);
        return bean;
    }

    @Override
    public List<SLARegistrationBean> getList(SLARegQuery namedQuery, Object ... parameters) throws JPAExecutorException {
        EntityManager em = jpaService.getEntityManager();
        Query query = this.getSelectQuery(namedQuery, em, parameters);
        List<SLARegistrationBean> beanList = jpaService.executeGetList(namedQuery.name(), query, em);
        return beanList;
    }

    @VisibleForTesting
    public static void destroy() {
        if (instance != null) {
            jpaService = null;
            instance = null;
        }
    }

    public static enum SLARegQuery {
        UPDATE_SLA_REG_ALL;

    }
}

