/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.executor.jpa.QueryExecutor;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.sla.SLASummaryBean;

public class SLASummaryQueryExecutor
extends QueryExecutor<SLASummaryBean, SLASummaryQuery> {
    private static SLASummaryQueryExecutor instance = new SLASummaryQueryExecutor();
    private static JPAService jpaService;

    private SLASummaryQueryExecutor() {
        Services services = Services.get();
        if (services != null) {
            jpaService = Services.get().get(JPAService.class);
        }
    }

    public static QueryExecutor<SLASummaryBean, SLASummaryQuery> getInstance() {
        if (instance == null) {
            instance = new SLASummaryQueryExecutor();
        }
        return instance;
    }

    @Override
    public Query getUpdateQuery(SLASummaryQuery namedQuery, SLASummaryBean bean, EntityManager em) throws JPAExecutorException {
        Query query = em.createNamedQuery(namedQuery.name());
        switch (namedQuery) {
            case UPDATE_SLA_SUMMARY_FOR_STATUS_ACTUAL_TIMES: {
                query.setParameter("jobId", (Object)bean.getId());
                query.setParameter("slaStatus", (Object)bean.getSLAStatus().toString());
                query.setParameter("lastModifiedTS", (Object)bean.getLastModifiedTimestamp());
                query.setParameter("eventStatus", (Object)bean.getEventStatusString());
                query.setParameter("jobStatus", (Object)bean.getJobStatus());
                query.setParameter("eventProcessed", (Object)bean.getEventProcessed());
                query.setParameter("actualStartTS", (Object)bean.getActualStartTimestamp());
                query.setParameter("actualEndTS", (Object)bean.getActualEndTimestamp());
                query.setParameter("actualDuration", (Object)bean.getActualDuration());
                break;
            }
            case UPDATE_SLA_SUMMARY_ALL: {
                query.setParameter("appName", (Object)bean.getAppName());
                query.setParameter("appType", (Object)bean.getAppType().toString());
                query.setParameter("nominalTime", (Object)bean.getNominalTimestamp());
                query.setParameter("expectedStartTime", (Object)bean.getExpectedStartTimestamp());
                query.setParameter("expectedEndTime", (Object)bean.getExpectedEndTimestamp());
                query.setParameter("expectedDuration", (Object)bean.getExpectedDuration());
                query.setParameter("jobStatus", (Object)bean.getJobStatus());
                query.setParameter("slaStatus", (Object)bean.getSLAStatusString());
                query.setParameter("eventStatus", (Object)bean.getEventStatusString());
                query.setParameter("lastModTime", (Object)bean.getLastModifiedTimestamp());
                query.setParameter("user", (Object)bean.getUser());
                query.setParameter("parentId", (Object)bean.getParentId());
                query.setParameter("eventProcessed", (Object)bean.getEventProcessed());
                query.setParameter("actualDuration", (Object)bean.getActualDuration());
                query.setParameter("actualEndTS", (Object)bean.getActualEndTimestamp());
                query.setParameter("actualStartTS", (Object)bean.getActualStartTimestamp());
                query.setParameter("jobId", (Object)bean.getId());
                break;
            }
            default: {
                throw new JPAExecutorException(ErrorCode.E0603, "QueryExecutor cannot set parameters for " + namedQuery.name());
            }
        }
        return query;
    }

    @Override
    public Query getSelectQuery(SLASummaryQuery namedQuery, EntityManager em, Object ... parameters) throws JPAExecutorException {
        Query query = em.createNamedQuery(namedQuery.name());
        switch (namedQuery) {
            case GET_SLA_SUMMARY: {
                query.setParameter("id", parameters[0]);
            }
        }
        return query;
    }

    @Override
    public int executeUpdate(SLASummaryQuery namedQuery, SLASummaryBean jobBean) throws JPAExecutorException {
        EntityManager em = jpaService.getEntityManager();
        Query query = this.getUpdateQuery(namedQuery, jobBean, em);
        int ret = jpaService.executeUpdate(namedQuery.name(), query, em);
        return ret;
    }

    @Override
    public SLASummaryBean get(SLASummaryQuery namedQuery, Object ... parameters) throws JPAExecutorException {
        EntityManager em = jpaService.getEntityManager();
        Query query = this.getSelectQuery(namedQuery, em, parameters);
        SLASummaryBean bean = (SLASummaryBean)jpaService.executeGet(namedQuery.name(), query, em);
        return bean;
    }

    @Override
    public List<SLASummaryBean> getList(SLASummaryQuery namedQuery, Object ... parameters) throws JPAExecutorException {
        EntityManager em = jpaService.getEntityManager();
        Query query = this.getSelectQuery(namedQuery, em, parameters);
        List<SLASummaryBean> beanList = jpaService.executeGetList(namedQuery.name(), query, em);
        return beanList;
    }

    @VisibleForTesting
    public static void destroy() {
        if (instance != null) {
            jpaService = null;
            instance = null;
        }
    }

    public static enum SLASummaryQuery {
        UPDATE_SLA_SUMMARY_FOR_STATUS_ACTUAL_TIMES,
        UPDATE_SLA_SUMMARY_ALL,
        GET_SLA_SUMMARY;

    }
}

