/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.operation;

import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hive.service.cli.FetchOrientation;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.OperationHandle;
import org.apache.hive.service.cli.OperationState;
import org.apache.hive.service.cli.RowSet;
import org.apache.hive.service.cli.TableSchema;
import org.apache.hive.service.cli.operation.ExecuteStatementOperation;
import org.apache.hive.service.cli.session.HiveSession;

public class AsyncExecStmtOperation
extends ExecuteStatementOperation {
    private ExecuteStatementOperation execOP;
    private final ExecutorService opExecutor = Executors.newSingleThreadExecutor();
    private Future<String> execFuture = null;
    private static final Log LOG = LogFactory.getLog(AsyncExecStmtOperation.class);

    public AsyncExecStmtOperation(HiveSession parentSession, String statement, Map<String, String> confOverlay) {
        super(parentSession, statement, confOverlay);
        LOG.info((Object)("Got ansync exec for query " + statement));
    }

    public static AsyncExecStmtOperation wrapExecStmtOperation(ExecuteStatementOperation execOP) {
        AsyncExecStmtOperation newExecOP = new AsyncExecStmtOperation(execOP.getParentSession(), execOP.getStatement(), execOP.confOverlay);
        newExecOP.setExecOP(execOP);
        return newExecOP;
    }

    private void startLogCapture(HiveSession parentSession, OperationHandle opHandle) throws HiveSQLException {
        parentSession.getSessionManager().getLogManager().registerCurrentThread(opHandle);
    }

    private void stopLogCapture(HiveSession parentSession) {
        parentSession.getSessionManager().getLogManager().unregisterCurrentThread();
    }

    @Override
    public void run() throws HiveSQLException {
        this.prepare();
        final ExecuteStatementOperation currExec = this.execOP;
        final HiveSession parentSession = this.getParentSession();
        final OperationHandle parentHandle = this.getHandle();
        this.execFuture = this.opExecutor.submit(new Callable<String>(){

            @Override
            public String call() throws HiveSQLException {
                AsyncExecStmtOperation.this.startLogCapture(parentSession, parentHandle);
                currExec.run();
                AsyncExecStmtOperation.this.stopLogCapture(parentSession);
                return null;
            }
        });
    }

    @Override
    public void prepare() throws HiveSQLException {
        final ExecuteStatementOperation currExec = this.execOP;
        final HiveSession parentSession = this.getParentSession();
        final OperationHandle parentHandle = this.getHandle();
        this.execFuture = this.opExecutor.submit(new Callable<String>(){

            @Override
            public String call() throws HiveSQLException {
                AsyncExecStmtOperation.this.startLogCapture(parentSession, parentHandle);
                HiveConf queryConf = new HiveConf(AsyncExecStmtOperation.this.getParentSession().getHiveConf());
                SessionState.start((SessionState)currExec.getParentSession().getSessionState());
                currExec.prepare(queryConf);
                AsyncExecStmtOperation.this.stopLogCapture(parentSession);
                return null;
            }
        });
        this.waitForCompletion(this.execFuture);
        this.setHasResultSet(this.execOP.hasResultSet());
    }

    @Override
    public void close() throws HiveSQLException {
        this.waitForCompletion(this.execFuture);
        final ExecuteStatementOperation currExec = this.execOP;
        final HiveSession parentSession = this.getParentSession();
        final OperationHandle parentHandle = this.getHandle();
        Future<String> opFuture = this.opExecutor.submit(new Callable<String>(){

            @Override
            public String call() throws HiveSQLException {
                AsyncExecStmtOperation.this.startLogCapture(parentSession, parentHandle);
                currExec.close();
                AsyncExecStmtOperation.this.stopLogCapture(parentSession);
                return null;
            }
        });
        this.waitForCompletion(opFuture);
        this.opExecutor.shutdown();
    }

    @Override
    public void cancel() throws HiveSQLException {
        final ExecuteStatementOperation currExec = this.execOP;
        final HiveSession parentSession = this.getParentSession();
        final OperationHandle parentHandle = this.getHandle();
        Future<String> opFuture = this.opExecutor.submit(new Callable<String>(){

            @Override
            public String call() throws HiveSQLException {
                AsyncExecStmtOperation.this.startLogCapture(parentSession, parentHandle);
                currExec.cancel();
                AsyncExecStmtOperation.this.stopLogCapture(parentSession);
                return null;
            }
        });
        this.waitForCompletion(opFuture);
        this.opExecutor.shutdown();
    }

    @Override
    public TableSchema getResultSetSchema() throws HiveSQLException {
        return this.execOP.getResultSetSchema();
    }

    @Override
    public RowSet getNextRowSet(final FetchOrientation orientation, final long maxRows) throws HiveSQLException {
        this.checkExecutionStatus();
        final ExecuteStatementOperation currExec = this.execOP;
        final HiveSession parentSession = this.getParentSession();
        final OperationHandle parentHandle = this.getHandle();
        Future<RowSet> opFuture = this.opExecutor.submit(new Callable<RowSet>(){

            @Override
            public RowSet call() throws HiveSQLException {
                AsyncExecStmtOperation.this.startLogCapture(parentSession, parentHandle);
                RowSet rowSet = currExec.getNextRowSet(orientation, maxRows);
                AsyncExecStmtOperation.this.stopLogCapture(parentSession);
                return rowSet;
            }
        });
        return this.waitForCompletion(opFuture);
    }

    @Override
    public OperationState getState() {
        return this.execOP.getState();
    }

    @Override
    public boolean isPrepared() {
        return this.execOP.isPrepared();
    }

    private void checkExecutionStatus() throws HiveSQLException {
        if (this.execFuture == null) {
            throw new HiveSQLException("No background query executed", "24000");
        }
        if (this.getState().equals((Object)OperationState.RUNNING) || !this.execFuture.isDone()) {
            throw new HiveSQLException("Query still runing", "HY010");
        }
        this.waitForCompletion(this.execFuture);
        if (this.getState().equals((Object)OperationState.ERROR)) {
            throw new HiveSQLException("Query execution failed", "07000");
        }
        if (this.getState().equals((Object)OperationState.CANCELED)) {
            throw new HiveSQLException("Query execution was canceled", "24000");
        }
    }

    private <T> T waitForCompletion(Future<T> opFuture) throws HiveSQLException {
        T result = null;
        try {
            result = opFuture.get();
        }
        catch (InterruptedException e) {
            throw new HiveSQLException(e.getMessage(), "24000", -1, e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof HiveSQLException) {
                throw (HiveSQLException)e.getCause();
            }
            throw new HiveSQLException(e.getMessage(), e.getCause());
        }
        return result;
    }

    private void setExecOP(ExecuteStatementOperation execOP) {
        this.execOP = execOP;
    }
}

