/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.operation;

import java.util.EnumSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.service.cli.FetchOrientation;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.OperationHandle;
import org.apache.hive.service.cli.OperationState;
import org.apache.hive.service.cli.OperationType;
import org.apache.hive.service.cli.RowSet;
import org.apache.hive.service.cli.TableSchema;
import org.apache.hive.service.cli.session.HiveSession;

public abstract class Operation {
    protected final HiveSession parentSession;
    private OperationState state = OperationState.INITIALIZED;
    private final OperationHandle opHandle;
    private HiveConf configuration = null;
    public static final Log LOG = LogFactory.getLog((String)Operation.class.getName());
    public static final long DEFAULT_FETCH_MAX_ROWS = 100L;
    protected boolean hasResultSet;
    private long operationTimeout;
    private long lastAccessTime;

    protected Operation(HiveSession parentSession, OperationType opType) {
        this.parentSession = parentSession;
        this.configuration = parentSession.getHiveConf();
        this.opHandle = new OperationHandle(opType);
        this.lastAccessTime = System.currentTimeMillis();
        this.operationTimeout = HiveConf.getTimeInMsec((Configuration)this.configuration, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SERVER2_IDLE_OPERATION_TIMEOUT);
    }

    public void setConfiguration(HiveConf configuration) {
        this.configuration = new HiveConf(configuration);
    }

    public HiveConf getConfiguration() {
        return new HiveConf(this.configuration);
    }

    public HiveSession getParentSession() {
        return this.parentSession;
    }

    public OperationHandle getHandle() {
        return this.opHandle;
    }

    public OperationType getType() {
        return this.opHandle.getOperationType();
    }

    public OperationState getState() {
        return this.state;
    }

    public boolean hasResultSet() {
        return this.hasResultSet;
    }

    protected void setHasResultSet(boolean hasResultSet) {
        this.hasResultSet = hasResultSet;
        this.opHandle.setHasResultSet(hasResultSet);
    }

    public boolean isTimedOut(long current) {
        if (this.operationTimeout == 0L) {
            return false;
        }
        if (this.operationTimeout > 0L) {
            return this.state.isTerminal() && this.getLastAccessTime() + this.operationTimeout <= current;
        }
        return this.getLastAccessTime() + -this.operationTimeout <= current;
    }

    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public long getOperationTimeout() {
        return this.operationTimeout;
    }

    public void setOperationTimeout(long operationTimeout) {
        this.operationTimeout = operationTimeout;
    }

    protected final void setState(OperationState newState) throws HiveSQLException {
        this.state.validateTransition(newState);
        this.state = newState;
        this.lastAccessTime = System.currentTimeMillis();
    }

    protected final void assertState(OperationState state) throws HiveSQLException {
        if (this.state != state) {
            throw new HiveSQLException("Expected state " + (Object)((Object)state) + ", but found " + (Object)((Object)this.state));
        }
        this.lastAccessTime = System.currentTimeMillis();
    }

    protected final void assertAtLeastState(OperationState state) throws HiveSQLException {
        if (this.state.compareTo(state) < 0) {
            throw new HiveSQLException("Expected state " + (Object)((Object)state) + ", but found " + (Object)((Object)this.state));
        }
    }

    public boolean isRunning() {
        return OperationState.RUNNING.equals((Object)this.getState());
    }

    public boolean isFinished() {
        return OperationState.FINISHED.equals((Object)this.getState());
    }

    public boolean isCanceled() {
        return OperationState.CANCELED.equals((Object)this.getState());
    }

    public boolean isFailed() {
        return OperationState.ERROR.equals((Object)this.getState());
    }

    public abstract void run() throws HiveSQLException;

    public void prepare() throws HiveSQLException {
        this.prepare(null);
    }

    public void prepare(HiveConf conf) throws HiveSQLException {
        this.setState(OperationState.INITIALIZED);
        throw new UnsupportedOperationException("SQLOperation.prepare()");
    }

    public boolean isPrepared() {
        return false;
    }

    public void cancel() throws HiveSQLException {
        this.setState(OperationState.CANCELED);
        throw new UnsupportedOperationException("SQLOperation.cancel()");
    }

    public abstract void close() throws HiveSQLException;

    public abstract TableSchema getResultSetSchema() throws HiveSQLException;

    public abstract RowSet getNextRowSet(FetchOrientation var1, long var2) throws HiveSQLException;

    public RowSet getNextRowSet() throws HiveSQLException {
        return this.getNextRowSet(FetchOrientation.FETCH_NEXT, 100L);
    }

    public void validateFetchOrientation(FetchOrientation orientation, EnumSet<FetchOrientation> supportedOrientations) throws HiveSQLException {
        for (FetchOrientation supportedOrientation : supportedOrientations) {
            if (!supportedOrientation.equals((Object)orientation)) continue;
            return;
        }
        throw new HiveSQLException("The fetch type " + orientation.toString() + " is not supported for this resultset", "HY106");
    }
}

