/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.operation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.service.AbstractService;
import org.apache.hive.service.cli.FetchOrientation;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.OperationHandle;
import org.apache.hive.service.cli.OperationState;
import org.apache.hive.service.cli.RowSet;
import org.apache.hive.service.cli.TableSchema;
import org.apache.hive.service.cli.operation.ExecuteStatementOperation;
import org.apache.hive.service.cli.operation.GetCatalogsOperation;
import org.apache.hive.service.cli.operation.GetColumnsOperation;
import org.apache.hive.service.cli.operation.GetFunctionsOperation;
import org.apache.hive.service.cli.operation.GetSchemasOperation;
import org.apache.hive.service.cli.operation.GetTableTypesOperation;
import org.apache.hive.service.cli.operation.GetTablesOperation;
import org.apache.hive.service.cli.operation.GetTypeInfoOperation;
import org.apache.hive.service.cli.operation.MetadataOperation;
import org.apache.hive.service.cli.operation.Operation;
import org.apache.hive.service.cli.session.HiveSession;
import org.apache.hive.service.cli.session.SessionManager;

public class OperationManager
extends AbstractService {
    private HiveConf hiveConf;
    private final Map<OperationHandle, Operation> handleToOperation = new HashMap<OperationHandle, Operation>();
    private SessionManager sessionManager;

    public OperationManager() {
        super("OperationManager");
    }

    @Override
    public synchronized void init(HiveConf hiveConf) {
        this.hiveConf = hiveConf;
        super.init(hiveConf);
    }

    @Override
    public synchronized void start() {
        super.start();
    }

    @Override
    public synchronized void stop() {
        super.stop();
    }

    public void setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public ExecuteStatementOperation newExecuteStatementOperation(HiveSession parentSession, String statement, Map<String, String> confOverlay) throws HiveSQLException {
        ExecuteStatementOperation executeStatementOperation = ExecuteStatementOperation.newExecuteStatementOperation(parentSession, statement, confOverlay);
        this.addOperation(executeStatementOperation);
        return executeStatementOperation;
    }

    public GetTypeInfoOperation newGetTypeInfoOperation(HiveSession parentSession) {
        GetTypeInfoOperation operation = new GetTypeInfoOperation(parentSession);
        this.addOperation(operation);
        return operation;
    }

    public GetCatalogsOperation newGetCatalogsOperation(HiveSession parentSession) {
        GetCatalogsOperation operation = new GetCatalogsOperation(parentSession);
        this.addOperation(operation);
        return operation;
    }

    public GetSchemasOperation newGetSchemasOperation(HiveSession parentSession, String catalogName, String schemaName) {
        GetSchemasOperation operation = new GetSchemasOperation(parentSession, catalogName, schemaName);
        this.addOperation(operation);
        return operation;
    }

    public MetadataOperation newGetTablesOperation(HiveSession parentSession, String catalogName, String schemaName, String tableName, List<String> tableTypes) {
        GetTablesOperation operation = new GetTablesOperation(parentSession, catalogName, schemaName, tableName, tableTypes);
        this.addOperation(operation);
        return operation;
    }

    public GetTableTypesOperation newGetTableTypesOperation(HiveSession parentSession) {
        GetTableTypesOperation operation = new GetTableTypesOperation(parentSession);
        this.addOperation(operation);
        return operation;
    }

    public GetColumnsOperation newGetColumnsOperation(HiveSession parentSession, String catalogName, String schemaName, String tableName, String columnName) {
        GetColumnsOperation operation = new GetColumnsOperation(parentSession, catalogName, schemaName, tableName, columnName);
        this.addOperation(operation);
        return operation;
    }

    public GetFunctionsOperation newGetFunctionsOperation(HiveSession parentSession, String catalogName, String schemaName, String functionName) {
        GetFunctionsOperation operation = new GetFunctionsOperation(parentSession, catalogName, schemaName, functionName);
        this.addOperation(operation);
        return operation;
    }

    public Operation getOperation(OperationHandle operationHandle) throws HiveSQLException {
        Operation operation = this._getOperation(operationHandle);
        if (operation == null) {
            throw new HiveSQLException("Invalid OperationHandle: " + operationHandle);
        }
        return operation;
    }

    private synchronized Operation _getOperation(OperationHandle operationHandle) {
        return this.handleToOperation.get(operationHandle);
    }

    private synchronized void addOperation(Operation operation) {
        this.handleToOperation.put(operation.getHandle(), operation);
    }

    private synchronized Operation removeOperation(OperationHandle opHandle) {
        return this.handleToOperation.remove(opHandle);
    }

    public OperationState getOperationState(OperationHandle opHandle) throws HiveSQLException {
        return this.getOperation(opHandle).getState();
    }

    public void cancelOperation(OperationHandle opHandle) throws HiveSQLException {
        this.getOperation(opHandle).cancel();
    }

    public void closeOperation(OperationHandle opHandle) throws HiveSQLException {
        Operation operation = this.removeOperation(opHandle);
        if (operation == null) {
            throw new HiveSQLException("Operation does not exist!");
        }
        operation.close();
    }

    public TableSchema getOperationResultSetSchema(OperationHandle opHandle) throws HiveSQLException {
        return this.getOperation(opHandle).getResultSetSchema();
    }

    public RowSet getOperationNextRowSet(OperationHandle opHandle) throws HiveSQLException {
        return this.getOperation(opHandle).getNextRowSet();
    }

    public RowSet getOperationNextRowSet(OperationHandle opHandle, FetchOrientation orientation, long maxRows) throws HiveSQLException {
        return this.getOperation(opHandle).getNextRowSet(orientation, maxRows);
    }

    public List<OperationHandle> closeExpiredOperations(OperationHandle[] handles) {
        ArrayList<OperationHandle> removed = new ArrayList<OperationHandle>();
        long current = System.currentTimeMillis();
        for (OperationHandle handle : handles) {
            Operation operation = this._getOperation(handle);
            if (operation == null) {
                LOG.warn((Object)("Invalid Operation " + handle));
                removed.add(handle);
                continue;
            }
            if (!operation.isTimedOut(current)) continue;
            LOG.warn((Object)("Operation " + handle + " is Timed-out and will be closed"));
            try {
                this.closeOperation(operation.getHandle());
            }
            catch (Exception e) {
                LOG.warn((Object)("Exception is thrown closing operation " + operation.getHandle()), (Throwable)e);
            }
            removed.add(handle);
        }
        return removed;
    }
}

