/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.session;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.ql.history.HiveHistory;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hive.service.auth.HiveAuthFactory;
import org.apache.hive.service.cli.FetchOrientation;
import org.apache.hive.service.cli.GetInfoType;
import org.apache.hive.service.cli.GetInfoValue;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.OperationHandle;
import org.apache.hive.service.cli.RowSet;
import org.apache.hive.service.cli.SessionHandle;
import org.apache.hive.service.cli.TableSchema;
import org.apache.hive.service.cli.log.LogManager;
import org.apache.hive.service.cli.operation.ExecuteStatementOperation;
import org.apache.hive.service.cli.operation.GetCatalogsOperation;
import org.apache.hive.service.cli.operation.GetColumnsOperation;
import org.apache.hive.service.cli.operation.GetFunctionsOperation;
import org.apache.hive.service.cli.operation.GetSchemasOperation;
import org.apache.hive.service.cli.operation.GetTableTypesOperation;
import org.apache.hive.service.cli.operation.GetTypeInfoOperation;
import org.apache.hive.service.cli.operation.MetadataOperation;
import org.apache.hive.service.cli.operation.OperationManager;
import org.apache.hive.service.cli.session.HiveSession;
import org.apache.hive.service.cli.session.SessionManager;

public class HiveSessionImpl
implements HiveSession {
    private final SessionHandle sessionHandle = new SessionHandle();
    private String username;
    private final String password;
    private final Map<String, String> sessionConf = new HashMap<String, String>();
    private final HiveConf hiveConf = new HiveConf();
    private final SessionState sessionState;
    private static final String FETCH_WORK_SERDE_CLASS = "org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe";
    private static final Log LOG = LogFactory.getLog(HiveSessionImpl.class);
    private SessionManager sessionManager;
    private OperationManager operationManager;
    private LogManager logManager;
    private IMetaStoreClient metastoreClient = null;
    private String ipAddress;
    private final Set<OperationHandle> opHandleSet = new HashSet<OperationHandle>();
    private long lastAccessTime;

    public HiveSessionImpl(String username, String password, Map<String, String> sessionConf, String ipAddress) {
        this.username = username;
        this.password = password;
        this.ipAddress = ipAddress;
        if (sessionConf != null) {
            for (Map.Entry<String, String> entry : sessionConf.entrySet()) {
                this.hiveConf.set(entry.getKey(), entry.getValue());
            }
        }
        this.hiveConf.set(HiveConf.ConfVars.HIVESESSIONID.varname, this.sessionHandle.getHandleIdentifier().toString());
        this.sessionState = new SessionState(this.hiveConf);
        this.lastAccessTime = System.currentTimeMillis();
    }

    @Override
    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    @Override
    public void setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    private OperationManager getOperationManager() {
        return this.operationManager;
    }

    @Override
    public void setOperationManager(OperationManager operationManager) {
        this.operationManager = operationManager;
    }

    protected synchronized void acquire() throws HiveSQLException {
        SessionState.start((SessionState)this.sessionState);
        this.lastAccessTime = System.currentTimeMillis();
    }

    protected synchronized void release() {
        assert (this.sessionState != null);
        this.lastAccessTime = System.currentTimeMillis();
    }

    @Override
    public SessionHandle getSessionHandle() {
        return this.sessionHandle;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public HiveConf getHiveConf() {
        this.hiveConf.setVar(HiveConf.ConfVars.HIVEFETCHOUTPUTSERDE, FETCH_WORK_SERDE_CLASS);
        return this.hiveConf;
    }

    @Override
    public LogManager getLogManager() {
        return this.logManager;
    }

    @Override
    public void setLogManager(LogManager logManager) {
        this.logManager = logManager;
    }

    @Override
    public IMetaStoreClient getMetaStoreClient() throws HiveSQLException {
        if (this.metastoreClient == null) {
            try {
                this.metastoreClient = new HiveMetaStoreClient(this.getHiveConf());
            }
            catch (MetaException e) {
                throw new HiveSQLException(e);
            }
        }
        return this.metastoreClient;
    }

    @Override
    public GetInfoValue getInfo(GetInfoType getInfoType) throws HiveSQLException {
        this.acquire();
        try {
            switch (getInfoType) {
                case CLI_SERVER_NAME: {
                    GetInfoValue getInfoValue = new GetInfoValue("Hive");
                    return getInfoValue;
                }
                case CLI_DBMS_NAME: {
                    GetInfoValue getInfoValue = new GetInfoValue("Apache Hive");
                    return getInfoValue;
                }
                case CLI_DBMS_VER: {
                    GetInfoValue getInfoValue = new GetInfoValue("0.10.0");
                    return getInfoValue;
                }
                case CLI_MAX_COLUMN_NAME_LEN: {
                    GetInfoValue getInfoValue = new GetInfoValue(128);
                    return getInfoValue;
                }
                case CLI_MAX_SCHEMA_NAME_LEN: {
                    GetInfoValue getInfoValue = new GetInfoValue(128);
                    return getInfoValue;
                }
                case CLI_MAX_TABLE_NAME_LEN: {
                    GetInfoValue getInfoValue = new GetInfoValue(128);
                    return getInfoValue;
                }
            }
            throw new HiveSQLException("Unrecognized GetInfoType value: " + getInfoType.toString());
        }
        finally {
            this.release();
        }
    }

    @Override
    public OperationHandle executeStatement(String statement, Map<String, String> confOverlay) throws HiveSQLException {
        this.acquire();
        OperationManager operationManager = this.getOperationManager();
        ExecuteStatementOperation operation = operationManager.newExecuteStatementOperation(this.getSession(), statement, confOverlay);
        this.getLogManager().unregisterCurrentThread();
        OperationHandle opHandle = operation.getHandle();
        this.getLogManager().registerCurrentThread(opHandle);
        try {
            operation.run();
            this.opHandleSet.add(opHandle);
            OperationHandle operationHandle = opHandle;
            return operationHandle;
        }
        catch (HiveSQLException e) {
            operationManager.closeOperation(opHandle);
            throw e;
        }
        finally {
            this.getLogManager().unregisterCurrentThread();
            this.release();
        }
    }

    @Override
    public OperationHandle getTypeInfo() throws HiveSQLException {
        this.acquire();
        OperationManager operationManager = this.getOperationManager();
        GetTypeInfoOperation operation = operationManager.newGetTypeInfoOperation(this.getSession());
        this.getLogManager().unregisterCurrentThread();
        OperationHandle opHandle = operation.getHandle();
        this.getLogManager().registerCurrentThread(opHandle);
        try {
            operation.run();
            this.opHandleSet.add(opHandle);
            OperationHandle operationHandle = opHandle;
            return operationHandle;
        }
        catch (HiveSQLException e) {
            operationManager.closeOperation(opHandle);
            throw e;
        }
        finally {
            this.getLogManager().unregisterCurrentThread();
            this.release();
        }
    }

    @Override
    public OperationHandle getCatalogs() throws HiveSQLException {
        this.acquire();
        OperationManager operationManager = this.getOperationManager();
        GetCatalogsOperation operation = operationManager.newGetCatalogsOperation(this.getSession());
        this.getLogManager().unregisterCurrentThread();
        OperationHandle opHandle = operation.getHandle();
        this.getLogManager().registerCurrentThread(opHandle);
        try {
            operation.run();
            this.opHandleSet.add(opHandle);
            OperationHandle operationHandle = opHandle;
            return operationHandle;
        }
        catch (HiveSQLException e) {
            operationManager.closeOperation(opHandle);
            throw e;
        }
        finally {
            this.getLogManager().unregisterCurrentThread();
            this.release();
        }
    }

    @Override
    public OperationHandle getSchemas(String catalogName, String schemaName) throws HiveSQLException {
        this.acquire();
        OperationManager operationManager = this.getOperationManager();
        GetSchemasOperation operation = operationManager.newGetSchemasOperation(this.getSession(), catalogName, schemaName);
        this.getLogManager().unregisterCurrentThread();
        OperationHandle opHandle = operation.getHandle();
        this.getLogManager().registerCurrentThread(opHandle);
        try {
            operation.run();
            this.opHandleSet.add(opHandle);
            OperationHandle operationHandle = opHandle;
            return operationHandle;
        }
        catch (HiveSQLException e) {
            operationManager.closeOperation(opHandle);
            throw e;
        }
        finally {
            this.getLogManager().unregisterCurrentThread();
            this.release();
        }
    }

    @Override
    public OperationHandle getTables(String catalogName, String schemaName, String tableName, List<String> tableTypes) throws HiveSQLException {
        this.acquire();
        OperationManager operationManager = this.getOperationManager();
        MetadataOperation operation = operationManager.newGetTablesOperation(this.getSession(), catalogName, schemaName, tableName, tableTypes);
        this.getLogManager().unregisterCurrentThread();
        OperationHandle opHandle = operation.getHandle();
        this.getLogManager().registerCurrentThread(opHandle);
        try {
            operation.run();
            this.opHandleSet.add(opHandle);
            OperationHandle operationHandle = opHandle;
            return operationHandle;
        }
        catch (HiveSQLException e) {
            operationManager.closeOperation(opHandle);
            throw e;
        }
        finally {
            this.getLogManager().unregisterCurrentThread();
            this.release();
        }
    }

    @Override
    public OperationHandle getTableTypes() throws HiveSQLException {
        this.acquire();
        OperationManager operationManager = this.getOperationManager();
        GetTableTypesOperation operation = operationManager.newGetTableTypesOperation(this.getSession());
        this.getLogManager().unregisterCurrentThread();
        OperationHandle opHandle = operation.getHandle();
        this.getLogManager().registerCurrentThread(opHandle);
        try {
            operation.run();
            this.opHandleSet.add(opHandle);
            OperationHandle operationHandle = opHandle;
            return operationHandle;
        }
        catch (HiveSQLException e) {
            operationManager.closeOperation(opHandle);
            throw e;
        }
        finally {
            this.getLogManager().unregisterCurrentThread();
            this.release();
        }
    }

    @Override
    public OperationHandle getColumns(String catalogName, String schemaName, String tableName, String columnName) throws HiveSQLException {
        this.acquire();
        OperationManager operationManager = this.getOperationManager();
        GetColumnsOperation operation = operationManager.newGetColumnsOperation(this.getSession(), catalogName, schemaName, tableName, columnName);
        this.getLogManager().unregisterCurrentThread();
        OperationHandle opHandle = operation.getHandle();
        this.getLogManager().registerCurrentThread(opHandle);
        try {
            operation.run();
            this.opHandleSet.add(opHandle);
            OperationHandle operationHandle = opHandle;
            return operationHandle;
        }
        catch (HiveSQLException e) {
            operationManager.closeOperation(opHandle);
            throw e;
        }
        finally {
            this.getLogManager().unregisterCurrentThread();
            this.release();
        }
    }

    @Override
    public OperationHandle getFunctions(String catalogName, String schemaName, String functionName) throws HiveSQLException {
        this.acquire();
        OperationManager operationManager = this.getOperationManager();
        GetFunctionsOperation operation = operationManager.newGetFunctionsOperation(this.getSession(), catalogName, schemaName, functionName);
        this.getLogManager().unregisterCurrentThread();
        OperationHandle opHandle = operation.getHandle();
        this.getLogManager().registerCurrentThread(opHandle);
        try {
            operation.run();
            this.opHandleSet.add(opHandle);
            OperationHandle operationHandle = opHandle;
            return operationHandle;
        }
        catch (HiveSQLException e) {
            operationManager.closeOperation(opHandle);
            throw e;
        }
        finally {
            this.getLogManager().unregisterCurrentThread();
            this.release();
        }
    }

    @Override
    public void close() throws HiveSQLException {
        try {
            this.acquire();
            if (this.metastoreClient != null) {
                this.metastoreClient.close();
            }
            for (OperationHandle opHandle : this.opHandleSet) {
                this.operationManager.closeOperation(opHandle);
            }
            this.opHandleSet.clear();
            HiveHistory hiveHist = this.sessionState.getHiveHistory();
            if (null != hiveHist) {
                hiveHist.closeStream();
            }
            this.sessionState.close();
        }
        catch (IOException ioe) {
            throw new HiveSQLException("Failure to close", ioe);
        }
        finally {
            this.release();
        }
    }

    @Override
    public SessionState getSessionState() {
        return this.sessionState;
    }

    @Override
    public String getIpAddress() {
        return this.ipAddress;
    }

    @Override
    public String setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
        return this.ipAddress;
    }

    @Override
    public String getUserName() {
        return this.username;
    }

    @Override
    public void setUserName(String userName) {
        this.username = userName;
    }

    @Override
    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    @Override
    public void closeExpiredOperations() {
        OperationHandle[] handles = this.opHandleSet.toArray(new OperationHandle[0]);
        if (handles.length > 0) {
            OperationManager manager = this.sessionManager.getOperationManager();
            this.opHandleSet.removeAll(manager.closeExpiredOperations(handles));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelOperation(OperationHandle opHandle) throws HiveSQLException {
        this.acquire();
        try {
            this.sessionManager.getOperationManager().cancelOperation(opHandle);
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeOperation(OperationHandle opHandle) throws HiveSQLException {
        this.acquire();
        try {
            this.operationManager.closeOperation(opHandle);
            this.opHandleSet.remove(opHandle);
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TableSchema getResultSetMetadata(OperationHandle opHandle) throws HiveSQLException {
        this.acquire();
        try {
            TableSchema tableSchema = this.sessionManager.getOperationManager().getOperationResultSetSchema(opHandle);
            return tableSchema;
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RowSet fetchResults(OperationHandle opHandle, FetchOrientation orientation, long maxRows) throws HiveSQLException {
        this.acquire();
        try {
            RowSet rowSet = this.sessionManager.getOperationManager().getOperationNextRowSet(opHandle, orientation, maxRows);
            return rowSet;
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RowSet fetchResults(OperationHandle opHandle) throws HiveSQLException {
        this.acquire();
        try {
            RowSet rowSet = this.sessionManager.getOperationManager().getOperationNextRowSet(opHandle);
            return rowSet;
        }
        finally {
            this.release();
        }
    }

    protected HiveSession getSession() {
        return this;
    }

    @Override
    public String getDelegationToken(HiveAuthFactory authFactory, String owner, String renewer) throws HiveSQLException {
        HiveAuthFactory.verifyProxyAccess(this.getUsername(), owner, this.getIpAddress(), this.getHiveConf());
        return authFactory.getDelegationToken(owner, renewer);
    }

    @Override
    public void cancelDelegationToken(HiveAuthFactory authFactory, String tokenStr) throws HiveSQLException {
        HiveAuthFactory.verifyProxyAccess(this.getUsername(), this.getUserFromToken(authFactory, tokenStr), this.getIpAddress(), this.getHiveConf());
        authFactory.cancelDelegationToken(tokenStr);
    }

    @Override
    public void renewDelegationToken(HiveAuthFactory authFactory, String tokenStr) throws HiveSQLException {
        HiveAuthFactory.verifyProxyAccess(this.getUsername(), this.getUserFromToken(authFactory, tokenStr), this.getIpAddress(), this.getHiveConf());
        authFactory.renewDelegationToken(tokenStr);
    }

    private String getUserFromToken(HiveAuthFactory authFactory, String tokenStr) throws HiveSQLException {
        return authFactory.getUserFromToken(tokenStr);
    }
}

