/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import java.io.IOException;
import java.util.List;
import java.util.TreeSet;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.coprocessor.BaseEndpointCoprocessor;
import org.apache.hadoop.hbase.coprocessor.MultiRowMutationProtocol;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.WrongRegionException;
import org.apache.hadoop.hbase.util.Bytes;

public class MultiRowMutationEndpoint
extends BaseEndpointCoprocessor
implements MultiRowMutationProtocol {
    @Override
    public void mutateRows(List<Mutation> mutations) throws IOException {
        RegionCoprocessorEnvironment env = (RegionCoprocessorEnvironment)this.getEnvironment();
        TreeSet<byte[]> rowsToLock = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        HRegionInfo regionInfo = env.getRegion().getRegionInfo();
        for (Mutation m : mutations) {
            if (!HRegion.rowIsInRange(regionInfo, m.getRow())) {
                String msg = "Requested row out of range '" + Bytes.toStringBinary(m.getRow()) + "'";
                if (rowsToLock.isEmpty()) {
                    throw new WrongRegionException(msg);
                }
                throw new DoNotRetryIOException(msg);
            }
            rowsToLock.add(m.getRow());
        }
        env.getRegion().mutateRowsWithLocks(mutations, rowsToLock);
    }
}

