/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.snapshot;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CancellationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.catalog.MetaEditor;
import org.apache.hadoop.hbase.errorhandling.ForeignException;
import org.apache.hadoop.hbase.errorhandling.ForeignExceptionDispatcher;
import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.SnapshotSentinel;
import org.apache.hadoop.hbase.master.handler.TableEventHandler;
import org.apache.hadoop.hbase.master.metrics.MasterMetrics;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.monitoring.TaskMonitor;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.snapshot.RestoreSnapshotException;
import org.apache.hadoop.hbase.snapshot.RestoreSnapshotHelper;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
public class RestoreSnapshotHandler
extends TableEventHandler
implements SnapshotSentinel {
    private static final Log LOG = LogFactory.getLog(RestoreSnapshotHandler.class);
    private final HTableDescriptor hTableDescriptor;
    private final HBaseProtos.SnapshotDescription snapshot;
    private final ForeignExceptionDispatcher monitor;
    private final MasterMetrics metricsMaster;
    private final MonitoredTask status;
    private volatile boolean stopped = false;

    public RestoreSnapshotHandler(MasterServices masterServices, HBaseProtos.SnapshotDescription snapshot, HTableDescriptor htd, MasterMetrics metricsMaster) throws IOException {
        super(EventHandler.EventType.C_M_RESTORE_SNAPSHOT, htd.getName(), masterServices, masterServices);
        this.metricsMaster = metricsMaster;
        this.snapshot = snapshot;
        this.monitor = new ForeignExceptionDispatcher();
        this.getTableDescriptor();
        this.hTableDescriptor = htd;
        this.status = TaskMonitor.get().createStatus("Restoring  snapshot '" + snapshot.getName() + "' to table " + this.hTableDescriptor.getNameAsString());
    }

    @Override
    protected void handleTableOperation(List<HRegionInfo> hris) throws IOException {
        MasterFileSystem fileSystemManager = this.masterServices.getMasterFileSystem();
        CatalogTracker catalogTracker = this.masterServices.getCatalogTracker();
        FileSystem fs = fileSystemManager.getFileSystem();
        Path rootDir = fileSystemManager.getRootDir();
        byte[] tableName = this.hTableDescriptor.getName();
        Path tableDir = HTableDescriptor.getTableDir(rootDir, tableName);
        try {
            this.masterServices.getTableDescriptors().add(this.hTableDescriptor);
            LOG.debug((Object)("Starting restore snapshot=" + SnapshotDescriptionUtils.toString(this.snapshot)));
            Path snapshotDir = SnapshotDescriptionUtils.getCompletedSnapshotDir(this.snapshot, rootDir);
            RestoreSnapshotHelper restoreHelper = new RestoreSnapshotHelper(this.masterServices.getConfiguration(), fs, this.snapshot, snapshotDir, this.hTableDescriptor, tableDir, this.monitor, this.status);
            RestoreSnapshotHelper.RestoreMetaChanges metaChanges = restoreHelper.restoreHdfsRegions();
            this.forceRegionsOffline(metaChanges);
            this.forceRegionsOffline(metaChanges);
            LinkedList<HRegionInfo> hrisToRemove = new LinkedList<HRegionInfo>();
            if (metaChanges.hasRegionsToRemove()) {
                hrisToRemove.addAll(metaChanges.getRegionsToRemove());
            }
            if (metaChanges.hasRegionsToRestore()) {
                hrisToRemove.addAll(metaChanges.getRegionsToRestore());
            }
            MetaEditor.deleteRegions(catalogTracker, hrisToRemove);
            hris.clear();
            if (metaChanges.hasRegionsToAdd()) {
                hris.addAll(metaChanges.getRegionsToAdd());
            }
            if (metaChanges.hasRegionsToRestore()) {
                hris.addAll(metaChanges.getRegionsToRestore());
            }
            MetaEditor.addRegionsToMeta(catalogTracker, hris);
            metaChanges.updateMetaParentRegions(catalogTracker, hris);
            LOG.info((Object)("Restore snapshot=" + SnapshotDescriptionUtils.toString(this.snapshot) + " on table=" + Bytes.toString(tableName) + " completed!"));
        }
        catch (IOException e) {
            String msg = "restore snapshot=" + SnapshotDescriptionUtils.toString(this.snapshot) + " failed. Try re-running the restore command.";
            LOG.error((Object)msg, (Throwable)e);
            this.monitor.receive(new ForeignException(this.masterServices.getServerName().toString(), e));
            throw new RestoreSnapshotException(msg, e);
        }
        finally {
            this.stopped = true;
        }
    }

    private void forceRegionsOffline(RestoreSnapshotHelper.RestoreMetaChanges metaChanges) {
        this.forceRegionsOffline(metaChanges.getRegionsToAdd());
        this.forceRegionsOffline(metaChanges.getRegionsToRestore());
        this.forceRegionsOffline(metaChanges.getRegionsToRemove());
    }

    private void forceRegionsOffline(List<HRegionInfo> hris) {
        AssignmentManager am = this.masterServices.getAssignmentManager();
        if (hris != null) {
            for (HRegionInfo hri : hris) {
                am.regionOffline(hri);
            }
        }
    }

    @Override
    protected void completed(Throwable exception) {
        this.stopped = true;
        if (exception != null) {
            this.status.abort("Restore snapshot '" + this.snapshot.getName() + "' failed because " + exception.getMessage());
        } else {
            this.status.markComplete("Restore snapshot '" + this.snapshot.getName() + "' completed!");
        }
        this.metricsMaster.addSnapshotRestore(this.status.getCompletionTimestamp() - this.status.getStartTime());
        super.completed(exception);
    }

    @Override
    public boolean isFinished() {
        return this.stopped;
    }

    @Override
    public long getCompletionTimestamp() {
        return this.status.getCompletionTimestamp();
    }

    @Override
    public HBaseProtos.SnapshotDescription getSnapshot() {
        return this.snapshot;
    }

    @Override
    public void cancel(String why) {
        if (this.stopped) {
            return;
        }
        this.stopped = true;
        String msg = "Stopping restore snapshot=" + SnapshotDescriptionUtils.toString(this.snapshot) + " because: " + why;
        LOG.info((Object)msg);
        CancellationException ce = new CancellationException(why);
        this.monitor.receive(new ForeignException(this.masterServices.getServerName().toString(), ce));
    }

    @Override
    public ForeignException getExceptionIfFailed() {
        return this.monitor.getException();
    }

    @Override
    public void rethrowExceptionIfFailed() throws ForeignException {
        this.monitor.rethrowException();
    }
}

