/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hbase.HBaseFileSystem;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.catalog.MetaEditor;
import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.executor.RegionTransitionData;
import org.apache.hadoop.hbase.io.Reference;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CancelableProgressable;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.HasThread;
import org.apache.hadoop.hbase.util.PairOfSameType;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.hbase.zookeeper.ZKAssign;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.io.Writable;
import org.apache.zookeeper.KeeperException;

public class SplitTransaction {
    private static final Log LOG = LogFactory.getLog(SplitTransaction.class);
    private static final String SPLITDIR = ".splits";
    private final HRegion parent;
    private HRegionInfo hri_a;
    private HRegionInfo hri_b;
    private Path splitdir;
    private long fileSplitTimeout = 30000L;
    private int znodeVersion = -1;
    private final byte[] splitrow;
    private final List<JournalEntry> journal = new ArrayList<JournalEntry>();
    private static IOException closedByOtherException = new IOException("Failed to close region: already closed by another thread");

    public SplitTransaction(HRegion r, byte[] splitrow) {
        this.parent = r;
        this.splitrow = splitrow;
        this.splitdir = SplitTransaction.getSplitDir(this.parent);
    }

    public boolean prepare() {
        if (!this.parent.isSplittable()) {
            return false;
        }
        if (this.splitrow == null) {
            return false;
        }
        HRegionInfo hri = this.parent.getRegionInfo();
        this.parent.prepareToSplit();
        byte[] startKey = hri.getStartKey();
        byte[] endKey = hri.getEndKey();
        if (Bytes.equals(startKey, this.splitrow) || !this.parent.getRegionInfo().containsRow(this.splitrow)) {
            LOG.info((Object)("Split row is not inside region key range or is equal to startkey: " + Bytes.toStringBinary(this.splitrow)));
            return false;
        }
        long rid = SplitTransaction.getDaughterRegionIdTimestamp(hri);
        this.hri_a = new HRegionInfo(hri.getTableName(), startKey, this.splitrow, false, rid);
        this.hri_b = new HRegionInfo(hri.getTableName(), this.splitrow, endKey, false, rid);
        return true;
    }

    private static long getDaughterRegionIdTimestamp(HRegionInfo hri) {
        long rid = EnvironmentEdgeManager.currentTimeMillis();
        if (rid < hri.getRegionId()) {
            LOG.warn((Object)("Clock skew; parent regions id is " + hri.getRegionId() + " but current time here is " + rid));
            rid = hri.getRegionId() + 1L;
        }
        return rid;
    }

    PairOfSameType<HRegion> createDaughters(Server server, RegionServerServices services) throws IOException {
        LOG.info((Object)("Starting split of region " + this.parent));
        if (server != null && server.isStopped() || services != null && services.isStopping()) {
            throw new IOException("Server is stopped or stopping");
        }
        assert (!this.parent.lock.writeLock().isHeldByCurrentThread()) : "Unsafe to hold write lock while performing RPCs";
        if (this.parent.getCoprocessorHost() != null) {
            this.parent.getCoprocessorHost().preSplit();
        }
        boolean testing = server == null ? true : server.getConfiguration().getBoolean("hbase.testing.nocluster", false);
        long l = this.fileSplitTimeout = testing ? this.fileSplitTimeout : server.getConfiguration().getLong("hbase.regionserver.fileSplitTimeout", this.fileSplitTimeout);
        if (server != null && server.getZooKeeper() != null) {
            try {
                this.createNodeSplitting(server.getZooKeeper(), this.parent.getRegionInfo(), server.getServerName());
            }
            catch (KeeperException e) {
                throw new IOException("Failed creating SPLITTING znode on " + this.parent.getRegionNameAsString(), e);
            }
        }
        this.journal.add(JournalEntry.SET_SPLITTING_IN_ZK);
        if (server != null && server.getZooKeeper() != null) {
            try {
                this.znodeVersion = this.transitionNodeSplitting(server.getZooKeeper(), this.parent.getRegionInfo(), server.getServerName(), -1);
            }
            catch (KeeperException e) {
                throw new IOException("Failed setting SPLITTING znode on " + this.parent.getRegionNameAsString(), e);
            }
        }
        this.createSplitDir(this.parent.getFilesystem(), this.splitdir);
        this.journal.add(JournalEntry.CREATE_SPLIT_DIR);
        List<StoreFile> hstoreFilesToSplit = null;
        Exception exceptionToThrow = null;
        try {
            hstoreFilesToSplit = this.parent.close(false);
        }
        catch (Exception e) {
            exceptionToThrow = e;
        }
        if (exceptionToThrow == null && hstoreFilesToSplit == null) {
            exceptionToThrow = closedByOtherException;
        }
        if (exceptionToThrow != closedByOtherException) {
            this.journal.add(JournalEntry.CLOSED_PARENT_REGION);
        }
        if (exceptionToThrow != null) {
            if (exceptionToThrow instanceof IOException) {
                throw (IOException)exceptionToThrow;
            }
            throw new IOException(exceptionToThrow);
        }
        if (!testing) {
            services.removeFromOnlineRegions(this.parent.getRegionInfo().getEncodedName());
        }
        this.journal.add(JournalEntry.OFFLINED_PARENT);
        this.splitStoreFiles(this.splitdir, hstoreFilesToSplit);
        this.journal.add(JournalEntry.STARTED_REGION_A_CREATION);
        HRegion a = this.createDaughterRegion(this.hri_a, this.parent.rsServices);
        this.journal.add(JournalEntry.STARTED_REGION_B_CREATION);
        HRegion b = this.createDaughterRegion(this.hri_b, this.parent.rsServices);
        this.journal.add(JournalEntry.PONR);
        if (!testing) {
            MetaEditor.offlineParentInMeta(server.getCatalogTracker(), this.parent.getRegionInfo(), a.getRegionInfo(), b.getRegionInfo());
        }
        return new PairOfSameType<HRegion>(a, b);
    }

    void openDaughters(Server server, RegionServerServices services, HRegion a, HRegion b) throws IOException {
        boolean stopping;
        boolean stopped = server != null && server.isStopped();
        boolean bl = stopping = services != null && services.isStopping();
        if (stopped || stopping) {
            LOG.info((Object)("Not opening daughters " + b.getRegionInfo().getRegionNameAsString() + " and " + a.getRegionInfo().getRegionNameAsString() + " because stopping=" + stopping + ", stopped=" + stopped));
        } else {
            DaughterOpener aOpener = new DaughterOpener(server, a);
            DaughterOpener bOpener = new DaughterOpener(server, b);
            aOpener.start();
            bOpener.start();
            try {
                aOpener.join();
                bOpener.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException("Interrupted " + e.getMessage());
            }
            if (aOpener.getException() != null) {
                throw new IOException("Failed " + aOpener.getName(), aOpener.getException());
            }
            if (bOpener.getException() != null) {
                throw new IOException("Failed " + bOpener.getName(), bOpener.getException());
            }
            if (services != null) {
                try {
                    services.postOpenDeployTasks(b, server.getCatalogTracker(), true);
                    services.addToOnlineRegions(b);
                    services.postOpenDeployTasks(a, server.getCatalogTracker(), true);
                    services.addToOnlineRegions(a);
                }
                catch (KeeperException ke) {
                    throw new IOException(ke);
                }
            }
        }
    }

    void transitionZKNode(Server server, RegionServerServices services, HRegion a, HRegion b) throws IOException {
        if (server != null && server.getZooKeeper() != null) {
            try {
                this.znodeVersion = SplitTransaction.transitionNodeSplit(server.getZooKeeper(), this.parent.getRegionInfo(), a.getRegionInfo(), b.getRegionInfo(), server.getServerName(), this.znodeVersion);
                int spins = 0;
                do {
                    if (spins % 10 == 0) {
                        LOG.debug((Object)("Still waiting on the master to process the split for " + this.parent.getRegionInfo().getEncodedName()));
                    }
                    Thread.sleep(100L);
                    this.znodeVersion = SplitTransaction.tickleNodeSplit(server.getZooKeeper(), this.parent.getRegionInfo(), a.getRegionInfo(), b.getRegionInfo(), server.getServerName(), this.znodeVersion);
                    ++spins;
                } while (this.znodeVersion != -1 && !server.isStopped() && !services.isStopping());
            }
            catch (Exception e) {
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                throw new IOException("Failed telling master about split", e);
            }
        }
        if (this.parent.getCoprocessorHost() != null) {
            this.parent.getCoprocessorHost().postSplit(a, b);
        }
    }

    public PairOfSameType<HRegion> execute(Server server, RegionServerServices services) throws IOException {
        PairOfSameType<HRegion> regions = this.createDaughters(server, services);
        this.openDaughters(server, services, regions.getFirst(), regions.getSecond());
        this.transitionZKNode(server, services, regions.getFirst(), regions.getSecond());
        return regions;
    }

    void openDaughterRegion(Server server, HRegion daughter) throws IOException, KeeperException {
        HRegionInfo hri = daughter.getRegionInfo();
        LoggingProgressable reporter = server == null ? null : new LoggingProgressable(hri, server.getConfiguration());
        daughter.openHRegion(reporter);
    }

    private static Path getSplitDir(HRegion r) {
        return new Path(r.getRegionDir(), SPLITDIR);
    }

    void createSplitDir(FileSystem fs, Path splitdir) throws IOException {
        if (fs.exists(splitdir)) {
            LOG.info((Object)("The " + splitdir + " directory exists.  Hence deleting it to recreate it"));
            if (!HBaseFileSystem.deleteDirFromFileSystem(fs, splitdir)) {
                throw new IOException("Failed deletion of " + splitdir + " before creating them again.");
            }
        }
        if (!HBaseFileSystem.makeDirOnFileSystem(fs, splitdir)) {
            throw new IOException("Failed create of " + splitdir);
        }
    }

    private static void cleanupSplitDir(FileSystem fs, Path splitdir) throws IOException {
        SplitTransaction.deleteDir(fs, splitdir, false);
    }

    private static void deleteDir(FileSystem fs, Path dir, boolean mustPreExist) throws IOException {
        if (!fs.exists(dir)) {
            if (mustPreExist) {
                throw new IOException(dir.toString() + " does not exist!");
            }
        } else if (!HBaseFileSystem.deleteDirFromFileSystem(fs, dir)) {
            throw new IOException("Failed delete of " + dir);
        }
    }

    private void splitStoreFiles(Path splitdir, List<StoreFile> hstoreFilesToSplit) throws IOException {
        if (hstoreFilesToSplit == null) {
            throw new IOException("Close returned empty list of StoreFiles");
        }
        int nbFiles = hstoreFilesToSplit.size();
        if (nbFiles == 0) {
            return;
        }
        ThreadFactoryBuilder builder = new ThreadFactoryBuilder();
        builder.setNameFormat("StoreFileSplitter-%1$d");
        ThreadFactory factory = builder.build();
        ThreadPoolExecutor threadPool = (ThreadPoolExecutor)Executors.newFixedThreadPool(nbFiles, factory);
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>(nbFiles);
        for (StoreFile storeFile : hstoreFilesToSplit) {
            StoreFileSplitter sfs = new StoreFileSplitter(storeFile, splitdir);
            futures.add(threadPool.submit(sfs));
        }
        threadPool.shutdown();
        try {
            boolean stillRunning;
            boolean bl = stillRunning = !threadPool.awaitTermination(this.fileSplitTimeout, TimeUnit.MILLISECONDS);
            if (stillRunning) {
                threadPool.shutdownNow();
                while (!threadPool.isTerminated()) {
                    Thread.sleep(50L);
                }
                throw new IOException("Took too long to split the files and create the references, aborting split");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Interrupted while waiting for file splitters", e);
        }
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException("Interrupted while trying to get the results of file splitters", e);
            }
            catch (ExecutionException e) {
                throw new IOException(e);
            }
        }
    }

    private void splitStoreFile(StoreFile sf, Path splitdir) throws IOException {
        FileSystem fs = this.parent.getFilesystem();
        byte[] family = sf.getFamily();
        String encoded = this.hri_a.getEncodedName();
        Path storedir = Store.getStoreHomedir(splitdir, encoded, family);
        StoreFile.split(fs, storedir, sf, this.splitrow, Reference.Range.bottom);
        encoded = this.hri_b.getEncodedName();
        storedir = Store.getStoreHomedir(splitdir, encoded, family);
        StoreFile.split(fs, storedir, sf, this.splitrow, Reference.Range.top);
    }

    HRegion createDaughterRegion(HRegionInfo hri, RegionServerServices rsServices) throws IOException {
        FileSystem fs = this.parent.getFilesystem();
        Path regionDir = SplitTransaction.getSplitDirForDaughter(this.parent.getFilesystem(), this.splitdir, hri);
        HRegion r = HRegion.newHRegion(this.parent.getTableDir(), this.parent.getLog(), fs, this.parent.getBaseConf(), hri, this.parent.getTableDesc(), rsServices);
        long halfParentReadRequestCount = this.parent.getReadRequestsCount() / 2L;
        r.readRequestsCount.set(halfParentReadRequestCount);
        r.setOpMetricsReadRequestCount(halfParentReadRequestCount);
        long halfParentWriteRequest = this.parent.getWriteRequestsCount() / 2L;
        r.writeRequestsCount.set(halfParentWriteRequest);
        r.setOpMetricsWriteRequestCount(halfParentWriteRequest);
        HRegion.moveInitialFilesIntoPlace(fs, regionDir, r.getRegionDir());
        return r;
    }

    private static void cleanupDaughterRegion(FileSystem fs, Path tabledir, String encodedName) throws IOException {
        Path regiondir = HRegion.getRegionDir(tabledir, encodedName);
        SplitTransaction.deleteDir(fs, regiondir, false);
    }

    private static Path getSplitDirForDaughter(FileSystem fs, Path splitdir, HRegionInfo hri) throws IOException {
        return new Path(splitdir, hri.getEncodedName());
    }

    public boolean rollback(Server server, RegionServerServices services) throws IOException {
        boolean result = true;
        FileSystem fs = this.parent.getFilesystem();
        ListIterator<JournalEntry> iterator = this.journal.listIterator(this.journal.size());
        block11: while (iterator.hasPrevious()) {
            JournalEntry je = iterator.previous();
            switch (je) {
                case SET_SPLITTING_IN_ZK: {
                    if (server == null || server.getZooKeeper() == null) continue block11;
                    SplitTransaction.cleanZK(server, this.parent.getRegionInfo());
                    continue block11;
                }
                case CREATE_SPLIT_DIR: {
                    this.parent.writestate.writesEnabled = true;
                    SplitTransaction.cleanupSplitDir(fs, this.splitdir);
                    continue block11;
                }
                case CLOSED_PARENT_REGION: {
                    try {
                        this.parent.initialize();
                        continue block11;
                    }
                    catch (IOException e) {
                        LOG.error((Object)("Failed rollbacking CLOSED_PARENT_REGION of region " + this.parent.getRegionNameAsString()), (Throwable)e);
                        throw new RuntimeException(e);
                    }
                }
                case STARTED_REGION_A_CREATION: {
                    SplitTransaction.cleanupDaughterRegion(fs, this.parent.getTableDir(), this.hri_a.getEncodedName());
                    continue block11;
                }
                case STARTED_REGION_B_CREATION: {
                    SplitTransaction.cleanupDaughterRegion(fs, this.parent.getTableDir(), this.hri_b.getEncodedName());
                    continue block11;
                }
                case OFFLINED_PARENT: {
                    if (services == null) continue block11;
                    services.addToOnlineRegions(this.parent);
                    continue block11;
                }
                case PONR: {
                    return false;
                }
            }
            throw new RuntimeException("Unhandled journal entry: " + (Object)((Object)je));
        }
        return result;
    }

    HRegionInfo getFirstDaughter() {
        return this.hri_a;
    }

    HRegionInfo getSecondDaughter() {
        return this.hri_b;
    }

    Path getSplitDir() {
        return this.splitdir;
    }

    static void cleanupAnySplitDetritus(HRegion r) throws IOException {
        Path splitdir = SplitTransaction.getSplitDir(r);
        FileSystem fs = r.getFilesystem();
        if (!fs.exists(splitdir)) {
            return;
        }
        FileStatus[] daughters = fs.listStatus(splitdir, (PathFilter)new FSUtils.DirFilter(fs));
        for (int i = 0; i < daughters.length; ++i) {
            SplitTransaction.cleanupDaughterRegion(fs, r.getTableDir(), daughters[i].getPath().getName());
        }
        SplitTransaction.cleanupSplitDir(r.getFilesystem(), splitdir);
        LOG.info((Object)("Cleaned up old failed split transaction detritus: " + splitdir));
    }

    private static void cleanZK(Server server, HRegionInfo hri) {
        try {
            ZKAssign.deleteNode(server.getZooKeeper(), hri.getEncodedName(), EventHandler.EventType.RS_ZK_REGION_SPLITTING);
        }
        catch (KeeperException e) {
            server.abort("Failed cleanup of " + hri.getRegionNameAsString(), e);
        }
    }

    void createNodeSplitting(ZooKeeperWatcher zkw, HRegionInfo region, ServerName serverName) throws KeeperException, IOException {
        LOG.debug((Object)zkw.prefix("Creating ephemeral node for " + region.getEncodedName() + " in SPLITTING state"));
        RegionTransitionData data = new RegionTransitionData(EventHandler.EventType.RS_ZK_REGION_SPLITTING, region.getRegionName(), serverName);
        String node = ZKAssign.getNodeName(zkw, region.getEncodedName());
        if (!ZKUtil.createEphemeralNodeAndWatch(zkw, node, data.getBytes())) {
            throw new IOException("Failed create of ephemeral " + node);
        }
    }

    private static int transitionNodeSplit(ZooKeeperWatcher zkw, HRegionInfo parent, HRegionInfo a, HRegionInfo b, ServerName serverName, int znodeVersion) throws KeeperException, IOException {
        byte[] payload = Writables.getBytes(new Writable[]{a, b});
        return ZKAssign.transitionNode(zkw, parent, serverName, EventHandler.EventType.RS_ZK_REGION_SPLITTING, EventHandler.EventType.RS_ZK_REGION_SPLIT, znodeVersion, payload);
    }

    int transitionNodeSplitting(ZooKeeperWatcher zkw, HRegionInfo parent, ServerName serverName, int version) throws KeeperException, IOException {
        return ZKAssign.transitionNode(zkw, parent, serverName, EventHandler.EventType.RS_ZK_REGION_SPLITTING, EventHandler.EventType.RS_ZK_REGION_SPLITTING, version);
    }

    private static int tickleNodeSplit(ZooKeeperWatcher zkw, HRegionInfo parent, HRegionInfo a, HRegionInfo b, ServerName serverName, int znodeVersion) throws KeeperException, IOException {
        byte[] payload = Writables.getBytes(new Writable[]{a, b});
        return ZKAssign.transitionNode(zkw, parent, serverName, EventHandler.EventType.RS_ZK_REGION_SPLIT, EventHandler.EventType.RS_ZK_REGION_SPLIT, znodeVersion, payload);
    }

    class StoreFileSplitter
    implements Callable<Void> {
        private final StoreFile sf;
        private final Path splitdir;

        public StoreFileSplitter(StoreFile sf, Path splitdir) {
            this.sf = sf;
            this.splitdir = splitdir;
        }

        @Override
        public Void call() throws IOException {
            SplitTransaction.this.splitStoreFile(this.sf, this.splitdir);
            return null;
        }
    }

    static class LoggingProgressable
    implements CancelableProgressable {
        private final HRegionInfo hri;
        private long lastLog = -1L;
        private final long interval;

        LoggingProgressable(HRegionInfo hri, Configuration c) {
            this.hri = hri;
            this.interval = c.getLong("hbase.regionserver.split.daughter.open.log.interval", 10000L);
        }

        @Override
        public boolean progress() {
            long now = System.currentTimeMillis();
            if (now - this.lastLog > this.interval) {
                LOG.info((Object)("Opening " + this.hri.getRegionNameAsString()));
                this.lastLog = now;
            }
            return true;
        }
    }

    class DaughterOpener
    extends HasThread {
        private final Server server;
        private final HRegion r;
        private Throwable t;

        DaughterOpener(Server s, HRegion r) {
            super((s == null ? "null-services" : s.getServerName()) + "-daughterOpener=" + r.getRegionInfo().getEncodedName());
            this.t = null;
            this.setDaemon(true);
            this.server = s;
            this.r = r;
        }

        Throwable getException() {
            return this.t;
        }

        @Override
        public void run() {
            try {
                SplitTransaction.this.openDaughterRegion(this.server, this.r);
            }
            catch (Throwable t) {
                this.t = t;
            }
        }
    }

    static enum JournalEntry {
        SET_SPLITTING_IN_ZK,
        CREATE_SPLIT_DIR,
        CLOSED_PARENT_REGION,
        OFFLINED_PARENT,
        STARTED_REGION_A_CREATION,
        STARTED_REGION_B_CREATION,
        PONR;

    }
}

