/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.replication.ReplicationZookeeper;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSource;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceInterface;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperListener;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

public class ReplicationSourceManager {
    private static final Log LOG = LogFactory.getLog(ReplicationSourceManager.class);
    private final List<ReplicationSourceInterface> sources;
    private final List<ReplicationSourceInterface> oldsources;
    private final AtomicBoolean replicating;
    private final ReplicationZookeeper zkHelper;
    private final Stoppable stopper;
    private final Map<String, SortedSet<String>> hlogsById;
    private final Configuration conf;
    private final FileSystem fs;
    private Path latestPath;
    private final List<String> otherRegionServers = new ArrayList<String>();
    private final Path logDir;
    private final Path oldLogDir;
    private final long sleepBeforeFailover;
    private final ThreadPoolExecutor executor;
    private final Random rand;

    public ReplicationSourceManager(ReplicationZookeeper zkHelper, Configuration conf, Stoppable stopper, FileSystem fs, AtomicBoolean replicating, Path logDir, Path oldLogDir) {
        this.sources = new ArrayList<ReplicationSourceInterface>();
        this.replicating = replicating;
        this.zkHelper = zkHelper;
        this.stopper = stopper;
        this.hlogsById = new HashMap<String, SortedSet<String>>();
        this.oldsources = new ArrayList<ReplicationSourceInterface>();
        this.conf = conf;
        this.fs = fs;
        this.logDir = logDir;
        this.oldLogDir = oldLogDir;
        this.sleepBeforeFailover = conf.getLong("replication.sleep.before.failover", 2000L);
        this.zkHelper.registerRegionServerListener(new OtherRegionServerWatcher(this.zkHelper.getZookeeperWatcher()));
        this.zkHelper.registerRegionServerListener(new PeersWatcher(this.zkHelper.getZookeeperWatcher()));
        this.zkHelper.listPeersIdsAndWatch();
        int nbWorkers = conf.getInt("replication.executor.workers", 1);
        this.executor = new ThreadPoolExecutor(nbWorkers, nbWorkers, 100L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        ThreadFactoryBuilder tfb = new ThreadFactoryBuilder();
        tfb.setNameFormat("ReplicationExecutor-%d");
        this.executor.setThreadFactory(tfb.build());
        this.rand = new Random();
    }

    public void logPositionAndCleanOldLogs(Path log, String id, long position, boolean queueRecovered, boolean holdLogInZK) {
        String key = log.getName();
        LOG.info((Object)("Going to report log #" + key + " for position " + position + " in " + log));
        this.zkHelper.writeReplicationStatus(key, id, position);
        if (holdLogInZK) {
            return;
        }
        this.cleanOldLogs(key, id, queueRecovered);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanOldLogs(String key, String id, boolean queueRecovered) {
        Map<String, SortedSet<String>> map = this.hlogsById;
        synchronized (map) {
            SortedSet<String> hlogs = this.hlogsById.get(id);
            if (queueRecovered || hlogs.first().equals(key)) {
                return;
            }
            SortedSet<String> hlogSet = hlogs.headSet(key);
            for (String hlog : hlogSet) {
                this.zkHelper.removeLogFromList(hlog, id);
            }
            hlogSet.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws IOException {
        for (String string : this.zkHelper.getPeerClusters().keySet()) {
            this.addSource(string);
        }
        List<String> currentReplicators = this.zkHelper.getListOfReplicators();
        if (currentReplicators == null || currentReplicators.size() == 0) {
            return;
        }
        List<String> list = this.otherRegionServers;
        synchronized (list) {
            this.refreshOtherRegionServersList();
            LOG.info((Object)("Current list of replicators: " + currentReplicators + " other RSs: " + this.otherRegionServers));
        }
        for (String rs : currentReplicators) {
            List<String> list2 = this.otherRegionServers;
            synchronized (list2) {
                if (!this.otherRegionServers.contains(rs)) {
                    this.transferQueues(rs);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReplicationSourceInterface addSource(String id) throws IOException {
        ReplicationSourceInterface src = this.getReplicationSource(this.conf, this.fs, this, this.stopper, this.replicating, id);
        Map<String, SortedSet<String>> map = this.hlogsById;
        synchronized (map) {
            this.sources.add(src);
            this.hlogsById.put(id, new TreeSet());
            if (this.latestPath != null) {
                String name = this.latestPath.getName();
                this.hlogsById.get(id).add(name);
                try {
                    this.zkHelper.addLogToList(name, src.getPeerClusterZnode());
                }
                catch (KeeperException ke) {
                    String message = "Cannot add log to zk for replication when creating a new source";
                    this.stopper.stop(message);
                    throw new IOException(message, ke);
                }
                src.enqueueLog(this.latestPath);
            }
        }
        src.startup();
        return src;
    }

    public void join() {
        this.executor.shutdown();
        if (this.sources.size() == 0) {
            this.zkHelper.deleteOwnRSZNode();
        }
        for (ReplicationSourceInterface source : this.sources) {
            source.terminate("Region server is closing");
        }
    }

    protected Map<String, SortedSet<String>> getHLogs() {
        return Collections.unmodifiableMap(this.hlogsById);
    }

    public List<ReplicationSourceInterface> getSources() {
        return this.sources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void preLogRoll(Path newLog) throws IOException {
        if (!this.replicating.get()) {
            LOG.warn((Object)"Replication stopped, won't add new log");
            return;
        }
        Map<String, SortedSet<String>> map = this.hlogsById;
        synchronized (map) {
            String name = newLog.getName();
            for (ReplicationSourceInterface replicationSourceInterface : this.sources) {
                try {
                    this.zkHelper.addLogToList(name, replicationSourceInterface.getPeerClusterZnode());
                }
                catch (KeeperException ke) {
                    throw new IOException("Cannot add log to zk for replication", ke);
                }
            }
            for (SortedSet sortedSet : this.hlogsById.values()) {
                if (this.sources.isEmpty()) {
                    sortedSet.clear();
                }
                sortedSet.add(name);
            }
        }
        this.latestPath = newLog;
    }

    void postLogRoll(Path newLog) throws IOException {
        if (!this.replicating.get()) {
            LOG.warn((Object)"Replication stopped, won't add new log");
            return;
        }
        for (ReplicationSourceInterface source : this.sources) {
            source.enqueueLog(newLog);
        }
    }

    public ReplicationZookeeper getRepZkWrapper() {
        return this.zkHelper;
    }

    public ReplicationSourceInterface getReplicationSource(Configuration conf, FileSystem fs, ReplicationSourceManager manager, Stoppable stopper, AtomicBoolean replicating, String peerId) throws IOException {
        ReplicationSourceInterface src;
        try {
            Class<?> c = Class.forName(conf.get("replication.replicationsource.implementation", ReplicationSource.class.getCanonicalName()));
            src = (ReplicationSourceInterface)c.newInstance();
        }
        catch (Exception e) {
            LOG.warn((Object)"Passed replication source implementation throws errors, defaulting to ReplicationSource", (Throwable)e);
            src = new ReplicationSource();
        }
        src.init(conf, fs, manager, stopper, replicating, peerId);
        return src;
    }

    public void transferQueues(String rsZnode) {
        NodeFailoverWorker transfer = new NodeFailoverWorker(rsZnode);
        try {
            this.executor.execute(transfer);
        }
        catch (RejectedExecutionException ex) {
            LOG.info((Object)("Cancelling the transfer of " + rsZnode + " because of " + ex.getMessage()));
        }
    }

    public void closeRecoveredQueue(ReplicationSourceInterface src) {
        LOG.info((Object)("Done with the recovered queue " + src.getPeerClusterZnode()));
        this.oldsources.remove(src);
        this.zkHelper.deleteSource(src.getPeerClusterZnode(), false);
    }

    public void removePeer(String id) {
        LOG.info((Object)("Closing the following queue " + id + ", currently have " + this.sources.size() + " and another " + this.oldsources.size() + " that were recovered"));
        String terminateMessage = "Replication stream was removed by a user";
        ReplicationSourceInterface srcToRemove = null;
        ArrayList<ReplicationSourceInterface> oldSourcesToDelete = new ArrayList<ReplicationSourceInterface>();
        for (ReplicationSourceInterface src : this.oldsources) {
            if (!id.equals(src.getPeerClusterId())) continue;
            oldSourcesToDelete.add(src);
        }
        for (ReplicationSourceInterface src : oldSourcesToDelete) {
            src.terminate(terminateMessage);
            this.closeRecoveredQueue(src);
        }
        LOG.info((Object)("Number of deleted recovered sources for " + id + ": " + oldSourcesToDelete.size()));
        for (ReplicationSourceInterface src : this.sources) {
            if (!id.equals(src.getPeerClusterId())) continue;
            srcToRemove = src;
            break;
        }
        if (srcToRemove == null) {
            LOG.error((Object)("The queue we wanted to close is missing " + id));
            return;
        }
        srcToRemove.terminate(terminateMessage);
        this.sources.remove(srcToRemove);
        this.zkHelper.deleteSource(id, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean refreshOtherRegionServersList() {
        List<String> newRsList = this.zkHelper.getRegisteredRegionServers();
        if (newRsList == null) {
            return false;
        }
        List<String> list = this.otherRegionServers;
        synchronized (list) {
            this.otherRegionServers.clear();
            this.otherRegionServers.addAll(newRsList);
        }
        return true;
    }

    public Path getOldLogDir() {
        return this.oldLogDir;
    }

    public Path getLogDir() {
        return this.logDir;
    }

    public FileSystem getFs() {
        return this.fs;
    }

    class NodeFailoverWorker
    extends Thread {
        private String rsZnode;

        public NodeFailoverWorker(String rsZnode) {
            super("Failover-for-" + rsZnode);
            this.rsZnode = rsZnode;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(ReplicationSourceManager.this.sleepBeforeFailover + (long)(ReplicationSourceManager.this.rand.nextFloat() * (float)ReplicationSourceManager.this.sleepBeforeFailover));
            }
            catch (InterruptedException e) {
                LOG.warn((Object)"Interrupted while waiting before transferring a queue.");
                Thread.currentThread().interrupt();
            }
            if (ReplicationSourceManager.this.stopper.isStopped()) {
                LOG.info((Object)"Not transferring queue since we are shutting down");
                return;
            }
            SortedMap<String, SortedSet<String>> newQueues = null;
            if (ReplicationSourceManager.this.conf.getBoolean("hbase.zookeeper.useMulti", true)) {
                LOG.info((Object)("Atomically moving " + this.rsZnode + "'s hlogs to my queue"));
                newQueues = ReplicationSourceManager.this.zkHelper.copyQueuesFromRSUsingMulti(this.rsZnode);
            } else {
                LOG.info((Object)("Moving " + this.rsZnode + "'s hlogs to my queue"));
                if (!ReplicationSourceManager.this.zkHelper.lockOtherRS(this.rsZnode)) {
                    return;
                }
                newQueues = ReplicationSourceManager.this.zkHelper.copyQueuesFromRS(this.rsZnode);
                ReplicationSourceManager.this.zkHelper.deleteRsQueues(this.rsZnode);
            }
            if (newQueues.isEmpty()) {
                return;
            }
            for (Map.Entry<String, SortedSet<String>> entry : newQueues.entrySet()) {
                String peerId = entry.getKey();
                try {
                    ReplicationSourceInterface src = ReplicationSourceManager.this.getReplicationSource(ReplicationSourceManager.this.conf, ReplicationSourceManager.this.fs, ReplicationSourceManager.this, ReplicationSourceManager.this.stopper, ReplicationSourceManager.this.replicating, peerId);
                    if (!ReplicationSourceManager.this.zkHelper.getPeerClusters().containsKey(src.getPeerClusterId())) {
                        src.terminate("Recovered queue doesn't belong to any current peer");
                        break;
                    }
                    ReplicationSourceManager.this.oldsources.add(src);
                    for (String hlog : entry.getValue()) {
                        src.enqueueLog(new Path(ReplicationSourceManager.this.oldLogDir, hlog));
                    }
                    src.startup();
                }
                catch (IOException e) {
                    LOG.error((Object)"Failed creating a source", (Throwable)e);
                }
            }
        }
    }

    public class PeersWatcher
    extends ZooKeeperListener {
        public PeersWatcher(ZooKeeperWatcher watcher) {
            super(watcher);
        }

        @Override
        public void nodeDeleted(String path) {
            List<String> peers = this.refreshPeersList(path);
            if (peers == null) {
                return;
            }
            String id = ReplicationZookeeper.getZNodeName(path);
            ReplicationSourceManager.this.removePeer(id);
        }

        @Override
        public void nodeChildrenChanged(String path) {
            List<String> peers = this.refreshPeersList(path);
            if (peers == null) {
                return;
            }
            for (String id : peers) {
                try {
                    boolean added = ReplicationSourceManager.this.zkHelper.connectToPeer(id);
                    if (!added) continue;
                    ReplicationSourceManager.this.addSource(id);
                }
                catch (IOException e) {
                    LOG.error((Object)"Error while adding a new peer", (Throwable)e);
                }
                catch (KeeperException e) {
                    LOG.error((Object)"Error while adding a new peer", (Throwable)e);
                }
            }
        }

        private List<String> refreshPeersList(String path) {
            if (!path.startsWith(ReplicationSourceManager.this.zkHelper.getPeersZNode())) {
                return null;
            }
            return ReplicationSourceManager.this.zkHelper.listPeersIdsAndWatch();
        }
    }

    public class OtherRegionServerWatcher
    extends ZooKeeperListener {
        public OtherRegionServerWatcher(ZooKeeperWatcher watcher) {
            super(watcher);
        }

        @Override
        public void nodeCreated(String path) {
            this.refreshListIfRightPath(path);
        }

        @Override
        public void nodeDeleted(String path) {
            if (ReplicationSourceManager.this.stopper.isStopped()) {
                return;
            }
            boolean cont = this.refreshListIfRightPath(path);
            if (!cont) {
                return;
            }
            LOG.info((Object)(path + " znode expired, trying to lock it"));
            ReplicationSourceManager.this.transferQueues(ReplicationZookeeper.getZNodeName(path));
        }

        @Override
        public void nodeChildrenChanged(String path) {
            if (ReplicationSourceManager.this.stopper.isStopped()) {
                return;
            }
            this.refreshListIfRightPath(path);
        }

        private boolean refreshListIfRightPath(String path) {
            if (!path.startsWith(((ReplicationSourceManager)ReplicationSourceManager.this).zkHelper.getZookeeperWatcher().rsZNode)) {
                return false;
            }
            return ReplicationSourceManager.this.refreshOtherRegionServersList();
        }
    }
}

