/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hbase.mapping;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.steps.hbaseinput.HBaseInputData;
import org.pentaho.di.trans.steps.hbaseinput.Messages;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.ComboValuesSelectionListener;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.hbase.mapping.ConfigurationProducer;
import org.pentaho.hbase.mapping.FieldProducer;
import org.pentaho.hbase.mapping.MappingAdmin;
import org.pentaho.hbase.shim.api.HBaseValueMeta;
import org.pentaho.hbase.shim.api.Mapping;
import org.pentaho.hbase.shim.spi.HBaseConnection;

public class MappingEditor
extends Composite
implements ConfigurationProducer {
    protected Shell m_shell;
    protected Composite m_parent;
    protected boolean m_allowTableCreate;
    protected TextVar m_zookeeperHostText;
    protected TextVar m_zookeeperPortText;
    protected CCombo m_existingTableNamesCombo;
    protected Button m_getTableNames;
    protected boolean m_familiesInvalidated;
    protected CCombo m_existingMappingNamesCombo;
    protected TableView m_fieldsView;
    protected ColumnInfo m_keyCI;
    protected ColumnInfo m_familyCI;
    protected ColumnInfo m_typeCI;
    protected Button m_saveBut;
    protected Button m_deleteBut;
    protected Button m_getFieldsBut;
    protected Button m_keyValueTupleBut;
    protected MappingAdmin m_admin;
    protected ConfigurationProducer m_configProducer;
    protected FieldProducer m_incomingFieldsProducer;
    protected static final String DEFAULT_FAMILY = "Family1";
    protected String m_currentConfiguration = "";
    protected boolean m_connectionProblem;
    protected TransMeta m_transMeta;

    public MappingEditor(Shell shell, Composite parent, ConfigurationProducer configProducer, FieldProducer fieldProducer, int tableViewStyle, boolean allowTableCreate, PropsUI props, TransMeta transMeta) {
        super(parent, 0);
        FormData fd;
        this.m_shell = shell;
        this.m_parent = parent;
        this.m_transMeta = transMeta;
        boolean showConnectWidgets = false;
        this.m_configProducer = configProducer;
        if (this.m_configProducer != null) {
            this.m_currentConfiguration = this.m_configProducer.getCurrentConfiguration();
        } else {
            showConnectWidgets = true;
            this.m_configProducer = this;
        }
        this.m_incomingFieldsProducer = fieldProducer;
        this.m_allowTableCreate = allowTableCreate;
        int middle = props.getMiddlePct();
        int margin = 4;
        FormLayout controlLayout = new FormLayout();
        controlLayout.marginWidth = 3;
        controlLayout.marginHeight = 3;
        this.setLayout((Layout)controlLayout);
        props.setLook((Control)this);
        if (showConnectWidgets) {
            Label zooHostLab = new Label((Composite)this, 131072);
            zooHostLab.setText("Zookeeper host");
            props.setLook((Control)zooHostLab);
            fd = new FormData();
            fd.left = new FormAttachment(0, 0);
            fd.top = new FormAttachment(0, margin);
            fd.right = new FormAttachment(middle, -margin);
            zooHostLab.setLayoutData((Object)fd);
            this.m_zookeeperHostText = new TextVar((VariableSpace)transMeta, (Composite)this, 18436);
            props.setLook((Control)this.m_zookeeperHostText);
            fd = new FormData();
            fd.left = new FormAttachment(middle, 0);
            fd.top = new FormAttachment(0, margin);
            fd.right = new FormAttachment(100, 0);
            this.m_zookeeperHostText.setLayoutData((Object)fd);
            Label zooPortLab = new Label((Composite)this, 131072);
            zooPortLab.setText("Zookeeper port");
            props.setLook((Control)zooPortLab);
            fd = new FormData();
            fd.left = new FormAttachment(0, 0);
            fd.top = new FormAttachment((Control)this.m_zookeeperHostText, margin);
            fd.right = new FormAttachment(middle, -margin);
            zooPortLab.setLayoutData((Object)fd);
            this.m_zookeeperPortText = new TextVar((VariableSpace)transMeta, (Composite)this, 18436);
            props.setLook((Control)this.m_zookeeperPortText);
            fd = new FormData();
            fd.left = new FormAttachment(middle, 0);
            fd.top = new FormAttachment((Control)this.m_zookeeperHostText, margin);
            fd.right = new FormAttachment(100, 0);
            this.m_zookeeperPortText.setLayoutData((Object)fd);
            this.m_currentConfiguration = this.m_configProducer.getCurrentConfiguration();
        }
        Label tableNameLab = new Label((Composite)this, 131072);
        tableNameLab.setText(Messages.getString("MappingDialog.TableName.Label"));
        props.setLook((Control)tableNameLab);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = showConnectWidgets ? new FormAttachment((Control)this.m_zookeeperPortText, margin) : new FormAttachment(0, margin);
        fd.right = new FormAttachment(middle, -margin);
        tableNameLab.setLayoutData((Object)fd);
        this.m_getTableNames = new Button((Composite)this, 0x1000008);
        props.setLook((Control)this.m_getTableNames);
        this.m_getTableNames.setText(Messages.getString("MappingDialog.TableName.GetTableNames"));
        fd = new FormData();
        fd.right = new FormAttachment(100, 0);
        fd.top = showConnectWidgets ? new FormAttachment((Control)this.m_zookeeperPortText, 0) : new FormAttachment(0, 0);
        this.m_getTableNames.setLayoutData((Object)fd);
        this.m_getTableNames.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MappingEditor.this.populateTableCombo(false);
            }
        });
        this.m_existingTableNamesCombo = new CCombo((Composite)this, 2048);
        props.setLook((Control)this.m_existingTableNamesCombo);
        fd = new FormData();
        fd.left = new FormAttachment(middle, 0);
        fd.right = new FormAttachment((Control)this.m_getTableNames, -margin);
        fd.top = showConnectWidgets ? new FormAttachment((Control)this.m_zookeeperPortText, margin) : new FormAttachment(0, margin);
        this.m_existingTableNamesCombo.setLayoutData((Object)fd);
        this.m_existingTableNamesCombo.setEditable(this.m_allowTableCreate);
        Label mappingNameLab = new Label((Composite)this, 131072);
        mappingNameLab.setText(Messages.getString("MappingDialog.MappingName.Label"));
        props.setLook((Control)tableNameLab);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.m_getTableNames, 0);
        fd.right = new FormAttachment(middle, -margin);
        mappingNameLab.setLayoutData((Object)fd);
        this.m_existingMappingNamesCombo = new CCombo((Composite)this, 2048);
        props.setLook((Control)this.m_existingMappingNamesCombo);
        fd = new FormData();
        fd.left = new FormAttachment(middle, 0);
        fd.top = new FormAttachment((Control)this.m_getTableNames, 0);
        fd.right = new FormAttachment(100, 0);
        this.m_existingMappingNamesCombo.setLayoutData((Object)fd);
        this.m_existingTableNamesCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MappingEditor.this.m_familiesInvalidated = true;
                MappingEditor.this.populateMappingComboAndFamilyStuff();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                MappingEditor.this.m_familiesInvalidated = true;
                MappingEditor.this.populateMappingComboAndFamilyStuff();
            }
        });
        this.m_existingTableNamesCombo.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                MappingEditor.this.m_familiesInvalidated = true;
            }
        });
        this.m_existingTableNamesCombo.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                MappingEditor.this.m_familiesInvalidated = true;
                MappingEditor.this.populateMappingComboAndFamilyStuff();
            }
        });
        this.m_existingMappingNamesCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MappingEditor.this.loadTableViewFromMapping();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                MappingEditor.this.loadTableViewFromMapping();
            }
        });
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(Messages.getString("HBaseInputDialog.Fields.FIELD_ALIAS"), 1, false), new ColumnInfo(Messages.getString("HBaseInputDialog.Fields.FIELD_KEY"), 2, true), new ColumnInfo(Messages.getString("HBaseInputDialog.Fields.FIELD_FAMILY"), 2, true), new ColumnInfo(Messages.getString("HBaseInputDialog.Fields.FIELD_NAME"), 1, false), new ColumnInfo(Messages.getString("HBaseInputDialog.Fields.FIELD_TYPE"), 2, true), new ColumnInfo(Messages.getString("HBaseInputDialog.Fields.FIELD_INDEXED"), 1, false)};
        this.m_keyCI = colinf[1];
        this.m_keyCI.setComboValues(new String[]{"N", "Y"});
        this.m_familyCI = colinf[2];
        this.m_familyCI.setComboValues(new String[]{""});
        this.m_typeCI = colinf[4];
        this.m_typeCI.setComboValues(new String[]{"String", "Integer", "Long", "Float", "Double", "Date", "BigNumber", "Serializable", "Binary"});
        this.m_keyCI.setComboValuesSelectionListener(new ComboValuesSelectionListener(){

            public String[] getComboValues(TableItem tableItem, int rowNr, int colNr) {
                tableItem.setText(5, "");
                return MappingEditor.this.m_keyCI.getComboValues();
            }
        });
        this.m_typeCI.setComboValuesSelectionListener(new ComboValuesSelectionListener(){

            public String[] getComboValues(TableItem tableItem, int rowNr, int colNr) {
                String[] comboValues = null;
                String keyOrNot = tableItem.getText(2);
                comboValues = Const.isEmpty((String)keyOrNot) || keyOrNot.equalsIgnoreCase("N") ? new String[]{"String", "Integer", "Long", "Float", "Double", "Boolean", "Date", "BigNumber", "Serializable", "Binary"} : new String[]{"String", "Integer", "UnsignedInteger", "Long", "UnsignedLong", "Date", "UnsignedDate", "Binary"};
                return comboValues;
            }
        });
        this.m_saveBut = new Button((Composite)this, 0x1000008);
        props.setLook((Control)this.m_saveBut);
        this.m_saveBut.setText(Messages.getString("MappingDialog.SaveMapping"));
        this.m_saveBut.setToolTipText(Messages.getString("MappingDialog.SaveMapping.TipText"));
        fd = new FormData();
        fd.left = new FormAttachment(0, margin);
        fd.bottom = new FormAttachment(100, -margin * 2);
        this.m_saveBut.setLayoutData((Object)fd);
        this.m_saveBut.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MappingEditor.this.saveMapping();
            }
        });
        this.m_deleteBut = new Button((Composite)this, 0x1000008);
        props.setLook((Control)this.m_deleteBut);
        this.m_deleteBut.setText(Messages.getString("MappingDialog.DeleteMapping"));
        fd = new FormData();
        fd.left = new FormAttachment((Control)this.m_saveBut, margin);
        fd.bottom = new FormAttachment(100, -margin * 2);
        this.m_deleteBut.setLayoutData((Object)fd);
        this.m_deleteBut.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MappingEditor.this.deleteMapping();
            }
        });
        if (this.m_allowTableCreate) {
            this.m_getFieldsBut = new Button((Composite)this, 0x1000008);
            props.setLook((Control)this.m_getFieldsBut);
            this.m_getFieldsBut.setText(Messages.getString("MappingDialog.GetIncomingFields"));
            fd = new FormData();
            fd.right = new FormAttachment(100, 0);
            fd.bottom = new FormAttachment(100, -margin * 2);
            this.m_getFieldsBut.setLayoutData((Object)fd);
            this.m_getFieldsBut.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MappingEditor.this.populateTableWithIncomingFields();
                }
            });
        } else {
            this.m_keyValueTupleBut = new Button((Composite)this, 0x1000008);
            props.setLook((Control)this.m_keyValueTupleBut);
            this.m_keyValueTupleBut.setText(Messages.getString("MappingDialog.KeyValueTemplate"));
            this.m_keyValueTupleBut.setToolTipText(Messages.getString("MappingDialog.KeyValueTemplate.TipText"));
            fd = new FormData();
            fd.right = new FormAttachment(100, 0);
            fd.bottom = new FormAttachment(100, -margin * 2);
            this.m_keyValueTupleBut.setLayoutData((Object)fd);
            this.m_keyValueTupleBut.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MappingEditor.this.populateTableWithTupleTemplate();
                }
            });
        }
        this.m_fieldsView = new TableView((VariableSpace)transMeta, (Composite)this, tableViewStyle, colinf, 1, null, props);
        fd = new FormData();
        fd.top = new FormAttachment((Control)this.m_existingMappingNamesCombo, margin * 2);
        fd.bottom = new FormAttachment((Control)this.m_saveBut, -margin * 2);
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        this.m_fieldsView.setLayoutData((Object)fd);
    }

    private void populateTableWithTupleTemplate() {
        Table table = this.m_fieldsView.table;
        HashSet<String> existingRowAliases = new HashSet<String>();
        for (int i = 0; i < table.getItemCount(); ++i) {
            TableItem tableItem = table.getItem(i);
            String alias = tableItem.getText(1);
            if (Const.isEmpty((String)alias)) continue;
            existingRowAliases.add(alias);
        }
        int choice = 0;
        if (existingRowAliases.size() > 0) {
            MessageDialog md = new MessageDialog(this.m_shell, Messages.getString("MappingDialog.GetFieldsChoice.Title"), null, Messages.getString("MappingDialog.GetFieldsChoice.Message", "" + existingRowAliases.size(), "5"), 4, new String[]{Messages.getString("MappingOutputDialog.ClearAndAdd"), Messages.getString("MappingOutputDialog.Cancel")}, 0);
            MessageDialog.setDefaultImage((Image)GUIResource.getInstance().getImageSpoon());
            int idx = md.open();
            choice = idx & 0xFF;
        }
        if (choice == 1 || choice == 255) {
            return;
        }
        this.m_fieldsView.clearAll();
        TableItem item = new TableItem(table, 0);
        item.setText(1, "KEY");
        item.setText(2, "Y");
        item = new TableItem(table, 0);
        item.setText(1, "Family");
        item.setText(2, "N");
        item.setText(5, "String");
        item = new TableItem(table, 0);
        item.setText(1, "Column");
        item.setText(2, "N");
        item = new TableItem(table, 0);
        item.setText(1, "Value");
        item.setText(2, "N");
        item = new TableItem(table, 0);
        item.setText(1, "Timestamp");
        item.setText(2, "N");
        item.setText(5, "Long");
        this.m_fieldsView.removeEmptyRows();
        this.m_fieldsView.setRowNums();
        this.m_fieldsView.optWidth(true);
    }

    private void populateTableWithIncomingFields() {
        if (this.m_incomingFieldsProducer != null) {
            RowMetaInterface incomingRowMeta = this.m_incomingFieldsProducer.getIncomingFields();
            Table table = this.m_fieldsView.table;
            if (incomingRowMeta != null) {
                HashSet<String> existingRowAliases = new HashSet<String>();
                for (int i = 0; i < table.getItemCount(); ++i) {
                    TableItem tableItem = table.getItem(i);
                    String alias = tableItem.getText(1);
                    if (Const.isEmpty((String)alias)) continue;
                    existingRowAliases.add(alias);
                }
                int choice = 0;
                if (existingRowAliases.size() > 0) {
                    MessageDialog md = new MessageDialog(this.m_shell, Messages.getString("MappingDialog.GetFieldsChoice.Title"), null, Messages.getString("MappingDialog.GetFieldsChoice.Message", "" + existingRowAliases.size(), "" + incomingRowMeta.size()), 4, new String[]{Messages.getString("MappingDialog.AddNew"), Messages.getString("MappingOutputDialog.Add"), Messages.getString("MappingOutputDialog.ClearAndAdd"), Messages.getString("MappingOutputDialog.Cancel")}, 0);
                    MessageDialog.setDefaultImage((Image)GUIResource.getInstance().getImageSpoon());
                    int idx = md.open();
                    choice = idx & 0xFF;
                }
                if (choice == 3 || choice == 255) {
                    return;
                }
                if (choice == 2) {
                    this.m_fieldsView.clearAll();
                }
                for (int i = 0; i < incomingRowMeta.size(); ++i) {
                    ValueMetaInterface vm = incomingRowMeta.getValueMeta(i);
                    boolean addIt = true;
                    if (choice == 0 && existingRowAliases.contains(vm.getName())) {
                        addIt = false;
                    }
                    if (!addIt) continue;
                    TableItem item = new TableItem(this.m_fieldsView.table, 0);
                    item.setText(1, vm.getName());
                    item.setText(2, "N");
                    if (this.m_familyCI.getComboValues()[0].length() > 0) {
                        item.setText(3, this.m_familyCI.getComboValues()[0]);
                    } else {
                        item.setText(3, DEFAULT_FAMILY);
                    }
                    item.setText(4, vm.getName());
                    item.setText(5, vm.getTypeDesc());
                    if (vm.getType() == 5) {
                        item.setText(5, "Long");
                    }
                    if (vm.getType() == 1) {
                        item.setText(5, "Double");
                    }
                    if (vm.getStorageType() != 2) continue;
                    Object[] indexValus = vm.getIndex();
                    String indexValsS = HBaseValueMeta.objectIndexValuesToString((Object[])indexValus);
                    item.setText(6, indexValsS);
                }
                this.m_fieldsView.removeEmptyRows();
                this.m_fieldsView.setRowNums();
                this.m_fieldsView.optWidth(true);
            }
        }
    }

    private void populateTableCombo(boolean force) {
        if (this.m_configProducer == null) {
            return;
        }
        if (this.m_connectionProblem && !this.m_currentConfiguration.equals(this.m_configProducer.getCurrentConfiguration())) {
            this.m_connectionProblem = false;
            this.m_currentConfiguration = this.m_configProducer.getCurrentConfiguration();
        }
        if ((this.m_existingTableNamesCombo.getItemCount() == 0 || force) && !this.m_connectionProblem) {
            String existingName = this.m_existingTableNamesCombo.getText();
            this.m_existingTableNamesCombo.removeAll();
            try {
                HBaseConnection hbAdmin = this.m_configProducer.getHBaseConnection();
                hbAdmin.checkHBaseAvailable();
                this.m_admin = new MappingAdmin();
                this.m_admin.setConnection(hbAdmin);
                List tables = hbAdmin.listTableNames();
                for (String currentTableName : tables) {
                    this.m_existingTableNamesCombo.add(currentTableName);
                }
                if (!Const.isEmpty((String)existingName)) {
                    this.m_existingTableNamesCombo.setText(existingName);
                }
            }
            catch (Exception e) {
                this.m_connectionProblem = true;
                this.showConnectionErrorDialog(e);
            }
        }
    }

    private void showConnectionErrorDialog(Exception ex) {
        new ErrorDialog(this.m_shell, Messages.getString("MappingDialog.Error.Title.UnableToConnect"), Messages.getString("MappingDialog.Error.Message.UnableToConnect") + "\n\n", ex);
    }

    private void deleteMapping() {
        String tableName = "";
        if (!Const.isEmpty((String)this.m_existingTableNamesCombo.getText().trim()) && (tableName = this.m_existingTableNamesCombo.getText().trim()).indexOf(64) > 0) {
            tableName = tableName.substring(0, tableName.indexOf(64));
        }
        if (Const.isEmpty((String)tableName) || Const.isEmpty((String)this.m_existingMappingNamesCombo.getText().trim())) {
            MessageDialog.openError((Shell)this.m_shell, (String)Messages.getString("MappingDialog.Error.Title.MissingTableMappingName"), (String)Messages.getString("MappingDialog.Error.Message.MissingTableMappingName"));
            return;
        }
        try {
            boolean ok = MessageDialog.openConfirm((Shell)this.m_shell, (String)Messages.getString("MappingDialog.Info.Title.ConfirmDelete"), (String)Messages.getString("MappingDialog.Info.Message.ConfirmDelete", this.m_existingMappingNamesCombo.getText().trim(), tableName));
            if (ok) {
                boolean result = this.m_admin.deleteMapping(this.m_existingTableNamesCombo.getText().trim(), this.m_existingMappingNamesCombo.getText().trim());
                if (result) {
                    MessageDialog.openConfirm((Shell)this.m_shell, (String)Messages.getString("MappingDialog.Info.Title.MappingDeleted"), (String)Messages.getString("MappingDialog.Info.Message.MappingDeleted", this.m_existingMappingNamesCombo.getText().trim(), tableName));
                    this.populateMappingComboAndFamilyStuff();
                } else {
                    MessageDialog.openError((Shell)this.m_shell, (String)Messages.getString("MappingDialog.Error.Title.DeleteMapping"), (String)Messages.getString("MappingDialog.Error.Message.DeleteMapping", this.m_existingMappingNamesCombo.getText().trim(), tableName));
                }
            }
            return;
        }
        catch (Exception ex) {
            MessageDialog.openError((Shell)this.m_shell, (String)Messages.getString("MappingDialog.Error.Title.DeleteMapping"), (String)Messages.getString("MappingDialog.Error.Message.DeleteMappingIO", this.m_existingMappingNamesCombo.getText().trim(), tableName, ex.getMessage()));
            return;
        }
    }

    public Mapping getMapping(boolean performChecksAndShowGUIErrorDialog, List<String> problems) {
        int i;
        String tableName = "";
        if (!Const.isEmpty((String)this.m_existingTableNamesCombo.getText().trim()) && (tableName = this.m_existingTableNamesCombo.getText().trim()).indexOf(64) > 0) {
            tableName = tableName.substring(0, tableName.indexOf(64));
        }
        if (performChecksAndShowGUIErrorDialog && (Const.isEmpty((String)this.m_existingMappingNamesCombo.getText().trim()) || Const.isEmpty((String)tableName))) {
            MessageDialog.openError((Shell)this.m_shell, (String)Messages.getString("MappingDialog.Error.Title.MissingTableMappingName"), (String)Messages.getString("MappingDialog.Error.Message.MissingTableMappingName"));
            if (problems != null) {
                problems.add(Messages.getString("MappingDialog.Error.Message.MissingTableMappingName"));
            }
            return null;
        }
        if (this.m_fieldsView.nrNonEmpty() == 0 && performChecksAndShowGUIErrorDialog) {
            MessageDialog.openError((Shell)this.m_shell, (String)Messages.getString("MappingDialog.Error.Title.NoFieldsDefined"), (String)Messages.getString("MappingDialog.Error.Message.NoFieldsDefined"));
            if (problems != null) {
                problems.add(Messages.getString("MappingDialog.Error.Message.NoFieldsDefined"));
            }
            return null;
        }
        Mapping theMapping = new Mapping(tableName, this.m_existingMappingNamesCombo.getText().trim());
        boolean keyDefined = false;
        boolean moreThanOneKey = false;
        ArrayList<String> missingFamilies = new ArrayList<String>();
        ArrayList<String> missingColumnNames = new ArrayList<String>();
        ArrayList<String> missingTypes = new ArrayList<String>();
        int nrNonEmpty = this.m_fieldsView.nrNonEmpty();
        boolean isTupleMapping = false;
        int tupleIdCount = 0;
        if (nrNonEmpty == 5) {
            for (i = 0; i < nrNonEmpty; ++i) {
                if (!this.m_fieldsView.getNonEmpty(i).getText(1).equals("KEY") && !this.m_fieldsView.getNonEmpty(i).getText(1).equals("Family") && !this.m_fieldsView.getNonEmpty(i).getText(1).equals("Column") && !this.m_fieldsView.getNonEmpty(i).getText(1).equals("Value") && !this.m_fieldsView.getNonEmpty(i).getText(1).equals("Timestamp")) continue;
                ++tupleIdCount;
            }
        }
        if (tupleIdCount == 5) {
            isTupleMapping = true;
            theMapping.setTupleMapping(true);
        }
        for (i = 0; i < nrNonEmpty; ++i) {
            TableItem item = this.m_fieldsView.getNonEmpty(i);
            boolean isKey = false;
            String alias = null;
            if (!Const.isEmpty((String)item.getText(1))) {
                alias = item.getText(1).trim();
            }
            if (!Const.isEmpty((String)item.getText(2))) {
                isKey = item.getText(2).trim().equalsIgnoreCase("Y");
                if (isKey && keyDefined) {
                    moreThanOneKey = true;
                    break;
                }
                if (isKey) {
                    keyDefined = true;
                }
            }
            String family = "";
            if (!Const.isEmpty((String)item.getText(3))) {
                family = item.getText(3);
            } else if (!isKey && !isTupleMapping) {
                missingFamilies.add(item.getText(0));
            }
            String colName = "";
            if (!Const.isEmpty((String)item.getText(4))) {
                colName = item.getText(4);
            } else if (!isKey && !isTupleMapping) {
                missingColumnNames.add(item.getText(0));
            }
            String type = null;
            if (!Const.isEmpty((String)item.getText(5))) {
                type = item.getText(5);
            } else {
                missingTypes.add(item.getText(0));
            }
            String indexedVals = null;
            if (!Const.isEmpty((String)item.getText(6))) {
                indexedVals = item.getText(6);
            }
            if (isKey && !moreThanOneKey) {
                if (Const.isEmpty((String)alias)) {
                    if (performChecksAndShowGUIErrorDialog) {
                        MessageDialog.openError((Shell)this.m_shell, (String)Messages.getString("MappingDialog.Error.Title.NoAliasForKey"), (String)Messages.getString("MappingDialog.Error.Message.NoAliasForKey"));
                    }
                    if (problems != null) {
                        problems.add(Messages.getString("MappingDialog.Error.Message.NoAliasForKey"));
                    }
                    return null;
                }
                if (Const.isEmpty((String)type)) {
                    if (performChecksAndShowGUIErrorDialog) {
                        MessageDialog.openError((Shell)this.m_shell, (String)Messages.getString("MappingDialog.Error.Title.NoTypeForKey"), (String)Messages.getString("MappingDialog.Error.Message.NoTypeForKey"));
                    }
                    if (problems != null) {
                        problems.add(Messages.getString("MappingDialog.Error.Message.NoTypeForKey"));
                    }
                    return null;
                }
                if (moreThanOneKey) {
                    if (performChecksAndShowGUIErrorDialog) {
                        MessageDialog.openError((Shell)this.m_shell, (String)Messages.getString("MappingDialog.Error.Title.MoreThanOneKey"), (String)Messages.getString("MappingDialog.Error.Message.MoreThanOneKey"));
                    }
                    if (problems != null) {
                        problems.add(Messages.getString("MappingDialog.Error.Message.MoreThanOneKey"));
                    }
                    return null;
                }
                if (isTupleMapping) {
                    theMapping.setKeyName(alias);
                    theMapping.setTupleFamilies(family);
                } else {
                    theMapping.setKeyName(alias);
                }
                try {
                    theMapping.setKeyTypeAsString(type);
                }
                catch (Exception ex) {}
                continue;
            }
            if (missingFamilies.size() != 0 || missingColumnNames.size() != 0 || missingTypes.size() != 0) continue;
            String combinedName = family + "," + colName;
            combinedName = !Const.isEmpty((String)alias) ? combinedName + "," + alias : combinedName + "," + colName;
            HBaseValueMeta vm = new HBaseValueMeta(combinedName, 0, -1, -1);
            try {
                vm.setHBaseTypeFromString(type);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
            if (vm.isString() && indexedVals != null && indexedVals.length() > 0) {
                Object[] vals = HBaseValueMeta.stringIndexListToObjects((String)indexedVals);
                vm.setIndex(vals);
                vm.setStorageType(2);
            }
            try {
                theMapping.addMappedColumn(vm, isTupleMapping);
                continue;
            }
            catch (Exception ex) {
                if (performChecksAndShowGUIErrorDialog) {
                    MessageDialog.openError((Shell)this.m_shell, (String)Messages.getString("MappingDialog.Error.Title.DuplicateColumn"), (String)(Messages.getString("MappingDialog.Error.Message1.DuplicateColumn") + family + "," + colName + Messages.getString("MappingDialog.Error.Message2.DuplicateColumn")));
                }
                if (problems != null) {
                    problems.add(Messages.getString("MappingDialog.Error.Message1.DuplicateColumn") + family + "," + colName + Messages.getString("MappingDialog.Error.Message2.DuplicateColumn"));
                }
                return null;
            }
        }
        if (!keyDefined) {
            if (performChecksAndShowGUIErrorDialog) {
                MessageDialog.openError((Shell)this.m_shell, (String)Messages.getString("MappingDialog.Error.Title.NoKeyDefined"), (String)Messages.getString("MappingDialog.Error.Message.NoKeyDefined"));
            }
            if (problems != null) {
                problems.add(Messages.getString("MappingDialog.Error.Message.NoKeyDefined"));
            }
            return null;
        }
        if (missingFamilies.size() > 0 || missingColumnNames.size() > 0 || missingTypes.size() > 0) {
            StringBuffer buff = new StringBuffer();
            buff.append(Messages.getString("MappingDialog.Error.Message.IssuesPreventingSaving") + ":\n\n");
            if (missingFamilies.size() > 0) {
                buff.append(Messages.getString("MappingDialog.Error.Message.FamilyIssue") + ":\n");
                buff.append(((Object)missingFamilies).toString()).append("\n\n");
            }
            if (missingColumnNames.size() > 0) {
                buff.append(Messages.getString("MappingDialog.Error.Message.ColumnIssue") + ":\n");
                buff.append(((Object)missingColumnNames).toString()).append("\n\n");
            }
            if (missingTypes.size() > 0) {
                buff.append(Messages.getString("MappingDialog.Error.Message.TypeIssue") + ":\n");
                buff.append(((Object)missingTypes).toString()).append("\n\n");
            }
            if (performChecksAndShowGUIErrorDialog) {
                MessageDialog.openError((Shell)this.m_shell, (String)Messages.getString("MappingDialog.Error.Title.IssuesPreventingSaving"), (String)buff.toString());
            }
            if (problems != null) {
                problems.add(buff.toString());
            }
            return null;
        }
        return theMapping;
    }

    private void saveMapping() {
        Mapping theMapping = this.getMapping(true, null);
        if (theMapping == null) {
            return;
        }
        String tableName = theMapping.getTableName();
        if (this.m_allowTableCreate) {
            HBaseConnection hbAdmin = this.m_admin.getConnection();
            try {
                if (!hbAdmin.tableExists(tableName)) {
                    boolean result = MessageDialog.openConfirm((Shell)this.m_shell, (String)"Create table", (String)("Table \"" + tableName + "\" does not exist. Create it?"));
                    if (!result) {
                        return;
                    }
                    if (theMapping.getMappedColumns().size() == 0) {
                        MessageDialog.openError((Shell)this.m_shell, (String)"No columns defined", (String)"A HBase table requires at least one column family to be defined.");
                        return;
                    }
                    Set cols = theMapping.getMappedColumns().keySet();
                    TreeSet<String> families = new TreeSet<String>();
                    for (String col : cols) {
                        String family = ((HBaseValueMeta)theMapping.getMappedColumns().get(col)).getColumnFamily();
                        families.add(family);
                    }
                    String compression = null;
                    String bloomFilter = null;
                    String[] opts = this.m_existingTableNamesCombo.getText().trim().split("@");
                    if (opts.length > 1) {
                        compression = opts[1];
                        if (opts.length == 3) {
                            bloomFilter = opts[2];
                        }
                    }
                    Properties creationProps = new Properties();
                    if (compression != null) {
                        creationProps.setProperty("col.descriptor.compression", compression);
                    }
                    if (bloomFilter != null) {
                        creationProps.setProperty("col.descriptor.bloomFilter", bloomFilter);
                    }
                    ArrayList<String> familyList = new ArrayList<String>();
                    for (String fam : families) {
                        familyList.add(fam);
                    }
                    hbAdmin.createTable(tableName, familyList, creationProps);
                    this.populateTableCombo(true);
                }
            }
            catch (Exception ex) {
                new ErrorDialog(this.m_shell, Messages.getString("MappingDialog.Error.Title.ErrorCreatingTable"), Messages.getString("MappingDialog.Error.Message.ErrorCreatingTable") + " \"" + this.m_existingTableNamesCombo.getText().trim() + "\"", ex);
                return;
            }
        }
        try {
            boolean result;
            if (this.m_admin.mappingExists(tableName, this.m_existingMappingNamesCombo.getText().trim()) && !(result = MessageDialog.openConfirm((Shell)this.m_shell, (String)Messages.getString("MappingDialog.Info.Title.MappingExists"), (String)(Messages.getString("MappingDialog.Info.Message1.MappingExists") + this.m_existingMappingNamesCombo.getText().trim() + Messages.getString("MappingDialog.Info.Message2.MappingExists") + tableName + Messages.getString("MappingDialog.Info.Message3.MappingExists"))))) {
                return;
            }
            this.m_admin.putMapping(theMapping, true);
            MessageDialog.openConfirm((Shell)this.m_shell, (String)Messages.getString("MappingDialog.Info.Title.MappingSaved"), (String)(Messages.getString("MappingDialog.Info.Message1.MappingSaved") + this.m_existingMappingNamesCombo.getText().trim() + Messages.getString("MappingDialog.Info.Message2.MappingSaved") + tableName + Messages.getString("MappingDialog.Info.Message3.MappingSaved")));
        }
        catch (Exception ex) {
            new ErrorDialog(this.m_shell, Messages.getString("MappingDialog.Error.Title.ErrorSaving"), Messages.getString("MappingDialog.Error.Message.ErrorSaving"), ex);
        }
    }

    public void setMapping(Mapping mapping) {
        if (mapping == null) {
            return;
        }
        this.m_fieldsView.clearAll();
        TableItem keyItem = new TableItem(this.m_fieldsView.table, 0);
        if (!Const.isEmpty((String)mapping.getKeyName())) {
            keyItem.setText(1, mapping.getKeyName());
        }
        keyItem.setText(2, "Y");
        if (mapping.getKeyType() != null && !Const.isEmpty((String)mapping.getKeyType().toString())) {
            keyItem.setText(5, mapping.getKeyType().toString());
        }
        if (mapping.isTupleMapping() && !Const.isEmpty((String)mapping.getTupleFamilies())) {
            keyItem.setText(3, mapping.getTupleFamilies());
        }
        Map mappedFields = mapping.getMappedColumns();
        for (String alias : mappedFields.keySet()) {
            HBaseValueMeta vm = (HBaseValueMeta)mappedFields.get(alias);
            TableItem item = new TableItem(this.m_fieldsView.table, 0);
            item.setText(1, alias);
            item.setText(2, "N");
            item.setText(3, vm.getColumnFamily());
            item.setText(4, vm.getColumnName());
            if (vm.isInteger()) {
                if (vm.getIsLongOrDouble()) {
                    item.setText(5, "Long");
                } else {
                    item.setText(5, "Integer");
                }
            } else if (vm.isNumber()) {
                if (vm.getIsLongOrDouble()) {
                    item.setText(5, "Double");
                } else {
                    item.setText(5, "Float");
                }
            } else {
                item.setText(5, vm.getTypeDesc());
            }
            if (vm.getStorageType() != 2) continue;
            item.setText(6, HBaseValueMeta.objectIndexValuesToString((Object[])vm.getIndex()));
        }
        this.m_fieldsView.removeEmptyRows();
        this.m_fieldsView.setRowNums();
        this.m_fieldsView.optWidth(true);
    }

    private void loadTableViewFromMapping() {
        String tableName = "";
        if (!Const.isEmpty((String)this.m_existingTableNamesCombo.getText().trim()) && (tableName = this.m_existingTableNamesCombo.getText().trim()).indexOf(64) > 0) {
            tableName = tableName.substring(0, tableName.indexOf(64));
        }
        try {
            if (this.m_admin.mappingExists(tableName, this.m_existingMappingNamesCombo.getText().trim())) {
                Mapping mapping = this.m_admin.getMapping(tableName, this.m_existingMappingNamesCombo.getText().trim());
                this.setMapping(mapping);
            }
        }
        catch (Exception ex) {
            new ErrorDialog(this.m_shell, Messages.getString("MappingDialog.Error.Title.ErrorLoadingMapping"), Messages.getString("MappingDialog.Error.Message.ErrorLoadingMapping"), ex);
        }
    }

    private void populateMappingComboAndFamilyStuff() {
        String tableName = "";
        if (!Const.isEmpty((String)this.m_existingTableNamesCombo.getText().trim()) && (tableName = this.m_existingTableNamesCombo.getText().trim()).indexOf(64) > 0) {
            tableName = tableName.substring(0, tableName.indexOf(64));
        }
        this.m_familyCI.setComboValues(new String[]{""});
        this.m_existingMappingNamesCombo.removeAll();
        if (this.m_admin != null && !Const.isEmpty((String)tableName)) {
            try {
                List<String> mappingNames = this.m_admin.getMappingNames(tableName);
                for (String m : mappingNames) {
                    this.m_existingMappingNamesCombo.add(m);
                }
                HBaseConnection hbAdmin = this.m_admin.getConnection();
                if (hbAdmin.tableExists(tableName)) {
                    List colFams = hbAdmin.getTableFamiles(tableName);
                    String[] familyNames = colFams.toArray(new String[1]);
                    this.m_familyCI.setComboValues(familyNames);
                } else {
                    this.m_familyCI.setComboValues(new String[]{""});
                }
                this.m_familiesInvalidated = false;
                return;
            }
            catch (Exception e) {
                this.showConnectionErrorDialog(e);
            }
        }
    }

    @Override
    public HBaseConnection getHBaseConnection() throws Exception {
        HBaseConnection conf = null;
        String zookeeperHosts = null;
        String zookeeperPort = null;
        if (!Const.isEmpty((String)this.m_zookeeperHostText.getText())) {
            zookeeperHosts = this.m_transMeta.environmentSubstitute(this.m_zookeeperHostText.getText());
        }
        if (!Const.isEmpty((String)this.m_zookeeperPortText.getText())) {
            zookeeperPort = this.m_transMeta.environmentSubstitute(this.m_zookeeperPortText.getText());
        }
        conf = HBaseInputData.getHBaseConnection(zookeeperHosts, zookeeperPort, null, null, null);
        return conf;
    }

    @Override
    public String getCurrentConfiguration() {
        String host = "";
        String port = "";
        if (!Const.isEmpty((String)this.m_zookeeperHostText.getText())) {
            host = this.m_zookeeperHostText.getText();
        }
        if (!Const.isEmpty((String)this.m_zookeeperPortText.getText())) {
            port = this.m_zookeeperPortText.getText();
        }
        return host + ":" + port;
    }
}

