/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.gpload;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.gpload.GPLoadData;
import org.pentaho.di.trans.steps.gpload.GPLoadDataOutput;
import org.pentaho.di.trans.steps.gpload.GPLoadMeta;

public class GPLoad
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = GPLoadMeta.class;
    private static String INDENT = "    ";
    private static String GPLOAD_YAML_VERSION = "VERSION: 1.0.0.1";
    private static String SINGLE_QUOTE = "'";
    private static String OPEN_BRACKET = "[";
    private static String CLOSE_BRACKET = "]";
    private static String SPACE_PADDED_DASH = " - ";
    private static String COLON = ":";
    private static char DOUBLE_QUOTE = (char)34;
    Process gploadProcess = null;
    private GPLoadMeta meta;
    protected GPLoadData data;
    private GPLoadDataOutput output = null;
    private boolean preview = false;

    public GPLoad(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public String getControlFileContents(GPLoadMeta meta, RowMetaInterface rm) throws KettleException {
        String maxErrors;
        String localhostPort;
        String dataFilename;
        String[] tableFields = meta.getFieldTable();
        boolean[] matchColumn = meta.getMatchColumn();
        boolean[] updateColumn = meta.getUpdateColumn();
        DatabaseMeta databaseMeta = meta.getDatabaseMeta();
        String schemaName = meta.getSchemaName();
        String targetTableName = meta.getTableName();
        if (schemaName == null) {
            schemaName = "";
        }
        if (targetTableName == null) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"GPLoad.Exception.TargetTableNameMissing", (String[])new String[0]));
        }
        if (Const.isEmpty((String)(targetTableName = this.environmentSubstitute(targetTableName).trim()))) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"GPLoad.Exception.TargetTableNameMissing", (String[])new String[0]));
        }
        if (Const.isEmpty((String)(schemaName = this.environmentSubstitute(schemaName)))) {
            schemaName = databaseMeta.getPreferredSchemaName();
        }
        schemaName = Const.isEmpty((String)schemaName) ? "" : schemaName + ".";
        targetTableName = schemaName + databaseMeta.quoteField(targetTableName);
        String loadAction = meta.getLoadAction();
        if (loadAction.equalsIgnoreCase("merge") || loadAction.equalsIgnoreCase("update")) {
            if (matchColumn == null) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"GPLoad.Exception.MatchColumnsNeeded", (String[])new String[0]));
            }
            if (!meta.hasMatchColumn()) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"GPLoad.Exception.MatchColumnsNeeded", (String[])new String[0]));
            }
            if (updateColumn == null) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"GPLoad.Exception.UpdateColumnsNeeded", (String[])new String[0]));
            }
            if (!meta.hasUpdateColumn()) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"GPLoad.Exception.UpdateColumnsNeeded", (String[])new String[0]));
            }
        }
        if (!Const.isEmpty((String)(dataFilename = meta.getDataFile()))) {
            dataFilename = this.environmentSubstitute(dataFilename).trim();
        }
        if (Const.isEmpty((String)dataFilename)) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"GPload.Exception.DataFileMissing", (String[])new String[0]));
        }
        String delimiter = meta.getDelimiter();
        if (!Const.isEmpty((String)delimiter)) {
            delimiter = this.environmentSubstitute(delimiter).trim();
        }
        if (Const.isEmpty((String)delimiter)) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"GPload.Exception.DelimiterMissing", (String[])new String[0]));
        }
        StringBuffer contents = new StringBuffer(1000);
        contents.append(GPLOAD_YAML_VERSION).append(Const.CR);
        contents.append("DATABASE: ");
        contents.append(this.environmentSubstitute(databaseMeta.getDatabaseName()));
        contents.append(Const.CR);
        contents.append("USER: ").append(this.environmentSubstitute(databaseMeta.getUsername())).append(Const.CR);
        contents.append("HOST: ").append(this.environmentSubstitute(databaseMeta.getHostname())).append(Const.CR);
        contents.append("PORT: ").append(this.environmentSubstitute(databaseMeta.getDatabasePortNumberString())).append(Const.CR);
        contents.append("GPLOAD:").append(Const.CR);
        contents.append(INDENT).append("INPUT: ").append(Const.CR);
        contents.append(INDENT).append("- SOURCE: ").append(Const.CR);
        String[] localHosts = meta.getLocalHosts();
        String stringLocalHosts = null;
        if (!Const.isEmpty((String[])localHosts)) {
            StringBuilder sbLocalHosts = new StringBuilder();
            for (String localHost : localHosts) {
                String trimmedAndSubstitutedLocalHost = this.environmentSubstitute(localHost.trim());
                if (Const.isEmpty((String)trimmedAndSubstitutedLocalHost)) continue;
                sbLocalHosts.append(INDENT).append(INDENT).append(SPACE_PADDED_DASH).append(trimmedAndSubstitutedLocalHost).append(Const.CR);
            }
            stringLocalHosts = sbLocalHosts.toString();
            if (!Const.isEmpty((String)stringLocalHosts)) {
                contents.append(INDENT).append(INDENT).append("LOCAL_HOSTNAME: ").append(Const.CR).append(stringLocalHosts);
            }
        }
        if (!Const.isEmpty((String)(localhostPort = meta.getLocalhostPort())) && !Const.isEmpty((String)(localhostPort = this.environmentSubstitute(localhostPort).trim()))) {
            contents.append(INDENT).append(INDENT).append("PORT: ").append(localhostPort).append(Const.CR);
        }
        dataFilename = SINGLE_QUOTE + this.environmentSubstitute(dataFilename) + SINGLE_QUOTE;
        contents.append(INDENT).append(INDENT).append("FILE: ").append(OPEN_BRACKET).append(dataFilename).append(CLOSE_BRACKET).append(Const.CR);
        if (tableFields.length > 0) {
            contents.append(INDENT).append("- COLUMNS: ").append(Const.CR);
            for (String columnName : tableFields) {
                contents.append(INDENT).append(INDENT).append(SPACE_PADDED_DASH).append(databaseMeta.quoteField(columnName)).append(COLON).append(Const.CR);
            }
        }
        contents.append(INDENT).append("- FORMAT: TEXT").append(Const.CR);
        contents.append(INDENT).append("- DELIMITER: ").append(SINGLE_QUOTE).append(delimiter).append(SINGLE_QUOTE).append(Const.CR);
        String enclosure = meta.getEnclosure();
        enclosure = enclosure != null ? this.environmentSubstitute(meta.getEnclosure()) : "";
        contents.append(INDENT).append("- QUOTE: ").append(SINGLE_QUOTE).append(enclosure).append(SINGLE_QUOTE).append(Const.CR);
        contents.append(INDENT).append("- HEADER: FALSE").append(Const.CR);
        String encoding = meta.getEncoding();
        if (!Const.isEmpty((String)encoding)) {
            contents.append(INDENT).append("- ENCODING: ").append(encoding).append(Const.CR);
        }
        if ((maxErrors = meta.getMaxErrors()) == null) {
            maxErrors = GPLoadMeta.MAX_ERRORS_DEFAULT;
        } else {
            maxErrors = this.environmentSubstitute(maxErrors);
            try {
                if (Integer.valueOf(maxErrors) < 0) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"GPLoad.Exception.MaxErrorsInvalid", (String[])new String[0]));
                }
            }
            catch (NumberFormatException nfe) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"GPLoad.Exception.MaxErrorsInvalid", (String[])new String[0]));
            }
        }
        contents.append(INDENT).append("- ERROR_LIMIT: ").append(maxErrors).append(Const.CR);
        String errorTableName = meta.getErrorTableName();
        if (!Const.isEmpty((String)errorTableName) && !Const.isEmpty((String)(errorTableName = this.environmentSubstitute(errorTableName).trim()))) {
            contents.append(INDENT).append("- ERROR_TABLE: ").append(errorTableName).append(Const.CR);
        }
        contents.append(INDENT).append("OUTPUT:").append(Const.CR);
        contents.append(INDENT).append("- TABLE: ").append(targetTableName).append(Const.CR);
        contents.append(INDENT).append("- MODE: ").append(loadAction).append(Const.CR);
        if (loadAction.equals("update") || loadAction.equals("merge")) {
            String updateCondition;
            if (meta.hasMatchColumn()) {
                contents.append(INDENT).append("- MATCH_COLUMNS: ").append(Const.CR);
                for (int i = 0; i < matchColumn.length; ++i) {
                    if (!matchColumn[i]) continue;
                    contents.append(INDENT).append(INDENT).append(SPACE_PADDED_DASH).append(databaseMeta.quoteField(tableFields[i])).append(Const.CR);
                }
            }
            if (meta.hasUpdateColumn()) {
                contents.append(INDENT).append("- UPDATE_COLUMNS: ").append(Const.CR);
                for (int i = 0; i < updateColumn.length; ++i) {
                    if (!updateColumn[i]) continue;
                    contents.append(INDENT).append(INDENT).append(SPACE_PADDED_DASH).append(databaseMeta.quoteField(tableFields[i])).append(Const.CR);
                }
            }
            if (!Const.isEmpty((String)(updateCondition = meta.getUpdateCondition())) && !Const.isEmpty((String)(updateCondition = updateCondition.replaceAll("[\r\n]", " ").trim()))) {
                contents.append(INDENT).append("- UPDATE_CONDITION: ").append(DOUBLE_QUOTE).append(updateCondition).append(DOUBLE_QUOTE).append(Const.CR);
            }
        }
        return contents.toString();
    }

    public void createControlFile(GPLoadMeta meta) throws KettleException {
        String filename = meta.getControlFile();
        if (Const.isEmpty((String)filename)) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"GPLoad.Exception.NoControlFileSpecified", (String[])new String[0]));
        }
        if (Const.isEmpty((String)(filename = this.environmentSubstitute(filename).trim()))) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"GPLoad.Exception.NoControlFileSpecified", (String[])new String[0]));
        }
        File controlFile = new File(filename);
        OutputStreamWriter fw = null;
        try {
            controlFile.createNewFile();
            fw = new FileWriter(controlFile);
            fw.write(this.getControlFileContents(meta, this.getInputRowMeta()));
        }
        catch (IOException ex) {
            throw new KettleException(ex.getMessage(), (Throwable)ex);
        }
        finally {
            try {
                if (fw != null) {
                    fw.close();
                }
            }
            catch (Exception ignored) {}
        }
    }

    private String getPath(String pathToFile, String exceptionMessage, boolean checkExistenceOfFile) throws KettleException {
        if (Const.isEmpty((String)pathToFile)) {
            throw new KettleException(exceptionMessage);
        }
        if (Const.isEmpty((String)(pathToFile = this.environmentSubstitute(pathToFile).trim()))) {
            throw new KettleException(exceptionMessage);
        }
        FileObject fileObject = KettleVFS.getFileObject((String)pathToFile, (VariableSpace)this.getTransMeta());
        try {
            if (checkExistenceOfFile) {
                if (!fileObject.exists()) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"GPLoad.Execption.FileDoesNotExist", (String[])new String[]{pathToFile}));
                }
            } else {
                FileObject parentFolder = fileObject.getParent();
                if (parentFolder.exists()) {
                    return KettleVFS.getFilename((FileObject)fileObject);
                }
                throw new KettleException(BaseMessages.getString(PKG, (String)"GPLoad.Exception.DirectoryDoesNotExist", (String[])new String[]{parentFolder.getURL().getPath()}));
            }
            if (Const.getOS().startsWith("Windows")) {
                return this.addQuotes(pathToFile);
            }
            return KettleVFS.getFilename((FileObject)fileObject);
        }
        catch (FileSystemException fsex) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"GPLoad.Exception.GPLoadCommandBuild", (String[])new String[]{fsex.getMessage()}));
        }
    }

    public String createCommandLine(GPLoadMeta meta, boolean password) throws KettleException {
        StringBuffer sbCommandLine = new StringBuffer(300);
        if (Const.getOS().startsWith("Windows")) {
            sbCommandLine.append("cmd /c ");
        }
        sbCommandLine.append(this.getPath(meta.getGploadPath(), BaseMessages.getString(PKG, (String)"GPLoad.Exception.GPLoadPathMisssing", (String[])new String[0]), true));
        sbCommandLine.append(" -f ");
        sbCommandLine.append(this.getPath(meta.getControlFile(), BaseMessages.getString(PKG, (String)"GPLoad.Exception.ControlFilePathMissing", (String[])new String[0]), false));
        String logfile = meta.getLogFile();
        if (!Const.isEmpty((String)logfile)) {
            sbCommandLine.append(" -l ");
            sbCommandLine.append(this.getPath(meta.getLogFile(), BaseMessages.getString(PKG, (String)"GPLoad.Exception.LogFilePathMissing", (String[])new String[0]), false));
        }
        return sbCommandLine.toString();
    }

    public boolean execute(GPLoadMeta meta, boolean wait) throws KettleException {
        String commandLine = null;
        Runtime rt = Runtime.getRuntime();
        int gpLoadExitVal = 0;
        try {
            commandLine = this.createCommandLine(meta, true);
            this.logBasic("Executing: " + commandLine);
            this.gploadProcess = rt.exec(commandLine);
            StreamLogger errorLogger = new StreamLogger(this.gploadProcess.getErrorStream(), "ERROR");
            StreamLogger outputLogger = new StreamLogger(this.gploadProcess.getInputStream(), "OUTPUT");
            errorLogger.start();
            outputLogger.start();
            if (wait) {
                gpLoadExitVal = this.gploadProcess.waitFor();
                this.logBasic(BaseMessages.getString(PKG, (String)"GPLoad.Log.ExitValuePsqlPath", (String[])new String[]{"" + gpLoadExitVal}));
                if (gpLoadExitVal != 0) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"GPLoad.Log.ExitValuePsqlPath", (String[])new String[]{"" + gpLoadExitVal}));
                }
            }
        }
        catch (KettleException ke) {
            throw ke;
        }
        catch (Exception ex) {
            throw new KettleException("Error while executing '" + commandLine + "'. Exit value = " + gpLoadExitVal);
        }
        return true;
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (GPLoadMeta)smi;
        this.data = (GPLoadData)sdi;
        try {
            Object[] r = this.getRow();
            if (r == null) {
                this.setOutputDone();
                if (!this.preview) {
                    String loadMethod;
                    if (this.output != null) {
                        try {
                            this.output.close();
                        }
                        catch (IOException e) {
                            throw new KettleException("Error while closing output", (Throwable)e);
                        }
                        this.output = null;
                    }
                    if ("AUTO_END".equals(loadMethod = this.meta.getLoadMethod())) {
                        if (this.getLinesOutput() > 0L) {
                            this.createControlFile(this.meta);
                            this.execute(this.meta, true);
                        } else {
                            this.logBasic(BaseMessages.getString(PKG, (String)"GPLoad.Info.NoRowsWritten", (String[])new String[0]));
                        }
                    } else if ("MANUAL".equals(loadMethod)) {
                        this.createControlFile(this.meta);
                        this.logBasic(BaseMessages.getString(PKG, (String)"GPLoad.Info.MethodManual", (String[])new String[0]));
                    } else {
                        throw new KettleException(BaseMessages.getString(PKG, (String)"GPload.Execption.UnhandledLoadMethod", (String[])new String[]{loadMethod}));
                    }
                }
                return false;
            }
            if (!this.preview) {
                if (this.first) {
                    this.first = false;
                    this.output = new GPLoadDataOutput(this, this.meta, this.log.getLogLevel());
                    this.output.open((VariableSpace)this, this.gploadProcess);
                }
                this.output.writeLine(this.getInputRowMeta(), r);
            }
            this.putRow(this.getInputRowMeta(), r);
            this.incrementLinesOutput();
        }
        catch (KettleException e) {
            this.logError(BaseMessages.getString(PKG, (String)"GPLoad.Log.ErrorInStep", (String[])new String[0]) + e.getMessage());
            this.setErrors(1L);
            this.stopAll();
            this.setOutputDone();
            return false;
        }
        return true;
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (GPLoadMeta)smi;
        this.data = (GPLoadData)sdi;
        Trans trans = this.getTrans();
        this.preview = trans.isPreview();
        return super.init(smi, sdi);
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (GPLoadMeta)smi;
        this.data = (GPLoadData)sdi;
        super.dispose(smi, sdi);
        if (!this.preview && this.meta.isEraseFiles()) {
            FileObject fileObject = null;
            String method = this.meta.getLoadMethod();
            if ("AUTO_END".equals(method) && this.meta.getControlFile() != null) {
                try {
                    fileObject = KettleVFS.getFileObject((String)this.environmentSubstitute(this.meta.getControlFile()), (VariableSpace)this.getTransMeta());
                    fileObject.delete();
                    fileObject.close();
                }
                catch (Exception ex) {
                    this.logError("Error deleting control file '" + KettleVFS.getFilename((FileObject)fileObject) + "': " + ex.getMessage());
                }
            }
            if ("AUTO_END".equals(method) && this.meta.getDataFile() != null) {
                try {
                    fileObject = KettleVFS.getFileObject((String)this.environmentSubstitute(this.meta.getDataFile()), (VariableSpace)this.getTransMeta());
                    fileObject.delete();
                    fileObject.close();
                }
                catch (Exception ex) {
                    this.logError("Error deleting data file '" + KettleVFS.getFilename((FileObject)fileObject) + "': " + ex.getMessage(), ex);
                }
            }
            if ("MANUAL".equals(method)) {
                this.logBasic("Deletion of files is not compatible with 'manual load method'");
            }
        }
    }

    private String addQuotes(String string) {
        if (Const.getOS().startsWith("Windows") && string.indexOf(" ") != -1) {
            string = "\"" + string + "\"";
        }
        return string;
    }

    private final class StreamLogger
    extends Thread {
        private InputStream input;
        private String type;

        StreamLogger(InputStream is, String type) {
            this.input = is;
            this.type = type + ">";
        }

        @Override
        public void run() {
            try {
                String line;
                BufferedReader br = new BufferedReader(new InputStreamReader(this.input));
                while ((line = br.readLine()) != null) {
                    if (!GPLoad.this.log.isBasic()) continue;
                    GPLoad.this.logBasic(this.type + line);
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }
}

