/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce.hcat;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hcatalog.data.HCatRecord;
import org.apache.sqoop.mapreduce.hcat.SqoopHCatExportFormat;
import org.apache.sqoop.mapreduce.hcat.SqoopHCatInputSplit;

public class SqoopHCatRecordReader
extends RecordReader<WritableComparable, HCatRecord> {
    private final SqoopHCatExportFormat hCatExportFormat;
    private SqoopHCatInputSplit hCatSplit;
    private TaskAttemptContext context;
    private int subIndex;
    private long progress;
    private RecordReader<WritableComparable, HCatRecord> curReader;
    public static final Log LOG = LogFactory.getLog((String)SqoopHCatRecordReader.class.getName());

    public SqoopHCatRecordReader(InputSplit split, TaskAttemptContext context, SqoopHCatExportFormat inputFormat) throws IOException {
        this.hCatSplit = (SqoopHCatInputSplit)split;
        this.context = context;
        this.subIndex = 0;
        this.curReader = null;
        this.progress = 0L;
        this.hCatExportFormat = inputFormat;
        this.initNextRecordReader();
    }

    public void initialize(InputSplit split, TaskAttemptContext ctxt) throws IOException, InterruptedException {
        this.hCatSplit = (SqoopHCatInputSplit)split;
        this.context = ctxt;
        if (null != this.curReader) {
            this.curReader.initialize((InputSplit)((SqoopHCatInputSplit)split).get(0), this.context);
        }
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        while (this.curReader == null || !this.curReader.nextKeyValue()) {
            if (this.initNextRecordReader()) continue;
            return false;
        }
        return true;
    }

    public WritableComparable getCurrentKey() throws IOException, InterruptedException {
        return (WritableComparable)this.curReader.getCurrentKey();
    }

    public HCatRecord getCurrentValue() throws IOException, InterruptedException {
        return (HCatRecord)this.curReader.getCurrentValue();
    }

    public void close() throws IOException {
        if (this.curReader != null) {
            this.curReader.close();
            this.curReader = null;
        }
    }

    public float getProgress() throws IOException, InterruptedException {
        long subprogress = 0L;
        if (null != this.curReader) {
            subprogress = (long)(this.curReader.getProgress() * (float)this.hCatSplit.get(this.subIndex - 1).getLength());
        }
        return Math.min(1.0f, (float)(this.progress + subprogress) / (float)this.hCatSplit.getLength());
    }

    protected boolean initNextRecordReader() throws IOException {
        if (this.curReader != null) {
            this.curReader.close();
            this.curReader = null;
            if (this.subIndex > 0) {
                this.progress += this.hCatSplit.get(this.subIndex - 1).getLength();
            }
            LOG.debug((Object)("Closed current reader.  Current progress = " + this.progress));
        }
        if (this.subIndex == this.hCatSplit.length()) {
            LOG.debug((Object)"Done with all splits");
            return false;
        }
        try {
            this.curReader = this.hCatExportFormat.createHCatRecordReader((InputSplit)this.hCatSplit.get(this.subIndex), this.context);
            LOG.debug((Object)("Created a HCatRecordReader for split " + this.subIndex));
            if (this.subIndex > 0) {
                this.curReader.initialize((InputSplit)this.hCatSplit.get(this.subIndex), this.context);
                LOG.info((Object)"Initialized reader with current split");
            }
        }
        catch (Exception e) {
            throw new IOException("Error initializing HCat record reader", e);
        }
        LOG.debug((Object)("Created record reader for subsplit " + this.subIndex));
        ++this.subIndex;
        return true;
    }
}

