/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.hl7mllpack;

import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.v21.message.ACK;
import ca.uhn.hl7v2.parser.GenericParser;
import ca.uhn.hl7v2.protocol.Transportable;
import ca.uhn.hl7v2.protocol.impl.MLLPTransport;
import ca.uhn.hl7v2.protocol.impl.TransportableImpl;
import ca.uhn.hl7v2.validation.ValidationContext;
import ca.uhn.hl7v2.validation.impl.NoValidation;
import java.util.List;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.annotations.JobEntry;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.steps.hl7input.common.MLLPSocketCache;
import org.pentaho.di.trans.steps.hl7input.common.MLLPSocketCacheEntry;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

@JobEntry(id="HL7MLLPAcknowledge", categoryDescription="i18n:org.pentaho.di.job:JobCategory.Category.Utility", i18nPackageName="org.pentaho.di.job.entries.hl7mllpack", image="mllp-ack.png", name="HL7MLLPAcknowledge.Name", description="HL7MLLPAcknowledge.TooltipDesc")
public class HL7MLLPAcknowledge
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private static Class<?> PKG = HL7MLLPAcknowledge.class;
    private String server;
    private String port;
    private String variableName;

    public HL7MLLPAcknowledge(String name) {
        super(name, "");
        this.setID(-1L);
        this.variableName = "MESSAGE";
    }

    public HL7MLLPAcknowledge() {
        this("");
    }

    public Object clone() {
        HL7MLLPAcknowledge je = (HL7MLLPAcknowledge)super.clone();
        return je;
    }

    public String getXML() {
        StringBuffer retval = new StringBuffer(128);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"server", (String)this.server));
        retval.append("      ").append(XMLHandler.addTagValue((String)"port", (String)this.port));
        retval.append("      ").append(XMLHandler.addTagValue((String)"variable", (String)this.variableName));
        return retval.toString();
    }

    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep, IMetaStore metaStore) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.server = XMLHandler.getTagValue((Node)entrynode, (String)"server");
            this.port = XMLHandler.getTagValue((Node)entrynode, (String)"port");
            this.variableName = XMLHandler.getTagValue((Node)entrynode, (String)"variable");
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException("Unable to load job entry from XML node", (Throwable)xe);
        }
    }

    public void loadRep(Repository rep, IMetaStore metaStore, ObjectId idJobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            this.server = rep.getJobEntryAttributeString(idJobentry, "server");
            this.port = rep.getJobEntryAttributeString(idJobentry, "port");
            this.variableName = rep.getJobEntryAttributeString(idJobentry, "variable");
        }
        catch (KettleException dbe) {
            throw new KettleException("Unable to load job entry from the repository for id_jobentry=" + idJobentry, (Throwable)dbe);
        }
    }

    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_job) throws KettleException {
        try {
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "server", this.server);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "port", this.port);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "variable", this.variableName);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Unable to save job entry of type 'ftp' to the repository for id_job=" + id_job, (Throwable)dbe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result execute(Result previousResult, int nr) {
        Result result = previousResult;
        try {
            MLLPTransport transport;
            String serverName = this.environmentSubstitute(this.server);
            int portNumber = Integer.parseInt(this.environmentSubstitute(this.port));
            String variable = this.environmentSubstitute(this.variableName);
            MLLPSocketCacheEntry entry = MLLPSocketCache.getInstance().getServerSocketStreamSource(serverName, portNumber);
            MLLPTransport mLLPTransport = transport = entry.getTransport();
            synchronized (mLLPTransport) {
                ACK mod;
                String message = this.getVariable(variable);
                GenericParser parser = new GenericParser();
                NoValidation validationContext = new NoValidation();
                parser.setValidationContext((ValidationContext)validationContext);
                Message msg = parser.parse(message);
                Message ack = msg.generateACK();
                String ackMessage = ack.encode();
                String APPNAME = "PDI4";
                if (ack instanceof ACK) {
                    mod = (ACK)ack;
                    mod.getMSH().getSENDINGAPPLICATION().setValue(APPNAME);
                    mod.getMSH().getSENDINGFACILITY().setValue(APPNAME);
                    ackMessage = mod.encode();
                } else if (ack instanceof ca.uhn.hl7v2.model.v22.message.ACK) {
                    mod = (ca.uhn.hl7v2.model.v22.message.ACK)ack;
                    mod.getMSH().getSendingApplication().setValue(APPNAME);
                    mod.getMSH().getSendingFacility().setValue(APPNAME);
                    ackMessage = mod.encode();
                } else if (ack instanceof ca.uhn.hl7v2.model.v23.message.ACK) {
                    mod = (ca.uhn.hl7v2.model.v23.message.ACK)ack;
                    mod.getMSH().getSendingApplication().getNamespaceID().setValue(APPNAME);
                    mod.getMSH().getSendingFacility().getNamespaceID().setValue(APPNAME);
                    ackMessage = mod.encode();
                } else if (ack instanceof ca.uhn.hl7v2.model.v231.message.ACK) {
                    mod = (ca.uhn.hl7v2.model.v231.message.ACK)ack;
                    mod.getMSH().getSendingApplication().getNamespaceID().setValue(APPNAME);
                    mod.getMSH().getSendingFacility().getNamespaceID().setValue(APPNAME);
                    ackMessage = mod.encode();
                } else if (ack instanceof ca.uhn.hl7v2.model.v24.message.ACK) {
                    mod = (ca.uhn.hl7v2.model.v24.message.ACK)ack;
                    mod.getMSH().getSendingApplication().getNamespaceID().setValue(APPNAME);
                    mod.getMSH().getSendingFacility().getNamespaceID().setValue(APPNAME);
                    ackMessage = mod.encode();
                } else if (ack instanceof ca.uhn.hl7v2.model.v25.message.ACK) {
                    mod = (ca.uhn.hl7v2.model.v25.message.ACK)ack;
                    mod.getMSH().getSendingApplication().getNamespaceID().setValue(APPNAME);
                    mod.getMSH().getSendingFacility().getNamespaceID().setValue(APPNAME);
                    ackMessage = mod.encode();
                } else if (ack instanceof ca.uhn.hl7v2.model.v251.message.ACK) {
                    mod = (ca.uhn.hl7v2.model.v251.message.ACK)ack;
                    mod.getMSH().getSendingApplication().getNamespaceID().setValue(APPNAME);
                    mod.getMSH().getSendingFacility().getNamespaceID().setValue(APPNAME);
                    ackMessage = mod.encode();
                } else if (ack instanceof ca.uhn.hl7v2.model.v26.message.ACK) {
                    mod = (ca.uhn.hl7v2.model.v26.message.ACK)ack;
                    mod.getMSH().getSendingApplication().getNamespaceID().setValue(APPNAME);
                    mod.getMSH().getSendingFacility().getNamespaceID().setValue(APPNAME);
                    ackMessage = mod.encode();
                } else {
                    this.logError("This job entry does not support the HL7 dialect used. Found ACK class: " + ack.getClass().getName());
                }
                TransportableImpl transportable = new TransportableImpl(ackMessage);
                transport.doSend((Transportable)transportable);
            }
            result.setNrErrors(0L);
            result.setResult(true);
        }
        catch (Exception e) {
            this.log.logError(BaseMessages.getString(PKG, (String)"HL7MLLPInput.Exception.UnexpectedError", (String[])new String[0]), (Throwable)e);
            result.setNrErrors(1L);
            result.setResult(false);
        }
        return result;
    }

    public boolean evaluates() {
        return true;
    }

    public boolean isUnconditional() {
        return false;
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }
}

