/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.market;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.market.entry.MarketEntry;
import org.pentaho.di.core.market.entry.MarketEntryType;
import org.pentaho.di.core.plugins.KettleURLClassLoader;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.spoon.SpoonLifecycleListener;
import org.pentaho.di.ui.spoon.SpoonPerspective;
import org.pentaho.di.ui.spoon.SpoonPlugin;
import org.pentaho.di.ui.spoon.SpoonPluginCategories;
import org.pentaho.di.ui.spoon.SpoonPluginInterface;
import org.pentaho.di.ui.spoon.dialog.MarketplaceController;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.impl.XulEventHandler;
import org.pentaho.xul.swt.tab.TabSet;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

@SpoonPlugin(id="market", image="")
@SpoonPluginCategories(value={"spoon"})
public class Market
implements SpoonPluginInterface {
    private static Class<?> PKG = Market.class;

    public static final String getMarketplacesFile() {
        return Const.getKettleDirectory() + Const.FILE_SEPARATOR + "marketplaces.xml";
    }

    public void applyToContainer(String category, XulDomContainer container) throws XulException {
        if (category.equals("spoon")) {
            container.registerClassLoader((Object)this.getClass().getClassLoader());
            container.loadOverlay("org/pentaho/di/core/market/spoon_overlays.xul");
            container.addEventHandler((XulEventHandler)new MarketplaceController());
        }
    }

    public SpoonLifecycleListener getLifecycleListener() {
        return null;
    }

    public SpoonPerspective getPerspective() {
        return null;
    }

    private static PluginInterface getPluginObject(String pluginId) {
        for (Class pluginType : PluginRegistry.getInstance().getPluginTypes()) {
            if (PluginRegistry.getInstance().findPluginWithId(pluginType, pluginId) == null) continue;
            return PluginRegistry.getInstance().findPluginWithId(pluginType, pluginId);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String discoverInstalledVersion(MarketEntry marketEntry) {
        String pluginFolder = Market.buildPluginsFolderPath(marketEntry) + File.separator + marketEntry.getId();
        File pluginFolderFile = new File(pluginFolder);
        if (pluginFolderFile.exists()) {
            marketEntry.setInstalled(true);
            String versionPath = pluginFolder + File.separator + "version.xml";
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            InputStreamReader reader = null;
            try {
                File file = new File(versionPath);
                if (!file.exists()) {
                    String string = "Unknown";
                    return string;
                }
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document dom = db.parse(new InputSource(reader = new FileReader(versionPath)));
                NodeList versionElements = dom.getElementsByTagName("version");
                if (versionElements.getLength() < 1) return "Unknown";
                Element versionElement = (Element)versionElements.item(0);
                marketEntry.setInstalledBuildId(versionElement.getAttribute("buildId"));
                marketEntry.setInstalledBranch(versionElement.getAttribute("branch"));
                marketEntry.setInstalledVersion(versionElement.getTextContent());
                String string = versionElement.getTextContent();
                return string;
            }
            catch (Exception e) {
                e.printStackTrace();
                return "Unknown";
            }
            finally {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        marketEntry.setInstalled(false);
        return "Unknown";
    }

    public static String buildPluginsFolderPath(MarketEntry marketEntry) {
        PluginInterface plugin = Market.getPluginObject(marketEntry.getId());
        if (plugin != null && plugin.getPluginDirectory() != null) {
            return new File(plugin.getPluginDirectory().getFile()).getParent();
        }
        String subfolder = Market.getInstallationSubfolder(marketEntry);
        return "plugins" + (subfolder == null ? "" : Const.FILE_SEPARATOR + subfolder);
    }

    public static void installUninstall(MarketEntry marketEntry, boolean isInstalled, ProgressMonitorDialog monitorDialog) throws KettleException {
        if (isInstalled) {
            Market.uninstall(marketEntry, monitorDialog, true);
        } else {
            Market.install(marketEntry, monitorDialog);
        }
    }

    public static void install(MarketEntry marketEntry, ProgressMonitorDialog monitorDialog) throws KettleException {
        File bdPluginFolder;
        String parentFolderName = Market.buildPluginsFolderPath(marketEntry);
        if (marketEntry.getType().equals((Object)MarketEntryType.HadoopShim) && ((bdPluginFolder = new File(parentFolderName).getParentFile()) == null || !bdPluginFolder.exists())) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"Marketplaces.Dialog.PluginNotInstalled.message", (String[])new String[]{"Pentaho Big Data Plugin"}) + ". You must install the Pentaho Big Data plugin before you can install a Hadoop Shim");
        }
        File pluginFolder = new File(parentFolderName + File.separator + marketEntry.getId());
        LogChannel.GENERAL.logBasic("Installing plugin in folder: " + pluginFolder.getAbsolutePath());
        if (pluginFolder.exists()) {
            monitorDialog.close();
            MessageBox mb = new MessageBox(Spoon.getInstance().getShell(), 200);
            mb.setMessage(BaseMessages.getString(PKG, (String)"Marketplace.Dialog.PromptOverwritePlugin.Message", (String[])new String[]{pluginFolder.getAbsolutePath()}));
            mb.setText(BaseMessages.getString(PKG, (String)"Marketplace.Dialog.PromptOverwritePlugin.Title", (String[])new String[0]));
            int answer = 128;
            answer = mb.open();
            if (answer == 64) {
                monitorDialog.open();
                ClassLoader cl = PluginRegistry.getInstance().getClassLoader(Market.getPluginObject(marketEntry.getId()));
                if (cl instanceof KettleURLClassLoader) {
                    ((KettleURLClassLoader)cl).closeClassLoader();
                }
                Market.deleteDirectory(pluginFolder);
                Market.unzipMarketEntry(parentFolderName, marketEntry.getPackageUrl());
                if (Market.discoverInstalledVersion(marketEntry).equalsIgnoreCase("unknown")) {
                    Market.createVersionXML(marketEntry);
                }
                Market.refreshSpoon(monitorDialog);
            }
        } else {
            Market.unzipMarketEntry(parentFolderName, marketEntry.getPackageUrl());
            if (Market.discoverInstalledVersion(marketEntry).equalsIgnoreCase("unknown")) {
                Market.createVersionXML(marketEntry);
            }
            Market.refreshSpoon(monitorDialog);
        }
    }

    private static void createVersionXML(MarketEntry marketEntry) throws KettleException {
        String pluginFolder = Market.buildPluginsFolderPath(marketEntry) + File.separator + marketEntry.getId();
        String versionPath = pluginFolder + File.separator + "version.xml";
        File parentFolder = new File(pluginFolder);
        File file = new File(versionPath);
        if (file != null) {
            BufferedWriter bufferedWriter = null;
            try {
                if (!parentFolder.exists()) {
                    parentFolder.mkdirs();
                }
                FileWriter fw = new FileWriter(file.getAbsoluteFile());
                bufferedWriter = new BufferedWriter(fw);
                bufferedWriter.write("<version>" + marketEntry.getVersion() + "</version>");
            }
            catch (IOException ioe) {
                throw new KettleException((Throwable)ioe);
            }
            finally {
                if (bufferedWriter != null) {
                    try {
                        bufferedWriter.close();
                    }
                    catch (IOException ioe) {
                        throw new KettleException((Throwable)ioe);
                    }
                }
            }
        }
    }

    private static void unzipMarketEntry(String folderName, String packageUrl) throws KettleException {
        File tmpFile = null;
        FileInputStream inputStream = null;
        ZipInputStream zis = null;
        try {
            tmpFile = File.createTempFile("plugin", ".zip");
            FileUtils.copyURLToFile((URL)new URL(packageUrl), (File)tmpFile);
            inputStream = new FileInputStream(tmpFile);
            zis = new ZipInputStream(inputStream);
            ZipEntry zipEntry = null;
            try {
                zipEntry = zis.getNextEntry();
            }
            catch (IOException ioe) {
                throw new KettleException((Throwable)ioe);
            }
            byte[] buffer = new byte[1024];
            int bytesRead = 0;
            FileOutputStream fos = null;
            while (zipEntry != null) {
                try {
                    File file = new File(folderName + File.separator + zipEntry.getName());
                    if (zipEntry.isDirectory()) {
                        file.mkdirs();
                    } else {
                        file.getParentFile().mkdirs();
                        fos = new FileOutputStream(file);
                        while ((bytesRead = zis.read(buffer)) != -1) {
                            fos.write(buffer, 0, bytesRead);
                        }
                    }
                    zipEntry = zis.getNextEntry();
                }
                catch (FileNotFoundException fnfe) {
                    throw new KettleException((Throwable)fnfe);
                }
                catch (IOException ioe) {
                    throw new KettleException((Throwable)ioe);
                }
                finally {
                    if (fos == null) continue;
                    try {
                        fos.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        catch (IOException e) {
            throw new KettleException("Unable to unzip file " + packageUrl, (Throwable)e);
        }
        finally {
            if (zis != null) {
                tmpFile.delete();
                try {
                    zis.close();
                }
                catch (Exception e) {
                    throw new KettleException("Unable to close zip file stream (corrupt file?) of file " + tmpFile, (Throwable)e);
                }
            }
        }
    }

    public static void uninstall(MarketEntry marketEntry, final ProgressMonitorDialog monitorDialog, boolean refresh) throws KettleException {
        String parentFolderName = Market.buildPluginsFolderPath(marketEntry);
        File pluginFolder = new File(parentFolderName + File.separator + marketEntry.getId());
        LogChannel.GENERAL.logBasic("Uninstalling plugin in folder: " + pluginFolder.getAbsolutePath());
        if (!pluginFolder.exists()) {
            throw new KettleException("No plugin was found in the expected folder : " + pluginFolder.getAbsolutePath());
        }
        try {
            for (PluginInterface plugin : PluginRegistry.getInstance().findPluginsByFolder(pluginFolder.toURI().toURL())) {
                ClassLoader cl = PluginRegistry.getInstance().getClassLoader(plugin);
                if (cl instanceof KettleURLClassLoader) {
                    ((KettleURLClassLoader)cl).closeClassLoader();
                }
                PluginRegistry.getInstance().removePlugin(plugin.getPluginType(), plugin);
            }
        }
        catch (MalformedURLException e1) {
            LogChannel.GENERAL.logError(e1.getLocalizedMessage(), (Throwable)e1);
        }
        Market.deleteDirectory(pluginFolder);
        if (refresh) {
            if (!Display.getDefault().getThread().equals(Thread.currentThread())) {
                Spoon.getInstance().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Market.refreshSpoon(monitorDialog);
                        }
                        catch (KettleException e) {
                            e.printStackTrace();
                        }
                    }
                });
            } else {
                Market.refreshSpoon(monitorDialog);
            }
        }
    }

    public static void uninstallMarketInSeparateClassLoader(final File path, final ProgressMonitorDialog monitorDialog) throws Exception {
        try {
            Spoon.getInstance().getMainSpoonContainer().removeOverlay("org/pentaho/di/core/market/spoon_overlays.xul");
            Market.uninstall(new MarketEntry("market", MarketEntryType.Mixed), monitorDialog, false);
            Spoon.getInstance().getDisplay().asyncExec(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        Market.refreshSpoon(monitorDialog);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        if (Market.class.getClassLoader() instanceof KettleURLClassLoader) {
                            ((KettleURLClassLoader)Market.class.getClassLoader()).closeClassLoader();
                        }
                        path.delete();
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void upgradeMarketInSeparateClassLoader(final File path, String packageUrl, final ProgressMonitorDialog monitorDialog) throws Exception {
        try {
            PluginInterface plugin = Market.getPluginObject("market");
            if (plugin == null) {
                throw new KettleException("No Plugin!");
            }
            File pluginFolder = new File(plugin.getPluginDirectory().getFile());
            String parentFolderName = pluginFolder.getParent();
            ClassLoader cl = PluginRegistry.getInstance().getClassLoader(plugin);
            if (cl instanceof KettleURLClassLoader) {
                ((KettleURLClassLoader)cl).closeClassLoader();
            }
            Market.deleteDirectory(pluginFolder);
            Market.unzipMarketEntry(parentFolderName, packageUrl);
            Spoon.getInstance().getDisplay().asyncExec(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        Market.refreshSpoon(monitorDialog);
                        MessageBox box = new MessageBox(Spoon.getInstance().getShell(), 40);
                        box.setText(BaseMessages.getString((Class)PKG, (String)"MarketplacesDialog.RestartUpdate.Title", (String[])new String[0]));
                        box.setMessage(BaseMessages.getString((Class)PKG, (String)"MarketplacesDialog.RestartUpdate.Message", (String[])new String[0]));
                        box.open();
                    }
                    catch (KettleException e) {
                        e.printStackTrace();
                    }
                    finally {
                        if (Market.class.getClassLoader() instanceof KettleURLClassLoader) {
                            ((KettleURLClassLoader)Market.class.getClassLoader()).closeClassLoader();
                        }
                        path.delete();
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            if (Market.class.getClassLoader() instanceof KettleURLClassLoader) {
                ((KettleURLClassLoader)Market.class.getClassLoader()).closeClassLoader();
            }
            path.delete();
        }
    }

    public static void upgradeMarket(final MarketEntry entry) throws KettleException {
        try {
            PluginInterface plugin = Market.getPluginObject("market");
            if (plugin == null) {
                throw new KettleException("No Plugin!");
            }
            String pluginFolderName = plugin.getPluginDirectory().getFile();
            File folder = new File(pluginFolderName);
            File[] files = folder.listFiles();
            File jar = null;
            for (File f : files) {
                if (!f.getName().endsWith(".jar")) continue;
                jar = f;
                break;
            }
            final File finalJar = jar;
            Thread t = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    KettleURLClassLoader classloader = null;
                    try {
                        File tmpJar = File.createTempFile("kettle_marketplace_tmp", ".jar");
                        FileInputStream fis = new FileInputStream(finalJar);
                        FileOutputStream fos = new FileOutputStream(tmpJar);
                        IOUtils.copy((InputStream)fis, (OutputStream)fos);
                        fis.close();
                        fos.close();
                        classloader = new KettleURLClassLoader(new URL[]{tmpJar.toURI().toURL()}, Spoon.getInstance().getClass().getClassLoader());
                        Class clazz = classloader.loadClass("org.pentaho.di.core.market.Market");
                        Method m = clazz.getMethod("upgradeMarketInSeparateClassLoader", File.class, String.class);
                        m.invoke(null, tmpJar, entry.getPackageUrl());
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                    finally {
                        if (classloader != null) {
                            classloader.closeClassLoader();
                        }
                    }
                }
            };
            t.start();
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new KettleException(t);
        }
    }

    public static void uninstallMarket() throws KettleException {
        try {
            PluginInterface plugin = Market.getPluginObject("market");
            if (plugin == null) {
                throw new KettleException("No Plugin!");
            }
            String pluginFolderName = plugin.getPluginDirectory().getFile();
            File folder = new File(pluginFolderName);
            File[] files = folder.listFiles();
            File jar = null;
            for (File f : files) {
                if (!f.getName().endsWith(".jar")) continue;
                jar = f;
                break;
            }
            final File finalJar = jar;
            Thread t = new Thread(){
                KettleURLClassLoader classloader = null;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        File tmpJar = File.createTempFile("kettle_marketplace_tmp", ".jar");
                        FileInputStream fis = new FileInputStream(finalJar);
                        FileOutputStream fos = new FileOutputStream(tmpJar);
                        IOUtils.copy((InputStream)fis, (OutputStream)fos);
                        fis.close();
                        fos.close();
                        KettleURLClassLoader classloader = new KettleURLClassLoader(new URL[]{tmpJar.toURI().toURL()}, Spoon.getInstance().getClass().getClassLoader());
                        Class clazz = classloader.loadClass("org.pentaho.di.core.market.Market");
                        Method m = clazz.getMethod("uninstallMarketInSeparateClassLoader", File.class, ProgressMonitorDialog.class);
                        m.invoke(null, tmpJar, null);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                    finally {
                        if (this.classloader != null) {
                            this.classloader.closeClassLoader();
                        }
                    }
                }
            };
            t.start();
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new KettleException(t);
        }
    }

    private static void refreshSpoon(ProgressMonitorDialog monitorDialog) throws KettleException {
        if (monitorDialog != null) {
            monitorDialog.close();
        }
        MessageBox box = new MessageBox(Spoon.getInstance().getShell(), 36);
        box.setText(BaseMessages.getString(PKG, (String)"MarketplacesDialog.RestartUpdate.Title", (String[])new String[0]));
        box.setMessage(BaseMessages.getString(PKG, (String)"MarketplacesDialog.RestartUpdate.Message", (String[])new String[0]));
        box.open();
        DatabaseMeta.clearDatabaseInterfacesMap();
        PluginRegistry.init();
        Spoon spoon = Spoon.getInstance();
        int numTabs = spoon.delegates.tabs.getTabs().size();
        TabSet tabSet = spoon.getTabSet();
        int selectedIndex = tabSet.getSelectedIndex();
        for (int i = numTabs - 1; i >= 0; --i) {
            if (i == selectedIndex) continue;
            tabSet.setSelected(i);
            if (!spoon.isExecutionResultsPaneVisible()) continue;
            spoon.showExecutionResults();
        }
        tabSet.setSelected(selectedIndex);
        if (spoon.isExecutionResultsPaneVisible()) {
            spoon.showExecutionResults();
        }
        spoon.refreshCoreObjects();
        spoon.refreshTree();
        spoon.refreshGraph();
        spoon.enableMenus();
        GUIResource.getInstance().reload();
        spoon.selectionFilter.setText(spoon.selectionFilter.getText());
    }

    public static String getInstallationSubfolder(MarketEntry marketEntry) {
        String subfolder = null;
        switch (marketEntry.getType()) {
            case Step: {
                subfolder = "steps";
                break;
            }
            case JobEntry: {
                subfolder = "jobentries";
                break;
            }
            case Partitioner: {
                subfolder = "steps";
                break;
            }
            case SpoonPlugin: {
                subfolder = "spoon";
                break;
            }
            case Database: {
                subfolder = "databases";
                break;
            }
            case Repository: {
                subfolder = "repositories";
                break;
            }
            case HadoopShim: {
                subfolder = "pentaho-big-data-plugin" + File.separator + "hadoop-configurations";
                break;
            }
            case Mixed: 
            case General: {
                subfolder = "";
                break;
            }
            default: {
                subfolder = null;
            }
        }
        return subfolder;
    }

    private static void deleteDirectory(File dir) throws KettleException {
        if (dir != null) {
            File[] files = dir.listFiles();
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    if (files[i].isDirectory()) {
                        Market.deleteDirectory(files[i]);
                        continue;
                    }
                    if (files[i].delete()) continue;
                    throw new KettleException("Failed to delete " + files[i]);
                }
            }
            if (!dir.delete()) {
                throw new KettleException("Failed to delete directory " + dir);
            }
        }
    }
}

