/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.spoon.dialog;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ExpandEvent;
import org.eclipse.swt.events.ExpandListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.market.Market;
import org.pentaho.di.core.market.entry.MarketEntries;
import org.pentaho.di.core.market.entry.MarketEntry;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class MarketplaceDialog
extends Dialog {
    private static Class<?> MARKET_PKG = Market.class;
    private Label wlMarketplaces;
    private Button wClose;
    private Shell shell;
    private PropsUI props;
    private ExpandBar expandBar;
    private int margin;
    private int middle;
    private Text selectionFilter;
    private Button checkInstalled;
    private Button checkNotinstalled;
    private ProgressMonitorDialog pmd = null;
    private SelectionAdapter upgradeSelectionListener;
    private SelectionAdapter installSelectionListener;
    private static MarketEntries marketEntries = null;
    private Map<MarketEntry, Composite> marketEntryControls = new HashMap<MarketEntry, Composite>();

    public MarketplaceDialog(Shell parent) {
        super(parent, 0);
        this.props = PropsUI.getInstance();
    }

    public void open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.shell.setImage(GUIResource.getInstance().getImageSpoon());
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(MARKET_PKG, (String)"Marketplace.Dialog.Title", (String[])new String[0]));
        this.shell.setImage(GUIResource.getInstance().getImageLogoSmall());
        this.margin = 4;
        this.middle = this.props.getMiddlePct();
        this.wlMarketplaces = new Label((Composite)this.shell, 0);
        this.wlMarketplaces.setText(BaseMessages.getString(MARKET_PKG, (String)"Marketplace.Dialog.DetectedPlugins", (String[])new String[0]));
        this.props.setLook((Control)this.wlMarketplaces);
        FormData fdlMarketplaces = new FormData();
        fdlMarketplaces.left = new FormAttachment(0, 0);
        fdlMarketplaces.top = new FormAttachment(0, this.margin);
        this.wlMarketplaces.setLayoutData((Object)fdlMarketplaces);
        this.selectionFilter = new Text((Composite)this.shell, 19332);
        this.selectionFilter.setFont(GUIResource.getInstance().getFontSmall());
        this.selectionFilter.setToolTipText(BaseMessages.getString(MARKET_PKG, (String)"MarketplacesDialog.Filter.Tooltip", (String[])new String[0]));
        FormData fdSelectionFilter = new FormData();
        fdSelectionFilter.top = new FormAttachment(0, this.margin);
        fdSelectionFilter.right = new FormAttachment(100, 0);
        fdSelectionFilter.left = new FormAttachment((Control)this.wlMarketplaces, 10);
        this.selectionFilter.setLayoutData((Object)fdSelectionFilter);
        this.selectionFilter.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                MarketplaceDialog.this.filter();
            }
        });
        this.expandBar = new ExpandBar((Composite)this.shell, 768);
        this.expandBar.addExpandListener(new ExpandListener(){

            public void itemCollapsed(ExpandEvent e) {
            }

            public void itemExpanded(ExpandEvent e) {
                ExpandItem item = (ExpandItem)(e.item == null ? e.getSource() : e.item);
                if (item.getControl() != null) {
                    return;
                }
                MarketplaceDialog.this.initExpandItemControl(item);
            }
        });
        FormData fdBar = new FormData();
        fdBar.left = new FormAttachment(0, 0);
        fdBar.top = new FormAttachment((Control)this.wlMarketplaces, this.margin);
        fdBar.right = new FormAttachment(100, 0);
        fdBar.bottom = new FormAttachment(100, -100);
        this.expandBar.setLayoutData((Object)fdBar);
        this.pmd = new ProgressMonitorDialog(this.shell);
        this.upgradeSelectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    final Button button = (Button)(e.item == null ? e.getSource() : e.item);
                    Composite composite = button.getParent();
                    final MarketEntry marketEntry = (MarketEntry)composite.getData("marketEntry");
                    if (marketEntry.getId().equals("market")) {
                        MessageBox mb = new MessageBox(MarketplaceDialog.this.shell, 200);
                        mb.setMessage(BaseMessages.getString((Class)MARKET_PKG, (String)"MarketplacesDialog.UpgradeMarket.Message", (String[])new String[0]));
                        mb.setText(BaseMessages.getString((Class)MARKET_PKG, (String)"MarketplacesDialog.UpgradeMarket.Title", (String[])new String[0]));
                        int id = mb.open();
                        if (id == 64) {
                            MarketplaceDialog.this.dispose();
                            Market.upgradeMarket(marketEntry);
                        }
                    } else {
                        try {
                            MarketplaceDialog.this.pmd.run(true, true, (IRunnableWithProgress)new ProgressMonitorRunner(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        Market.install(marketEntry, MarketplaceDialog.this.pmd);
                                        button.setEnabled(false);
                                    }
                                    catch (KettleException ke) {
                                        new ErrorDialog(MarketplaceDialog.this.shell, BaseMessages.getString((Class)MARKET_PKG, (String)"Market.error", (String[])new String[0]), BaseMessages.getString((Class)MARKET_PKG, (String)"Market.installUninstall.error", (String[])new String[0]), (Exception)((Object)ke));
                                    }
                                }
                            }));
                        }
                        catch (Exception ex) {
                            new ErrorDialog(MarketplaceDialog.this.shell, "Error with Progress Monitor Dialog", "Error with Progress Monitor Dialog", ex);
                        }
                    }
                }
                catch (KettleException ke) {
                    new ErrorDialog(MarketplaceDialog.this.shell, BaseMessages.getString((Class)MARKET_PKG, (String)"Market.error", (String[])new String[0]), BaseMessages.getString((Class)MARKET_PKG, (String)"Market.installUninstall.error", (String[])new String[0]), (Exception)((Object)ke));
                }
            }
        };
        this.installSelectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    final Button button = (Button)(e.item == null ? e.getSource() : e.item);
                    final Composite composite = button.getParent();
                    final MarketEntry marketEntry = (MarketEntry)composite.getData("marketEntry");
                    if (marketEntry.getId().equals("market")) {
                        MessageBox mb = new MessageBox(MarketplaceDialog.this.shell, 200);
                        mb.setMessage(BaseMessages.getString((Class)MARKET_PKG, (String)"MarketplacesDialog.UninstallMarket.Message", (String[])new String[0]));
                        mb.setText(BaseMessages.getString((Class)MARKET_PKG, (String)"MarketplacesDialog.UninstallMarket.Title", (String[])new String[0]));
                        int id = mb.open();
                        if (id == 64) {
                            MarketplaceDialog.this.dispose();
                            MarketplaceDialog.this.pmd.run(true, true, (IRunnableWithProgress)new ProgressMonitorRunner(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        Market.uninstallMarket();
                                    }
                                    catch (KettleException ke) {
                                        new ErrorDialog(MarketplaceDialog.this.shell, BaseMessages.getString((Class)MARKET_PKG, (String)"Market.error", (String[])new String[0]), BaseMessages.getString((Class)MARKET_PKG, (String)"Market.installUninstall.error", (String[])new String[0]), (Exception)((Object)ke));
                                    }
                                }
                            }));
                        }
                    } else {
                        MarketplaceDialog.this.pmd.run(true, true, (IRunnableWithProgress)new ProgressMonitorRunner(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    Market.installUninstall(marketEntry, marketEntry.isInstalled(), MarketplaceDialog.this.pmd);
                                    Market.discoverInstalledVersion(marketEntry);
                                    MarketplaceDialog.this.setButtonLabel(button, marketEntry.isInstalled());
                                    MarketplaceDialog.this.setPluginName(marketEntry);
                                    Button upgradeButton = null;
                                    for (Control control : composite.getChildren()) {
                                        if (!(control instanceof Button) || !"upgradeButton".equals(control.getData("id"))) continue;
                                        upgradeButton = (Button)control;
                                        break;
                                    }
                                    if (upgradeButton != null) {
                                        if (marketEntry.isInstalled() && marketEntry.getInstalledVersion().compareTo(marketEntry.getVersion()) < 0) {
                                            upgradeButton.setVisible(true);
                                        } else {
                                            upgradeButton.setVisible(false);
                                        }
                                    }
                                }
                                catch (KettleException ke) {
                                    new ErrorDialog(MarketplaceDialog.this.shell, BaseMessages.getString((Class)MARKET_PKG, (String)"Market.error", (String[])new String[0]), BaseMessages.getString((Class)MARKET_PKG, (String)"Market.installUninstall.error", (String[])new String[0]), (Exception)((Object)ke));
                                }
                            }
                        }));
                    }
                }
                catch (Throwable ke) {
                    new ErrorDialog(MarketplaceDialog.this.shell, BaseMessages.getString((Class)MARKET_PKG, (String)"Market.error", (String[])new String[0]), BaseMessages.getString((Class)MARKET_PKG, (String)"Market.installUninstall.error", (String[])new String[0]), ke);
                }
            }
        };
        this.addMarketPlaceEntries();
        SelectionAdapter checkListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MarketplaceDialog.this.filter();
            }
        };
        this.checkInstalled = new Button((Composite)this.shell, 32);
        this.checkInstalled.setText(BaseMessages.getString(MARKET_PKG, (String)"MarketplacesDialog.CheckInstalled", (String[])new String[0]));
        this.checkInstalled.setSelection(true);
        this.checkInstalled.addSelectionListener((SelectionListener)checkListener);
        this.props.setLook((Control)this.checkInstalled);
        FormData fdInstalled = new FormData();
        fdInstalled.left = new FormAttachment(0, 0);
        fdInstalled.top = new FormAttachment((Control)this.expandBar, this.margin);
        fdInstalled.right = new FormAttachment(100, 0);
        this.checkInstalled.setLayoutData((Object)fdInstalled);
        this.checkNotinstalled = new Button((Composite)this.shell, 32);
        this.checkNotinstalled.setText(BaseMessages.getString(MARKET_PKG, (String)"MarketplacesDialog.CheckNotinstalled", (String[])new String[0]));
        this.checkNotinstalled.setSelection(true);
        this.checkNotinstalled.addSelectionListener((SelectionListener)checkListener);
        this.props.setLook((Control)this.checkNotinstalled);
        FormData fdNotinstalled = new FormData();
        fdNotinstalled.left = new FormAttachment(0, 0);
        fdNotinstalled.top = new FormAttachment((Control)this.checkInstalled, this.margin);
        fdNotinstalled.right = new FormAttachment(100, 0);
        this.checkNotinstalled.setLayoutData((Object)fdNotinstalled);
        this.wClose = new Button((Composite)this.shell, 8);
        this.wClose.setText(BaseMessages.getString(MARKET_PKG, (String)"System.Button.Close", (String[])new String[0]));
        this.wClose.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MarketplaceDialog.this.dispose();
            }
        });
        BaseStepDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{this.wClose}, (int)this.margin, null);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                MarketplaceDialog.this.dispose();
            }
        });
        BaseStepDialog.setSize((Shell)this.shell);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    private ExpandItem findExpandItem(MarketEntry marketEntry) {
        Composite composite = this.marketEntryControls.get(marketEntry);
        if (composite == null) {
            return null;
        }
        for (ExpandItem expandItem : this.expandBar.getItems()) {
            if (expandItem.getControl() != composite) continue;
            return expandItem;
        }
        return null;
    }

    private Composite getMarketEntryControl(MarketEntry marketEntry) {
        Composite composite;
        if (this.marketEntryControls.containsKey(marketEntry)) {
            composite = this.marketEntryControls.get(marketEntry);
        } else {
            composite = this.createMarketEntryControl(marketEntry);
            this.marketEntryControls.put(marketEntry, composite);
        }
        return composite;
    }

    private void initExpandItemControl(ExpandItem expandItem) {
        MarketEntry marketEntry = (MarketEntry)expandItem.getData("marketEntry");
        Composite composite = this.getMarketEntryControl(marketEntry);
        expandItem.setHeight(composite.computeSize((int)-1, (int)-1).y + 30);
        expandItem.setControl((Control)composite);
    }

    private ExpandItem createExpandItem(MarketEntry marketEntry) {
        Image image;
        ExpandItem expandItem = new ExpandItem(this.expandBar, 0);
        expandItem.setData("marketEntry", (Object)marketEntry);
        Market.discoverInstalledVersion(marketEntry);
        this.setPluginName(expandItem, marketEntry.getName(), marketEntry.isInstalled());
        expandItem.setHeight(30);
        switch (marketEntry.getType()) {
            case Step: {
                image = GUIResource.getInstance().getImageTransGraph();
                break;
            }
            case JobEntry: {
                image = GUIResource.getInstance().getImageTransGraph();
                break;
            }
            case SpoonPlugin: {
                image = GUIResource.getInstance().getImageTransGraph();
                break;
            }
            case Database: {
                image = GUIResource.getInstance().getImageConnection();
                break;
            }
            case HadoopShim: {
                image = GUIResource.getInstance().getHadoop();
                break;
            }
            default: {
                image = GUIResource.getInstance().getImageArrow();
            }
        }
        expandItem.setImage(image);
        return expandItem;
    }

    private Composite createMarketEntryControl(MarketEntry marketEntry) {
        final ScrolledComposite scrollBox = new ScrolledComposite((Composite)this.expandBar, 512);
        scrollBox.setExpandHorizontal(true);
        scrollBox.setExpandVertical(true);
        final Composite composite = new Composite((Composite)scrollBox, 0);
        composite.setData("marketEntry", (Object)marketEntry);
        FormLayout layout = new FormLayout();
        layout.marginHeight = this.margin;
        layout.marginWidth = this.margin;
        composite.setLayout((Layout)layout);
        this.props.setLook((Control)composite);
        composite.addListener(9, new Listener(){
            int width = -1;

            public void handleEvent(Event e) {
                int newWidth = composite.getSize().x;
                if (newWidth != this.width) {
                    scrollBox.setMinHeight(composite.computeSize((int)newWidth, (int)-1).y + 15);
                    this.width = newWidth;
                }
            }
        });
        scrollBox.setContent((Control)composite);
        Control lastControl = null;
        this.addLeftLabel(composite, BaseMessages.getString(MARKET_PKG, (String)"MarketplacesDialog.ID.label", (String[])new String[0]), lastControl);
        lastControl = this.addRightLabel(composite, Const.NVL((String)marketEntry.getId(), (String)""), lastControl);
        this.addLeftLabel(composite, BaseMessages.getString(MARKET_PKG, (String)"MarketplacesDialog.Name.label", (String[])new String[0]), lastControl);
        lastControl = this.addRightLabel(composite, Const.NVL((String)marketEntry.getName(), (String)""), lastControl);
        this.addLeftLabel(composite, BaseMessages.getString(MARKET_PKG, (String)"MarketplacesDialog.AvailableVersion.label", (String[])new String[0]), lastControl);
        lastControl = this.addRightLabel(composite, Const.NVL((String)marketEntry.getVersion(), (String)""), lastControl);
        if (!Const.isEmpty((String)marketEntry.getMinPdiVersion())) {
            this.addLeftLabel(composite, BaseMessages.getString(MARKET_PKG, (String)"MarketplacesDialog.MinPdiVersion.label", (String[])new String[0]), lastControl);
            lastControl = this.addRightLabel(composite, Const.NVL((String)marketEntry.getMinPdiVersion(), (String)""), lastControl);
        }
        if (!Const.isEmpty((String)marketEntry.getMaxPdiVersion())) {
            this.addLeftLabel(composite, BaseMessages.getString(MARKET_PKG, (String)"MarketplacesDialog.MaxPdiVersion.label", (String[])new String[0]), lastControl);
            lastControl = this.addRightLabel(composite, Const.NVL((String)marketEntry.getMaxPdiVersion(), (String)""), lastControl);
        }
        if (!Const.isEmpty((String)marketEntry.getAuthor())) {
            this.addLeftLabel(composite, BaseMessages.getString(MARKET_PKG, (String)"MarketplacesDialog.Author.label", (String[])new String[0]), lastControl);
            lastControl = this.addRightLabel(composite, Const.NVL((String)marketEntry.getAuthor(), (String)""), lastControl);
        }
        this.addLeftLabel(composite, BaseMessages.getString(MARKET_PKG, (String)"MarketplacesDialog.InstallPath.label", (String[])new String[0]), lastControl);
        lastControl = this.addRightLabel(composite, new File(Market.buildPluginsFolderPath(marketEntry)).getAbsolutePath(), lastControl);
        if (!Const.isEmpty((String)marketEntry.getDescription())) {
            this.addLeftLabel(composite, BaseMessages.getString(MARKET_PKG, (String)"MarketplacesDialog.Description.label", (String[])new String[0]), lastControl);
            lastControl = this.addRightLabel(composite, marketEntry.getDescription(), lastControl);
        }
        this.addLeftLabel(composite, BaseMessages.getString(MARKET_PKG, (String)"MarketplacesDialog.PackageURL.label", (String[])new String[0]), lastControl);
        lastControl = this.addRightURL(composite, marketEntry.getPackageUrl(), lastControl);
        if (!Const.isEmpty((String)marketEntry.getDocumentationUrl())) {
            this.addLeftLabel(composite, BaseMessages.getString(MARKET_PKG, (String)"MarketplacesDialog.Documentation.label", (String[])new String[0]), lastControl);
            lastControl = this.addRightURL(composite, marketEntry.getDocumentationUrl(), lastControl);
        }
        if (!Const.isEmpty((String)marketEntry.getCasesUrl())) {
            this.addLeftLabel(composite, BaseMessages.getString(MARKET_PKG, (String)"MarketplacesDialog.CaseTracking.label", (String[])new String[0]), lastControl);
            lastControl = this.addRightURL(composite, marketEntry.getCasesUrl(), lastControl);
        }
        if (!Const.isEmpty((String)marketEntry.getSourceUrl())) {
            this.addLeftLabel(composite, BaseMessages.getString(MARKET_PKG, (String)"MarketplacesDialog.SourceCode.label", (String[])new String[0]), lastControl);
            lastControl = this.addRightURL(composite, marketEntry.getSourceUrl(), lastControl);
        }
        if (!Const.isEmpty((String)marketEntry.getLicenseName())) {
            this.addLeftLabel(composite, BaseMessages.getString(MARKET_PKG, (String)"MarketplacesDialog.License.label", (String[])new String[0]), lastControl);
            lastControl = this.addRightLabel(composite, Const.NVL((String)marketEntry.getLicenseName(), (String)""), lastControl);
        }
        if (!Const.isEmpty((String)marketEntry.getLicenseText())) {
            this.addLeftLabel(composite, BaseMessages.getString(MARKET_PKG, (String)"MarketplacesDialog.LicenseDetails.label", (String[])new String[0]), lastControl);
            lastControl = this.addRightLabel(composite, Const.NVL((String)marketEntry.getLicenseText(), (String)""), lastControl);
        }
        this.addLeftLabel(composite, BaseMessages.getString(MARKET_PKG, (String)"MarketplacesDialog.SupportLevel.label", (String[])new String[0]), lastControl);
        lastControl = this.addRightLabel(composite, marketEntry.getSupportLevel().getDescription(), lastControl);
        if (!Const.isEmpty((String)marketEntry.getSupportMessage())) {
            this.addLeftLabel(composite, BaseMessages.getString(MARKET_PKG, (String)"MarketplacesDialog.SupportMessage.label", (String[])new String[0]), lastControl);
            lastControl = this.addRightLabel(composite, marketEntry.getSupportMessage(), lastControl);
        }
        if (!Const.isEmpty((String)marketEntry.getSupportUrl())) {
            this.addLeftLabel(composite, BaseMessages.getString(MARKET_PKG, (String)"MarketplacesDialog.SupportURL.label", (String[])new String[0]), lastControl);
            lastControl = this.addRightURL(composite, marketEntry.getSupportUrl(), lastControl);
        }
        Market.discoverInstalledVersion(marketEntry);
        if (marketEntry.isInstalled()) {
            this.addLeftLabel(composite, BaseMessages.getString(MARKET_PKG, (String)"MarketplacesDialog.InstalledVersion.label", (String[])new String[0]), lastControl);
            lastControl = this.addRightLabel(composite, marketEntry.getInstalledVersion(), lastControl);
        }
        Button installedButton = new Button(composite, 8);
        installedButton.setData("id", (Object)"installedButton");
        this.setButtonLabel(installedButton, marketEntry.isInstalled());
        installedButton.addSelectionListener((SelectionListener)this.installSelectionListener);
        Button upgradeButton = new Button(composite, 8);
        upgradeButton.setData("id", (Object)"upgradeButton");
        upgradeButton.setText(BaseMessages.getString(MARKET_PKG, (String)"MarketplacesDialog.UpgradeTo.button", (String[])new String[]{marketEntry.getVersion()}));
        upgradeButton.addSelectionListener((SelectionListener)this.upgradeSelectionListener);
        BaseStepDialog.positionBottomButtons((Composite)composite, (Button[])new Button[]{installedButton, upgradeButton}, (int)this.margin, (Control)lastControl);
        boolean showUpgradeButton = marketEntry.isInstalled() && (marketEntry.getInstalledVersion() == null || marketEntry.getVersion() == null || marketEntry.getInstalledVersion().compareTo(marketEntry.getVersion()) < 0);
        upgradeButton.setVisible(showUpgradeButton);
        Label wlName = new Label(composite, 16384);
        this.props.setLook((Control)wlName);
        wlName.setText("Name:");
        FormData fdlName = new FormData();
        fdlName.top = new FormAttachment(0, 0);
        fdlName.left = new FormAttachment(0, 0);
        fdlName.right = new FormAttachment(this.middle, 0);
        wlName.setLayoutData((Object)fdlName);
        return scrollBox;
    }

    private void addMarketPlaceEntries() {
        if (marketEntries == null) {
            marketEntries = new MarketEntries();
        }
        for (MarketEntry marketEntry : marketEntries) {
            this.createExpandItem(marketEntry);
        }
    }

    private void setButtonLabel(Button button, boolean isInstalled) {
        String text = isInstalled ? "Marketplaces.Dialog.UninstallButton.label" : "Marketplaces.Dialog.install.button.label";
        button.setText(BaseMessages.getString(MARKET_PKG, (String)text, (String[])new String[0]));
    }

    private void setPluginName(MarketEntry marketEntry) {
        ExpandItem expandItem = this.findExpandItem(marketEntry);
        this.setPluginName(expandItem, marketEntry.getName(), marketEntry.isInstalled());
    }

    private void setPluginName(ExpandItem expandItem, String name, boolean isInstalled) {
        if (isInstalled) {
            expandItem.setText(BaseMessages.getString(MARKET_PKG, (String)"Marketplaces.Dialog.PluginInstalled.message", (String[])new String[]{name}));
        } else {
            expandItem.setText(BaseMessages.getString(MARKET_PKG, (String)"Marketplaces.Dialog.PluginNotInstalled.message", (String[])new String[]{name}));
        }
    }

    private void addLeftLabel(Composite composite, String string, Control lastControl) {
        Label label = new Label(composite, 131072);
        this.props.setLook((Control)label);
        if (string == null) {
            string = "null";
        }
        label.setText(string);
        label.setFont(GUIResource.getInstance().getFontBold());
        FormData fdLabel = new FormData();
        fdLabel.top = lastControl != null ? new FormAttachment(lastControl, 2 * this.margin) : new FormAttachment(0, 0);
        fdLabel.left = new FormAttachment(0, 0);
        fdLabel.right = new FormAttachment(this.middle / 2, 0);
        label.setLayoutData((Object)fdLabel);
    }

    private Control addRightLabel(Composite composite, String string, Control lastControl) {
        Label label = new Label(composite, 16448);
        this.props.setLook((Control)label);
        if (string == null) {
            string = "null";
        }
        label.setText(string);
        FormData fdLabel = new FormData();
        fdLabel.top = lastControl != null ? new FormAttachment(lastControl, 2 * this.margin) : new FormAttachment(0, 0);
        fdLabel.left = new FormAttachment(this.middle / 2, this.margin);
        fdLabel.right = new FormAttachment(100, 0);
        label.setLayoutData((Object)fdLabel);
        return label;
    }

    private Control addRightURL(Composite composite, final String string, Control lastControl) {
        Link link = new Link(composite, 16448);
        this.props.setLook((Control)link);
        link.setText("<a>" + string + "</a>");
        FormData fdLabel = new FormData();
        fdLabel.top = lastControl != null ? new FormAttachment(lastControl, 2 * this.margin) : new FormAttachment(0, 0);
        fdLabel.left = new FormAttachment(this.middle / 2, this.margin);
        fdLabel.right = new FormAttachment(100, 0);
        link.setLayoutData((Object)fdLabel);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                Spoon.getInstance().addSpoonBrowser(string, string);
            }
        });
        return link;
    }

    public void dispose() {
        this.clearExpandItems();
        this.marketEntryControls.clear();
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }

    private void clearExpandItems() {
        for (ExpandItem item : this.expandBar.getItems()) {
            item.setExpanded(false);
            item.setControl(null);
            item.dispose();
        }
    }

    private void filter() {
        this.filter(this.selectionFilter.getText());
    }

    private void filter(String filter) {
        this.clearExpandItems();
        String filterUCase = filter.toUpperCase();
        boolean installed = this.checkInstalled.getSelection();
        boolean notInstalled = this.checkNotinstalled.getSelection();
        for (MarketEntry marketEntry : marketEntries) {
            boolean isInstalled;
            if ((!installed || !notInstalled) && ((isInstalled = marketEntry.isInstalled()) && !installed || !isInstalled && !notInstalled) || !filter.isEmpty() && !marketEntry.getName().toUpperCase().contains(filterUCase)) continue;
            this.createExpandItem(marketEntry);
        }
    }

    private class ProgressMonitorRunner
    implements IRunnableWithProgress {
        private Runnable runnable;

        public ProgressMonitorRunner(Runnable runnable) {
            this.runnable = runnable;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            try {
                Spoon.getInstance().getDisplay().asyncExec(this.runnable);
            }
            catch (Exception e) {
                throw new InvocationTargetException(e, "Error during install: " + e.toString());
            }
        }
    }
}

