/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.orm;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.lib.BigDecimalSerializer;
import com.cloudera.sqoop.lib.BlobRef;
import com.cloudera.sqoop.lib.BooleanParser;
import com.cloudera.sqoop.lib.ClobRef;
import com.cloudera.sqoop.lib.DelimiterSet;
import com.cloudera.sqoop.lib.FieldFormatter;
import com.cloudera.sqoop.lib.JdbcWritableBridge;
import com.cloudera.sqoop.lib.LargeObjectLoader;
import com.cloudera.sqoop.lib.LobSerializer;
import com.cloudera.sqoop.lib.RecordParser;
import com.cloudera.sqoop.lib.SqoopRecord;
import com.cloudera.sqoop.manager.ConnManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.BytesWritable;
import org.apache.sqoop.orm.CompilationManager;
import org.apache.sqoop.orm.TableClassName;

public class ClassWriter {
    public static final Log LOG = LogFactory.getLog((String)ClassWriter.class.getName());
    public static final HashSet<String> JAVA_RESERVED_WORDS = new HashSet();
    public static final int CLASS_WRITER_VERSION = 3;
    private SqoopOptions options;
    private ConnManager connManager;
    private String tableName;
    private CompilationManager compileManager;
    private boolean bigDecimalFormatString;

    public ClassWriter(SqoopOptions opts, ConnManager connMgr, String table, CompilationManager compMgr) {
        this.options = opts;
        this.connManager = connMgr;
        this.tableName = table;
        this.compileManager = compMgr;
        this.bigDecimalFormatString = this.options.getConf().getBoolean("sqoop.bigdecimal.format.string", true);
    }

    public static String getIdentifierStrForChar(char c) {
        if (Character.isJavaIdentifierPart(c)) {
            return "" + c;
        }
        if (Character.isWhitespace(c)) {
            return null;
        }
        return "_";
    }

    private static boolean isReservedWord(String word) {
        return JAVA_RESERVED_WORDS.contains(word);
    }

    public static String toIdentifier(String candidate) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (char c : candidate.toCharArray()) {
            if (Character.isJavaIdentifierStart(c) && first) {
                sb.append(c);
                first = false;
                continue;
            }
            if (Character.isJavaIdentifierPart(c) && !first) {
                sb.append(c);
                continue;
            }
            if (first && Character.isJavaIdentifierPart(c) && !Character.isJavaIdentifierStart(c)) {
                sb.append("_");
                sb.append(c);
                first = false;
                continue;
            }
            String translated = ClassWriter.getIdentifierStrForChar(c);
            if (null == translated) continue;
            sb.append(translated);
            first = false;
        }
        return sb.toString();
    }

    public static String toJavaIdentifier(String candidate) {
        String output = ClassWriter.toIdentifier(candidate);
        if (ClassWriter.isReservedWord(output)) {
            return "_" + output;
        }
        if (candidate.startsWith("_")) {
            return "_" + output;
        }
        return output;
    }

    private String toJavaType(String columnName, int sqlType) {
        Properties mapping = this.options.getMapColumnJava();
        if (mapping.containsKey(columnName)) {
            String type = mapping.getProperty(columnName);
            if (LOG.isDebugEnabled()) {
                LOG.info((Object)("Overriding type of column " + columnName + " to " + type));
            }
            return type;
        }
        return this.connManager.toJavaType(this.tableName, columnName, sqlType);
    }

    private String dbGetterForType(String javaType) {
        String[] parts = javaType.split("\\.");
        if (parts.length == 0) {
            LOG.error((Object)("No ResultSet method for Java type " + javaType));
            return null;
        }
        String lastPart = parts[parts.length - 1];
        try {
            String getter = "read" + Character.toUpperCase(lastPart.charAt(0)) + lastPart.substring(1);
            return getter;
        }
        catch (StringIndexOutOfBoundsException oob) {
            LOG.error((Object)("Could not infer JdbcWritableBridge getter for Java type " + javaType));
            return null;
        }
    }

    private String dbSetterForType(String javaType) {
        String[] parts = javaType.split("\\.");
        if (parts.length == 0) {
            LOG.error((Object)("No PreparedStatement Set method for Java type " + javaType));
            return null;
        }
        String lastPart = parts[parts.length - 1];
        try {
            String setter = "write" + Character.toUpperCase(lastPart.charAt(0)) + lastPart.substring(1);
            return setter;
        }
        catch (StringIndexOutOfBoundsException oob) {
            LOG.error((Object)("Could not infer PreparedStatement setter for Java type " + javaType));
            return null;
        }
    }

    private String stringifierForType(String javaType, String colName) {
        if (javaType.equals("String")) {
            String r = colName + "==null?\"" + this.options.getNullStringValue() + "\":" + colName;
            return r;
        }
        if (javaType.equals("java.math.BigDecimal") && this.bigDecimalFormatString) {
            String r = colName + "==null?\"" + this.options.getNullNonStringValue() + "\":" + colName + ".toPlainString()";
            return r;
        }
        String r = colName + "==null?\"" + this.options.getNullNonStringValue() + "\":" + "\"\" + " + colName;
        return r;
    }

    private String rpcGetterForType(String javaType, String inputObj, String colName) {
        if (javaType.equals("Integer")) {
            return "    this." + colName + " = Integer.valueOf(" + inputObj + ".readInt());\n";
        }
        if (javaType.equals("Long")) {
            return "    this." + colName + " = Long.valueOf(" + inputObj + ".readLong());\n";
        }
        if (javaType.equals("Float")) {
            return "    this." + colName + " = Float.valueOf(" + inputObj + ".readFloat());\n";
        }
        if (javaType.equals("Double")) {
            return "    this." + colName + " = Double.valueOf(" + inputObj + ".readDouble());\n";
        }
        if (javaType.equals("Boolean")) {
            return "    this." + colName + " = Boolean.valueOf(" + inputObj + ".readBoolean());\n";
        }
        if (javaType.equals("String")) {
            return "    this." + colName + " = Text.readString(" + inputObj + ");\n";
        }
        if (javaType.equals("java.sql.Date")) {
            return "    this." + colName + " = new Date(" + inputObj + ".readLong());\n";
        }
        if (javaType.equals("java.sql.Time")) {
            return "    this." + colName + " = new Time(" + inputObj + ".readLong());\n";
        }
        if (javaType.equals("java.sql.Timestamp")) {
            return "    this." + colName + " = new Timestamp(" + inputObj + ".readLong());\n" + "    this." + colName + ".setNanos(" + inputObj + ".readInt());\n";
        }
        if (javaType.equals("java.math.BigDecimal")) {
            return "    this." + colName + " = " + BigDecimalSerializer.class.getCanonicalName() + ".readFields(" + inputObj + ");\n";
        }
        if (javaType.equals(ClobRef.class.getName())) {
            return "    this." + colName + " = " + LobSerializer.class.getCanonicalName() + ".readClobFields(" + inputObj + ");\n";
        }
        if (javaType.equals(BlobRef.class.getName())) {
            return "    this." + colName + " = " + LobSerializer.class.getCanonicalName() + ".readBlobFields(" + inputObj + ");\n";
        }
        if (javaType.equals(BytesWritable.class.getName())) {
            return "    this." + colName + " = new BytesWritable();\n" + "    this." + colName + ".readFields(" + inputObj + ");\n";
        }
        LOG.error((Object)("No ResultSet method for Java type " + javaType));
        return null;
    }

    private String rpcGetterForMaybeNull(String javaType, String inputObj, String colName) {
        return "    if (" + inputObj + ".readBoolean()) { \n" + "        this." + colName + " = null;\n" + "    } else {\n" + this.rpcGetterForType(javaType, inputObj, colName) + "    }\n";
    }

    private String rpcSetterForType(String javaType, String outputObj, String colName) {
        if (javaType.equals("Integer")) {
            return "    " + outputObj + ".writeInt(this." + colName + ");\n";
        }
        if (javaType.equals("Long")) {
            return "    " + outputObj + ".writeLong(this." + colName + ");\n";
        }
        if (javaType.equals("Boolean")) {
            return "    " + outputObj + ".writeBoolean(this." + colName + ");\n";
        }
        if (javaType.equals("Float")) {
            return "    " + outputObj + ".writeFloat(this." + colName + ");\n";
        }
        if (javaType.equals("Double")) {
            return "    " + outputObj + ".writeDouble(this." + colName + ");\n";
        }
        if (javaType.equals("String")) {
            return "    Text.writeString(" + outputObj + ", " + colName + ");\n";
        }
        if (javaType.equals("java.sql.Date")) {
            return "    " + outputObj + ".writeLong(this." + colName + ".getTime());\n";
        }
        if (javaType.equals("java.sql.Time")) {
            return "    " + outputObj + ".writeLong(this." + colName + ".getTime());\n";
        }
        if (javaType.equals("java.sql.Timestamp")) {
            return "    " + outputObj + ".writeLong(this." + colName + ".getTime());\n" + "    " + outputObj + ".writeInt(this." + colName + ".getNanos());\n";
        }
        if (javaType.equals(BytesWritable.class.getName())) {
            return "    this." + colName + ".write(" + outputObj + ");\n";
        }
        if (javaType.equals("java.math.BigDecimal")) {
            return "    " + BigDecimalSerializer.class.getCanonicalName() + ".write(this." + colName + ", " + outputObj + ");\n";
        }
        if (javaType.equals(ClobRef.class.getName())) {
            return "    " + LobSerializer.class.getCanonicalName() + ".writeClob(this." + colName + ", " + outputObj + ");\n";
        }
        if (javaType.equals(BlobRef.class.getName())) {
            return "    " + LobSerializer.class.getCanonicalName() + ".writeBlob(this." + colName + ", " + outputObj + ");\n";
        }
        throw new IllegalArgumentException("No ResultSet method for Java type " + javaType);
    }

    private String rpcSetterForMaybeNull(String javaType, String outputObj, String colName) {
        return "    if (null == this." + colName + ") { \n" + "        " + outputObj + ".writeBoolean(true);\n" + "    } else {\n" + "        " + outputObj + ".writeBoolean(false);\n" + this.rpcSetterForType(javaType, outputObj, colName) + "    }\n";
    }

    private void generateFields(Map<String, Integer> columnTypes, String[] colNames, String className, StringBuilder sb) {
        for (String col : colNames) {
            int sqlType = columnTypes.get(col);
            String javaType = this.toJavaType(col, sqlType);
            if (null == javaType) {
                LOG.error((Object)("Cannot resolve SQL type " + sqlType));
                continue;
            }
            sb.append("  private " + javaType + " " + col + ";\n");
            sb.append("  public " + javaType + " get_" + col + "() {\n");
            sb.append("    return " + col + ";\n");
            sb.append("  }\n");
            sb.append("  public void set_" + col + "(" + javaType + " " + col + ") {\n");
            sb.append("    this." + col + " = " + col + ";\n");
            sb.append("  }\n");
            sb.append("  public " + className + " with_" + col + "(" + javaType + " " + col + ") {\n");
            sb.append("    this." + col + " = " + col + ";\n");
            sb.append("    return this;\n");
            sb.append("  }\n");
        }
    }

    private void generateEquals(Map<String, Integer> columnTypes, String[] colNames, String className, StringBuilder sb) {
        sb.append("  public boolean equals(Object o) {\n");
        sb.append("    if (this == o) {\n");
        sb.append("      return true;\n");
        sb.append("    }\n");
        sb.append("    if (!(o instanceof " + className + ")) {\n");
        sb.append("      return false;\n");
        sb.append("    }\n");
        sb.append("    " + className + " that = (" + className + ") o;\n");
        sb.append("    boolean equal = true;\n");
        for (String col : colNames) {
            int sqlType = columnTypes.get(col);
            String javaType = this.toJavaType(col, sqlType);
            if (null == javaType) {
                LOG.error((Object)("Cannot resolve SQL type " + sqlType));
                continue;
            }
            sb.append("    equal = equal && (this." + col + " == null ? that." + col + " == null : this." + col + ".equals(that." + col + "));\n");
        }
        sb.append("    return equal;\n");
        sb.append("  }\n");
    }

    private void generateDbRead(Map<String, Integer> columnTypes, String[] colNames, StringBuilder sb) {
        sb.append("  public void readFields(ResultSet __dbResults) ");
        sb.append("throws SQLException {\n");
        sb.append("    this.__cur_result_set = __dbResults;\n");
        int fieldNum = 0;
        for (String col : colNames) {
            ++fieldNum;
            int sqlType = columnTypes.get(col);
            String javaType = this.toJavaType(col, sqlType);
            if (null == javaType) {
                LOG.error((Object)("No Java type for SQL type " + sqlType + " for column " + col));
                continue;
            }
            String getterMethod = this.dbGetterForType(javaType);
            if (null == getterMethod) {
                LOG.error((Object)("No db getter method for Java type " + javaType));
                continue;
            }
            sb.append("    this." + col + " = JdbcWritableBridge." + getterMethod + "(" + fieldNum + ", __dbResults);\n");
        }
        sb.append("  }\n");
    }

    private void generateLoadLargeObjects(Map<String, Integer> columnTypes, String[] colNames, StringBuilder sb) {
        sb.append("  public void loadLargeObjects(LargeObjectLoader __loader)\n");
        sb.append("      throws SQLException, IOException, ");
        sb.append("InterruptedException {\n");
        int fieldNum = 0;
        for (String col : colNames) {
            ++fieldNum;
            int sqlType = columnTypes.get(col);
            String javaType = this.toJavaType(col, sqlType);
            if (null == javaType) {
                LOG.error((Object)("No Java type for SQL type " + sqlType + " for column " + col));
                continue;
            }
            String getterMethod = this.dbGetterForType(javaType);
            if (!"readClobRef".equals(getterMethod) && !"readBlobRef".equals(getterMethod)) continue;
            sb.append("    this." + col + " = __loader." + getterMethod + "(" + fieldNum + ", this.__cur_result_set);\n");
        }
        sb.append("  }\n");
    }

    private void generateDbWrite(Map<String, Integer> columnTypes, String[] colNames, StringBuilder sb) {
        sb.append("  public void write(PreparedStatement __dbStmt) throws SQLException {\n");
        sb.append("    write(__dbStmt, 0);\n");
        sb.append("  }\n\n");
        sb.append("  public int write(PreparedStatement __dbStmt, int __off) throws SQLException {\n");
        int fieldNum = 0;
        for (String col : colNames) {
            ++fieldNum;
            int sqlType = columnTypes.get(col);
            String javaType = this.toJavaType(col, sqlType);
            if (null == javaType) {
                LOG.error((Object)("No Java type for SQL type " + sqlType + " for column " + col));
                continue;
            }
            String setterMethod = this.dbSetterForType(javaType);
            if (null == setterMethod) {
                LOG.error((Object)("No db setter method for Java type " + javaType));
                continue;
            }
            sb.append("    JdbcWritableBridge." + setterMethod + "(" + col + ", " + fieldNum + " + __off, " + sqlType + ", __dbStmt);\n");
        }
        sb.append("    return " + fieldNum + ";\n");
        sb.append("  }\n");
    }

    private void generateHadoopRead(Map<String, Integer> columnTypes, String[] colNames, StringBuilder sb) {
        sb.append("  public void readFields(DataInput __dataIn) throws IOException {\n");
        for (String col : colNames) {
            int sqlType = columnTypes.get(col);
            String javaType = this.toJavaType(col, sqlType);
            if (null == javaType) {
                LOG.error((Object)("No Java type for SQL type " + sqlType + " for column " + col));
                continue;
            }
            String getterMethod = this.rpcGetterForMaybeNull(javaType, "__dataIn", col);
            if (null == getterMethod) {
                LOG.error((Object)("No RPC getter method for Java type " + javaType));
                continue;
            }
            sb.append(getterMethod);
        }
        sb.append("  }\n");
    }

    private void generateCloneMethod(Map<String, Integer> columnTypes, String[] colNames, StringBuilder sb) {
        TableClassName tableNameInfo = new TableClassName(this.options);
        String className = tableNameInfo.getShortClassForTable(this.tableName);
        sb.append("  public Object clone() throws CloneNotSupportedException {\n");
        sb.append("    " + className + " o = (" + className + ") super.clone();\n");
        for (String colName : colNames) {
            int sqlType = columnTypes.get(colName);
            String javaType = this.toJavaType(colName, sqlType);
            if (null == javaType) continue;
            if (javaType.equals("java.sql.Date") || javaType.equals("java.sql.Time") || javaType.equals("java.sql.Timestamp") || javaType.equals(ClobRef.class.getName()) || javaType.equals(BlobRef.class.getName())) {
                sb.append("    o." + colName + " = (o." + colName + " != null) ? (" + javaType + ") o." + colName + ".clone() : null;\n");
                continue;
            }
            if (!javaType.equals(BytesWritable.class.getName())) continue;
            sb.append("    o." + colName + " = new BytesWritable(" + "Arrays.copyOf(" + colName + ".getBytes(), " + colName + ".getLength()));\n");
        }
        sb.append("    return o;\n");
        sb.append("  }\n\n");
    }

    private void generateSetField(Map<String, Integer> columnTypes, String[] colNames, StringBuilder sb) {
        sb.append("  public void setField(String __fieldName, Object __fieldVal) {\n");
        boolean first = true;
        for (String colName : colNames) {
            int sqlType = columnTypes.get(colName);
            String javaType = this.toJavaType(colName, sqlType);
            if (null == javaType) continue;
            if (!first) {
                sb.append("    else");
            }
            sb.append("    if (\"" + colName + "\".equals(__fieldName)) {\n");
            sb.append("      this." + colName + " = (" + javaType + ") __fieldVal;\n");
            sb.append("    }\n");
            first = false;
        }
        sb.append("    else {\n");
        sb.append("      throw new RuntimeException(");
        sb.append("\"No such field: \" + __fieldName);\n");
        sb.append("    }\n");
        sb.append("  }\n");
    }

    private void generateGetFieldMap(Map<String, Integer> columnTypes, String[] colNames, StringBuilder sb) {
        sb.append("  public Map<String, Object> getFieldMap() {\n");
        sb.append("    Map<String, Object> __sqoop$field_map = new TreeMap<String, Object>();\n");
        for (String colName : colNames) {
            sb.append("    __sqoop$field_map.put(\"" + colName + "\", this." + colName + ");\n");
        }
        sb.append("    return __sqoop$field_map;\n");
        sb.append("  }\n\n");
    }

    private void generateToString(Map<String, Integer> columnTypes, String[] colNames, StringBuilder sb) {
        sb.append("  private final DelimiterSet __outputDelimiters = ");
        sb.append(this.options.getOutputDelimiters().formatConstructor() + ";\n");
        sb.append("  public String toString() {\n");
        sb.append("    return toString(__outputDelimiters, true);\n");
        sb.append("  }\n");
        sb.append("  public String toString(DelimiterSet delimiters) {\n");
        sb.append("    return toString(delimiters, true);\n");
        sb.append("  }\n");
        sb.append("  public String toString(boolean useRecordDelim) {\n");
        sb.append("    return toString(__outputDelimiters, useRecordDelim);\n");
        sb.append("  }\n");
        sb.append("  public String toString(DelimiterSet delimiters, ");
        sb.append("boolean useRecordDelim) {\n");
        sb.append("    StringBuilder __sb = new StringBuilder();\n");
        sb.append("    char fieldDelim = delimiters.getFieldsTerminatedBy();\n");
        boolean first = true;
        for (String col : colNames) {
            int sqlType = columnTypes.get(col);
            String javaType = this.toJavaType(col, sqlType);
            if (null == javaType) {
                LOG.error((Object)("No Java type for SQL type " + sqlType + " for column " + col));
                continue;
            }
            if (!first) {
                sb.append("    __sb.append(fieldDelim);\n");
            }
            first = false;
            String stringExpr = this.stringifierForType(javaType, col);
            if (null == stringExpr) {
                LOG.error((Object)("No toString method for Java type " + javaType));
                continue;
            }
            if (javaType.equals("String") && this.options.doHiveDropDelims()) {
                sb.append("    // special case for strings hive, droppingdelimiters \\n,\\r,\\01 from strings\n");
                sb.append("    __sb.append(FieldFormatter.hiveStringDropDelims(" + stringExpr + ", delimiters));\n");
                continue;
            }
            if (javaType.equals("String") && this.options.getHiveDelimsReplacement() != null) {
                sb.append("    // special case for strings hive, replacing delimiters \\n,\\r,\\01 with '" + this.options.getHiveDelimsReplacement() + "' from strings\n");
                sb.append("    __sb.append(FieldFormatter.hiveStringReplaceDelims(" + stringExpr + ", \"" + this.options.getHiveDelimsReplacement() + "\", " + "delimiters));\n");
                continue;
            }
            sb.append("    __sb.append(FieldFormatter.escapeAndEnclose(" + stringExpr + ", delimiters));\n");
        }
        sb.append("    if (useRecordDelim) {\n");
        sb.append("      __sb.append(delimiters.getLinesTerminatedBy());\n");
        sb.append("    }\n");
        sb.append("    return __sb.toString();\n");
        sb.append("  }\n");
    }

    private void generateParseMethod(String typ, StringBuilder sb) {
        sb.append("  public void parse(" + typ + " __record) " + "throws RecordParser.ParseError {\n");
        sb.append("    if (null == this.__parser) {\n");
        sb.append("      this.__parser = new RecordParser(__inputDelimiters);\n");
        sb.append("    }\n");
        sb.append("    List<String> __fields = this.__parser.parseRecord(__record);\n");
        sb.append("    __loadFromFields(__fields);\n");
        sb.append("  }\n\n");
    }

    private void parseNullVal(String javaType, String colName, StringBuilder sb) {
        if (javaType.equals("String")) {
            sb.append("    if (__cur_str.equals(\"" + this.options.getInNullStringValue() + "\")) { this.");
            sb.append(colName);
            sb.append(" = null; } else {\n");
        } else {
            sb.append("    if (__cur_str.equals(\"" + this.options.getInNullNonStringValue());
            sb.append("\") || __cur_str.length() == 0) { this.");
            sb.append(colName);
            sb.append(" = null; } else {\n");
        }
    }

    private void parseColumn(String colName, int colType, StringBuilder sb) {
        sb.append("    __cur_str = __it.next();\n");
        String javaType = this.toJavaType(colName, colType);
        this.parseNullVal(javaType, colName, sb);
        if (javaType.equals("String")) {
            sb.append("      this." + colName + " = __cur_str;\n");
        } else if (javaType.equals("Integer")) {
            sb.append("      this." + colName + " = Integer.valueOf(__cur_str);\n");
        } else if (javaType.equals("Long")) {
            sb.append("      this." + colName + " = Long.valueOf(__cur_str);\n");
        } else if (javaType.equals("Float")) {
            sb.append("      this." + colName + " = Float.valueOf(__cur_str);\n");
        } else if (javaType.equals("Double")) {
            sb.append("      this." + colName + " = Double.valueOf(__cur_str);\n");
        } else if (javaType.equals("Boolean")) {
            sb.append("      this." + colName + " = BooleanParser.valueOf(__cur_str);\n");
        } else if (javaType.equals("java.sql.Date")) {
            sb.append("      this." + colName + " = java.sql.Date.valueOf(__cur_str);\n");
        } else if (javaType.equals("java.sql.Time")) {
            sb.append("      this." + colName + " = java.sql.Time.valueOf(__cur_str);\n");
        } else if (javaType.equals("java.sql.Timestamp")) {
            sb.append("      this." + colName + " = java.sql.Timestamp.valueOf(__cur_str);\n");
        } else if (javaType.equals("java.math.BigDecimal")) {
            sb.append("      this." + colName + " = new java.math.BigDecimal(__cur_str);\n");
        } else if (javaType.equals(ClobRef.class.getName())) {
            sb.append("      this." + colName + " = ClobRef.parse(__cur_str);\n");
        } else if (javaType.equals(BlobRef.class.getName())) {
            sb.append("      this." + colName + " = BlobRef.parse(__cur_str);\n");
        } else if (javaType.equals(BytesWritable.class.getName())) {
            sb.append("      String[] strByteVal = __cur_str.trim().split(\" \");\n");
            sb.append("      byte [] byteVal = new byte[strByteVal.length];\n");
            sb.append("      for (int i = 0; i < byteVal.length; ++i) {\n");
            sb.append("          byteVal[i] = (byte)Integer.parseInt(strByteVal[i], 16);\n");
            sb.append("      }\n");
            sb.append("      this." + colName + " = new BytesWritable(byteVal);\n");
        } else {
            LOG.error((Object)("No parser available for Java type " + javaType));
        }
        sb.append("    }\n\n");
    }

    private void generateParser(Map<String, Integer> columnTypes, String[] colNames, StringBuilder sb) {
        sb.append("  private final DelimiterSet __inputDelimiters = ");
        sb.append(this.options.getInputDelimiters().formatConstructor() + ";\n");
        sb.append("  private RecordParser __parser;\n");
        this.generateParseMethod("Text", sb);
        this.generateParseMethod("CharSequence", sb);
        this.generateParseMethod("byte []", sb);
        this.generateParseMethod("char []", sb);
        this.generateParseMethod("ByteBuffer", sb);
        this.generateParseMethod("CharBuffer", sb);
        sb.append("  private void __loadFromFields(List<String> fields) {\n");
        sb.append("    Iterator<String> __it = fields.listIterator();\n");
        sb.append("    String __cur_str;\n");
        for (String colName : colNames) {
            int colType = columnTypes.get(colName);
            this.parseColumn(colName, colType, sb);
        }
        sb.append("  }\n\n");
    }

    private void generateHadoopWrite(Map<String, Integer> columnTypes, String[] colNames, StringBuilder sb) {
        sb.append("  public void write(DataOutput __dataOut) throws IOException {\n");
        for (String col : colNames) {
            int sqlType = columnTypes.get(col);
            String javaType = this.toJavaType(col, sqlType);
            if (null == javaType) {
                LOG.error((Object)("No Java type for SQL type " + sqlType + " for column " + col));
                continue;
            }
            String setterMethod = this.rpcSetterForMaybeNull(javaType, "__dataOut", col);
            if (null == setterMethod) {
                LOG.error((Object)("No RPC setter method for Java type " + javaType));
                continue;
            }
            sb.append(setterMethod);
        }
        sb.append("  }\n");
    }

    private String[] cleanColNames(String[] colNames) {
        String[] cleanedColNames = new String[colNames.length];
        for (int i = 0; i < colNames.length; ++i) {
            String identifier;
            String col = colNames[i];
            cleanedColNames[i] = identifier = ClassWriter.toJavaIdentifier(col);
        }
        return cleanedColNames;
    }

    private void logORMSelfGenerationMessage() {
        LOG.info((Object)"The connection manager declares that it self manages mapping between records & fields and rows & columns.  No class will will be generated.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate() throws IOException {
        boolean mkdirSuccess;
        Map<String, Integer> columnTypes = this.getColumnTypes();
        if (this.connManager.isORMFacilitySelfManaged()) {
            this.logORMSelfGenerationMessage();
            return;
        }
        if (columnTypes == null) {
            throw new IOException("No columns to generate for ClassWriter");
        }
        String[] colNames = this.getColumnNames(columnTypes);
        String[] cleanedColNames = this.cleanColNames(colNames);
        HashSet<String> uniqColNames = new HashSet<String>();
        for (int i = 0; i < colNames.length; ++i) {
            String identifier = cleanedColNames[i];
            if (identifier.isEmpty()) {
                throw new IllegalArgumentException("We found column without column name. Please verify that you've entered all column names in your query if using free form query import (consider adding clause AS if you're using column transformation)");
            }
            if (uniqColNames.contains(identifier)) {
                throw new IllegalArgumentException("Duplicate Column identifier specified: '" + identifier + "'");
            }
            uniqColNames.add(identifier);
            String col = colNames[i];
            Integer type = columnTypes.get(col);
            if (type == null) {
                throw new IllegalArgumentException("Column name '" + col + "' not in table");
            }
            columnTypes.put(identifier, type);
        }
        Properties mapping = this.options.getMapColumnJava();
        if (mapping != null && !mapping.isEmpty()) {
            for (Object column : mapping.keySet()) {
                if (uniqColNames.contains((String)column)) continue;
                throw new IllegalArgumentException("No column by the name " + column + "found while importing data; expecting one of " + uniqColNames);
            }
        }
        String[] dbWriteColNames = this.options.getDbOutputColumns();
        String[] cleanedDbWriteColNames = null;
        cleanedDbWriteColNames = null == dbWriteColNames ? cleanedColNames : this.cleanColNames(dbWriteColNames);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"selected columns:");
            for (String col : cleanedColNames) {
                LOG.debug((Object)("  " + col));
            }
            if (cleanedDbWriteColNames != cleanedColNames) {
                LOG.debug((Object)"db write column order:");
                for (String dbCol : cleanedDbWriteColNames) {
                    LOG.debug((Object)("  " + dbCol));
                }
            }
        }
        StringBuilder sb = this.generateClassForColumns(columnTypes, cleanedColNames, cleanedDbWriteColNames);
        String codeOutDir = this.options.getJarOutputDir();
        String className = new TableClassName(this.options).getClassForTable(this.tableName);
        String sourceFilename = className.replace('.', File.separatorChar) + ".java";
        String filename = codeOutDir + sourceFilename;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Writing source file: " + filename));
            LOG.debug((Object)("Table name: " + this.tableName));
            StringBuilder sbColTypes = new StringBuilder();
            for (String col : colNames) {
                Integer colType = columnTypes.get(col);
                sbColTypes.append(col + ":" + colType + ", ");
            }
            String colTypeStr = sbColTypes.toString();
            LOG.debug((Object)("Columns: " + colTypeStr));
            LOG.debug((Object)("sourceFilename is " + sourceFilename));
        }
        this.compileManager.addSourceFile(sourceFilename);
        File file = new File(filename);
        File dir = file.getParentFile();
        if (null != dir && !dir.exists() && !(mkdirSuccess = dir.mkdirs())) {
            LOG.debug((Object)("Could not create directory tree for " + dir));
        }
        FileOutputStream ostream = null;
        Writer writer = null;
        try {
            ostream = new FileOutputStream(filename);
            writer = new OutputStreamWriter(ostream);
            writer.append(sb.toString());
        }
        finally {
            if (null != writer) {
                try {
                    writer.close();
                }
                catch (IOException ioe) {}
            }
            if (null != ostream) {
                try {
                    ((OutputStream)ostream).close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    protected String[] getColumnNames(Map<String, Integer> columnTypes) {
        String[] colNames = this.options.getColumns();
        if (null == colNames) {
            colNames = null != this.tableName ? this.connManager.getColumnNames(this.tableName) : (this.options.getCall() != null ? this.connManager.getColumnNamesForProcedure(this.options.getCall()) : this.connManager.getColumnNamesForQuery(this.options.getSqlQuery()));
        } else {
            block0: for (String userColName : colNames) {
                for (Map.Entry<String, Integer> typeEntry : columnTypes.entrySet()) {
                    String typeColName = typeEntry.getKey();
                    if (!typeColName.equalsIgnoreCase(userColName) || typeColName.equals(userColName)) continue;
                    columnTypes.put(userColName, typeEntry.getValue());
                    continue block0;
                }
            }
        }
        return colNames;
    }

    protected Map<String, Integer> getColumnTypes() throws IOException {
        if (this.options.getCall() == null) {
            return this.connManager.getColumnTypes(this.tableName, this.options.getSqlQuery());
        }
        return this.connManager.getColumnTypesForProcedure(this.options.getCall());
    }

    private StringBuilder generateClassForColumns(Map<String, Integer> columnTypes, String[] colNames, String[] dbWriteColNames) {
        if (colNames.length == 0) {
            throw new IllegalArgumentException("Attempted to generate class with no columns!");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("// ORM class for table '" + this.tableName + "'\n");
        sb.append("// WARNING: This class is AUTO-GENERATED. Modify at your own risk.\n");
        sb.append("//\n");
        sb.append("// Debug information:\n");
        sb.append("// Generated date: " + new Date() + "\n");
        sb.append("// For connector: " + this.connManager.getClass().getCanonicalName() + "\n");
        TableClassName tableNameInfo = new TableClassName(this.options);
        String packageName = tableNameInfo.getPackageForTable();
        if (null != packageName) {
            sb.append("package ");
            sb.append(packageName);
            sb.append(";\n");
        }
        sb.append("import org.apache.hadoop.io.BytesWritable;\n");
        sb.append("import org.apache.hadoop.io.Text;\n");
        sb.append("import org.apache.hadoop.io.Writable;\n");
        sb.append("import org.apache.hadoop.mapred.lib.db.DBWritable;\n");
        sb.append("import " + JdbcWritableBridge.class.getCanonicalName() + ";\n");
        sb.append("import " + DelimiterSet.class.getCanonicalName() + ";\n");
        sb.append("import " + FieldFormatter.class.getCanonicalName() + ";\n");
        sb.append("import " + RecordParser.class.getCanonicalName() + ";\n");
        sb.append("import " + BooleanParser.class.getCanonicalName() + ";\n");
        sb.append("import " + BlobRef.class.getCanonicalName() + ";\n");
        sb.append("import " + ClobRef.class.getCanonicalName() + ";\n");
        sb.append("import " + LargeObjectLoader.class.getCanonicalName() + ";\n");
        sb.append("import " + SqoopRecord.class.getCanonicalName() + ";\n");
        sb.append("import java.sql.PreparedStatement;\n");
        sb.append("import java.sql.ResultSet;\n");
        sb.append("import java.sql.SQLException;\n");
        sb.append("import java.io.DataInput;\n");
        sb.append("import java.io.DataOutput;\n");
        sb.append("import java.io.IOException;\n");
        sb.append("import java.nio.ByteBuffer;\n");
        sb.append("import java.nio.CharBuffer;\n");
        sb.append("import java.sql.Date;\n");
        sb.append("import java.sql.Time;\n");
        sb.append("import java.sql.Timestamp;\n");
        sb.append("import java.util.Arrays;\n");
        sb.append("import java.util.Iterator;\n");
        sb.append("import java.util.List;\n");
        sb.append("import java.util.Map;\n");
        sb.append("import java.util.TreeMap;\n");
        sb.append("\n");
        String className = tableNameInfo.getShortClassForTable(this.tableName);
        sb.append("public class " + className + " extends SqoopRecord " + " implements DBWritable, Writable {\n");
        sb.append("  private final int PROTOCOL_VERSION = 3;\n");
        sb.append("  public int getClassFormatVersion() { return PROTOCOL_VERSION; }\n");
        sb.append("  protected ResultSet __cur_result_set;\n");
        this.generateFields(columnTypes, colNames, className, sb);
        this.generateEquals(columnTypes, colNames, className, sb);
        this.generateDbRead(columnTypes, colNames, sb);
        this.generateLoadLargeObjects(columnTypes, colNames, sb);
        this.generateDbWrite(columnTypes, dbWriteColNames, sb);
        this.generateHadoopRead(columnTypes, colNames, sb);
        this.generateHadoopWrite(columnTypes, colNames, sb);
        this.generateToString(columnTypes, colNames, sb);
        this.generateParser(columnTypes, colNames, sb);
        this.generateCloneMethod(columnTypes, colNames, sb);
        this.generateGetFieldMap(columnTypes, colNames, sb);
        this.generateSetField(columnTypes, colNames, sb);
        sb.append("}\n");
        return sb;
    }

    static {
        JAVA_RESERVED_WORDS.add("abstract");
        JAVA_RESERVED_WORDS.add("else");
        JAVA_RESERVED_WORDS.add("int");
        JAVA_RESERVED_WORDS.add("strictfp");
        JAVA_RESERVED_WORDS.add("assert");
        JAVA_RESERVED_WORDS.add("enum");
        JAVA_RESERVED_WORDS.add("interface");
        JAVA_RESERVED_WORDS.add("super");
        JAVA_RESERVED_WORDS.add("boolean");
        JAVA_RESERVED_WORDS.add("extends");
        JAVA_RESERVED_WORDS.add("long");
        JAVA_RESERVED_WORDS.add("switch");
        JAVA_RESERVED_WORDS.add("break");
        JAVA_RESERVED_WORDS.add("false");
        JAVA_RESERVED_WORDS.add("native");
        JAVA_RESERVED_WORDS.add("synchronized");
        JAVA_RESERVED_WORDS.add("byte");
        JAVA_RESERVED_WORDS.add("final");
        JAVA_RESERVED_WORDS.add("new");
        JAVA_RESERVED_WORDS.add("this");
        JAVA_RESERVED_WORDS.add("case");
        JAVA_RESERVED_WORDS.add("finally");
        JAVA_RESERVED_WORDS.add("null");
        JAVA_RESERVED_WORDS.add("throw");
        JAVA_RESERVED_WORDS.add("catch");
        JAVA_RESERVED_WORDS.add("float");
        JAVA_RESERVED_WORDS.add("package");
        JAVA_RESERVED_WORDS.add("throws");
        JAVA_RESERVED_WORDS.add("char");
        JAVA_RESERVED_WORDS.add("for");
        JAVA_RESERVED_WORDS.add("private");
        JAVA_RESERVED_WORDS.add("transient");
        JAVA_RESERVED_WORDS.add("class");
        JAVA_RESERVED_WORDS.add("goto");
        JAVA_RESERVED_WORDS.add("protected");
        JAVA_RESERVED_WORDS.add("true");
        JAVA_RESERVED_WORDS.add("const");
    }
}

