/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.alias;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.Actions;
import org.elasticsearch.action.support.master.MasterNodeOperationRequest;
import org.elasticsearch.cluster.metadata.AliasAction;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class IndicesAliasesRequest
extends MasterNodeOperationRequest {
    private List<AliasAction> aliasActions = Lists.newArrayList();

    public IndicesAliasesRequest addAlias(String index, String alias) {
        this.aliasActions.add(new AliasAction(AliasAction.Type.ADD, index, alias));
        return this;
    }

    public IndicesAliasesRequest removeAlias(String index, String alias) {
        this.aliasActions.add(new AliasAction(AliasAction.Type.REMOVE, index, alias));
        return this;
    }

    List<AliasAction> aliasActions() {
        return this.aliasActions;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.aliasActions.isEmpty()) {
            validationException = Actions.addValidationError("Must specify at least one alias action", validationException);
        }
        return validationException;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        int size = in.readVInt();
        for (int i = 0; i < size; ++i) {
            this.aliasActions.add(AliasAction.readAliasAction(in));
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.aliasActions.size());
        for (AliasAction aliasAction : this.aliasActions) {
            aliasAction.writeTo(out);
        }
    }
}

