/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util.concurrent.resource;

import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.util.concurrent.resource.AcquirableResource;

public class BlockingAcquirableResource<T extends Releasable>
implements AcquirableResource<T> {
    private final T resource;
    private int count = 0;
    private boolean markForClose = false;
    private boolean closed;

    public BlockingAcquirableResource(T resource) {
        this.resource = resource;
    }

    @Override
    public T resource() {
        return this.resource;
    }

    @Override
    public synchronized boolean acquire() {
        if (this.markForClose) {
            return false;
        }
        ++this.count;
        return true;
    }

    @Override
    public synchronized void release() {
        --this.count;
        this.checkIfCanClose();
    }

    @Override
    public synchronized void markForClose() {
        this.markForClose = true;
        this.checkIfCanClose();
    }

    @Override
    public void forceClose() {
        this.count = 0;
        this.markForClose();
    }

    private void checkIfCanClose() {
        if (this.markForClose && this.count <= 0 && !this.closed) {
            this.closed = true;
            this.resource.release();
        }
    }
}

