/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.field.function.sort;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.Scorer;
import org.elasticsearch.script.SearchScript;

public class DoubleFieldsFunctionDataComparator
extends FieldComparator {
    private final SearchScript script;
    private final double[] values;
    private double bottom;

    public static FieldComparatorSource comparatorSource(SearchScript script) {
        return new InnerSource(script);
    }

    public DoubleFieldsFunctionDataComparator(int numHits, SearchScript script) {
        this.script = script;
        this.values = new double[numHits];
    }

    public void setNextReader(IndexReader reader, int docBase) throws IOException {
        this.script.setNextReader(reader);
    }

    public void setScorer(Scorer scorer) {
        this.script.setScorer(scorer);
    }

    public int compare(int slot1, int slot2) {
        double v1 = this.values[slot1];
        double v2 = this.values[slot2];
        if (v1 > v2) {
            return 1;
        }
        if (v1 < v2) {
            return -1;
        }
        return 0;
    }

    public int compareBottom(int doc) {
        this.script.setNextDocId(doc);
        double v2 = this.script.runAsDouble();
        if (this.bottom > v2) {
            return 1;
        }
        if (this.bottom < v2) {
            return -1;
        }
        return 0;
    }

    public void copy(int slot, int doc) {
        this.script.setNextDocId(doc);
        this.values[slot] = this.script.runAsDouble();
    }

    public void setBottom(int bottom) {
        this.bottom = this.values[bottom];
    }

    public Comparable value(int slot) {
        return Double.valueOf(this.values[slot]);
    }

    private static class InnerSource
    extends FieldComparatorSource {
        private final SearchScript script;

        private InnerSource(SearchScript script) {
            this.script = script;
        }

        public FieldComparator newComparator(String fieldname, int numHits, int sortPos, boolean reversed) throws IOException {
            return new DoubleFieldsFunctionDataComparator(numHits, this.script);
        }
    }
}

