/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.xcontent;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.xcontent.AbstractFieldMapper;
import org.elasticsearch.index.mapper.xcontent.ParseContext;
import org.elasticsearch.index.mapper.xcontent.XContentMapper;
import org.elasticsearch.index.mapper.xcontent.XContentMapperBuilders;
import org.elasticsearch.index.mapper.xcontent.XContentTypeParsers;

public class BinaryFieldMapper
extends AbstractFieldMapper<byte[]> {
    public static final String CONTENT_TYPE = "binary";

    protected BinaryFieldMapper(FieldMapper.Names names) {
        super(names, Field.Index.NO, Field.Store.YES, Field.TermVector.NO, 1.0f, true, true, null, null);
    }

    @Override
    public byte[] value(Fieldable field) {
        return field.getBinaryValue();
    }

    @Override
    public byte[] valueFromString(String value) {
        return null;
    }

    @Override
    public String valueAsString(Fieldable field) {
        return null;
    }

    @Override
    public String indexedValue(String value) {
        return value;
    }

    protected Field parseCreateField(ParseContext context) throws IOException {
        if (context.parser().currentToken() == XContentParser.Token.VALUE_NULL) {
            return null;
        }
        byte[] value = context.parser().binaryValue();
        if (value == null) {
            return null;
        }
        return new Field(this.names.indexName(), value);
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.names.name());
        builder.field("type", this.contentType());
        if (!this.names.name().equals(this.names.indexNameClean())) {
            builder.field("index_name", this.names.indexNameClean());
        }
        builder.endObject();
        return builder;
    }

    public static class TypeParser
    implements XContentMapper.TypeParser {
        @Override
        public XContentMapper.Builder parse(String name, Map<String, Object> node, XContentMapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = XContentMapperBuilders.binaryField(name);
            XContentTypeParsers.parseField(builder, name, node, parserContext);
            return builder;
        }
    }

    public static class Builder
    extends AbstractFieldMapper.Builder<Builder, BinaryFieldMapper> {
        public Builder(String name) {
            super(name);
            this.builder = this;
        }

        @Override
        public Builder indexName(String indexName) {
            return (Builder)super.indexName(indexName);
        }

        @Override
        public BinaryFieldMapper build(XContentMapper.BuilderContext context) {
            return new BinaryFieldMapper(this.buildNames(context));
        }
    }
}

