/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query.xcontent;

import java.io.IOException;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.search.function.BoostScoreFunction;
import org.elasticsearch.common.lucene.search.function.FunctionScoreQuery;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.query.xcontent.QueryParseContext;
import org.elasticsearch.index.query.xcontent.XContentQueryParser;
import org.elasticsearch.index.settings.IndexSettings;

public class CustomBoostFactorQueryParser
extends AbstractIndexComponent
implements XContentQueryParser {
    public static final String NAME = "custom_boost_factor";

    @Inject
    public CustomBoostFactorQueryParser(Index index, @IndexSettings Settings settings) {
        super(index, settings);
    }

    @Override
    public String[] names() {
        return new String[]{NAME, Strings.toCamelCase(NAME)};
    }

    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        Query query = null;
        float boost = 1.0f;
        float boostFactor = 1.0f;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (!"query".equals(currentFieldName)) continue;
                query = parseContext.parseInnerQuery();
                continue;
            }
            if (!token.isValue()) continue;
            if ("boost_factor".equals(currentFieldName) || "boostFactor".equals(currentFieldName)) {
                boostFactor = parser.floatValue();
                continue;
            }
            if (!"boost".equals(currentFieldName)) continue;
            boost = parser.floatValue();
        }
        if (query == null) {
            throw new QueryParsingException(this.index, "[constant_factor_query] requires 'query' element");
        }
        FunctionScoreQuery functionScoreQuery = new FunctionScoreQuery(query, new BoostScoreFunction(boostFactor));
        functionScoreQuery.setBoost(boost);
        return functionScoreQuery;
    }
}

