/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.geo;

import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.index.search.geo.LatLng;

public enum GeoDistance {
    PLANE{
        private static final double EARTH_CIRCUMFERENCE_MILES = 24901.0;
        private static final double DISTANCE_PER_DEGREE = 69.16944444444445;

        @Override
        public double calculate(double sourceLatitude, double sourceLongitude, double targetLatitude, double targetLongitude, DistanceUnit unit) {
            double px = targetLongitude - sourceLongitude;
            double py = targetLatitude - sourceLatitude;
            double distanceMiles = Math.sqrt(px * px + py * py) * 69.16944444444445;
            return DistanceUnit.convert(distanceMiles, DistanceUnit.MILES, unit);
        }
    }
    ,
    ARC{

        @Override
        public double calculate(double sourceLatitude, double sourceLongitude, double targetLatitude, double targetLongitude, DistanceUnit unit) {
            LatLng sourcePoint = new LatLng(sourceLatitude, sourceLongitude);
            LatLng targetPoint = new LatLng(targetLatitude, targetLongitude);
            return DistanceUnit.convert(sourcePoint.arcDistance(targetPoint, DistanceUnit.MILES), DistanceUnit.MILES, unit);
        }
    };


    public abstract double calculate(double var1, double var3, double var5, double var7, DistanceUnit var9);

    public static GeoDistance fromString(String s) {
        if ("plane".equals(s)) {
            return PLANE;
        }
        if ("arc".equals(s)) {
            return ARC;
        }
        throw new ElasticSearchIllegalArgumentException("No geo distance for [" + s + "]");
    }
}

